/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.icpac.multisimilaritycompare.system.core.entity;

import com.jxdinfo.idp.icpac.multisimilaritycompare.system.core.entity.DuplicateCheckCandidateSentence;
import com.jxdinfo.idp.icpac.multisimilaritycompare.system.core.entity.DuplicateCheckOperationEnum;
import com.jxdinfo.idp.icpac.multisimilaritycompare.system.core.handler.SentenceHandler;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.web.multipart.MultipartFile;

public class DuplicateCheckInfo {
    private String checkId;
    private MultipartFile file;
    private Double simThresh;
    private Map<String, Object> attachmentCollections;
    private Integer minSentenceLen;
    private DuplicateCheckOperationEnum operationEnum;
    private SentenceHandler sentenceHandler;
    private int candidateSentenceNum;
    private List<DuplicateCheckCandidateSentence> candidateSentenceList;
    private String format;

    public DuplicateCheckInfo(String checkId, DuplicateCheckOperationEnum operationEnum) {
        this.assertNoNull(checkId, "\u7ed9\u5b9a\u7684\u64cd\u4f5c\u6807\u8bc6\u7b26id\u4e3a\u7a7a");
        this.checkId = checkId;
        this.operationEnum = operationEnum;
        this.attachmentCollections = new HashMap<String, Object>();
    }

    public DuplicateCheckInfo(String checkId, MultipartFile file, Double simThresh, Integer minSentenceLen, DuplicateCheckOperationEnum operationEnum, SentenceHandler sentenceHandler) {
        this.assertNoNull(checkId, "\u7ed9\u5b9a\u7684\u64cd\u4f5c\u6807\u8bc6\u7b26id\u4e3a\u7a7a");
        this.checkId = checkId;
        this.assertNoNull(file, "\u7ed9\u5b9a\u7684\u67e5\u91cd\u6587\u4ef6\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u8fdb\u884c\u5ba1\u67e5");
        this.file = file;
        this.assertNoNull(simThresh, "\u76f8\u4f3c\u5ea6\u9608\u503c\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u8fdb\u884c\u5ba1\u67e5");
        if (simThresh <= 0.0) {
            throw new IllegalArgumentException("\u76f8\u4f3c\u5ea6\u9608\u503c\u4e0d\u80fd\u4e3a0\uff0c\u7ed9\u5b9a\u7684\u76f8\u4f3c\u5ea6\u9608\u503c\u4e3a\uff1a" + minSentenceLen);
        }
        this.simThresh = simThresh;
        this.assertNoNull(minSentenceLen, "\u89c4\u5b9a\u67e5\u91cd\u7684\u6700\u5c0f\u53e5\u5b50\u5b57\u7b26\u6570\u4e3a\u7a7a");
        if (minSentenceLen <= 0) {
            throw new IllegalArgumentException("\u6700\u5c0f\u5b57\u7b26\u957f\u5ea6\u4e0d\u80fd\u5c0f\u4e8e0\uff0c\u7ed9\u5b9a\u7684\u6700\u5c0f\u5b57\u7b26\u957f\u5ea6\u4e3a\uff1a" + minSentenceLen);
        }
        this.minSentenceLen = minSentenceLen;
        this.operationEnum = operationEnum;
        this.attachmentCollections = new HashMap<String, Object>();
        this.sentenceHandler = sentenceHandler;
    }

    private void assertNoNull(Object o, String message) {
        if (this.file == o) {
            throw new NullPointerException(message);
        }
    }

    public Object addAttachment(String key, Object attachment) {
        if (key == null) {
            throw new NullPointerException("\u7ed9\u5b9a\u7684key\u4e0d\u80fd\u4e3anull");
        }
        Object oldAttachment = this.attachmentCollections.remove(key);
        this.attachmentCollections.put(key, attachment);
        return oldAttachment;
    }

    public <T> T getAttachment(String key, Class<T> type) {
        Object o = this.attachmentCollections.get(key);
        if (o == null) {
            return null;
        }
        return (T)o;
    }

    public String getFileName() {
        if (this.file == null) {
            return "";
        }
        return this.file.getOriginalFilename();
    }

    public String getCheckId() {
        return this.checkId;
    }

    public MultipartFile getFile() {
        return this.file;
    }

    public Double getSimThresh() {
        return this.simThresh;
    }

    public Map<String, Object> getAttachmentCollections() {
        return this.attachmentCollections;
    }

    public Integer getMinSentenceLen() {
        return this.minSentenceLen;
    }

    public DuplicateCheckOperationEnum getOperationEnum() {
        return this.operationEnum;
    }

    public SentenceHandler getSentenceHandler() {
        return this.sentenceHandler;
    }

    public int getCandidateSentenceNum() {
        return this.candidateSentenceNum;
    }

    public List<DuplicateCheckCandidateSentence> getCandidateSentenceList() {
        return this.candidateSentenceList;
    }

    public String getFormat() {
        return this.format;
    }

    public void setCheckId(String checkId) {
        this.checkId = checkId;
    }

    public void setFile(MultipartFile file) {
        this.file = file;
    }

    public void setSimThresh(Double simThresh) {
        this.simThresh = simThresh;
    }

    public void setAttachmentCollections(Map<String, Object> attachmentCollections) {
        this.attachmentCollections = attachmentCollections;
    }

    public void setMinSentenceLen(Integer minSentenceLen) {
        this.minSentenceLen = minSentenceLen;
    }

    public void setOperationEnum(DuplicateCheckOperationEnum operationEnum) {
        this.operationEnum = operationEnum;
    }

    public void setSentenceHandler(SentenceHandler sentenceHandler) {
        this.sentenceHandler = sentenceHandler;
    }

    public void setCandidateSentenceNum(int candidateSentenceNum) {
        this.candidateSentenceNum = candidateSentenceNum;
    }

    public void setCandidateSentenceList(List<DuplicateCheckCandidateSentence> candidateSentenceList) {
        this.candidateSentenceList = candidateSentenceList;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DuplicateCheckInfo)) {
            return false;
        }
        DuplicateCheckInfo other = (DuplicateCheckInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getCandidateSentenceNum() != other.getCandidateSentenceNum()) {
            return false;
        }
        Double this$simThresh = this.getSimThresh();
        Double other$simThresh = other.getSimThresh();
        if (this$simThresh == null ? other$simThresh != null : !((Object)this$simThresh).equals(other$simThresh)) {
            return false;
        }
        Integer this$minSentenceLen = this.getMinSentenceLen();
        Integer other$minSentenceLen = other.getMinSentenceLen();
        if (this$minSentenceLen == null ? other$minSentenceLen != null : !((Object)this$minSentenceLen).equals(other$minSentenceLen)) {
            return false;
        }
        String this$checkId = this.getCheckId();
        String other$checkId = other.getCheckId();
        if (this$checkId == null ? other$checkId != null : !this$checkId.equals(other$checkId)) {
            return false;
        }
        MultipartFile this$file = this.getFile();
        MultipartFile other$file = other.getFile();
        if (this$file == null ? other$file != null : !this$file.equals(other$file)) {
            return false;
        }
        Map<String, Object> this$attachmentCollections = this.getAttachmentCollections();
        Map<String, Object> other$attachmentCollections = other.getAttachmentCollections();
        if (this$attachmentCollections == null ? other$attachmentCollections != null : !((Object)this$attachmentCollections).equals(other$attachmentCollections)) {
            return false;
        }
        DuplicateCheckOperationEnum this$operationEnum = this.getOperationEnum();
        DuplicateCheckOperationEnum other$operationEnum = other.getOperationEnum();
        if (this$operationEnum == null ? other$operationEnum != null : !((Object)((Object)this$operationEnum)).equals((Object)other$operationEnum)) {
            return false;
        }
        SentenceHandler this$sentenceHandler = this.getSentenceHandler();
        SentenceHandler other$sentenceHandler = other.getSentenceHandler();
        if (this$sentenceHandler == null ? other$sentenceHandler != null : !this$sentenceHandler.equals(other$sentenceHandler)) {
            return false;
        }
        List<DuplicateCheckCandidateSentence> this$candidateSentenceList = this.getCandidateSentenceList();
        List<DuplicateCheckCandidateSentence> other$candidateSentenceList = other.getCandidateSentenceList();
        if (this$candidateSentenceList == null ? other$candidateSentenceList != null : !((Object)this$candidateSentenceList).equals(other$candidateSentenceList)) {
            return false;
        }
        String this$format = this.getFormat();
        String other$format = other.getFormat();
        return !(this$format == null ? other$format != null : !this$format.equals(other$format));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DuplicateCheckInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getCandidateSentenceNum();
        Double $simThresh = this.getSimThresh();
        result = result * 59 + ($simThresh == null ? 43 : ((Object)$simThresh).hashCode());
        Integer $minSentenceLen = this.getMinSentenceLen();
        result = result * 59 + ($minSentenceLen == null ? 43 : ((Object)$minSentenceLen).hashCode());
        String $checkId = this.getCheckId();
        result = result * 59 + ($checkId == null ? 43 : $checkId.hashCode());
        MultipartFile $file = this.getFile();
        result = result * 59 + ($file == null ? 43 : $file.hashCode());
        Map<String, Object> $attachmentCollections = this.getAttachmentCollections();
        result = result * 59 + ($attachmentCollections == null ? 43 : ((Object)$attachmentCollections).hashCode());
        DuplicateCheckOperationEnum $operationEnum = this.getOperationEnum();
        result = result * 59 + ($operationEnum == null ? 43 : ((Object)((Object)$operationEnum)).hashCode());
        SentenceHandler $sentenceHandler = this.getSentenceHandler();
        result = result * 59 + ($sentenceHandler == null ? 43 : $sentenceHandler.hashCode());
        List<DuplicateCheckCandidateSentence> $candidateSentenceList = this.getCandidateSentenceList();
        result = result * 59 + ($candidateSentenceList == null ? 43 : ((Object)$candidateSentenceList).hashCode());
        String $format = this.getFormat();
        result = result * 59 + ($format == null ? 43 : $format.hashCode());
        return result;
    }

    public String toString() {
        return "DuplicateCheckInfo(checkId=" + this.getCheckId() + ", file=" + this.getFile() + ", simThresh=" + this.getSimThresh() + ", attachmentCollections=" + this.getAttachmentCollections() + ", minSentenceLen=" + this.getMinSentenceLen() + ", operationEnum=" + (Object)((Object)this.getOperationEnum()) + ", sentenceHandler=" + this.getSentenceHandler() + ", candidateSentenceNum=" + this.getCandidateSentenceNum() + ", candidateSentenceList=" + this.getCandidateSentenceList() + ", format=" + this.getFormat() + ")";
    }
}

