/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.icpac.docexamine.executor.imp.excelelementextractor;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.idp.icpac.common.entity.FileBytesInfo;
import com.jxdinfo.idp.icpac.common.entity.po.ExtractElement;
import com.jxdinfo.idp.icpac.doccontrast.entity.po.ConfigDocElement;
import com.jxdinfo.idp.icpac.docexamine.entity.docconfig.BasisText;
import com.jxdinfo.idp.icpac.docexamine.entity.docconfig.extractsetting.ExtractSettings;
import com.jxdinfo.idp.icpac.docexamine.entity.location.SheetContent;
import com.jxdinfo.idp.icpac.docexamine.executor.imp.AbstractExtractor;
import com.jxdinfo.idp.icpac.docexamine.executor.imp.excelelementextractor.ElementExcelExtractorFactory;
import com.jxdinfo.idp.icpac.multisimilaritycompare.utils.ReadExcelUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class SheetElementExcelExtractor
extends ElementExcelExtractorFactory {
    private static final Logger log = LoggerFactory.getLogger(SheetElementExcelExtractor.class);

    public SheetElementExcelExtractor() {
        super("sheet");
    }

    @Override
    public ExtractElement extractElement(String subtaskId, ConfigDocElement docElement) {
        FileBytesInfo docFileInfo = AbstractExtractor.docFileInfoMap.get(subtaskId);
        ExtractElement extractElement = new ExtractElement();
        LinkedHashMap cellDataMap = (LinkedHashMap)cellDataMapMap.get(subtaskId);
        Map map = (Map)JSONObject.parseObject((String)docElement.getExtractRule(), Map.class);
        ExtractSettings extractSettings = (ExtractSettings)JSONObject.parseObject((String)JSONObject.toJSONString(map.get("extractSettings")), ExtractSettings.class);
        if ("2".equals(extractSettings.getMatchStrategy())) {
            ArrayList tempDataMap = new ArrayList(cellDataMap.entrySet());
            Collections.reverse(tempDataMap);
            cellDataMap.clear();
            for (Map.Entry entry : tempDataMap) {
                cellDataMap.put(entry.getKey(), entry.getValue());
            }
        }
        block1: for (String key : cellDataMap.keySet()) {
            List<BasisText> list = extractSettings.getBasisTexts();
            for (BasisText basisText : list) {
                if (!basisText.getText().equals(key)) continue;
                int sheetIndex = ReadExcelUtil.sheetIndex(docFileInfo, key);
                extractElement.setElementLocation(this.getLocation(sheetIndex, key, null));
                extractElement.setElementText(key);
                Map<Object, Object> maps = new HashMap();
                if (!ElementExcelExtractorFactory.excelSheetDataMaps.isEmpty()) {
                    maps = ElementExcelExtractorFactory.excelSheetDataMaps.get(subtaskId);
                }
                SheetContent sheetContent = new SheetContent();
                sheetContent.setSheetName(basisText.getText());
                sheetContent.setCellList((List)cellDataMap.get(key));
                maps.put(docElement.getElementName(), sheetContent);
                ElementExcelExtractorFactory.excelSheetDataMaps.put(subtaskId, maps);
                break block1;
            }
        }
        return extractElement;
    }
}

