/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.icpac.docexamine.executor.imp.excelelementextractor;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.idp.icpac.common.util.entity.excel.CellData;
import com.jxdinfo.idp.icpac.docexamine.entity.docconfig.extractsetting.ExtractSettings;
import com.jxdinfo.idp.icpac.docexamine.entity.location.ExcelLocation;
import com.jxdinfo.idp.icpac.docexamine.entity.location.SheetContent;
import com.jxdinfo.idp.icpac.docexamine.executor.IElementExcelExtractor;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;

public abstract class ElementExcelExtractorFactory
implements IElementExcelExtractor {
    private static final Logger log = LoggerFactory.getLogger(ElementExcelExtractorFactory.class);
    private static Map<String, IElementExcelExtractor> excelElementExtractorMap = new HashMap<String, IElementExcelExtractor>();
    public static Map<String, LinkedHashMap<String, List<CellData>>> cellDataMapMap = new ConcurrentHashMap<String, LinkedHashMap<String, List<CellData>>>();
    public static Map<String, Map<String, SheetContent>> excelSheetDataMaps = new HashMap<String, Map<String, SheetContent>>();
    public static Map<String, Map<String, CellData>> excelTableDataMaps = new HashMap<String, Map<String, CellData>>();

    public ElementExcelExtractorFactory(String key) {
        ElementExcelExtractorFactory.register(key, this);
    }

    public static void register(String key, IElementExcelExtractor extractor) {
        excelElementExtractorMap.put(key, extractor);
    }

    public static IElementExcelExtractor get(String key) {
        return excelElementExtractorMap.get(key);
    }

    protected <T> T getExtractSettings(ExtractSettings settings, Class<T> tClass) {
        T t = null;
        try {
            t = tClass.newInstance();
            BeanUtils.copyProperties((Object)settings, t);
        }
        catch (Exception e) {
            log.error("\u62bd\u53d6\u8bbe\u7f6e\u8f6c\u6362\u5f02\u5e38", (Throwable)e);
        }
        return t;
    }

    protected String getLocation(Integer sheetIndex, String sheetName, String dataLocation) {
        ExcelLocation location = new ExcelLocation();
        location.setSheetIndex(sheetIndex + 1);
        location.setDataLocation(dataLocation);
        return JSON.toJSONString((Object)location);
    }
}

