/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.icpac.docexamine.executor.imp;

import cn.hutool.core.util.IdUtil;
import com.jxdinfo.idp.dio.service.FileService;
import com.jxdinfo.idp.icpac.common.entity.FileBytesInfo;
import com.jxdinfo.idp.icpac.common.entity.po.ExtractElement;
import com.jxdinfo.idp.icpac.common.service.IExtractElementService;
import com.jxdinfo.idp.icpac.doccontrast.entity.dto.DocSubtaskDto;
import com.jxdinfo.idp.icpac.doccontrast.entity.po.ConfigDocElement;
import com.jxdinfo.idp.icpac.doccontrast.entity.po.DocSubtask;
import com.jxdinfo.idp.icpac.doccontrast.service.IConfigDocElementService;
import com.jxdinfo.idp.icpac.doccontrast.util.ExecutorFactory;
import com.jxdinfo.idp.icpac.docexamine.entity.docconfig.extractsetting.ExtractSettings;
import com.jxdinfo.idp.icpac.docexamine.executor.IExtractor;
import com.jxdinfo.idp.interf.FileSystemInterface;
import com.jxdinfo.idp.po.DocFilePo;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractExtractor
implements IExtractor {
    private static final Logger log = LoggerFactory.getLogger(AbstractExtractor.class);
    public static final Map<String, FileBytesInfo> docFileInfoMap = new ConcurrentHashMap<String, FileBytesInfo>();
    @Autowired
    private FileSystemInterface fileInfoService;
    @Autowired
    private FileService fileService;
    @Autowired
    protected IExtractElementService extractElementService;
    @Autowired
    protected IConfigDocElementService docElementService;

    protected AbstractExtractor(String key) {
        ExecutorFactory.register(key, this);
    }

    protected FileBytesInfo getFileInfo(DocSubtask subtask) {
        DocFilePo fileInfo = (DocFilePo)this.fileInfoService.getById((Serializable)subtask.getDocId());
        try {
            byte[] fileBytes = subtask.getFiles();
            if (fileBytes == null || fileBytes.length == 0) {
                fileBytes = this.fileService.download(fileInfo.getFilePath());
            }
            FileBytesInfo docFileInfo = new FileBytesInfo(fileBytes, fileInfo.getFileName());
            if (!ArrayUtils.isNotEmpty((byte[])fileBytes)) {
                return null;
            }
            docFileInfoMap.put(subtask.getId(), docFileInfo);
            return docFileInfo;
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u6587\u4ef6\u6d41\u5f02\u5e38", (Throwable)e);
            return null;
        }
    }

    protected <T> T getExtractSettings(ExtractSettings settings, Class<T> tClass) {
        T t = null;
        try {
            t = tClass.newInstance();
            BeanUtils.copyProperties((Object)settings, t);
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
        return t;
    }

    protected ExtractElement extractEmptyElement(DocSubtaskDto dto, ConfigDocElement element) {
        ExtractElement extractElement = new ExtractElement();
        extractElement.setId(IdUtil.simpleUUID());
        extractElement.setDocId(dto.getDocId());
        extractElement.setDocElementId(element.getId());
        extractElement.setDocFormat(dto.getDocFormat());
        extractElement.setElementType(element.getElementType());
        extractElement.setDocElementId(element.getId());
        return extractElement;
    }
}

