/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.icpac.doccontrast.util;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.pdfbox.contentstream.PDContentStream;
import org.apache.pdfbox.contentstream.operator.Operator;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.pdfparser.PDFStreamParser;
import org.apache.pdfbox.pdfwriter.ContentStreamWriter;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.common.PDStream;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Service;
import technology.tabula.extractors.SpreadsheetExtractionAlgorithm;

@Component
@Service
public class ReadPdfUtil {
    private static final SpreadsheetExtractionAlgorithm SPREADSHEEET_EXTRACTION_ALGORITHM = new SpreadsheetExtractionAlgorithm();

    public static void removeTextWatermark(PDDocument pd) throws Exception {
        HashMap<String, Integer> countMap = new HashMap<String, Integer>();
        for (PDPage page : pd.getPages()) {
            PDFStreamParser pdfsp = new PDFStreamParser((PDContentStream)page);
            pdfsp.parse();
            List tokens = pdfsp.parse();
            Iterator iterator = tokens.iterator();
            boolean find = false;
            while (iterator.hasNext()) {
                Object next = iterator.next();
                if (next instanceof Operator) {
                    Operator op = (Operator)next;
                    find = op.getName().equals("Tm");
                    continue;
                }
                if (!find || !(next instanceof COSString)) continue;
                countMap.put(next.toString(), countMap.getOrDefault(next.toString(), 0) + 1);
            }
        }
        ArrayList waterMarks = new ArrayList();
        for (Map.Entry entry : countMap.entrySet()) {
            if ((Integer)entry.getValue() < pd.getPages().getCount() * 8) continue;
            waterMarks.add(entry.getKey());
        }
        for (PDPage page : pd.getPages()) {
            PDFStreamParser pdfsp = new PDFStreamParser((PDContentStream)page);
            pdfsp.parse();
            List tokens = pdfsp.parse();
            Iterator iterator = tokens.iterator();
            boolean find = false;
            while (iterator.hasNext()) {
                Object next = iterator.next();
                if (next instanceof Operator) {
                    Operator op = (Operator)next;
                    find = op.getName().equals("Tm");
                    continue;
                }
                if (!find || !(next instanceof COSString)) continue;
                for (String waterMark : waterMarks) {
                    if (!next.toString().equals(waterMark)) continue;
                    iterator.remove();
                }
            }
            PDStream updatedStream = new PDStream(pd);
            OutputStream out = updatedStream.createOutputStream();
            ContentStreamWriter tokenWriter = new ContentStreamWriter(out);
            tokenWriter.writeTokens(tokens);
            out.close();
            page.setContents(updatedStream);
        }
    }

    private static void checkCellMap(TreeMap<Double, Double> cellMap) {
        Iterator<Map.Entry<Double, Double>> iterator = cellMap.entrySet().iterator();
        double index = 0.0;
        while (iterator.hasNext()) {
            Map.Entry<Double, Double> currentEntry = iterator.next();
            cellMap.put(currentEntry.getKey(), index);
            index += 1.0;
        }
    }
}

