/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.icpac.doccontrast.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jxdinfo.idp.common.util.uuid.IdUtils;
import com.jxdinfo.idp.icpac.common.entity.po.ExtractElement;
import com.jxdinfo.idp.icpac.common.service.IExtractElementService;
import com.jxdinfo.idp.icpac.doccontrast.entity.dto.DocSubtaskDto;
import com.jxdinfo.idp.icpac.doccontrast.entity.po.ZnysAbilityExtractElementNotUseOcr;
import com.jxdinfo.idp.icpac.doccontrast.service.IDocExamineService;
import com.jxdinfo.idp.icpac.doccontrast.service.IDocSubtaskService;
import com.jxdinfo.idp.icpac.doccontrast.service.IZnysAbilityExtractElementNotUseOcrService;
import com.jxdinfo.idp.icpac.doccontrast.util.ExecutorFactory;
import com.jxdinfo.idp.icpac.docexamine.executor.IExtractor;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.ResourceUtils;

@Service
public class DocExamineServiceImpl
implements IDocExamineService {
    private static final Logger log = LoggerFactory.getLogger(DocExamineServiceImpl.class);
    @Autowired
    private IDocSubtaskService subtaskService;
    @Autowired
    private IExtractElementService extractElementService;
    @Autowired
    private IZnysAbilityExtractElementNotUseOcrService znysAbilityExtractElementNotUseOcrService;
    private static ExecutorService pool = Executors.newFixedThreadPool(10);
    private IExtractor extractor;
    @Value(value="${isUserOcr}")
    private String isUserOcr;

    @Override
    public void extract(String subTaskId, byte[] files) {
        DocSubtaskDto subtask = this.subtaskService.getDetail(subTaskId);
        subtask.setFiles(files);
        this.extract(subtask);
    }

    private void extract(DocSubtaskDto subtask) {
        if (subtask.getDocId() != null) {
            this.extractElementService.removeByDocId(subtask.getDocId());
        }
        List<Object> extractElementList = new ArrayList();
        String docFormat = subtask.getDocFormat();
        if ((Objects.equals(docFormat, "4") || Objects.equals(docFormat, "5")) && Objects.equals(this.isUserOcr, "0")) {
            Long docVersionId = subtask.getDocVersionId();
            QueryWrapper wrapper = (QueryWrapper)new QueryWrapper().eq((Object)"DOC_VERSION_ID", (Object)docVersionId);
            List zaeenuList = this.znysAbilityExtractElementNotUseOcrService.list((Wrapper)wrapper);
            for (ZnysAbilityExtractElementNotUseOcr zaeenu : zaeenuList) {
                ExtractElement extractElement = new ExtractElement();
                extractElement.setId(IdUtils.simpleUUID());
                extractElement.setDocId(subtask.getDocId());
                extractElement.setDocElementId(zaeenu.getDocElementId());
                extractElement.setDocFormat(zaeenu.getDocFormat());
                extractElement.setElementType(zaeenu.getElementType());
                extractElement.setElementText(zaeenu.getElementText());
                extractElementList.add(extractElement);
            }
        } else {
            this.extractor = ExecutorFactory.executor(docFormat);
            if (this.extractor == null) {
                return;
            }
            extractElementList = this.extractor.extract(subtask);
        }
        this.extractElementService.saveBatch(extractElementList);
    }

    private void deleteDirectory(File file) throws IOException {
        if (file.exists()) {
            if (!file.isDirectory() || file.list().length == 0) {
                file.delete();
            } else {
                for (File f : file.listFiles()) {
                    this.deleteDirectory(f);
                }
                file.delete();
            }
        }
    }

    private void deleteRecentDirectory() throws FileNotFoundException {
        String path = ResourceUtils.getURL((String)"classpath:").getPath() + "static/img";
        Date nowDate = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(nowDate);
        calendar.add(5, -3);
        Date daysAgo = calendar.getTime();
        long t1 = daysAgo.getTime();
        try {
            File f = new File(path);
            File[] files = f.listFiles();
            if (files == null) {
                return;
            }
            for (File value : files) {
                String filePath = value.getCanonicalPath();
                long lastTime = value.lastModified();
                if (lastTime >= t1 || !value.exists()) continue;
                File file = new File(filePath);
                this.deleteDirectory(file);
            }
        }
        catch (IOException e) {
            log.error("\u5220\u9664\u5386\u53f2\u6587\u4ef6\u5931\u8d25", (Throwable)e);
        }
    }
}

