/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.icpac.doccontrast.controller;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.SftpException;
import com.jxdinfo.idp.common.response.ApiResponse;
import com.jxdinfo.idp.icpac.doccontrast.entity.ContrastResult;
import com.jxdinfo.idp.icpac.doccontrast.entity.ContrastSymbol;
import com.jxdinfo.idp.icpac.doccontrast.entity.dto.ContrastTaskDto;
import com.jxdinfo.idp.icpac.doccontrast.entity.dto.DocContrastDto;
import com.jxdinfo.idp.icpac.doccontrast.entity.query.ContrastResultQuery;
import com.jxdinfo.idp.icpac.doccontrast.entity.query.ContrastSymbolQuery;
import com.jxdinfo.idp.icpac.doccontrast.entity.query.ContrastTaskQuery;
import com.jxdinfo.idp.icpac.doccontrast.entity.query.DocContrastQuery;
import com.jxdinfo.idp.icpac.doccontrast.service.IContrastSymbolService;
import com.jxdinfo.idp.icpac.doccontrast.service.IDocContrastService;
import com.jxdinfo.idp.icpac.doccontrast.service.impl.FileInfoServiceImpl;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/icpac/docContrast"})
public class DocContrastController {
    @Autowired
    private IDocContrastService service;
    @Autowired
    private FileInfoServiceImpl fileInfoService;
    @Autowired
    private IContrastSymbolService contrastSymbolService;

    @PostMapping(value={"/getTaskList"})
    public ApiResponse<Page<ContrastTaskDto>> getTaskList(@RequestBody ContrastTaskQuery query) {
        return ApiResponse.data(this.service.getTaskList(query));
    }

    @PostMapping(value={"/getTaskById"})
    public ApiResponse<ContrastTaskDto> getTaskById(@RequestBody ContrastTaskQuery query) {
        return ApiResponse.data((Object)this.service.getTaskById(query));
    }

    @PostMapping(value={"/deleteTask"})
    public ApiResponse<Void> deleteTask(@RequestBody DocContrastQuery query) throws IOException, JSchException, SftpException {
        this.service.deleteTask(query);
        return ApiResponse.success();
    }

    @PostMapping(value={"/contrast"})
    public ApiResponse<ContrastTaskDto> contrast(@RequestBody DocContrastDto query) throws Exception {
        ContrastTaskQuery contrastTaskQuery = new ContrastTaskQuery();
        contrastTaskQuery.setId(this.service.contrast(query));
        if (this.service.getTaskById(contrastTaskQuery).getPointCount() == 0) {
            return ApiResponse.data((Object)this.service.getTaskById(contrastTaskQuery), (String)"\u4e24\u4e2a\u6587\u6863\u5b8c\u5168\u76f8\u540c\u6216\u5b8c\u5168\u4e0d\u540c");
        }
        return ApiResponse.data((Object)this.service.getTaskById(contrastTaskQuery));
    }

    @PostMapping(value={"/removeFile"})
    public ApiResponse<Boolean> removeFile(@RequestBody Long fileId) {
        if (this.fileInfoService.remove(fileId)) {
            return ApiResponse.success();
        }
        return ApiResponse.fail((String)"\u5220\u9664\u5931\u8d25");
    }

    @PostMapping(value={"/getResult"})
    public ApiResponse<List<ContrastResult>> getResult(@RequestBody ContrastResultQuery query) {
        List<ContrastResult> resultList = this.service.getResultList(query);
        if (resultList.size() == 0) {
            return ApiResponse.data(resultList, (String)"\u4e24\u4e2a\u6587\u6863\u5b8c\u5168\u76f8\u540c");
        }
        if (resultList.size() == 1 && "9".equals(resultList.get(0).getElementType())) {
            return ApiResponse.data(new ArrayList(), (String)"\u4e24\u4e2a\u6587\u6863\u5b8c\u5168\u4e0d\u540c");
        }
        return ApiResponse.success(resultList);
    }

    @PostMapping(value={"/getStream"})
    public void getStream(HttpServletResponse response, @RequestBody DocContrastQuery query) throws Exception {
        this.service.getStream(response, query);
    }

    @PostMapping(value={"/insertOrUpdate"})
    public ApiResponse<Object> InsertOrUpdate(@RequestBody ContrastSymbolQuery query) {
        String result = this.contrastSymbolService.insertOrUpdate(query);
        if (result.equals("\u6b64\u5b57\u7b26\u5df2\u5b58\u5728")) {
            return ApiResponse.fail((String)"\u6b64\u5b57\u7b26\u5df2\u5b58\u5728");
        }
        if (result.equals("\u5b57\u7b26\u8d85\u957f\uff0c\u65b0\u589e\u5931\u8d25")) {
            return ApiResponse.fail((String)"\u5b57\u7b26\u8d85\u957f\uff0c\u65b0\u589e\u5931\u8d25");
        }
        return ApiResponse.success((Object)JSON.parseObject((String)result, ContrastSymbol.class));
    }

    @PostMapping(value={"/getSymbol"})
    public ApiResponse<List<ContrastSymbol>> getAllSymbol(@RequestBody ContrastSymbolQuery query) {
        return ApiResponse.data(this.contrastSymbolService.getSymbol(query));
    }

    @PostMapping(value={"/deleteBatch"})
    public ApiResponse<Void> deleteBatch(@RequestBody List<String> ids) {
        this.contrastSymbolService.deleteBatch(ids);
        return ApiResponse.success();
    }

    @PostMapping(value={"/updateAll"})
    public ApiResponse<Void> updateAll(@RequestBody ContrastSymbolQuery query) {
        this.contrastSymbolService.updateAll(query);
        return ApiResponse.success();
    }
}

