/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.icpac.common.ocr.handler.parser;

import cn.hutool.core.util.IdUtil;
import com.jxdinfo.idp.extract.domain.extractor.ocrconfigxtract.SingleSignInfo;
import com.jxdinfo.idp.icpac.common.entity.PdfOcrResponse;
import com.jxdinfo.idp.icpac.common.entity.po.ExtractElement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ObjectUtils;

public class SignParser {
    private PdfOcrResponse ocrResponse;
    private Long docId;
    private String docFormat;
    private String elementType;

    public SignParser(PdfOcrResponse ocrResponse, String docFormat, String elementType) {
        this.ocrResponse = ocrResponse;
        this.docId = ocrResponse.getDocId();
        this.docFormat = docFormat;
        this.elementType = elementType;
    }

    public List<ExtractElement> parse() {
        Map<String, SingleSignInfo> sign = this.ocrResponse.getSign();
        ArrayList<ExtractElement> elementResults = new ArrayList<ExtractElement>();
        for (Map.Entry<String, SingleSignInfo> entry : sign.entrySet()) {
            String key = entry.getKey();
            SingleSignInfo signInfo = sign.get(key);
            ExtractElement extractElement = new ExtractElement();
            extractElement.setId(IdUtil.fastSimpleUUID());
            extractElement.setDocId(this.docId);
            extractElement.setDocFormat(this.docFormat);
            extractElement.setElementType(this.elementType);
            extractElement.setDocElementId(key);
            extractElement.setElementText(this.checkBoolean(signInfo));
            elementResults.add(extractElement);
        }
        return elementResults;
    }

    private String checkBoolean(SingleSignInfo signInfo) {
        if (ObjectUtils.isEmpty((Object)signInfo)) {
            return "\u5426";
        }
        return signInfo.isFlag() ? "\u6709" : "\u65e0";
    }
}

