/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.icpac.common.ocr.handler.parser;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.jxdinfo.idp.icpac.common.entity.PdfOcrResponse;
import com.jxdinfo.idp.icpac.common.entity.po.ExtractElement;
import com.jxdinfo.idp.icpac.common.ocr.handler.parser.OcrBaseParser;
import com.jxdinfo.idp.icpac.common.response.generic.OcrPageResponse;
import com.jxdinfo.idp.icpac.common.response.generic.OcrSeal;
import com.jxdinfo.idp.icpac.common.response.generic.OcrText;
import com.jxdinfo.idp.icpac.docexamine.entity.location.OcrCoord;
import com.jxdinfo.idp.icpac.docexamine.entity.location.OcrTextLocation;
import java.util.ArrayList;
import java.util.List;

public class PageParser
extends OcrBaseParser {
    private String type;

    public PageParser(PdfOcrResponse ocrResponse) {
        super(ocrResponse, ocrResponse.getDocId(), "5", "text");
        this.type = ocrResponse.getPageInfoType();
    }

    public List<ExtractElement> parse() {
        ArrayList<ExtractElement> result = new ArrayList<ExtractElement>();
        List<OcrPageResponse> pageInfos = this.ocrResponse.getPageInfos();
        if (CollectionUtil.isEmpty(pageInfos)) {
            return result;
        }
        for (OcrPageResponse pageInfo : pageInfos) {
            String locationStr;
            List<Double> box;
            OcrTextLocation location;
            ExtractElement extractElement;
            if ("text".equals(this.type)) {
                List<OcrText> textes = pageInfo.getTextes();
                for (OcrText text : textes) {
                    extractElement = this.extractElement();
                    location = new OcrTextLocation();
                    location.setPageIndex(pageInfo.getPage_id());
                    location.setPageHeight(pageInfo.getPage_size().getH());
                    location.setPageWidth(pageInfo.getPage_size().getW());
                    box = text.getBox();
                    location.setType(this.type);
                    location.setLeftTop(new OcrCoord(box.get(0), box.get(1)));
                    location.setRightTop(new OcrCoord(box.get(2), box.get(3)));
                    location.setRightBottom(new OcrCoord(box.get(4), box.get(5)));
                    location.setLeftBottom(new OcrCoord(box.get(6), box.get(7)));
                    locationStr = JSON.toJSONString((Object)location);
                    extractElement.setOriginText(text.getText());
                    extractElement.setElementText(text.getText());
                    extractElement.setElementLocation(locationStr);
                    result.add(extractElement);
                }
                continue;
            }
            List<OcrSeal> objects = pageInfo.getObjects();
            for (OcrSeal seal : objects) {
                extractElement = this.extractElement();
                location = new OcrTextLocation();
                location.setPageIndex(pageInfo.getPage_id());
                location.setPageHeight(pageInfo.getPage_size().getH());
                location.setPageWidth(pageInfo.getPage_size().getW());
                box = seal.getBox();
                location.setType(this.type);
                location.setLeftTop(new OcrCoord(box.get(0), box.get(1)));
                location.setRightTop(new OcrCoord());
                location.setRightBottom(new OcrCoord(box.get(2), box.get(3)));
                location.setLeftBottom(new OcrCoord());
                locationStr = JSON.toJSONString((Object)location);
                extractElement.setOriginText(seal.getText());
                extractElement.setElementText(seal.getText());
                extractElement.setElementLocation(locationStr);
                result.add(extractElement);
            }
        }
        return result;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PageParser)) {
            return false;
        }
        PageParser other = (PageParser)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        return !(this$type == null ? other$type != null : !this$type.equals(other$type));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof PageParser;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "PageParser(type=" + this.getType() + ")";
    }
}

