/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.icpac.common.ocr.handler.parser;

import cn.hutool.core.util.IdUtil;
import cn.hutool.json.JSONException;
import cn.hutool.json.JSONObject;
import com.jxdinfo.idp.icpac.common.entity.PdfOcrResponse;
import com.jxdinfo.idp.icpac.common.entity.po.ExtractElement;
import com.jxdinfo.idp.icpac.common.ocr.entity.config.extract.number.NumberConfig;
import com.jxdinfo.idp.icpac.common.ocr.handler.postprocess.impl.NumberPostProcessHandler;
import com.jxdinfo.idp.icpac.doccontrast.entity.po.ConfigDocElement;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NumberParser {
    private static final Logger log = LoggerFactory.getLogger(NumberParser.class);
    private PdfOcrResponse ocrResponse;
    private Long docId;
    private String docFormat;
    private String elementType;

    public NumberParser(PdfOcrResponse ocrResponse, String docFormat, String elementType) {
        this.ocrResponse = ocrResponse;
        this.docId = ocrResponse.getDocId();
        this.docFormat = docFormat;
        this.elementType = elementType;
    }

    public List<ExtractElement> parse(List<ConfigDocElement> configDocElements) {
        Map<String, String> numberResult = this.ocrResponse.getNumber();
        List<NumberConfig> numberConfig = this.ocrResponse.getOcrConfig().getNumberConfig();
        ArrayList<ExtractElement> elementResult = new ArrayList<ExtractElement>();
        for (ConfigDocElement element : configDocElements) {
            if (!element.getElementType().equals("text") && !element.getElementType().equals("number") && !element.getElementType().equals("date")) continue;
            try {
                if (!element.getElementType().equals("number")) continue;
                NumberConfig numberConfigs = new NumberConfig();
                numberConfigs.setKey(element.getElementName());
                JSONObject jsonObject = new JSONObject((Object)element.getExtractRule());
                numberConfigs.setReplace((Boolean)jsonObject.get((Object)"replace"));
                numberConfigs.setText_pattern((List)jsonObject.get((Object)"text_pattern"));
                numberConfigs.setText_process((String)jsonObject.get((Object)"text_process"));
                numberConfig.add(numberConfigs);
            }
            catch (JSONException e) {
                log.error("\u540e\u5904\u7406\u83b7\u53d6\u914d\u7f6e\u5bf9\u8c61\u5931\u8d25");
            }
            catch (NullPointerException e) {
                log.error("\u540e\u5904\u7406\u83b7\u53d6\u914d\u7f6e\u5bf9\u8c61\u5c5e\u6027\u5931\u8d25");
            }
        }
        for (NumberConfig config : numberConfig) {
            String key = config.getKey();
            String value = numberResult.get(key);
            if (StringUtils.isBlank((CharSequence)(value = this.checkNum2(value)))) continue;
            NumberPostProcessHandler handler = config.getPostProcessHandler(value);
            value = handler.process();
            ExtractElement extractElement = new ExtractElement();
            extractElement.setId(IdUtil.fastSimpleUUID());
            extractElement.setDocId(this.docId);
            extractElement.setDocFormat(this.docFormat);
            extractElement.setElementType(this.elementType);
            extractElement.setDocElementId(key);
            extractElement.setElementText(value);
            elementResult.add(extractElement);
        }
        return elementResult;
    }

    private String checkNum2(String str) {
        try {
            String s = "0";
            if (StringUtils.isEmpty((CharSequence)str)) {
                return s;
            }
            Pattern p = Pattern.compile("(\\d+\\.?\\d*)");
            Matcher m = p.matcher(str);
            ArrayList<BigDecimal> resultList = new ArrayList<BigDecimal>();
            BigDecimal result = BigDecimal.ZERO;
            while (m.find()) {
                resultList.add(new BigDecimal(m.group()));
                result = result.add(new BigDecimal(m.group()));
            }
            StringJoiner sj = new StringJoiner(", ");
            for (BigDecimal bd : resultList) {
                sj.add(bd.toString());
            }
            String ss = sj.toString();
            return ss;
        }
        catch (NumberFormatException e) {
            log.error("Number format error in the input string: " + str, (Throwable)e);
            return null;
        }
    }

    private BigDecimal checkNum(String str) {
        BigDecimal result;
        if (StringUtils.isEmpty((CharSequence)str)) {
            return new BigDecimal(0);
        }
        Pattern p = Pattern.compile("(\\d+)");
        Matcher m = p.matcher(str);
        if (m.find()) {
            TreeMap<Integer, String> map = new TreeMap<Integer, String>();
            Pattern p2 = Pattern.compile("(\\d+\\.\\d+)");
            m = p2.matcher(str);
            while (m.find()) {
                result = new BigDecimal(m.group(1) == null ? "" : m.group(1));
                int i = str.indexOf(result.toPlainString());
                String s = str.substring(i, i + result.toPlainString().length());
                map.put(i, s);
                str = str.substring(0, i) + str.substring(i + result.toPlainString().length());
            }
            Pattern p3 = Pattern.compile("(\\d+)");
            m = p3.matcher(str);
            while (m.find()) {
                result = new BigDecimal(m.group(1) == null ? "" : m.group(1));
                int i = str.indexOf(result.toPlainString());
                if (i > 0 && ".".equals(String.valueOf(str.charAt(i - 1)))) {
                    str = str.substring(0, i - 1) + str.substring(i + result.toPlainString().length());
                    continue;
                }
                String s = str.substring(i, i + result.toPlainString().length());
                map.put(i, s);
                str = str.substring(0, i) + str.substring(i + result.toPlainString().length());
            }
            result = new BigDecimal(0);
            for (Map.Entry e : map.entrySet()) {
                result = result.add(new BigDecimal((String)e.getValue()));
            }
            if (str.startsWith("-")) {
                return new BigDecimal(0).subtract(result);
            }
        } else {
            result = null;
        }
        return result;
    }
}

