/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.usehub.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.idp.common.response.ApiResponse;
import com.jxdinfo.idp.usehub.service.dto.UseHubFileDto;
import com.jxdinfo.usehub.dto.BaiduExtractDto;
import com.jxdinfo.usehub.dto.BaiduTaskDto;
import com.jxdinfo.usehub.po.BaiduExtractTaskPo;
import com.jxdinfo.usehub.service.IBaiduExtractTaskService;
import java.io.IOException;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/baidu/extract"})
public class BaiduExtractController {
    @Autowired
    private IBaiduExtractTaskService taskService;

    @GetMapping(value={"/checkStatus"})
    public ApiResponse<Boolean> checkStatus(@RequestParam String taskId) {
        if (this.taskService.checkResult(taskId)) {
            return ApiResponse.success((Object)true);
        }
        return ApiResponse.success((Object)false);
    }

    @PostMapping(value={"/getTaskList"})
    public ApiResponse<Page<BaiduExtractTaskPo>> getTaskList(@RequestBody BaiduTaskDto query) {
        return ApiResponse.success((Object)this.taskService.selectList(query));
    }

    @PostMapping(value={"/createTask"})
    public ApiResponse<Void> createTask(BaiduExtractDto query) throws IOException {
        if (this.taskService.createTask(query)) {
            return ApiResponse.success();
        }
        return ApiResponse.fail((String)UseHubFileDto.super("\u5239\u5eb4\u4ed9\u52ef\u5913\u8d6b"));
    }

    @PostMapping(value={"/getAuthentication"})
    public ApiResponse<String> getAuthentication() {
        String a = this.taskService.getAuthentication();
        if (a.equals(UseHubFileDto.super("+P<M<"))) {
            return ApiResponse.fail((String)UseHubFileDto.super("\u6764\u8395\u5398\u5212\u923a\u6761\u784f\uff2e\u8bb9\u67c7\u7745\u76da\u513d\u8b9c\u7f20"));
        }
        return ApiResponse.data((Object)a);
    }

    @PostMapping(value={"/deleteTask"})
    public ApiResponse<Void> deleteTask(@RequestBody List<String> ids) {
        if (this.taskService.deleteList(ids)) {
            return ApiResponse.success();
        }
        return ApiResponse.fail((String)UseHubFileDto.super("\u5202\u962a\u5913\u8d6b"));
    }
}

