/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.usehub.controller;

import cn.hutool.core.thread.ThreadUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.idp.common.response.ApiResponse;
import com.jxdinfo.idp.common.response.ResultCode;
import com.jxdinfo.idp.common.util.user.UserUtils;
import com.jxdinfo.idp.scene.api.dto.GroupSceneDto;
import com.jxdinfo.idp.scene.api.dto.SceneConfigDto;
import com.jxdinfo.idp.scene.api.dto.SceneRuleLibDto;
import com.jxdinfo.idp.scene.api.po.ScenePo;
import com.jxdinfo.idp.scene.api.vo.ScenePageVo;
import com.jxdinfo.idp.scene.server.service.impl.SceneDocTypeRelevancyServiceImpl;
import com.jxdinfo.idp.scene.server.service.impl.SceneServiceImpl;
import com.jxdinfo.idp.usehub.entity.dto.ReviewExecuteDto;
import com.jxdinfo.usehub.api.CensorOverInterface;
import com.jxdinfo.usehub.api.UsehubApiService;
import com.jxdinfo.usehub.dto.CensorOverDto;
import com.jxdinfo.usehub.dto.GroupSceneDtoExt;
import com.jxdinfo.usehub.dto.SceneDto;
import com.jxdinfo.usehub.dto.UseHubBatchUploadDocDto;
import com.jxdinfo.usehub.dto.UsehubAddBatchInfoDto;
import com.jxdinfo.usehub.dto.UsehubTaskBatchDetailDto;
import com.jxdinfo.usehub.dto.UsehubTaskDocDto;
import com.jxdinfo.usehub.dto.UsehubTaskDto;
import com.jxdinfo.usehub.po.UsehubTaskPo;
import com.jxdinfo.usehub.service.SceneExecuteService;
import com.jxdinfo.usehub.service.UseHubTaskService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class UsehubController
implements UsehubApiService {
    @Resource
    private UseHubTaskService iCensorExecuteService;
    @Resource
    private SceneServiceImpl sceneService;
    @Resource
    private SceneExecuteService iSceneExecuteService;
    @Autowired(required=false)
    private List<CensorOverInterface> censorOverInterfaces;
    private static final Logger log = LoggerFactory.getLogger(UsehubController.class);
    @Resource
    private SceneDocTypeRelevancyServiceImpl sceneDocTypeRelevancyServiceImpl;

    @GetMapping(value={"/deleteBatchInfo"})
    public ApiResponse<Void> deleteBatchInfo(@RequestParam String taskId, @RequestParam String batchNo) {
        if (taskId == null || taskId.isEmpty()) {
            return ApiResponse.fail((int)ResultCode.REQ_REJECT.getCode(), (String)ReviewExecuteDto.int("\u4f2d\u5156\u768f\u5b94\u67f3\u4ed3\u52b4\u66a9\u5b4dBx\u4e18\u7a71\u0014"));
        }
        if (batchNo == null || batchNo.isEmpty()) {
            return ApiResponse.fail((int)ResultCode.REQ_REJECT.getCode(), (String)ReviewExecuteDto.int("\u4f08\u5170\u76af\u626c\u6b0a\u53eb\u4e18\u7a71\u0014"));
        }
        try {
            this.iCensorExecuteService.deleteBatchInfo(taskId, batchNo);
        }
        catch (Exception a) {
            return ApiResponse.fail((int)ResultCode.REQ_REJECT.getCode(), (String)a.getMessage());
        }
        return ApiResponse.success();
    }

    @GetMapping(value={"/updateSceneNameInfo"})
    public ApiResponse<Void> updateSceneNameInfo(@RequestParam String sceneId, @RequestParam String sceneName) {
        if (sceneId == null || sceneId.isEmpty()) {
            return ApiResponse.fail((int)ResultCode.REQ_REJECT.getCode(), (String)ReviewExecuteDto.int("\u4f36\u514d\u7691\u5711\u667aBx\u4e18\u7a71\u0014"));
        }
        if (sceneName == null || sceneName.isEmpty()) {
            return ApiResponse.fail((int)ResultCode.REQ_REJECT.getCode(), (String)ReviewExecuteDto.int("\u4f36\u514d\u7691\u5711\u667a\u5426\u79ec\u4e18\u7a71\u0014"));
        }
        this.iCensorExecuteService.updateSceneNameInfo(Long.valueOf(sceneId), sceneName);
        return ApiResponse.success();
    }

    /*
     * WARNING - void declaration
     */
    @PostMapping(value={"/batchDeleteCensorTask"})
    public ApiResponse<Void> batchDeleteCensorTask(@RequestBody List<String> usehubTaskIdList) {
        Iterator<String> iterator;
        if (usehubTaskIdList.isEmpty()) {
            return ApiResponse.fail((int)ResultCode.REQ_REJECT.getCode(), (String)ReviewExecuteDto.int("\u4f2d\u5156\u768f\u5b94\u67f3\u4ed3\u52b4Bq\u96ed\u5414\u4e18\u7a71\u0014"));
        }
        Iterator<String> iterator2 = iterator = usehubTaskIdList.iterator();
        while (iterator2.hasNext()) {
            void a;
            Long l = Long.valueOf(iterator.next());
            iterator2 = iterator;
            this.iCensorExecuteService.deleteCensorTask((Long)a);
        }
        return ApiResponse.success();
    }

    @PostMapping(value={"/batchUploadDocInfo"})
    public ApiResponse<Void> batchUploadDocInfo(@RequestBody UseHubBatchUploadDocDto useHubBatchUploadDocDto) {
        try {
            this.iCensorExecuteService.batchUploadDocInfo(useHubBatchUploadDocDto);
        }
        catch (Exception a) {
            return ApiResponse.fail((int)ResultCode.REQ_REJECT.getCode(), (String)a.getMessage());
        }
        return ApiResponse.success();
    }

    /*
     * WARNING - void declaration
     */
    @PostMapping(value={"/getSceneByPage"})
    public ApiResponse<Page<SceneDto>> getSceneByPage(@RequestBody ScenePageVo scenePageVo) {
        Page a = new Page((long)scenePageVo.getCurrent(), (long)scenePageVo.getSize());
        Page a2 = this.sceneService.getSceneList(scenePageVo);
        List a3 = a2.getRecords();
        ArrayList<void> a4 = new ArrayList<void>();
        if (!a3.isEmpty()) {
            Iterator iterator;
            Iterator iterator2 = iterator = a3.iterator();
            while (iterator2.hasNext()) {
                void a5;
                SceneRuleLibDto a6 = (SceneRuleLibDto)iterator.next();
                long a7 = a6.getSceneId();
                SceneDto sceneDto = new SceneDto();
                iterator2 = iterator;
                void v1 = a5;
                a5.setId(a7);
                v1.setName(a6.getSceneName());
                v1.setTaskNum(this.iCensorExecuteService.queryCountBySceneId(Long.valueOf(a7)));
                a4.add(a5);
            }
        }
        Page page = a;
        page.setRecords(a4);
        a.setTotal(a2.getTotal());
        return ApiResponse.success((Object)page);
    }

    @PostMapping(value={"/queryCensorTaskList"})
    public ApiResponse<Page<UsehubTaskPo>> queryCensorTaskList(@RequestBody UsehubTaskDto dto) {
        return ApiResponse.success((Object)this.iCensorExecuteService.queryCensorTaskList(dto));
    }

    @GetMapping(value={"/ifCensorTaskEnd"})
    public ApiResponse<String> ifCensorTaskEnd(@RequestParam String taskId) {
        if (taskId == null || taskId.isEmpty()) {
            return ApiResponse.fail((int)ResultCode.REQ_REJECT.getCode(), (String)ReviewExecuteDto.int("\u4f2b\u5150\u7692\u5b89\u67f0\u4ed0\u52b4Bx\u4e18\u7a71\u0014"));
        }
        return ApiResponse.success((String)this.iCensorExecuteService.ifCensorTaskEnd(taskId));
    }

    public ApiResponse<Map<String, Object>> censorTaskRuleResult(@RequestParam String taskId, @RequestParam String sceneId, @RequestParam String batchNo, @RequestParam String docTypeId) {
        if (taskId == null || taskId.isEmpty()) {
            return ApiResponse.fail((int)ResultCode.REQ_REJECT.getCode(), (String)ReviewExecuteDto.int("\u4f2b\u5150\u7692\u5b89\u67f0\u4ed0\u52b4Bx\u4e18\u7a71\u0014"));
        }
        if (sceneId == null || sceneId.isEmpty()) {
            return ApiResponse.fail((int)ResultCode.REQ_REJECT.getCode(), (String)ReviewExecuteDto.int("\u4f36\u514d\u7691\u5711\u667aBx\u4e18\u7a71\u0014"));
        }
        return ApiResponse.success((Object)this.iCensorExecuteService.censorTaskRuleResult(taskId, sceneId, batchNo, docTypeId));
    }

    @PostMapping(value={"/addOrUpdateBatchInfo"})
    public ApiResponse<Void> addOrUpdateBatchInfo(@RequestBody UsehubAddBatchInfoDto usehubAddBatchInfoDto) {
        UsehubAddBatchInfoDto usehubAddBatchInfoDto2 = usehubAddBatchInfoDto;
        Long a = usehubAddBatchInfoDto2.getSceneId();
        String a2 = usehubAddBatchInfoDto2.getTaskId();
        String a3 = usehubAddBatchInfoDto2.getName();
        if (a == null) {
            return ApiResponse.fail((int)ResultCode.REQ_REJECT.getCode(), (String)ReviewExecuteDto.int("\u4f36\u514d\u7691\u5711\u667aBx\u4e18\u7a71\u0014"));
        }
        if (a2 == null || a2.isEmpty()) {
            return ApiResponse.fail((int)ResultCode.REQ_REJECT.getCode(), (String)ReviewExecuteDto.int("\u4f2d\u5156\u768f\u5b94\u67f3\u4ed3\u52b4\u66a9\u5b4dBx\u4e18\u7a71\u0014"));
        }
        if (a3 == null || a3.isEmpty()) {
            return ApiResponse.fail((int)ResultCode.REQ_REJECT.getCode(), (String)ReviewExecuteDto.int("\u4f15\u5173\u76ac\u626c\u6b0a\u53e2\u5426\u79ec\u4e18\u7a71\u0014"));
        }
        try {
            this.iCensorExecuteService.addOrUpdateBatchInfo(usehubAddBatchInfoDto);
        }
        catch (Exception a4) {
            return ApiResponse.fail((int)ResultCode.REQ_REJECT.getCode(), (String)a4.getMessage());
        }
        return ApiResponse.success();
    }

    public ApiResponse<Void> restartCensor(@Validated @RequestBody UsehubTaskDto usehubTaskDto) {
        UsehubTaskDto usehubTaskDto2 = usehubTaskDto;
        String a = usehubTaskDto2.getId();
        String a2 = usehubTaskDto2.getSceneId();
        String a3 = usehubTaskDto2.getSceneName();
        if (a == null || a.isEmpty()) {
            return ApiResponse.fail((int)ResultCode.REQ_REJECT.getCode(), (String)ReviewExecuteDto.int("\u4f2b\u5150\u7692\u5b89\u67f0\u4ed0\u52b4Bx\u4e18\u7a71\u0014"));
        }
        String a4 = usehubTaskDto.getTaskName();
        Map a5 = new HashMap();
        try {
            a5 = this.iCensorExecuteService.restartCensor(Long.valueOf(a), Long.valueOf(a2));
        }
        catch (Exception a6) {
            this.iCensorExecuteService.updateTaskStatus(Long.valueOf(a), ReviewExecuteDto.int("\u5bbd\u67c7\u593a\u8d10"), a6.getMessage());
            return ApiResponse.fail((int)ResultCode.REQ_REJECT.getCode(), (String)a6.getMessage());
        }
        String a7 = String.valueOf(UserUtils.getLoginUserId());
        Map a8 = a5;
        ThreadUtil.execute(() -> {
            boolean bl;
            UsehubController a7;
            long l = System.nanoTime();
            boolean bl2 = true;
            try {
                SceneConfigDto sceneConfigDto;
                SceneConfigDto sceneConfigDto2 = sceneConfigDto = new SceneConfigDto();
                SceneConfigDto sceneConfigDto3 = sceneConfigDto;
                SceneConfigDto sceneConfigDto4 = sceneConfigDto;
                sceneConfigDto4.setTaskId(Long.valueOf(a));
                sceneConfigDto4.setSceneId(Long.valueOf(a2));
                sceneConfigDto3.setSceneName(a3);
                sceneConfigDto3.setTaskName(a4);
                sceneConfigDto2.setTaskDocDtoMap(a8);
                sceneConfigDto2.setCreator(a7);
                a7.iSceneExecuteService.execute(sceneConfigDto);
                bl = bl2;
            }
            catch (Exception exception) {
                log.error(ReviewExecuteDto.int("\u6272\u8867\u5bb4\u67ce\u592d\u8d078\u000f"), (Throwable)exception);
                a7.iCensorExecuteService.updateTaskStatus(Long.valueOf(a), ReviewExecuteDto.int("\u5bbd\u67c7\u593a\u8d10"), exception.getMessage());
                bl = bl2 = false;
            }
            if (bl) {
                a7.iCensorExecuteService.updateTaskStatus(Long.valueOf(a), ReviewExecuteDto.int("\u5bbd\u67c7\u5b87\u6225"), null);
            }
            log.info(ReviewExecuteDto.int("\u302a\u007fk\u3039\u6590\u684a\u5bac\u67d6\u626c\u8879\u5b9a\u6bfd\uff19\u6010\u8002\u65ddg_fF"), (Object)a4, (Object)((System.nanoTime() - l) / 1000000L));
        });
        return ApiResponse.success();
    }

    @PostMapping(value={"/getDocTypeList"})
    public ApiResponse<Map<String, Object>> getDocTypeList(@RequestBody UsehubTaskDocDto usehubTaskDocDto) {
        UsehubTaskDocDto usehubTaskDocDto2 = usehubTaskDocDto;
        Long a = usehubTaskDocDto2.getSceneId();
        String a2 = usehubTaskDocDto2.getTaskId();
        if (a == null) {
            return ApiResponse.fail((int)ResultCode.REQ_REJECT.getCode(), (String)ReviewExecuteDto.int("\u4f36\u514d\u7691\u5711\u667aBx\u4e18\u7a71\u0014"));
        }
        if (a2 == null || a2.isEmpty()) {
            return ApiResponse.fail((int)ResultCode.REQ_REJECT.getCode(), (String)ReviewExecuteDto.int("\u4f2d\u5156\u768f\u5b94\u67f3\u4ed3\u52b4\u66a9\u5b4dBx\u4e18\u7a71\u0014"));
        }
        UsehubController usehubController = this;
        List a3 = usehubController.sceneDocTypeRelevancyServiceImpl.getDocTypeObjectList(a.longValue());
        return ApiResponse.success((Object)usehubController.iCensorExecuteService.getDocTypeList(a, a3, a2));
    }

    /*
     * WARNING - void declaration
     */
    @GetMapping(value={"/queryCensorResultDetailInfo"})
    public ApiResponse<List<UsehubTaskBatchDetailDto>> queryCensorResultDetailInfo(@RequestParam String string, String string2) {
        void docName;
        void taskId;
        if (taskId == null || taskId.isEmpty()) {
            return ApiResponse.fail((int)ResultCode.REQ_REJECT.getCode(), (String)ReviewExecuteDto.int("\u4f2b\u5150\u7692\u5b89\u67f0\u4ed0\u52b4Bx\u4e18\u7a71\u0014"));
        }
        Long a = Long.valueOf((String)taskId);
        return ApiResponse.success((Object)this.iCensorExecuteService.censorResultDetailInfo(a, (String)docName));
    }

    @GetMapping(value={"/deleteUnmatchedDocInfo"})
    public ApiResponse<Void> deleteUnmatchedDocInfo(@RequestParam String taskId, @RequestParam String docId) {
        if (taskId == null || taskId.isEmpty()) {
            return ApiResponse.fail((int)ResultCode.REQ_REJECT.getCode(), (String)ReviewExecuteDto.int("\u4f2d\u5156\u768f\u5b94\u67f3\u4ed3\u52b4\u66a9\u5b4dBx\u4e18\u7a71\u0014"));
        }
        if (docId == null || docId.isEmpty()) {
            return ApiResponse.fail((int)ResultCode.REQ_REJECT.getCode(), (String)ReviewExecuteDto.int("\u4f36\u514d\u7691\u65ac\u6876Bx\u4e18\u7a71\u0014"));
        }
        this.iCensorExecuteService.deleteUnmatchedDocInfo(taskId, docId);
        return ApiResponse.success();
    }

    @GetMapping(value={"/updateIsIgnoreInfo"})
    public ApiResponse<Void> updateIsIgnoreInfo(@RequestParam Long id, @RequestParam int isIgnore) {
        this.iCensorExecuteService.censorExecuteDocResultProcess(id, isIgnore);
        return ApiResponse.success();
    }

    @GetMapping(value={"/deleteUploadDocInfo"})
    public ApiResponse<Void> deleteUploadDocInfo(@RequestParam String taskId, @RequestParam String docTypeId, @RequestParam String docId) {
        if (taskId == null || taskId.isEmpty()) {
            return ApiResponse.fail((int)ResultCode.REQ_REJECT.getCode(), (String)ReviewExecuteDto.int("\u4f2d\u5156\u768f\u5b94\u67f3\u4ed3\u52b4\u66a9\u5b4dBx\u4e18\u7a71\u0014"));
        }
        if (docTypeId == null || docTypeId.isEmpty()) {
            return ApiResponse.fail((int)ResultCode.REQ_REJECT.getCode(), (String)ReviewExecuteDto.int("\u4f36\u514d\u7691\u65ac\u6876\u7c50\u5797\u4e18\u7a71\u0014"));
        }
        if (docId == null || docId.isEmpty()) {
            return ApiResponse.fail((int)ResultCode.REQ_REJECT.getCode(), (String)ReviewExecuteDto.int("\u4f36\u514d\u7691\u65ac\u6876Bx\u4e18\u7a71\u0014"));
        }
        this.iCensorExecuteService.deleteUploadDocInfo(taskId, docTypeId, docId);
        return ApiResponse.success();
    }

    @GetMapping(value={"/deleteCensorTask"})
    public ApiResponse<Void> deleteCensorTask(@RequestParam String usehubTaskId) {
        if (usehubTaskId == null || usehubTaskId.isEmpty()) {
            return ApiResponse.fail((int)ResultCode.REQ_REJECT.getCode(), (String)ReviewExecuteDto.int("\u4f2b\u5150\u7692\u5b89\u67f0\u4ed0\u52b4Bx\u4e18\u7a71\u0014"));
        }
        Long a = Long.valueOf(usehubTaskId);
        this.iCensorExecuteService.deleteCensorTask(a);
        return ApiResponse.success();
    }

    /*
     * WARNING - void declaration
     */
    @PostMapping(value={"/search"})
    public ApiResponse<List<SceneDto>> search(@RequestParam(required=false) String sceneName, @RequestParam(required=false) String startCreateTime, @RequestParam(required=false) String endCreateTime) {
        Iterator iterator;
        List a = this.sceneService.search(sceneName, startCreateTime, endCreateTime);
        ArrayList<void> a2 = new ArrayList<void>();
        Iterator iterator2 = iterator = a.iterator();
        while (iterator2.hasNext()) {
            void a3;
            ScenePo a4 = (ScenePo)iterator.next();
            long a5 = a4.getId();
            SceneDto sceneDto = new SceneDto();
            iterator2 = iterator;
            void v1 = a3;
            a3.setId((long)((int)a5));
            v1.setName(a4.getName());
            v1.setTaskNum(this.iCensorExecuteService.queryCountBySceneId(Long.valueOf(a5)));
            a2.add(a3);
        }
        return ApiResponse.success(a2);
    }

    @GetMapping(value={"/ifExitTaskName"})
    public ApiResponse<Boolean> ifExitTaskName(@RequestParam String sceneId, @RequestParam String taskName) {
        if (sceneId == null || sceneId.isEmpty()) {
            return ApiResponse.fail((int)ResultCode.REQ_REJECT.getCode(), (String)ReviewExecuteDto.int("\u4f36\u514d\u7691\u5711\u667aBx\u4e18\u7a71\u0014"));
        }
        if (taskName == null || taskName.isEmpty()) {
            return ApiResponse.fail((int)ResultCode.REQ_REJECT.getCode(), (String)ReviewExecuteDto.int("\u4f2b\u5150\u7692\u5b89\u67f0\u4ed0\u52b4\u5426\u79ec\u4e18\u7a71\u0014"));
        }
        return ApiResponse.success((Object)this.iCensorExecuteService.ifExitTaskName(sceneId, taskName));
    }

    public ApiResponse<Void> startCensor(@Validated @RequestBody UsehubTaskDto usehubTaskDto) {
        UsehubTaskDto usehubTaskDto2 = usehubTaskDto;
        String a = usehubTaskDto2.getSceneId();
        String a2 = usehubTaskDto2.getSceneName();
        String a3 = usehubTaskDto2.getTaskName();
        Map a4 = usehubTaskDto2.getTaskDocDtoMap();
        String a5 = usehubTaskDto2.getSaveId();
        if (a4.isEmpty()) {
            return ApiResponse.fail((int)ResultCode.REQ_REJECT.getCode(), (String)ReviewExecuteDto.int("\u4f2d\u5156\u768f\u5b94\u67f3\u4ed3\u52b4\u65ac\u6876\u4fca\u6073\u4e18\u7a71\u0014"));
        }
        if (a5 == null || "".equals(a5)) {
            return ApiResponse.fail((int)ResultCode.REQ_REJECT.getCode(), (String)ReviewExecuteDto.int("\u4f2d\u5156\u768f\u65b2\u6875\u4e22\u4f35\u4ed0\u52b4Bx\u4e18\u7a71\u0014"));
        }
        String a6 = "";
        try {
            a6 = this.iCensorExecuteService.startCensor(usehubTaskDto);
        }
        catch (Exception a7) {
            log.error(new StringBuilder().insert(0, ReviewExecuteDto.int("\u6272\u8867\u5bb4\u67ce\u592d\u8d07:\u000f")).append(a7.getMessage()).toString());
            this.iCensorExecuteService.updateTaskStatus(Long.valueOf(a6), ReviewExecuteDto.int("\u5bbd\u67c7\u593a\u8d10"), a7.getMessage());
            return ApiResponse.fail((int)ResultCode.REQ_REJECT.getCode(), (String)a7.getMessage());
        }
        String a8 = String.valueOf(UserUtils.getLoginUserId());
        String a9 = a6;
        ThreadUtil.execute(() -> {
            boolean bl;
            UsehubController a9;
            long l = System.nanoTime();
            boolean bl2 = true;
            try {
                SceneConfigDto sceneConfigDto;
                SceneConfigDto sceneConfigDto2 = sceneConfigDto = new SceneConfigDto();
                SceneConfigDto sceneConfigDto3 = sceneConfigDto;
                SceneConfigDto sceneConfigDto4 = sceneConfigDto;
                sceneConfigDto.setTaskId(Long.valueOf(a9));
                sceneConfigDto4.setSceneId(Long.valueOf(a));
                sceneConfigDto4.setSceneName(a2);
                sceneConfigDto3.setTaskName(a3);
                sceneConfigDto3.setTaskDocDtoMap(a4);
                sceneConfigDto2.setCreator(a8);
                sceneConfigDto2.setJsonMap(usehubTaskDto.getJsonMap());
                a9.iSceneExecuteService.execute(sceneConfigDto);
                bl = bl2;
            }
            catch (Exception exception) {
                log.error(ReviewExecuteDto.int("\u6272\u8867\u5bb4\u67ce\u592d\u8d079\u000f"), (Throwable)exception);
                if (exception instanceof NullPointerException || ReviewExecuteDto.int("rWgY").equals(exception.getMessage())) {
                    a9.iCensorExecuteService.updateTaskStatus(Long.valueOf(a9), ReviewExecuteDto.int("\u5bbd\u67c7\u593a\u8d10"), ReviewExecuteDto.int("\u63e3\u53dd\u7ee6\u678a\u4e25\u6ef4\u8d98\u5bb4\u67ce\u5170\u5f2d\u898a\u6c77"));
                } else {
                    a9.iCensorExecuteService.updateTaskStatus(Long.valueOf(a9), ReviewExecuteDto.int("\u5bbd\u67c7\u593a\u8d10"), exception.getMessage());
                }
                bl2 = false;
                if (ObjectUtil.isNotNull(a9.censorOverInterfaces)) {
                    a9.censorOverInterfaces.forEach(a22 -> {
                        try {
                            a22.failCall(new CensorOverDto(Long.valueOf(a9)));
                            return;
                        }
                        catch (Exception a22) {
                            log.error(new StringBuilder().insert(0, ReviewExecuteDto.int("\u56f5\u8c1f\u5913\u8d2e\u000f")).append(a22.getMessage()).toString());
                            return;
                        }
                    });
                }
                bl = bl2;
            }
            if (bl) {
                UsehubController usehubController = a9;
                usehubController.iCensorExecuteService.updateTaskStatus(Long.valueOf(a9), ReviewExecuteDto.int("\u5bbd\u67c7\u5b87\u6225"), null);
                if (ObjectUtil.isNotNull(usehubController.censorOverInterfaces)) {
                    a9.censorOverInterfaces.stream().forEach(a2 -> a2.successCall(new CensorOverDto(Long.valueOf(a9))));
                }
            }
            log.info(ReviewExecuteDto.int("\u302a\u007fk\u3039\u6590\u684a\u5bac\u67d6\u626c\u8879\u5b9a\u6bfd\uff19\u6010\u8002\u65ddg_fF"), (Object)a3, (Object)((System.nanoTime() - l) / 1000000L));
        });
        return ApiResponse.success((String)a6);
    }

    @GetMapping(value={"/queryAllCensorTaskCount"})
    public ApiResponse<Integer> queryAllCensorTaskCount() {
        return ApiResponse.success((Object)this.iCensorExecuteService.queryAllCensorTaskCount());
    }

    @PostMapping(value={"/uploadDocInfo"})
    public ApiResponse<Void> uploadDocInfo(@RequestBody UsehubTaskDocDto usehubTaskDocDto) {
        try {
            this.iCensorExecuteService.uploadDocInfo(usehubTaskDocDto);
        }
        catch (Exception a) {
            return ApiResponse.fail((int)ResultCode.REQ_REJECT.getCode(), (String)a.getMessage());
        }
        return ApiResponse.success();
    }

    /*
     * WARNING - void declaration
     */
    @PostMapping(value={"/getSceneGroupAndList"})
    public ApiResponse<List<GroupSceneDtoExt>> getSceneGroupAndList(@RequestBody com.jxdinfo.idp.scene.api.dto.SceneDto sceneDto) {
        ArrayList<void> a = new ArrayList<void>();
        List a2 = this.sceneService.getSceneGroupAndList(sceneDto);
        if (a2 != null && a2.size() > 0) {
            Iterator iterator;
            Iterator iterator2 = iterator = a2.iterator();
            while (iterator2.hasNext()) {
                void a3;
                GroupSceneDto a4 = (GroupSceneDto)iterator.next();
                GroupSceneDtoExt groupSceneDtoExt = new GroupSceneDtoExt();
                void v1 = a3;
                GroupSceneDto groupSceneDto = a4;
                void v3 = a3;
                v3.setGroupId(a4.getGroupId());
                v3.setName(a4.getName());
                a3.setDescription(groupSceneDto.getDescription());
                v1.setCreateTime(groupSceneDto.getCreateTime());
                v1.setCreator(a4.getCreator());
                ArrayList<void> a5 = new ArrayList<void>();
                Iterator iterator3 = a4.getSceneList().iterator();
                while (iterator3.hasNext()) {
                    void a6;
                    Iterator iterator4;
                    com.jxdinfo.idp.scene.api.dto.SceneDto a7 = (com.jxdinfo.idp.scene.api.dto.SceneDto)iterator4.next();
                    long a8 = a7.getId();
                    SceneDto sceneDto2 = new SceneDto();
                    iterator3 = iterator4;
                    void v5 = a6;
                    com.jxdinfo.idp.scene.api.dto.SceneDto sceneDto3 = a7;
                    void v7 = a6;
                    v7.setId(a8);
                    v7.setName(a7.getName());
                    a6.setCreator(sceneDto3.getCreator());
                    v5.setType(sceneDto3.getType());
                    v5.setTaskNum(this.iCensorExecuteService.queryCountBySceneId(Long.valueOf(a8)));
                    a5.add(a6);
                }
                a3.setSceneList(a5);
                iterator2 = iterator;
                a.add(a3);
            }
        }
        if (a != null && a.size() > 0) {
            Collections.sort(a, Comparator.comparing(GroupSceneDtoExt::getCreateTime).reversed());
        }
        return ApiResponse.success(a);
    }
}

