/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.usehub.controller;

import com.jxdinfo.usehub.dto.CensorResultExportRequestDto;
import com.jxdinfo.usehub.service.CensorResultExportService;
import java.io.IOException;
import java.net.URLEncoder;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/censorResultExport"})
public class CensorResultExportController {
    @Resource
    private CensorResultExportService censorResultExportService;

    @PostMapping(value={"/exportCensorResult"})
    public void exportCensorResult(HttpServletResponse response, @RequestBody CensorResultExportRequestDto requestDto) {
        try (ServletOutputStream outputStream = response.getOutputStream();){
            this.censorResultExportService.exportCensorResult(response, requestDto);
            response.setContentType("application/vnd.ms-excel");
            response.setHeader("Accept-Ranges", "bytes");
            response.setHeader("Content-Disposition", "attachment; filename=" + URLEncoder.encode(requestDto.getExportFileName(), "UTF-8"));
            response.setStatus(206);
            outputStream.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
            response.setStatus(500);
        }
    }
}

