/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.usehub.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.idp.common.base.dto.FileBytesInfo;
import com.jxdinfo.idp.common.enums.doc.DocTypeEnum;
import com.jxdinfo.idp.common.exception.IDPExcepttion;
import com.jxdinfo.idp.common.util.SnowFlakeUtil;
import com.jxdinfo.idp.dio.service.DocInfoIoService;
import com.jxdinfo.idp.dto.DocTypeDto;
import com.jxdinfo.idp.extract.domain.dto.ExtractChainItemDto;
import com.jxdinfo.idp.extract.domain.dto.ExtractChainNodeDto;
import com.jxdinfo.idp.extract.domain.dto.ExtractItemDto;
import com.jxdinfo.idp.extract.service.IExtractCoreService;
import com.jxdinfo.idp.interf.DocService;
import com.jxdinfo.idp.rule.api.service.IRuleService;
import com.jxdinfo.idp.scene.api.dto.SceneConfigDto;
import com.jxdinfo.idp.scene.api.dto.SceneDocInfoDto;
import com.jxdinfo.idp.scene.api.dto.SceneExtractItemDto;
import com.jxdinfo.idp.scene.api.dto.TaskDocDto;
import com.jxdinfo.idp.scene.api.dto.TaskInfoDto;
import com.jxdinfo.idp.scene.api.extend.SceneConfigExpandBuild;
import com.jxdinfo.idp.usehub.dao.mapper.UsehubTaskExtractResultMapper;
import com.jxdinfo.idp.usehub.dao.mapper.UsehubTaskMergeFileMapper;
import com.jxdinfo.idp.usehub.dao.mapper.UserhubTaskRuleResultMapper;
import com.jxdinfo.idp.usehub.service.handler.UseHubExtractHandlerFactory;
import com.jxdinfo.idp.vo.DocInfoVo;
import com.jxdinfo.usehub.dto.ExecuteExtractDto;
import com.jxdinfo.usehub.dto.ExecuteRuleItemDto;
import com.jxdinfo.usehub.po.UsehubTaskMergeFilePo;
import com.jxdinfo.usehub.service.CensorExecuteExtractService;
import com.jxdinfo.usehub.service.CensorExecuteRuleItemService;
import com.jxdinfo.usehub.service.SceneExecuteService;
import com.jxdinfo.usehub.service.UseHubTaskDetailService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SceneExecuteServiceImpl
implements SceneExecuteService {
    private static final Logger log = LoggerFactory.getLogger(SceneExecuteServiceImpl.class);
    @Resource
    private UserhubTaskRuleResultMapper iUserhubTaskRuleResultMapper;
    @Resource
    private UsehubTaskExtractResultMapper iUsehubTaskExtractResultMapper;
    @Autowired
    private IRuleService iIRuleService;
    @Autowired
    private DocInfoIoService iDocInfoIoService;
    @Autowired
    private UseHubTaskDetailService iUseHubTaskDetailService;
    @Autowired
    private SceneConfigExpandBuild iSceneConfigExpandBuild;
    @Autowired
    private IExtractCoreService iIExtractCoreService;
    @Autowired
    private CensorExecuteExtractService iCensorExecuteExtractService;
    @Autowired
    private CensorExecuteRuleItemService iCensorExecuteRuleItemService;
    @Resource
    private UsehubTaskMergeFileMapper iUsehubTaskMergeFileMapper;
    @Autowired
    private DocService iDocService;
    @Resource
    private UseHubExtractHandlerFactory useHubExtractHandlerFactory;

    public SceneConfigDto init(SceneConfigDto sceneConfigDto) {
        sceneConfigDto = this.iSceneConfigExpandBuild.build(sceneConfigDto);
        ArrayList<UsehubTaskMergeFilePo> usehubTaskMergeFilePoList = new ArrayList<UsehubTaskMergeFilePo>();
        ArrayList<TaskInfoDto> taskInfoList = new ArrayList<TaskInfoDto>();
        Map taskDocDtoMap = sceneConfigDto.getTaskDocDtoMap();
        HashMap<Long, byte[]> mergeFileMap = new HashMap<Long, byte[]>();
        for (Map.Entry m : taskDocDtoMap.entrySet()) {
            TaskInfoDto taskInfoDto = new TaskInfoDto();
            HashMap<DocTypeDto, DocInfoVo> docTemRelationMap = new HashMap<DocTypeDto, DocInfoVo>();
            String batchNo = (String)m.getKey();
            taskInfoDto.setBatchNo(batchNo);
            List value = (List)m.getValue();
            for (TaskDocDto taskDocDto : value) {
                Long docId;
                String filePaths;
                byte[] fileStream;
                DocTypeDto docTypeDto = new DocTypeDto();
                docTypeDto.setId(taskDocDto.getTemplateId());
                docTypeDto.setDocTypeName(taskDocDto.getTemplateName());
                List docInfoVos = taskDocDto.getDocInfoVos();
                if (docInfoVos == null || docInfoVos.isEmpty()) continue;
                String format = "";
                String mergeId = "";
                HashMap<String, Object> requestMap = new HashMap<String, Object>();
                ArrayList<Long> docIds = new ArrayList<Long>();
                int k = 0;
                for (DocInfoVo docInfoVo : docInfoVos) {
                    String docId2 = String.valueOf(docInfoVo.getId());
                    String mat = docInfoVo.getFormat();
                    String docType = DocTypeEnum.getValueByType((String)mat);
                    if (format != null && !"".equals(format) && !docType.equals(format)) {
                        throw new IDPExcepttion("\u6279\u6b21\u53f7\u4e3a:" + batchNo + "\uff0c\u6587\u6863\u7c7b\u578b\u540d\u79f0\u662f\uff1a" + taskDocDto.getTemplateName() + ", \u5b58\u5728\u4e0d\u540c\u683c\u5f0f\u7684\u6587\u4ef6\uff01");
                    }
                    format = docType;
                    mergeId = mergeId + docId2 + ",";
                    docIds.add(docInfoVo.getId());
                    ++k;
                }
                mergeId = mergeId.substring(0, mergeId.length() - 1);
                String mergeName = "";
                String mergeFormat = "";
                if (k > 1) {
                    Long id;
                    String filePath;
                    for (Long id2 : docIds) {
                        DocInfoVo docInfoVo = this.iDocService.getDocInfo(String.valueOf(id2));
                        if (docInfoVo == null) {
                            throw new IDPExcepttion("\u6839\u636e\u6587\u4ef6id:" + id2 + "\u6ca1\u6709\u627e\u8be5\u6587\u4ef6\u4fe1\u606f\uff01");
                        }
                        int docConvert = docInfoVo.getDocConvert();
                        if (docConvert == 0) continue;
                        try {
                            Thread.sleep(60000L);
                        }
                        catch (InterruptedException e) {
                            throw new RuntimeException(e);
                        }
                        DocInfoVo docVo = this.iDocService.getDocInfo(String.valueOf(id2));
                        int convert = docVo.getDocConvert();
                        if (convert == 0) continue;
                        throw new IDPExcepttion("\u6587\u4ef6id\u4e3a:" + id2 + "\u7684\u6587\u4ef6\u672a\u8f6c\u6362\u5b8c\u6210\uff0c\u8bf7\u7b49\u5f85\u8f6c\u6362\u5b8c\u6210\u540e\u518d\u64cd\u4f5c\uff01");
                    }
                    requestMap.put("docIds", docIds);
                    requestMap.put("format", format);
                    JSONObject jsonObject = this.iDocInfoIoService.mergeFileStream(requestMap);
                    mergeName = jsonObject.getString("fileName");
                    fileStream = jsonObject.getBytes("mergeFileStream");
                    mergeFormat = jsonObject.getString("format");
                    filePaths = filePath = jsonObject.getString("filePath");
                    if (fileStream == null || fileStream.length <= 0) {
                        throw new IDPExcepttion("\u6839\u636e\u6587\u4ef6id:" + mergeId + "\u6ca1\u6709\u627e\u5230\u5408\u5e76\u540e\u7684\u6587\u4ef6\u6d41\u4fe1\u606f\uff0c\u6267\u884c\u5ba1\u67e5\u5931\u8d25\uff01");
                    }
                    UsehubTaskMergeFilePo usehubTaskMergeFilePo = new UsehubTaskMergeFilePo();
                    docId = id = Long.valueOf(SnowFlakeUtil.getFlowIdInstance().nextId());
                    usehubTaskMergeFilePo.setId(id);
                    usehubTaskMergeFilePo.setDocTypeId(taskDocDto.getTemplateId());
                    usehubTaskMergeFilePo.setDocTypeName(taskDocDto.getTemplateName());
                    usehubTaskMergeFilePo.setFormat(mergeFormat);
                    usehubTaskMergeFilePo.setMergeId(mergeId);
                    usehubTaskMergeFilePo.setMergeName(mergeName);
                    usehubTaskMergeFilePo.setFilePath(filePath);
                    usehubTaskMergeFilePoList.add(usehubTaskMergeFilePo);
                } else {
                    JSONObject fiStrm = this.iDocInfoIoService.getFileStream(mergeId);
                    fileStream = fiStrm.getBytes("fileStream");
                    mergeName = fiStrm.getString("docName");
                    mergeFormat = fiStrm.getString("format");
                    filePaths = fiStrm.getString("realPath");
                    if (fileStream == null || fileStream.length <= 0) {
                        throw new IDPExcepttion("\u6839\u636e\u6587\u4ef6id:" + mergeId + "\u6ca1\u6709\u627e\u5230\u8be5\u6587\u4ef6\u6d41\u4fe1\u606f\uff0c\u6267\u884c\u5ba1\u67e5\u5931\u8d25\uff01");
                    }
                    docId = Long.valueOf(mergeId);
                }
                DocInfoVo docInfoVo = new DocInfoVo();
                docInfoVo.setId(docId);
                docInfoVo.setName(mergeName);
                docInfoVo.setFormat(mergeFormat);
                docInfoVo.setFilePath(filePaths);
                docTemRelationMap.put(docTypeDto, docInfoVo);
                mergeFileMap.put(docId, fileStream);
            }
            taskInfoDto.setDocTemRelationMap(docTemRelationMap);
            taskInfoList.add(taskInfoDto);
        }
        for (UsehubTaskMergeFilePo usehubTaskMergeFilePo : usehubTaskMergeFilePoList) {
            this.iUsehubTaskMergeFileMapper.insert(usehubTaskMergeFilePo);
        }
        sceneConfigDto.setTaskInfoList(taskInfoList);
        sceneConfigDto.setMergeFileMap(mergeFileMap);
        return sceneConfigDto;
    }

    public void executeExtract(SceneConfigDto sceneConfigDto) {
        Map temExtractItemsMap = sceneConfigDto.getDocTypeAndExtractItemsMap();
        Map mergeFileMap = sceneConfigDto.getMergeFileMap();
        List taskInfoList = sceneConfigDto.getTaskInfoList();
        HashMap extractResultMap = new HashMap();
        HashMap extractResultItemMap = new HashMap();
        for (TaskInfoDto taskInfoDto : taskInfoList) {
            String batchNo = taskInfoDto.getBatchNo();
            HashMap docExtractResultMap = new HashMap();
            HashMap docExtractItemResultMap = new HashMap();
            ExecuteExtractDto executeExtractDto = new ExecuteExtractDto();
            executeExtractDto.setTaskId(sceneConfigDto.getTaskId());
            executeExtractDto.setBatchNo(batchNo);
            executeExtractDto.setCreator(sceneConfigDto.getCreator());
            Map docTemRelationMap = taskInfoDto.getDocTemRelationMap();
            for (Map.Entry doc : docTemRelationMap.entrySet()) {
                DocTypeDto docTypeDto = (DocTypeDto)doc.getKey();
                String docTypeId = String.valueOf(docTypeDto.getId());
                List sceneExtractItemDtoList = new ArrayList();
                for (Map.Entry entry : temExtractItemsMap.entrySet()) {
                    String templateId;
                    SceneDocInfoDto sceneDocInfoDto = (SceneDocInfoDto)entry.getKey();
                    entry.setValue(((List)entry.getValue()).stream().filter(dto -> dto.getStatus() == 0).collect(Collectors.toList()));
                    if (sceneDocInfoDto == null || !docTypeId.equals(templateId = String.valueOf(sceneDocInfoDto.getDocId()))) continue;
                    sceneExtractItemDtoList = (List)entry.getValue();
                    break;
                }
                if (sceneExtractItemDtoList.isEmpty()) continue;
                executeExtractDto.setSceneExtractItemDtoList(sceneExtractItemDtoList);
                ArrayList extractNodeIdList = new ArrayList();
                ArrayList<FileBytesInfo> arrayList = new ArrayList<FileBytesInfo>();
                ArrayList<ExtractChainNodeDto> nodeDtoList = new ArrayList<ExtractChainNodeDto>();
                ArrayList<ExtractChainItemDto> itemDtoList2 = new ArrayList<ExtractChainItemDto>();
                ArrayList<ExtractItemDto> itemDtoList = new ArrayList<ExtractItemDto>();
                ArrayList<ExtractItemDto> filterExtractItemList = new ArrayList<ExtractItemDto>();
                for (SceneExtractItemDto sceneExtractItemDto : sceneExtractItemDtoList) {
                    Long itemId = sceneExtractItemDto.getExtractItemId();
                    ExtractItemDto extractItemDto = this.iIExtractCoreService.getItemDto(itemId);
                    if (this.useHubExtractHandlerFactory.isFilter(filterExtractItemList, extractItemDto)) continue;
                    if (sceneExtractItemDto.getMethod() == 1) {
                        ExtractChainItemDto extractChainItemDto = new ExtractChainItemDto();
                        BeanUtils.copyProperties((Object)extractItemDto, (Object)extractChainItemDto);
                        itemDtoList2.add(extractChainItemDto);
                        extractNodeIdList.addAll(sceneExtractItemDto.getExtractNodeIdList());
                        continue;
                    }
                    itemDtoList.add(extractItemDto);
                }
                DocInfoVo docInfoVo = (DocInfoVo)doc.getValue();
                FileBytesInfo bytesInfo = new FileBytesInfo();
                bytesInfo.setFileBytes((byte[])mergeFileMap.get(docInfoVo.getId()));
                bytesInfo.setFileName(docInfoVo.getName() + "." + docInfoVo.getFormat());
                bytesInfo.setFileFormat(docInfoVo.getFormat());
                bytesInfo.setRealPath(docInfoVo.getFilePath());
                arrayList.add(bytesInfo);
                for (String id : extractNodeIdList) {
                    ExtractChainNodeDto extractChainNodeDto = new ExtractChainNodeDto();
                    extractChainNodeDto.setFileBytesInfoList(arrayList);
                    extractChainNodeDto.setId(id);
                    nodeDtoList.add(extractChainNodeDto);
                }
                executeExtractDto.setExtractChainItemDtos(itemDtoList2);
                executeExtractDto.setExtractChainNodeDtos(nodeDtoList);
                HashMap<FileBytesInfo, List<ExtractItemDto>> doExtractMap = new HashMap<FileBytesInfo, List<ExtractItemDto>>();
                doExtractMap.put(bytesInfo, itemDtoList);
                this.useHubExtractHandlerFactory.handlerFileInfo(doExtractMap, bytesInfo, filterExtractItemList);
                executeExtractDto.setDoExtractMap(doExtractMap);
                executeExtractDto.setDocId(docInfoVo.getId());
                Map result = this.iCensorExecuteExtractService.execute(executeExtractDto);
                docExtractResultMap.putAll((Map)result.get("code"));
                docExtractItemResultMap.putAll((Map)result.get("item"));
            }
            extractResultMap.put(batchNo, docExtractResultMap);
            extractResultItemMap.put(batchNo, docExtractItemResultMap);
        }
        sceneConfigDto.setExtractResultMap(extractResultMap);
        sceneConfigDto.setExtractResultItemMap(extractResultItemMap);
    }

    public void executeRuleLibs(SceneConfigDto sceneConfigDto) {
        log.info("\u3010{}\u3011\u5f00\u59cb\u6267\u884c\u5ba1\u67e5", (Object)sceneConfigDto.getTaskName());
        long startTime = System.nanoTime();
        ExecuteRuleItemDto executeRuleItemDto = new ExecuteRuleItemDto();
        executeRuleItemDto.setTaskId(sceneConfigDto.getTaskId());
        executeRuleItemDto.setSceneId(sceneConfigDto.getSceneId());
        executeRuleItemDto.setExtractResultMap(sceneConfigDto.getExtractResultMap());
        executeRuleItemDto.setExtractResultItemMap(sceneConfigDto.getExtractResultItemMap());
        executeRuleItemDto.setCreator(sceneConfigDto.getCreator());
        executeRuleItemDto.setExtractInfoMap(sceneConfigDto.getExtractInfoMap());
        Map result = this.iCensorExecuteRuleItemService.execute(executeRuleItemDto);
        Map ruleItemResultMap = (Map)result.get("record");
        List ruleItemVoUnUsedList = (List)result.get("unUsedItem");
        sceneConfigDto.setRuleItemResultMap(ruleItemResultMap);
        sceneConfigDto.setRuleItemVoUnUsedList(ruleItemVoUnUsedList);
        log.info("\u3010{}\u3011\u5ba1\u67e5\u6267\u884c\u5b8c\u6210\uff0c\u8017\u65f6\uff1a{}ms", (Object)sceneConfigDto.getTaskName(), (Object)((System.nanoTime() - startTime) / 1000000L));
    }

    public void executeReport(SceneConfigDto sceneConfigDto) {
    }
}

