/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.usehub.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.idp.common.util.SnowFlakeUtil;
import com.jxdinfo.idp.rule.api.service.IRuleService;
import com.jxdinfo.idp.rule.api.vo.RuleExecuteItemVo;
import com.jxdinfo.idp.rule.api.vo.RuleItemQueryVo;
import com.jxdinfo.idp.rule.api.vo.RuleItemRecordVo;
import com.jxdinfo.idp.rule.api.vo.RuleItemVo;
import com.jxdinfo.idp.scene.api.po.SceneRuleExtractRelevancyPo;
import com.jxdinfo.idp.scene.api.po.SceneRuleReviewItemRelevancyPo;
import com.jxdinfo.idp.scene.server.service.SceneRuleExtractRelevancyService;
import com.jxdinfo.idp.scene.server.service.SceneRuleReviewItemRelevancyService;
import com.jxdinfo.idp.usehub.dao.mapper.UserhubTaskRuleResultMapper;
import com.jxdinfo.idp.usehub.util.ResultParseUtil;
import com.jxdinfo.usehub.dto.ExecuteRuleItemDto;
import com.jxdinfo.usehub.po.UsehubTaskRuleResultPo;
import com.jxdinfo.usehub.service.CensorExecuteRuleItemService;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CensorExecuteRuleItemServiceImpl
implements CensorExecuteRuleItemService {
    private static final Logger log = LoggerFactory.getLogger(CensorExecuteRuleItemServiceImpl.class);
    @Autowired
    private SceneRuleReviewItemRelevancyService sceneRuleReviewItemRelevancyService;
    @Autowired
    private SceneRuleExtractRelevancyService sceneRuleExtractRelevancyService;
    @Autowired
    private IRuleService ruleService;
    @Autowired
    private IRuleService iIRuleService;
    @Resource
    private UserhubTaskRuleResultMapper iUserhubTaskRuleResultMapper;

    public ExecuteRuleItemDto init(ExecuteRuleItemDto executeRuleItemDto) {
        HashMap ruleItemBatchNoMap = new HashMap();
        ArrayList<RuleItemVo> ruleItemVoUsedList = new ArrayList<RuleItemVo>();
        long sceneId = executeRuleItemDto.getSceneId();
        List sceneRuleReviewItemRelevancyPoList = this.sceneRuleReviewItemRelevancyService.findAllBySceneId(sceneId);
        if (sceneRuleReviewItemRelevancyPoList == null || sceneRuleReviewItemRelevancyPoList.isEmpty()) {
            throw new HussarException("\u672a\u67e5\u8be2\u5230\u5ba1\u67e5\u5e94\u7528\u7ba1\u7406\u4e2d\u5bf9\u5e94\u914d\u7f6e\u7684\u5ba1\u67e5\u9879\u4fe1\u606f!");
        }
        List sceneRuleExtractRelevancyPoAll = this.sceneRuleExtractRelevancyService.findAllBySceneId(sceneId);
        if (sceneRuleExtractRelevancyPoAll == null || sceneRuleExtractRelevancyPoAll.isEmpty()) {
            throw new HussarException("\u672a\u67e5\u8be2\u5230\u5ba1\u67e5\u5e94\u7528\u7ba1\u7406\u4e2d\u5ba1\u67e5\u9879\u4e0e\u63d0\u53d6\u9879\u5bf9\u5e94\u5173\u7cfb\u4fe1\u606f!");
        }
        HashMap<String, Long> ruleExtractRelevancyMap = new HashMap<String, Long>();
        for (SceneRuleExtractRelevancyPo sceneRuleExtractRelevancyPo : sceneRuleExtractRelevancyPoAll) {
            ruleExtractRelevancyMap.put(String.valueOf(sceneRuleExtractRelevancyPo.getExtractItemId()), sceneRuleExtractRelevancyPo.getRuleItemId());
        }
        Map extractResultItemMap = executeRuleItemDto.getExtractResultItemMap();
        ArrayList<Long> allRuleItemIdList = new ArrayList<Long>();
        for (Map.Entry m : extractResultItemMap.entrySet()) {
            String batchNo = (String)m.getKey();
            ArrayList<Long> ruleItemIdList = new ArrayList<Long>();
            ArrayList<Long> ruleItemIdUsedList = new ArrayList<Long>();
            Map reltMap = (Map)m.getValue();
            for (Map.Entry n : reltMap.entrySet()) {
                if (!ruleExtractRelevancyMap.containsKey(n.getKey())) continue;
                Long ruleItemId = (Long)ruleExtractRelevancyMap.get(n.getKey());
                int status = 0;
                for (SceneRuleReviewItemRelevancyPo sceneRuleReviewItemRelevancyPo : sceneRuleReviewItemRelevancyPoList) {
                    long ruleItemIdYY = sceneRuleReviewItemRelevancyPo.getRuleItemId();
                    if (!Objects.equals(ruleItemIdYY, ruleItemId)) continue;
                    status = sceneRuleReviewItemRelevancyPo.getEnabled();
                    break;
                }
                if (status == 0 || ruleItemIdList.contains(ruleItemId)) continue;
                ruleItemIdList.add(ruleItemId);
            }
            if (!ruleItemIdList.isEmpty()) {
                RuleItemQueryVo ruleItemQueryVo = new RuleItemQueryVo();
                ruleItemQueryVo.setCurrent(1);
                ruleItemQueryVo.setSize(100);
                ruleItemQueryVo.setIdList(ruleItemIdList);
                Page pageResult = this.ruleService.queryRuleItem(ruleItemQueryVo);
                List ruleItemVoList = pageResult.getRecords();
                if (ruleItemVoList == null || ruleItemVoList.isEmpty()) {
                    throw new HussarException("\u672a\u67e5\u8be2\u5230\u5ba1\u67e5\u89c4\u5219\u5e93\u4e2d\u5ba1\u67e5\u9879\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\u76f8\u5173\u914d\u7f6e!");
                }
                for (RuleItemVo ruleItemVo : ruleItemVoList) {
                    Integer enabled = ruleItemVo.getEnabled();
                    if (enabled == 0) continue;
                    ruleItemIdUsedList.add(ruleItemVo.getId());
                    if (!allRuleItemIdList.contains(ruleItemVo.getId())) {
                        allRuleItemIdList.add(ruleItemVo.getId());
                    }
                    if (ruleItemVoUsedList.contains(ruleItemVo)) continue;
                    ruleItemVoUsedList.add(ruleItemVo);
                }
            }
            if (ruleItemIdUsedList.isEmpty()) continue;
            ruleItemBatchNoMap.put(batchNo, ruleItemIdUsedList);
        }
        if (ruleItemBatchNoMap.isEmpty()) {
            throw new HussarException("\u4e0d\u5b58\u5728\u6709\u6548\u542f\u7528\u72b6\u6001\u7684\u5ba1\u67e5\u9879\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\u76f8\u5173\u914d\u7f6e!");
        }
        executeRuleItemDto.setRuleItemBatchNoMap(ruleItemBatchNoMap);
        executeRuleItemDto.setRuleItemVoUsedList(ruleItemVoUsedList);
        ArrayList<Long> ruleItemUnUsedList = new ArrayList<Long>();
        ArrayList<RuleItemVo> ruleItemVoUnUsedList = new ArrayList<RuleItemVo>();
        for (SceneRuleReviewItemRelevancyPo sceneRuleReviewItemRelevancyPo : sceneRuleReviewItemRelevancyPoList) {
            long ruleItemId;
            int enabled = sceneRuleReviewItemRelevancyPo.getEnabled();
            if (enabled == 0 || allRuleItemIdList.contains(ruleItemId = sceneRuleReviewItemRelevancyPo.getRuleItemId())) continue;
            ruleItemUnUsedList.add(ruleItemId);
        }
        if (!ruleItemUnUsedList.isEmpty()) {
            ArrayList usehubTaskRuleResultPoUnUsedList = new ArrayList();
            RuleItemQueryVo ruleItemQueryVo = new RuleItemQueryVo();
            ruleItemQueryVo.setCurrent(1);
            ruleItemQueryVo.setSize(100);
            ruleItemQueryVo.setIdList(ruleItemUnUsedList);
            Page pageResult2 = this.ruleService.queryRuleItem(ruleItemQueryVo);
            List ruleItemVoList2 = pageResult2.getRecords();
            if (ruleItemVoList2 == null || ruleItemVoList2.isEmpty()) {
                throw new HussarException("\u672a\u67e5\u8be2\u5230\u5ba1\u67e5\u89c4\u5219\u5e93\u4e2d\u5ba1\u67e5\u9879\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\u76f8\u5173\u914d\u7f6e!");
            }
            for (RuleItemVo ruleItemVo : ruleItemVoList2) {
                Integer enabled = ruleItemVo.getEnabled();
                if (enabled == 0) continue;
                ruleItemVoUnUsedList.add(ruleItemVo);
            }
        }
        executeRuleItemDto.setRuleItemVoUnUsedList(ruleItemVoUnUsedList);
        return executeRuleItemDto;
    }

    public void executeRuleItem(ExecuteRuleItemDto executeRuleItemDto) {
        HashMap ruleItemResultMap = new HashMap();
        Map extractResultMap = executeRuleItemDto.getExtractResultMap();
        List ruleItemVoUsedList = executeRuleItemDto.getRuleItemVoUsedList();
        Map extractInfoMap = executeRuleItemDto.getExtractInfoMap();
        Map ruleItemBatchNoMap = executeRuleItemDto.getRuleItemBatchNoMap();
        HashMap extractItemMap = new HashMap();
        HashMap ruleItemRelationMap = new HashMap();
        for (Map.Entry m : ruleItemBatchNoMap.entrySet()) {
            String batchNo = (String)m.getKey();
            Map extractMap = (Map)extractResultMap.get(batchNo);
            List ruleItemIdList = (List)m.getValue();
            HashMap codeNameMap = new HashMap();
            HashMap<String, String> relationMap = new HashMap<String, String>();
            for (Long ruleId : ruleItemIdList) {
                Map codeMap = this.iIRuleService.queryRuleParam(ruleId);
                codeNameMap.putAll(codeMap);
                String extractIds = "";
                for (Map.Entry map : codeMap.entrySet()) {
                    if ("".equals(extractIds)) {
                        extractIds = (String)extractInfoMap.get(map.getKey());
                        continue;
                    }
                    extractIds = extractIds + "," + (String)extractInfoMap.get(map.getKey());
                }
                relationMap.put(String.valueOf(ruleId), extractIds);
            }
            ruleItemRelationMap.put(batchNo, relationMap);
            Long[] ruleItemId = ruleItemIdList.toArray(new Long[0]);
            RuleExecuteItemVo ruleExecuteItemVos = new RuleExecuteItemVo();
            ruleExecuteItemVos.setRuleItemId(ruleItemId);
            ruleExecuteItemVos.setBatchNo(Long.valueOf(batchNo));
            ruleExecuteItemVos.setExtractedData(extractMap);
            List ruleItemRecordVoList = this.iIRuleService.executeRuleItems(ruleExecuteItemVos);
            if (!ruleItemRecordVoList.isEmpty()) {
                HashMap<RuleItemVo, RuleItemRecordVo> resultMap = new HashMap<RuleItemVo, RuleItemRecordVo>();
                block3: for (RuleItemRecordVo ruleItemRecordVo : ruleItemRecordVoList) {
                    Long scxId = ruleItemRecordVo.getRuleItemId();
                    for (RuleItemVo ruleItemVo : ruleItemVoUsedList) {
                        if (!Objects.equals(scxId, ruleItemVo.getId())) continue;
                        resultMap.put(ruleItemVo, ruleItemRecordVo);
                        continue block3;
                    }
                }
                ruleItemResultMap.put(batchNo, resultMap);
            }
            extractItemMap.put(batchNo, codeNameMap);
        }
        executeRuleItemDto.setRuleItemResultMap(ruleItemResultMap);
        executeRuleItemDto.setExtractItemMap(extractItemMap);
        executeRuleItemDto.setRuleItemRelationMap(ruleItemRelationMap);
    }

    public void saveResult(ExecuteRuleItemDto executeRuleItemDto) {
        String creator = executeRuleItemDto.getCreator();
        LocalDateTime nowTime = LocalDateTime.now();
        Map extractItemMap = executeRuleItemDto.getExtractItemMap();
        Map ruleItemRelationMap = executeRuleItemDto.getRuleItemRelationMap();
        Map ruleItemResultMap = executeRuleItemDto.getRuleItemResultMap();
        for (Map.Entry recordMap : ruleItemResultMap.entrySet()) {
            String batchNo = (String)recordMap.getKey();
            Map extractInfoMap = (Map)extractItemMap.get(batchNo);
            Map relationMap = (Map)ruleItemRelationMap.get(batchNo);
            Map reltMap = (Map)recordMap.getValue();
            for (Map.Entry m : reltMap.entrySet()) {
                RuleItemVo ruleItemVo = (RuleItemVo)m.getKey();
                RuleItemRecordVo ruleItemRecordVo = (RuleItemRecordVo)m.getValue();
                String rectifyComments = ruleItemRecordVo.getRectifyComments();
                if (rectifyComments != null && !"".equals(rectifyComments)) {
                    rectifyComments = ResultParseUtil.parseStr(rectifyComments, extractInfoMap);
                }
                Long id = SnowFlakeUtil.getFlowIdInstance().nextId();
                UsehubTaskRuleResultPo usehubTaskRuleResultPo = new UsehubTaskRuleResultPo();
                usehubTaskRuleResultPo.setId(id);
                usehubTaskRuleResultPo.setTaskId(executeRuleItemDto.getTaskId());
                usehubTaskRuleResultPo.setBatchNo(batchNo);
                usehubTaskRuleResultPo.setResultReason(ruleItemRecordVo.getResultReason());
                usehubTaskRuleResultPo.setRuleItemId(ruleItemVo.getId());
                usehubTaskRuleResultPo.setRuleItemName(ruleItemVo.getRuleItemName());
                usehubTaskRuleResultPo.setRuleItemLevel(ruleItemVo.getRuleItemLevel());
                usehubTaskRuleResultPo.setExtractIds((String)relationMap.get(String.valueOf(ruleItemVo.getId())));
                usehubTaskRuleResultPo.setResult(ruleItemRecordVo.getResult().intValue());
                usehubTaskRuleResultPo.setRectifyComments(rectifyComments);
                usehubTaskRuleResultPo.setCreator(creator);
                usehubTaskRuleResultPo.setCreateTime(nowTime);
                usehubTaskRuleResultPo.setDeleteFlag(Integer.valueOf(0));
                this.iUserhubTaskRuleResultMapper.insertInfo(usehubTaskRuleResultPo);
            }
        }
        List ruleItemVoUnUsedList = executeRuleItemDto.getRuleItemVoUnUsedList();
        if (!ruleItemVoUnUsedList.isEmpty()) {
            for (RuleItemVo ruleItemVo : ruleItemVoUnUsedList) {
                Long ruleResultId = SnowFlakeUtil.getFlowIdInstance().nextId();
                UsehubTaskRuleResultPo usehubTaskRuleResultPo = new UsehubTaskRuleResultPo();
                usehubTaskRuleResultPo.setId(ruleResultId);
                usehubTaskRuleResultPo.setTaskId(executeRuleItemDto.getTaskId());
                usehubTaskRuleResultPo.setRuleItemId(ruleItemVo.getId());
                usehubTaskRuleResultPo.setRuleItemName(ruleItemVo.getRuleItemName());
                usehubTaskRuleResultPo.setRuleItemLevel(ruleItemVo.getRuleItemLevel());
                usehubTaskRuleResultPo.setResult(3);
                usehubTaskRuleResultPo.setCreator(creator);
                usehubTaskRuleResultPo.setCreateTime(nowTime);
                usehubTaskRuleResultPo.setDeleteFlag(Integer.valueOf(0));
                this.iUserhubTaskRuleResultMapper.insertInfo(usehubTaskRuleResultPo);
            }
        }
    }
}

