/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.usehub.controller;

import cn.hutool.core.thread.ThreadUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.idp.common.response.ApiResponse;
import com.jxdinfo.idp.common.response.ResultCode;
import com.jxdinfo.idp.common.util.user.UserUtils;
import com.jxdinfo.idp.scene.api.dto.SceneConfigDto;
import com.jxdinfo.idp.scene.api.dto.SceneRuleLibDto;
import com.jxdinfo.idp.scene.api.po.ScenePo;
import com.jxdinfo.idp.scene.api.vo.ScenePageVo;
import com.jxdinfo.idp.scene.server.service.impl.SceneDocTypeRelevancyServiceImpl;
import com.jxdinfo.idp.scene.server.service.impl.SceneServiceImpl;
import com.jxdinfo.usehub.api.CensorOverInterface;
import com.jxdinfo.usehub.api.UsehubApiService;
import com.jxdinfo.usehub.dto.CensorOverDto;
import com.jxdinfo.usehub.dto.SceneDto;
import com.jxdinfo.usehub.dto.UseHubBatchUploadDocDto;
import com.jxdinfo.usehub.dto.UsehubAddBatchInfoDto;
import com.jxdinfo.usehub.dto.UsehubTaskBatchDetailDto;
import com.jxdinfo.usehub.dto.UsehubTaskDocDto;
import com.jxdinfo.usehub.dto.UsehubTaskDto;
import com.jxdinfo.usehub.po.UsehubTaskPo;
import com.jxdinfo.usehub.service.SceneExecuteService;
import com.jxdinfo.usehub.service.UseHubTaskService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

public class UsehubController
implements UsehubApiService {
    private static final Logger log = LoggerFactory.getLogger(UsehubController.class);
    @Resource
    private UseHubTaskService iCensorExecuteService;
    @Resource
    private SceneServiceImpl sceneService;
    @Resource
    private SceneDocTypeRelevancyServiceImpl sceneDocTypeRelevancyServiceImpl;
    @Resource
    private SceneExecuteService iSceneExecuteService;
    @Autowired(required=false)
    private List<CensorOverInterface> censorOverInterfaces;

    public ApiResponse<Void> startCensor(@Validated @RequestBody UsehubTaskDto usehubTaskDto) {
        String sceneId = usehubTaskDto.getSceneId();
        String sceneName = usehubTaskDto.getSceneName();
        String taskName = usehubTaskDto.getTaskName();
        Map taskDocDtoMap = usehubTaskDto.getTaskDocDtoMap();
        String saveId = usehubTaskDto.getSaveId();
        if (taskDocDtoMap.isEmpty()) {
            return ApiResponse.fail((int)ResultCode.REQ_REJECT.getCode(), (String)"\u4f20\u5165\u7684\u5ba1\u67e5\u4efb\u52a1\u6587\u6863\u4fe1\u606f\u4e3a\u7a7a!");
        }
        if (saveId == null || "".equals(saveId)) {
            return ApiResponse.fail((int)ResultCode.REQ_REJECT.getCode(), (String)"\u4f20\u5165\u7684\u6587\u6863\u4e0a\u4f20\u4efb\u52a1id\u4e3a\u7a7a!");
        }
        String taskId = "";
        try {
            taskId = this.iCensorExecuteService.startCensor(usehubTaskDto);
        }
        catch (Exception e) {
            log.error("\u6267\u884c\u5ba1\u67e5\u5931\u8d251:" + e.getMessage());
            this.iCensorExecuteService.updateTaskStatus(Long.valueOf(taskId), "\u5ba1\u67e5\u5931\u8d25", e.getMessage());
            return ApiResponse.fail((int)ResultCode.REQ_REJECT.getCode(), (String)e.getMessage());
        }
        String creator = String.valueOf(UserUtils.getLoginUserId());
        String finalTaskId = taskId;
        ThreadUtil.execute(() -> {
            boolean flag;
            long startTime;
            block6: {
                startTime = System.nanoTime();
                flag = true;
                try {
                    SceneConfigDto sceneConfigDto = new SceneConfigDto();
                    sceneConfigDto.setTaskId(Long.valueOf(finalTaskId));
                    sceneConfigDto.setSceneId(Long.valueOf(sceneId));
                    sceneConfigDto.setSceneName(sceneName);
                    sceneConfigDto.setTaskName(taskName);
                    sceneConfigDto.setTaskDocDtoMap(taskDocDtoMap);
                    sceneConfigDto.setCreator(creator);
                    this.iSceneExecuteService.execute(sceneConfigDto);
                }
                catch (Exception e) {
                    log.error("\u6267\u884c\u5ba1\u67e5\u5931\u8d252:" + e.getMessage());
                    if (e instanceof NullPointerException || "null".equals(e.getMessage())) {
                        this.iCensorExecuteService.updateTaskStatus(Long.valueOf(finalTaskId), "\u5ba1\u67e5\u5931\u8d25", "\u63d0\u53d6\u7ed3\u679c\u4e0d\u6ee1\u8db3\u5ba1\u67e5\u516c\u5f0f\u8981\u6c42");
                    } else {
                        this.iCensorExecuteService.updateTaskStatus(Long.valueOf(finalTaskId), "\u5ba1\u67e5\u5931\u8d25", e.getMessage());
                    }
                    flag = false;
                    if (!ObjectUtil.isNotNull(this.censorOverInterfaces)) break block6;
                    this.censorOverInterfaces.forEach(a -> {
                        try {
                            a.failCall(new CensorOverDto(Long.valueOf(finalTaskId)));
                        }
                        catch (Exception e1) {
                            log.error("\u56de\u8c03\u5931\u8d25:" + e1.getMessage());
                        }
                    });
                }
            }
            if (flag) {
                this.iCensorExecuteService.updateTaskStatus(Long.valueOf(finalTaskId), "\u5ba1\u67e5\u5b8c\u6210", null);
                if (ObjectUtil.isNotNull(this.censorOverInterfaces)) {
                    this.censorOverInterfaces.stream().forEach(a -> a.successCall(new CensorOverDto(Long.valueOf(finalTaskId))));
                }
            }
            log.info("{}\u6587\u6863\u5ba1\u67e5\u6267\u884c\u5b8c\u6bd5\uff0c\u603b\u8017\u65f6{}ms", (Object)taskName, (Object)((System.nanoTime() - startTime) / 1000000L));
        });
        return ApiResponse.success((String)taskId);
    }

    @GetMapping(value={"/updateIsIgnoreInfo"})
    public ApiResponse<Void> updateIsIgnoreInfo(@RequestParam Long id, @RequestParam int isIgnore) {
        this.iCensorExecuteService.censorExecuteDocResultProcess(id, isIgnore);
        return ApiResponse.success();
    }

    @GetMapping(value={"/queryCensorResultDetailInfo"})
    public ApiResponse<List<UsehubTaskBatchDetailDto>> queryCensorResultDetailInfo(@RequestParam String taskId, String docName) {
        if (taskId == null || taskId.isEmpty()) {
            return ApiResponse.fail((int)ResultCode.REQ_REJECT.getCode(), (String)"\u4f20\u5165\u7684\u5ba1\u67e5\u4efb\u52a1id\u4e3a\u7a7a!");
        }
        Long id = Long.valueOf(taskId);
        List usehubTaskDetailList = this.iCensorExecuteService.censorResultDetailInfo(id, docName);
        return ApiResponse.success((Object)usehubTaskDetailList);
    }

    public ApiResponse<Map<String, Object>> censorTaskRuleResult(@RequestParam String taskId, @RequestParam String sceneId, @RequestParam String batchNo, @RequestParam String docTypeId) {
        if (taskId == null || taskId.isEmpty()) {
            return ApiResponse.fail((int)ResultCode.REQ_REJECT.getCode(), (String)"\u4f20\u5165\u7684\u5ba1\u67e5\u4efb\u52a1id\u4e3a\u7a7a!");
        }
        if (sceneId == null || sceneId.isEmpty()) {
            return ApiResponse.fail((int)ResultCode.REQ_REJECT.getCode(), (String)"\u4f20\u5165\u7684\u573a\u666fid\u4e3a\u7a7a!");
        }
        Map taskExtractResult = this.iCensorExecuteService.censorTaskRuleResult(taskId, sceneId, batchNo, docTypeId);
        return ApiResponse.success((Object)taskExtractResult);
    }

    @GetMapping(value={"/deleteCensorTask"})
    public ApiResponse<Void> deleteCensorTask(@RequestParam String usehubTaskId) {
        if (usehubTaskId == null || usehubTaskId.isEmpty()) {
            return ApiResponse.fail((int)ResultCode.REQ_REJECT.getCode(), (String)"\u4f20\u5165\u7684\u5ba1\u67e5\u4efb\u52a1id\u4e3a\u7a7a!");
        }
        Long taskId = Long.valueOf(usehubTaskId);
        this.iCensorExecuteService.deleteCensorTask(taskId);
        return ApiResponse.success();
    }

    @PostMapping(value={"/batchDeleteCensorTask"})
    public ApiResponse<Void> batchDeleteCensorTask(@RequestBody List<String> usehubTaskIdList) {
        if (usehubTaskIdList.isEmpty()) {
            return ApiResponse.fail((int)ResultCode.REQ_REJECT.getCode(), (String)"\u4f20\u5165\u7684\u5ba1\u67e5\u4efb\u52a1id\u96c6\u5408\u4e3a\u7a7a!");
        }
        for (String usehubTaskId : usehubTaskIdList) {
            Long taskId = Long.valueOf(usehubTaskId);
            this.iCensorExecuteService.deleteCensorTask(taskId);
        }
        return ApiResponse.success();
    }

    public ApiResponse<Void> restartCensor(@Validated @RequestBody UsehubTaskDto usehubTaskDto) {
        String id = usehubTaskDto.getId();
        String sceneId = usehubTaskDto.getSceneId();
        String sceneName = usehubTaskDto.getSceneName();
        if (id == null || id.isEmpty()) {
            return ApiResponse.fail((int)ResultCode.REQ_REJECT.getCode(), (String)"\u4f20\u5165\u7684\u5ba1\u67e5\u4efb\u52a1id\u4e3a\u7a7a!");
        }
        String taskName = usehubTaskDto.getTaskName();
        Map taskDocDtoMap = new HashMap();
        try {
            taskDocDtoMap = this.iCensorExecuteService.restartCensor(Long.valueOf(id), Long.valueOf(sceneId));
        }
        catch (Exception e) {
            this.iCensorExecuteService.updateTaskStatus(Long.valueOf(id), "\u5ba1\u67e5\u5931\u8d25", e.getMessage());
            return ApiResponse.fail((int)ResultCode.REQ_REJECT.getCode(), (String)e.getMessage());
        }
        String creator = String.valueOf(UserUtils.getLoginUserId());
        Map finalTaskDocDtoMap = taskDocDtoMap;
        ThreadUtil.execute(() -> {
            boolean flag = true;
            try {
                SceneConfigDto sceneConfigDto = new SceneConfigDto();
                sceneConfigDto.setTaskId(Long.valueOf(id));
                sceneConfigDto.setSceneId(Long.valueOf(sceneId));
                sceneConfigDto.setSceneName(sceneName);
                sceneConfigDto.setTaskName(taskName);
                sceneConfigDto.setTaskDocDtoMap(finalTaskDocDtoMap);
                sceneConfigDto.setCreator(creator);
                this.iSceneExecuteService.execute(sceneConfigDto);
            }
            catch (Exception e) {
                log.error("\u6267\u884c\u5ba1\u67e5\u5931\u8d253:" + e.getMessage());
                this.iCensorExecuteService.updateTaskStatus(Long.valueOf(id), "\u5ba1\u67e5\u5931\u8d25", e.getMessage());
                flag = false;
            }
            if (flag) {
                this.iCensorExecuteService.updateTaskStatus(Long.valueOf(id), "\u5ba1\u67e5\u5b8c\u6210", null);
            }
        });
        return ApiResponse.success();
    }

    @PostMapping(value={"/queryCensorTaskList"})
    public ApiResponse<Page<UsehubTaskPo>> queryCensorTaskList(@RequestBody UsehubTaskDto dto) {
        Page page = this.iCensorExecuteService.queryCensorTaskList(dto);
        return ApiResponse.success((Object)page);
    }

    @GetMapping(value={"/queryAllCensorTaskCount"})
    public ApiResponse<Integer> queryAllCensorTaskCount() {
        int count = this.iCensorExecuteService.queryAllCensorTaskCount();
        return ApiResponse.success((Object)count);
    }

    @PostMapping(value={"/getSceneByPage"})
    public ApiResponse<Page<SceneDto>> getSceneByPage(@RequestBody ScenePageVo scenePageVo) {
        Page page = new Page((long)scenePageVo.getCurrent(), (long)scenePageVo.getSize());
        Page pageScene = this.sceneService.getSceneList(scenePageVo);
        List sceneRuleLibDtoList = pageScene.getRecords();
        ArrayList<SceneDto> sceneDtoList = new ArrayList<SceneDto>();
        if (!sceneRuleLibDtoList.isEmpty()) {
            for (SceneRuleLibDto sceneRuleLibDto : sceneRuleLibDtoList) {
                long sceneId = sceneRuleLibDto.getSceneId();
                SceneDto sceneDto = new SceneDto();
                sceneDto.setId(sceneId);
                sceneDto.setName(sceneRuleLibDto.getSceneName());
                int taskNum = this.iCensorExecuteService.queryCountBySceneId(Long.valueOf(sceneId));
                sceneDto.setTaskNum(taskNum);
                sceneDtoList.add(sceneDto);
            }
        }
        page.setRecords(sceneDtoList);
        page.setTotal(pageScene.getTotal());
        return ApiResponse.success((Object)page);
    }

    @PostMapping(value={"/search"})
    public ApiResponse<List<SceneDto>> search(@RequestParam(required=false) String sceneName, @RequestParam(required=false) String startCreateTime, @RequestParam(required=false) String endCreateTime) {
        List scenePoList = this.sceneService.search(sceneName, startCreateTime, endCreateTime);
        ArrayList<SceneDto> sceneDtoList = new ArrayList<SceneDto>();
        for (ScenePo scenePo : scenePoList) {
            long sceneId = scenePo.getId();
            SceneDto sceneDto = new SceneDto();
            sceneDto.setId((long)((int)sceneId));
            sceneDto.setName(scenePo.getName());
            int taskNum = this.iCensorExecuteService.queryCountBySceneId(Long.valueOf(sceneId));
            sceneDto.setTaskNum(taskNum);
            sceneDtoList.add(sceneDto);
        }
        return ApiResponse.success(sceneDtoList);
    }

    @PostMapping(value={"/uploadDocInfo"})
    public ApiResponse<Void> uploadDocInfo(@RequestBody UsehubTaskDocDto usehubTaskDocDto) {
        try {
            this.iCensorExecuteService.uploadDocInfo(usehubTaskDocDto);
        }
        catch (Exception e) {
            return ApiResponse.fail((int)ResultCode.REQ_REJECT.getCode(), (String)e.getMessage());
        }
        return ApiResponse.success();
    }

    @PostMapping(value={"/batchUploadDocInfo"})
    public ApiResponse<Void> batchUploadDocInfo(@RequestBody UseHubBatchUploadDocDto useHubBatchUploadDocDto) {
        try {
            this.iCensorExecuteService.batchUploadDocInfo(useHubBatchUploadDocDto);
        }
        catch (Exception e) {
            return ApiResponse.fail((int)ResultCode.REQ_REJECT.getCode(), (String)e.getMessage());
        }
        return ApiResponse.success();
    }

    @PostMapping(value={"/getDocTypeList"})
    public ApiResponse<Map<String, Object>> getDocTypeList(@RequestBody UsehubTaskDocDto usehubTaskDocDto) {
        Long sceneId = usehubTaskDocDto.getSceneId();
        String taskId = usehubTaskDocDto.getTaskId();
        if (sceneId == null) {
            return ApiResponse.fail((int)ResultCode.REQ_REJECT.getCode(), (String)"\u4f20\u5165\u7684\u573a\u666fid\u4e3a\u7a7a!");
        }
        if (taskId == null || taskId.isEmpty()) {
            return ApiResponse.fail((int)ResultCode.REQ_REJECT.getCode(), (String)"\u4f20\u5165\u7684\u5ba1\u67e5\u4efb\u52a1\u6682\u5b58id\u4e3a\u7a7a!");
        }
        List docTypeVoList = this.sceneDocTypeRelevancyServiceImpl.getDocTypeObjectList(sceneId.longValue());
        Map result = this.iCensorExecuteService.getDocTypeList(sceneId, docTypeVoList, taskId);
        return ApiResponse.success((Object)result);
    }

    @PostMapping(value={"/addOrUpdateBatchInfo"})
    public ApiResponse<Void> addOrUpdateBatchInfo(@RequestBody UsehubAddBatchInfoDto usehubAddBatchInfoDto) {
        Long sceneId = usehubAddBatchInfoDto.getSceneId();
        String taskId = usehubAddBatchInfoDto.getTaskId();
        String batchName = usehubAddBatchInfoDto.getName();
        if (sceneId == null) {
            return ApiResponse.fail((int)ResultCode.REQ_REJECT.getCode(), (String)"\u4f20\u5165\u7684\u573a\u666fid\u4e3a\u7a7a!");
        }
        if (taskId == null || taskId.isEmpty()) {
            return ApiResponse.fail((int)ResultCode.REQ_REJECT.getCode(), (String)"\u4f20\u5165\u7684\u5ba1\u67e5\u4efb\u52a1\u6682\u5b58id\u4e3a\u7a7a!");
        }
        if (batchName == null || batchName.isEmpty()) {
            return ApiResponse.fail((int)ResultCode.REQ_REJECT.getCode(), (String)"\u4f20\u5165\u7684\u6279\u6b21\u53f7\u540d\u79f0\u4e3a\u7a7a!");
        }
        try {
            this.iCensorExecuteService.addOrUpdateBatchInfo(usehubAddBatchInfoDto);
        }
        catch (Exception e) {
            return ApiResponse.fail((int)ResultCode.REQ_REJECT.getCode(), (String)e.getMessage());
        }
        return ApiResponse.success();
    }

    @GetMapping(value={"/deleteBatchInfo"})
    public ApiResponse<Void> deleteBatchInfo(@RequestParam String taskId, @RequestParam String batchNo) {
        if (taskId == null || taskId.isEmpty()) {
            return ApiResponse.fail((int)ResultCode.REQ_REJECT.getCode(), (String)"\u4f20\u5165\u7684\u5ba1\u67e5\u4efb\u52a1\u6682\u5b58id\u4e3a\u7a7a!");
        }
        if (batchNo == null || batchNo.isEmpty()) {
            return ApiResponse.fail((int)ResultCode.REQ_REJECT.getCode(), (String)"\u4f20\u5165\u7684\u6279\u6b21\u53f7\u4e3a\u7a7a!");
        }
        try {
            this.iCensorExecuteService.deleteBatchInfo(taskId, batchNo);
        }
        catch (Exception e) {
            return ApiResponse.fail((int)ResultCode.REQ_REJECT.getCode(), (String)e.getMessage());
        }
        return ApiResponse.success();
    }

    @GetMapping(value={"/deleteUploadDocInfo"})
    public ApiResponse<Void> deleteUploadDocInfo(@RequestParam String taskId, @RequestParam String docTypeId, @RequestParam String docId) {
        if (taskId == null || taskId.isEmpty()) {
            return ApiResponse.fail((int)ResultCode.REQ_REJECT.getCode(), (String)"\u4f20\u5165\u7684\u5ba1\u67e5\u4efb\u52a1\u6682\u5b58id\u4e3a\u7a7a!");
        }
        if (docTypeId == null || docTypeId.isEmpty()) {
            return ApiResponse.fail((int)ResultCode.REQ_REJECT.getCode(), (String)"\u4f20\u5165\u7684\u6587\u6863\u7c7b\u578b\u4e3a\u7a7a!");
        }
        if (docId == null || docId.isEmpty()) {
            return ApiResponse.fail((int)ResultCode.REQ_REJECT.getCode(), (String)"\u4f20\u5165\u7684\u6587\u6863id\u4e3a\u7a7a!");
        }
        this.iCensorExecuteService.deleteUploadDocInfo(taskId, docTypeId, docId);
        return ApiResponse.success();
    }

    @GetMapping(value={"/ifExitTaskName"})
    public ApiResponse<Boolean> ifExitTaskName(@RequestParam String sceneId, @RequestParam String taskName) {
        if (sceneId == null || sceneId.isEmpty()) {
            return ApiResponse.fail((int)ResultCode.REQ_REJECT.getCode(), (String)"\u4f20\u5165\u7684\u573a\u666fid\u4e3a\u7a7a!");
        }
        if (taskName == null || taskName.isEmpty()) {
            return ApiResponse.fail((int)ResultCode.REQ_REJECT.getCode(), (String)"\u4f20\u5165\u7684\u5ba1\u67e5\u4efb\u52a1\u540d\u79f0\u4e3a\u7a7a!");
        }
        return ApiResponse.success((Object)this.iCensorExecuteService.ifExitTaskName(sceneId, taskName));
    }

    @GetMapping(value={"/ifCensorTaskEnd"})
    public ApiResponse<String> ifCensorTaskEnd(@RequestParam String taskId) {
        if (taskId == null || taskId.isEmpty()) {
            return ApiResponse.fail((int)ResultCode.REQ_REJECT.getCode(), (String)"\u4f20\u5165\u7684\u5ba1\u67e5\u4efb\u52a1id\u4e3a\u7a7a!");
        }
        return ApiResponse.success((String)this.iCensorExecuteService.ifCensorTaskEnd(taskId));
    }

    @GetMapping(value={"/updateSceneNameInfo"})
    public ApiResponse<Void> updateSceneNameInfo(@RequestParam String sceneId, @RequestParam String sceneName) {
        if (sceneId == null || sceneId.isEmpty()) {
            return ApiResponse.fail((int)ResultCode.REQ_REJECT.getCode(), (String)"\u4f20\u5165\u7684\u573a\u666fid\u4e3a\u7a7a!");
        }
        if (sceneName == null || sceneName.isEmpty()) {
            return ApiResponse.fail((int)ResultCode.REQ_REJECT.getCode(), (String)"\u4f20\u5165\u7684\u573a\u666f\u540d\u79f0\u4e3a\u7a7a!");
        }
        this.iCensorExecuteService.updateSceneNameInfo(Long.valueOf(sceneId), sceneName);
        return ApiResponse.success();
    }

    @GetMapping(value={"/deleteUnmatchedDocInfo"})
    public ApiResponse<Void> deleteUnmatchedDocInfo(@RequestParam String taskId, @RequestParam String docId) {
        if (taskId == null || taskId.isEmpty()) {
            return ApiResponse.fail((int)ResultCode.REQ_REJECT.getCode(), (String)"\u4f20\u5165\u7684\u5ba1\u67e5\u4efb\u52a1\u6682\u5b58id\u4e3a\u7a7a!");
        }
        if (docId == null || docId.isEmpty()) {
            return ApiResponse.fail((int)ResultCode.REQ_REJECT.getCode(), (String)"\u4f20\u5165\u7684\u6587\u6863id\u4e3a\u7a7a!");
        }
        this.iCensorExecuteService.deleteUnmatchedDocInfo(taskId, docId);
        return ApiResponse.success();
    }
}

