/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.usehub.util;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.time.DateFormatUtils;

public class ResultParseUtil {
    public static String parseStr(String input, Map<String, String> extResultMap) {
        int endIndex;
        int hashIndex;
        String str = input;
        int startIndex = 0;
        while ((hashIndex = input.indexOf("#{", startIndex)) != -1 && (endIndex = input.indexOf("}", hashIndex)) != -1) {
            String content = input.substring(hashIndex + 2, endIndex);
            String template = "#{" + content + "}";
            String result = ResultParseUtil.parseTemplate(template, extResultMap);
            str = str.replace(template, result);
            startIndex = endIndex + 1;
        }
        return str;
    }

    private static String parseTemplate(String template, Map<String, String> extResultMap) {
        String regex = "#\\{extract\\.\"([^\"]+)\"\\.\"([^\"]+)\"\\}";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(template);
        if (matcher.find()) {
            String extractName = matcher.group(1);
            String extractResult = matcher.group(2);
            return extractName + ": " + extractResult;
        }
        String regex2 = "#\\{extract\\.\"([^\"]+)\"\\.\"\"}";
        Pattern pattern2 = Pattern.compile(regex2);
        Matcher matcher2 = pattern2.matcher(template);
        if (matcher2.find()) {
            String extractName2 = matcher2.group(1);
            String extractResult2 = extResultMap.get(extractName2);
            return extractName2 + ": " + extractResult2;
        }
        return template;
    }

    public static String parseExtractValue(Object result) {
        String value = "";
        if (result == null) {
            value = "";
        } else if (result instanceof String || result instanceof Number || result instanceof Character) {
            value = String.valueOf(result);
        } else if (result instanceof Date) {
            value = DateFormatUtils.format((Date)((Date)result), (String)"yyyy-MM-dd");
        } else if (result instanceof LocalDate) {
            value = ((LocalDate)result).format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        } else if (result instanceof LocalDateTime) {
            value = ((LocalDateTime)result).format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        } else {
            try {
                ObjectMapper objectMapper = new ObjectMapper();
                value = objectMapper.writeValueAsString(result);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return value;
    }
}

