/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.usehub.controller;

import com.jxdinfo.usehub.dto.CensorResultExportRequestDto;
import com.jxdinfo.usehub.service.CensorResultExportService;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@RestController
@RequestMapping(value={"/censorResultExport"})
public class CensorResultExportController {
    @Resource
    private CensorResultExportService censorResultExportService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(value={"/exportCensorResult"})
    public void exportCensorResult(@RequestBody CensorResultExportRequestDto requestDto) {
        ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        HttpServletResponse response = attributes.getResponse();
        File file = null;
        try {
            file = new File(this.censorResultExportService.exportCensorResult(requestDto));
            if (!file.exists()) {
                response.setStatus(404);
                return;
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            response.setStatus(500);
            return;
        }
        FileInputStream inputStream = null;
        ServletOutputStream outputStream = null;
        try {
            int bytesRead;
            inputStream = new FileInputStream(file);
            outputStream = response.getOutputStream();
            response.setHeader("Accept-Ranges", "bytes");
            response.setHeader("Content-Disposition", "attachment; filename=" + URLEncoder.encode(file.getName(), "UTF-8"));
            response.setHeader("Content-Type", "application/xlsx");
            response.setContentLengthLong(file.length());
            response.setStatus(206);
            byte[] buffer = new byte[1024];
            while ((bytesRead = ((InputStream)inputStream).read(buffer)) != -1) {
                outputStream.write(buffer, 0, bytesRead);
            }
            outputStream.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
            response.setStatus(500);
        }
        finally {
            if (!requestDto.getSaveDoc().booleanValue() && file.exists()) {
                file.delete();
            }
            if (inputStream != null) {
                try {
                    ((InputStream)inputStream).close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }
}

