/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.usehub.service.impl;

import com.jxdinfo.idp.common.excel.ExcelExportUtils;
import com.jxdinfo.idp.common.excel.ExportExcelDto;
import com.jxdinfo.idp.common.util.StringUtils;
import com.jxdinfo.idp.interf.DocService;
import com.jxdinfo.usehub.dto.CensorResultExportRequestDto;
import com.jxdinfo.usehub.dto.excelexport.CensorResultDto;
import com.jxdinfo.usehub.service.CensorResultExportService;
import com.jxdinfo.usehub.service.UseHubTaskService;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class CensorResultExportServiceImpl
implements CensorResultExportService {
    @Value(value="${idp.file.excel.exportpath}")
    private String exportPath;
    @Resource
    private UseHubTaskService iCensorExecuteService;
    @Resource
    private DocService docService;

    public String exportCensorResult(CensorResultExportRequestDto requestDto) throws FileNotFoundException {
        String path = this.exportPath;
        if (StringUtils.isNotEmpty((String)requestDto.getExportFilePath())) {
            path = requestDto.getExportFilePath();
        }
        ExportExcelDto dto = new ExportExcelDto();
        if (StringUtils.isEmpty((String)requestDto.getExportFileName())) {
            requestDto.setExportFileName(requestDto.getTaskId() + System.currentTimeMillis() + ".xlsx");
        }
        path = path + requestDto.getExportFileName();
        FileOutputStream fileOutputStream = new FileOutputStream(path);
        dto.setOut((OutputStream)fileOutputStream);
        List resultList = (List)this.iCensorExecuteService.censorTaskRuleResult(String.valueOf(requestDto.getTaskId()), String.valueOf(requestDto.getSceneId()), null, null).get("records");
        HashMap map = new HashMap();
        resultList.forEach(d -> {
            List taskExtractResultPos = d.getTaskExtractResultPos();
            taskExtractResultPos.forEach(p -> {
                List censorResultDtos = map.computeIfAbsent(String.valueOf(p.getDocId()), k -> new ArrayList());
                censorResultDtos.add(d);
            });
        });
        ArrayList docIds = new ArrayList(map.keySet());
        List docInfoVos = this.docService.getDocInfo(docIds);
        docInfoVos.forEach(d -> {
            List censorResultDtos = (List)map.get(d.getId());
            if (censorResultDtos != null) {
                map.put(d.getName(), censorResultDtos);
                map.remove(d.getId());
            }
        });
        ArrayList mapKey = new ArrayList(map.keySet());
        ArrayList dataset = new ArrayList(map.values());
        dto.setDataset(dataset);
        dto.setSheetNames(mapKey);
        dto.setTableTitles(mapKey);
        ArrayList classList = new ArrayList();
        mapKey.forEach(d -> classList.add(CensorResultDto.class));
        dto.setClassList(classList);
        ExcelExportUtils.exportExcel((ExportExcelDto)dto);
        return path;
    }
}

