/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.usehub.controller;

import com.jxdinfo.usehub.dto.CensorResultExportRequestDto;
import com.jxdinfo.usehub.service.CensorResultExportService;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/censorResultExport"})
public class CensorResultExportController {
    @Resource
    private CensorResultExportService censorResultExportService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(value={"/exportCensorResult"})
    public void exportCensorResult(CensorResultExportRequestDto requestDto, HttpServletResponse response) {
        File file = null;
        try {
            file = new File(this.censorResultExportService.exportCensorResult(requestDto));
            if (!file.exists()) {
                response.setStatus(404);
                return;
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            response.setStatus(500);
            return;
        }
        try (FileInputStream inputStream = new FileInputStream(file);
             ServletOutputStream outputStream = response.getOutputStream();){
            int bytesRead;
            response.reset();
            response.setContentType("application/octet-stream");
            response.setHeader("Content-Disposition", "attachment; filename=" + URLEncoder.encode(file.getName(), "UTF-8"));
            response.setContentLengthLong(file.length());
            byte[] buffer = new byte[1024];
            while ((bytesRead = ((InputStream)inputStream).read(buffer)) != -1) {
                outputStream.write(buffer, 0, bytesRead);
            }
            outputStream.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
            response.setStatus(500);
        }
        finally {
            if (!requestDto.getSaveDoc().booleanValue() && file.exists()) {
                file.delete();
            }
        }
    }
}

