/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.usehub.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.idp.common.util.SnowFlakeUtil;
import com.jxdinfo.idp.common.util.user.UserUtils;
import com.jxdinfo.idp.dm.server.mapper.DocInfoMapper;
import com.jxdinfo.idp.dm.server.util.DocUtil;
import com.jxdinfo.idp.extract.interf.IExtractCore;
import com.jxdinfo.idp.extract.mapper.ExtractItemMapper;
import com.jxdinfo.idp.po.FileInfoPo;
import com.jxdinfo.idp.rule.api.service.IRuleService;
import com.jxdinfo.idp.rule.server.mapper.RuleItemMapper;
import com.jxdinfo.idp.scene.api.dto.TaskDocDto;
import com.jxdinfo.idp.scene.server.service.SceneDocTypeRelevancyService;
import com.jxdinfo.idp.scene.server.service.SceneExtractItemDocTypeRelevancyService;
import com.jxdinfo.idp.scene.server.service.SceneRuleExtractRelevancyService;
import com.jxdinfo.idp.scene.server.service.SceneRuleItemDocTypeRelevancyService;
import com.jxdinfo.idp.scene.server.service.SceneRuleReviewItemRelevancyService;
import com.jxdinfo.idp.usehub.mapper.UsehubTaskDetailMapper;
import com.jxdinfo.idp.usehub.mapper.UsehubTaskDocMapper;
import com.jxdinfo.idp.usehub.mapper.UsehubTaskExtractResultMapper;
import com.jxdinfo.idp.usehub.mapper.UsehubTaskMapper;
import com.jxdinfo.idp.usehub.mapper.UserhubTaskRuleResultMapper;
import com.jxdinfo.idp.vo.DocInfoVo;
import com.jxdinfo.idp.vo.DocTypeVo;
import com.jxdinfo.usehub.dto.UseHubBatchUploadDocDto;
import com.jxdinfo.usehub.dto.UseHubUploadDocDto;
import com.jxdinfo.usehub.dto.UsehubAddBatchInfoDto;
import com.jxdinfo.usehub.dto.UsehubTaskBatchDetailDto;
import com.jxdinfo.usehub.dto.UsehubTaskDetailDto;
import com.jxdinfo.usehub.dto.UsehubTaskDocDto;
import com.jxdinfo.usehub.dto.UsehubTaskDto;
import com.jxdinfo.usehub.dto.UsehubTaskRuleResultDto;
import com.jxdinfo.usehub.po.UsehubTaskDetailPo;
import com.jxdinfo.usehub.po.UsehubTaskDocPo;
import com.jxdinfo.usehub.po.UsehubTaskExtractResultPo;
import com.jxdinfo.usehub.po.UsehubTaskPo;
import com.jxdinfo.usehub.po.UsehubTaskRuleResultPo;
import com.jxdinfo.usehub.service.UseHubTaskService;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UseHubTaskServiceImpl
implements UseHubTaskService {
    private static final Logger log = LoggerFactory.getLogger(UseHubTaskServiceImpl.class);
    @Resource
    private UsehubTaskDetailMapper iUsehubTaskDetailMapper;
    @Resource
    private UsehubTaskMapper iUsehubTaskMapper;
    @Resource
    private UsehubTaskExtractResultMapper iUsehubTaskExtractResultMapper;
    @Resource
    private UserhubTaskRuleResultMapper iUserhubTaskRuleResultMapper;
    @Resource
    private UsehubTaskDocMapper iUsehubTaskDocMapper;
    @Resource
    private DocInfoMapper docInfoMapper;
    @Autowired
    private SceneDocTypeRelevancyService sceneDocTypeRelevancyService;
    @Resource
    private RuleItemMapper ruleItemMapper;
    @Autowired
    private ExtractItemMapper extractItemMapper;
    @Autowired
    private SceneRuleItemDocTypeRelevancyService sceneRuleItemDocTypeRelevancyService;
    @Autowired
    private IRuleService ruleService;
    @Autowired
    private SceneRuleExtractRelevancyService sceneRuleExtractRelevancyService;
    @Autowired
    private IExtractCore iIExtractCore;
    @Autowired
    private SceneExtractItemDocTypeRelevancyService sceneExtractItemDocTypeRelevancyService;
    @Autowired
    private SceneRuleReviewItemRelevancyService sceneRuleReviewItemRelevancyService;

    public String startCensor(UsehubTaskDto usehubTaskDto) {
        String creator = String.valueOf(UserUtils.getLoginUserId());
        String sceneId = usehubTaskDto.getSceneId();
        String sceneName = usehubTaskDto.getSceneName();
        String taskName = usehubTaskDto.getTaskName();
        UsehubTaskPo usehubTaskPo = new UsehubTaskPo();
        Long taskId = SnowFlakeUtil.getFlowIdInstance().nextId();
        usehubTaskPo.setId(taskId);
        usehubTaskPo.setSceneId(Long.valueOf(sceneId));
        usehubTaskPo.setSceneName(sceneName);
        usehubTaskPo.setTaskName(taskName);
        LocalDateTime nowTime = LocalDateTime.now();
        usehubTaskPo.setCreateTime(nowTime);
        usehubTaskPo.setCreator(creator);
        usehubTaskPo.setTaskStatus("\u5ba1\u67e5\u4e2d");
        usehubTaskPo.setDeleteFlag(Integer.valueOf(0));
        int k = 0;
        ArrayList<UsehubTaskDetailPo> saveUsehubTaskDetailList = new ArrayList<UsehubTaskDetailPo>();
        Map taskDocDtoMap = usehubTaskDto.getTaskDocDtoMap();
        for (Map.Entry m : taskDocDtoMap.entrySet()) {
            String batchNo = (String)m.getKey();
            List value = (List)m.getValue();
            for (TaskDocDto taskDocDto : value) {
                List docInfoVos = taskDocDto.getDocInfoVos();
                Integer enabled = taskDocDto.getEnabled();
                if (docInfoVos == null || docInfoVos.isEmpty()) {
                    if (enabled != 1) continue;
                    throw new HussarException("\u6587\u6863\u7c7b\u578b\u540d\u79f0\uff1a" + taskDocDto.getTemplateName() + "\u5fc5\u987b\u4e0a\u4f20\u6587\u6863\uff01");
                }
                for (DocInfoVo docInfoVo : docInfoVos) {
                    ++k;
                    UsehubTaskDetailPo usehubTaskDetailPo = new UsehubTaskDetailPo();
                    Long usehubTaskDetailId = SnowFlakeUtil.getFlowIdInstance().nextId();
                    usehubTaskDetailPo.setId(usehubTaskDetailId);
                    usehubTaskDetailPo.setTaskId(taskId);
                    usehubTaskDetailPo.setBatchNo(batchNo);
                    usehubTaskDetailPo.setCreateTime(nowTime);
                    usehubTaskDetailPo.setCreator(creator);
                    usehubTaskDetailPo.setTemplateId(taskDocDto.getTemplateId());
                    usehubTaskDetailPo.setTemplateName(taskDocDto.getTemplateName());
                    usehubTaskDetailPo.setDocId(docInfoVo.getId());
                    usehubTaskDetailPo.setDocName(docInfoVo.getName());
                    usehubTaskDetailPo.setFormat(docInfoVo.getFormat());
                    usehubTaskDetailPo.setDeleteFlag(Integer.valueOf(0));
                    saveUsehubTaskDetailList.add(usehubTaskDetailPo);
                }
            }
        }
        if (k == 0) {
            throw new HussarException("\u6ca1\u6709\u9700\u8981\u5ba1\u67e5\u7684\u6587\u6863\u4fe1\u606f\uff0c\u8bf7\u4e0a\u4f20\u6587\u6863\uff01");
        }
        usehubTaskPo.setDocNum(k);
        this.iUsehubTaskMapper.insertInfo(usehubTaskPo);
        List<UsehubTaskDocPo> usehubTaskDocPoS = this.iUsehubTaskDocMapper.getTaskDocInfo(Long.valueOf(sceneId), usehubTaskDto.getSaveId());
        if (usehubTaskDocPoS == null || usehubTaskDocPoS.isEmpty()) {
            throw new HussarException("\u672a\u67e5\u8be2\u5230\u8be5\u5ba1\u67e5\u4efb\u52a1\u4e0a\u4f20\u7684\u6587\u6863\u4fe1\u606f\uff01");
        }
        HashMap<String, String> batchInfo = new HashMap<String, String>();
        for (UsehubTaskDocPo usehubTaskDocPo : usehubTaskDocPoS) {
            if (batchInfo.containsKey(usehubTaskDocPo.getBatchNo())) continue;
            batchInfo.put(usehubTaskDocPo.getBatchNo(), usehubTaskDocPo.getBatchName());
        }
        for (UsehubTaskDetailPo usehubTaskDetailPo : saveUsehubTaskDetailList) {
            usehubTaskDetailPo.setBatchName((String)batchInfo.get(usehubTaskDetailPo.getBatchNo()));
            this.iUsehubTaskDetailMapper.insertInfo(usehubTaskDetailPo);
        }
        return String.valueOf(taskId);
    }

    public void censorExecuteDocMatch(String executeStr) {
    }

    public void censorExecuteDocResultProcess(Long id, int isIgnore) {
        this.iUserhubTaskRuleResultMapper.updateIsIgnoreInfo(id, isIgnore);
    }

    public List<UsehubTaskBatchDetailDto> censorResultDetailInfo(Long taskId, String docName) {
        docName = DocUtil.queryString((String)docName);
        List<UsehubTaskDetailPo> usehubTaskDetailPoList = this.iUsehubTaskDetailMapper.getTaskDetailByTaskIdAndDocName(taskId, docName);
        HashMap resultList = new HashMap();
        for (UsehubTaskDetailPo usehubTaskDetailPo : usehubTaskDetailPoList) {
            List<UsehubTaskDetailPo> pos;
            String batchNo = usehubTaskDetailPo.getBatchNo();
            if (resultList.containsKey(batchNo)) {
                pos = (List)resultList.get(batchNo);
                pos.add(usehubTaskDetailPo);
                resultList.put(batchNo, pos);
                continue;
            }
            pos = new ArrayList();
            pos.add(usehubTaskDetailPo);
            resultList.put(batchNo, pos);
        }
        ArrayList<UsehubTaskBatchDetailDto> reslt = new ArrayList<UsehubTaskBatchDetailDto>();
        for (Map.Entry m : resultList.entrySet()) {
            String batchNo = (String)m.getKey();
            List detailPos = (List)m.getValue();
            String batchName = "";
            ArrayList<UsehubTaskDetailDto> usehubTaskDetailList = new ArrayList<UsehubTaskDetailDto>();
            HashMap tempDocMap = new HashMap();
            for (UsehubTaskDetailPo usehubTaskDetailPo : detailPos) {
                UsehubTaskDetailDto usehubTaskDetailDto;
                List<UsehubTaskDetailDto> taskDetailDtoList;
                batchName = usehubTaskDetailPo.getBatchName();
                Long templateId = usehubTaskDetailPo.getTemplateId();
                Long docId = usehubTaskDetailPo.getDocId();
                String docNameInfo = usehubTaskDetailPo.getDocName();
                String format = usehubTaskDetailPo.getFormat();
                if (templateId == null && docId == null) continue;
                if (tempDocMap.containsKey(templateId)) {
                    taskDetailDtoList = (List)tempDocMap.get(templateId);
                    usehubTaskDetailDto = new UsehubTaskDetailDto();
                    usehubTaskDetailDto.setDocFlag("1");
                    usehubTaskDetailDto.setDocId(docId);
                    usehubTaskDetailDto.setDocName(docNameInfo);
                    usehubTaskDetailDto.setFormat(format);
                    taskDetailDtoList.add(usehubTaskDetailDto);
                    tempDocMap.put(templateId, taskDetailDtoList);
                    continue;
                }
                taskDetailDtoList = new ArrayList();
                usehubTaskDetailDto = new UsehubTaskDetailDto();
                usehubTaskDetailDto.setDocFlag("1");
                usehubTaskDetailDto.setDocId(docId);
                usehubTaskDetailDto.setDocName(docNameInfo);
                usehubTaskDetailDto.setFormat(format);
                taskDetailDtoList.add(usehubTaskDetailDto);
                tempDocMap.put(templateId, taskDetailDtoList);
            }
            for (Map.Entry entry : tempDocMap.entrySet()) {
                Long tempId = (Long)entry.getKey();
                UsehubTaskDetailDto usehubTaskDetailDto = new UsehubTaskDetailDto();
                usehubTaskDetailDto.setTemplateId(tempId);
                String templateName = "";
                for (UsehubTaskDetailPo tailPo : usehubTaskDetailPoList) {
                    if (!Objects.equals(tailPo.getTemplateId(), tempId)) continue;
                    templateName = tailPo.getTemplateName();
                    break;
                }
                usehubTaskDetailDto.setTemplateName(templateName);
                usehubTaskDetailDto.setDocFlag("0");
                usehubTaskDetailDto.setTaskDetailDtoList((List)entry.getValue());
                usehubTaskDetailList.add(usehubTaskDetailDto);
            }
            UsehubTaskBatchDetailDto usehubTaskBatchDetailDto = new UsehubTaskBatchDetailDto();
            usehubTaskBatchDetailDto.setBatchNo(batchNo);
            usehubTaskBatchDetailDto.setBatchName(batchName);
            usehubTaskBatchDetailDto.setTaskDetailDtoList(usehubTaskDetailList);
            reslt.add(usehubTaskBatchDetailDto);
        }
        return reslt;
    }

    public static Map<Long, Map<Long, String>> getLongMap(List<UsehubTaskDetailPo> usehubTaskDetailPoList) {
        HashMap<Long, Map<Long, String>> tempDocMap = new HashMap<Long, Map<Long, String>>();
        for (UsehubTaskDetailPo usehubTaskDetailPo : usehubTaskDetailPoList) {
            Map<Long, String> docMap;
            Long templateId = usehubTaskDetailPo.getTemplateId();
            Long docId = usehubTaskDetailPo.getDocId();
            String docName = usehubTaskDetailPo.getDocName();
            if (tempDocMap.containsKey(templateId)) {
                docMap = (Map)tempDocMap.get(templateId);
                docMap.put(docId, docName);
                tempDocMap.put(templateId, docMap);
                continue;
            }
            docMap = new HashMap();
            docMap.put(docId, docName);
            tempDocMap.put(templateId, docMap);
        }
        return tempDocMap;
    }

    public Map<String, Object> censorTaskRuleResult(String taskId, String sceneId, String batchNo, String docTypeId) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        List<Object> ruleResultList = new ArrayList();
        if (batchNo != null && !batchNo.isEmpty()) {
            List<UsehubTaskRuleResultPo> ruleList = this.iUserhubTaskRuleResultMapper.getInfoByTaskIdAndBatchNo(Long.valueOf(taskId), batchNo);
            if (ruleList != null && !ruleList.isEmpty()) {
                List sceneRuleItemDocTypeRelevancyPos = this.sceneRuleItemDocTypeRelevancyService.getBySceneId(Long.valueOf(sceneId).longValue());
                if (sceneRuleItemDocTypeRelevancyPos == null || sceneRuleItemDocTypeRelevancyPos.isEmpty()) {
                    throw new HussarException("\u672a\u67e5\u8be2\u5230\u5ba1\u67e5\u9879\u4e0e\u6587\u6863\u7c7b\u578b\u5173\u8054\u4fe1\u606f!");
                }
                HashMap ruleTypeRelationMap = new HashMap();
                for (Object sceneRuleItemDocTypeRelevancyPo : sceneRuleItemDocTypeRelevancyPos) {
                    ruleTypeRelationMap.put(String.valueOf(sceneRuleItemDocTypeRelevancyPo.getDocTypeId()), String.valueOf(sceneRuleItemDocTypeRelevancyPo.getRuleItemId()));
                }
                String ruleItemIdUse = (String)ruleTypeRelationMap.get(docTypeId);
                for (UsehubTaskRuleResultPo usehubTaskRuleResultPo : ruleList) {
                    String ruleItemId = String.valueOf(usehubTaskRuleResultPo.getRuleItemId());
                    if (!ruleItemId.equals(ruleItemIdUse)) continue;
                    ruleResultList.add(usehubTaskRuleResultPo);
                }
            }
        } else {
            ruleResultList = this.iUserhubTaskRuleResultMapper.getInfoByTaskId(Long.valueOf(taskId));
        }
        if (ruleResultList.isEmpty()) {
            throw new HussarException("\u672a\u67e5\u8be2\u5230\u6587\u6863\u5ba1\u67e5\u7ed3\u679c\u4fe1\u606f!");
        }
        List<UsehubTaskDetailPo> usehubTaskDetailPos = this.iUsehubTaskDetailMapper.getUsehubTaskDetailByTaskId(Long.valueOf(taskId));
        if (usehubTaskDetailPos == null || usehubTaskDetailPos.isEmpty()) {
            throw new HussarException("\u672a\u67e5\u8be2\u5230\u5ba1\u67e5\u4efb\u52a1\u660e\u7ec6\u4fe1\u606f!");
        }
        HashMap<String, String> batchInfo = new HashMap<String, String>();
        for (UsehubTaskDetailPo usehubTaskDetailPo : usehubTaskDetailPos) {
            if (batchInfo.containsKey(usehubTaskDetailPo.getBatchNo())) continue;
            batchInfo.put(usehubTaskDetailPo.getBatchNo(), usehubTaskDetailPo.getBatchName());
        }
        int sucessNum = 0;
        int errNum = 0;
        int unNum = 0;
        ArrayList<UsehubTaskRuleResultDto> records = new ArrayList<UsehubTaskRuleResultDto>();
        for (UsehubTaskRuleResultPo usehubTaskRuleResultPo : ruleResultList) {
            String ruleItemName = usehubTaskRuleResultPo.getRuleItemName();
            ruleItemName = ruleItemName + "(" + (String)batchInfo.get(usehubTaskRuleResultPo.getBatchNo()) + ")";
            usehubTaskRuleResultPo.setRuleItemName(ruleItemName);
            int relt = usehubTaskRuleResultPo.getResult();
            if (relt == 3) {
                ++unNum;
            } else if (relt == 1) {
                ++sucessNum;
            } else if (relt == 2) {
                ++errNum;
            }
            UsehubTaskRuleResultDto usehubTaskRuleResultDto = new UsehubTaskRuleResultDto(usehubTaskRuleResultPo);
            List<UsehubTaskExtractResultPo> taskExtractResultPos = this.iUsehubTaskExtractResultMapper.getExtractInfoByTaskIdAndBatchNo(Long.valueOf(taskId), usehubTaskRuleResultPo.getBatchNo());
            String extractIds = usehubTaskRuleResultPo.getExtractIds();
            ArrayList<UsehubTaskExtractResultPo> extractResultList = new ArrayList<UsehubTaskExtractResultPo>();
            if (extractIds != null && !"".equals(extractIds)) {
                String[] extractId = extractIds.split(",");
                HashSet<String> set = new HashSet<String>(Arrays.asList(extractId));
                if (taskExtractResultPos != null && !taskExtractResultPos.isEmpty()) {
                    for (UsehubTaskExtractResultPo usehubTaskExtractResultPo : taskExtractResultPos) {
                        String extrId = String.valueOf(usehubTaskExtractResultPo.getExtractItemId());
                        if (!set.contains(extrId)) continue;
                        extractResultList.add(usehubTaskExtractResultPo);
                    }
                }
            }
            usehubTaskRuleResultDto.setTaskExtractResultPos(extractResultList);
            records.add(usehubTaskRuleResultDto);
        }
        result.put("sucessNum", sucessNum);
        result.put("errNum", errNum);
        result.put("unNum", unNum);
        result.put("records", records);
        return result;
    }

    public void deleteCensorTask(Long usehubTaskId) {
        LocalDateTime now = LocalDateTime.now();
        UsehubTaskPo usehubTaskPo = new UsehubTaskPo();
        usehubTaskPo.setId(usehubTaskId);
        usehubTaskPo.setDeleteFlag(Integer.valueOf(1));
        usehubTaskPo.setDeleteTime(now);
        this.iUsehubTaskMapper.updateTaskInfoById(usehubTaskPo);
        this.iUsehubTaskDetailMapper.updateDeleteInfo(usehubTaskId, 1, now);
        this.iUserhubTaskRuleResultMapper.updateDeleteInfo(usehubTaskId, 1, now);
        this.iUsehubTaskExtractResultMapper.updateInfo(usehubTaskId, 1, now);
    }

    public Map<String, List<TaskDocDto>> restartCensor(Long usehubTaskId, Long sceneId) {
        LocalDateTime nowTime = LocalDateTime.now();
        String creator = String.valueOf(UserUtils.getLoginUserId());
        UsehubTaskPo usehubTaskPo = new UsehubTaskPo();
        usehubTaskPo.setId(usehubTaskId);
        usehubTaskPo.setTaskStatus("\u5ba1\u67e5\u4e2d");
        usehubTaskPo.setCreator(creator);
        usehubTaskPo.setCreateTime(nowTime);
        usehubTaskPo.setError("null");
        this.iUsehubTaskMapper.updateTaskInfoById(usehubTaskPo);
        this.iUserhubTaskRuleResultMapper.updateDeleteInfo(usehubTaskId, 1, nowTime);
        this.iUsehubTaskExtractResultMapper.updateInfo(usehubTaskId, 1, nowTime);
        List<UsehubTaskDetailPo> oldUsehubTaskDetailPos = this.iUsehubTaskDetailMapper.getUsehubTaskDetailByTaskId(usehubTaskId);
        if (oldUsehubTaskDetailPos == null || oldUsehubTaskDetailPos.isEmpty()) {
            throw new HussarException("\u672a\u67e5\u8be2\u5230\u5ba1\u67e5\u4efb\u52a1\u660e\u7ec6\u4fe1\u606f!");
        }
        HashMap detailMap = new HashMap();
        for (UsehubTaskDetailPo oldTaskDetailPo : oldUsehubTaskDetailPos) {
            List<UsehubTaskDetailPo> valueList;
            String batchNo = oldTaskDetailPo.getBatchNo();
            if (detailMap.containsKey(batchNo)) {
                valueList = (List)detailMap.get(batchNo);
                valueList.add(oldTaskDetailPo);
                detailMap.put(batchNo, valueList);
                continue;
            }
            valueList = new ArrayList();
            valueList.add(oldTaskDetailPo);
            detailMap.put(batchNo, valueList);
        }
        HashMap<String, List<TaskDocDto>> taskDocDtoMap = new HashMap<String, List<TaskDocDto>>();
        for (Map.Entry m : detailMap.entrySet()) {
            ArrayList<TaskDocDto> taskDocDtos = new ArrayList<TaskDocDto>();
            String batchNo = (String)m.getKey();
            HashMap<Long, String> docTypeMap = new HashMap<Long, String>();
            HashMap docTemRelationMap = new HashMap();
            List detList = (List)m.getValue();
            for (UsehubTaskDetailPo usehubTaskDetailPo : detList) {
                DocInfoVo docInfoVo;
                List<DocInfoVo> docInfoVos;
                if (docTemRelationMap.containsKey(usehubTaskDetailPo.getTemplateId())) {
                    docInfoVos = (List)docTemRelationMap.get(usehubTaskDetailPo.getTemplateId());
                    docInfoVo = new DocInfoVo();
                    docInfoVo.setId(usehubTaskDetailPo.getDocId());
                    docInfoVo.setName(usehubTaskDetailPo.getDocName());
                    docInfoVo.setFormat(usehubTaskDetailPo.getFormat());
                    docInfoVos.add(docInfoVo);
                    docTemRelationMap.put(usehubTaskDetailPo.getTemplateId(), docInfoVos);
                    continue;
                }
                docInfoVos = new ArrayList();
                docInfoVo = new DocInfoVo();
                docInfoVo.setId(usehubTaskDetailPo.getDocId());
                docInfoVo.setName(usehubTaskDetailPo.getDocName());
                docInfoVo.setFormat(usehubTaskDetailPo.getFormat());
                docInfoVos.add(docInfoVo);
                docTemRelationMap.put(usehubTaskDetailPo.getTemplateId(), docInfoVos);
                docTypeMap.put(usehubTaskDetailPo.getTemplateId(), usehubTaskDetailPo.getTemplateName());
            }
            for (Map.Entry entry : docTemRelationMap.entrySet()) {
                Long docTypeId = (Long)entry.getKey();
                TaskDocDto taskDocDto = new TaskDocDto();
                taskDocDto.setTemplateId(docTypeId);
                taskDocDto.setTemplateName((String)docTypeMap.get(docTypeId));
                taskDocDto.setDocInfoVos((List)entry.getValue());
                taskDocDtos.add(taskDocDto);
            }
            taskDocDtoMap.put(batchNo, taskDocDtos);
        }
        return taskDocDtoMap;
    }

    public Page<UsehubTaskPo> queryCensorTaskList(UsehubTaskDto dto) {
        Page page = new Page();
        int count = 0;
        if (dto.getCurrent() == null) {
            dto.setCurrent(Integer.valueOf(1));
        }
        if (dto.getSize() == null) {
            dto.setSize(Integer.valueOf(10));
        }
        int pageSize = dto.getSize();
        int pageNumber = dto.getCurrent();
        page.setCurrent((long)pageNumber);
        page.setSize((long)pageSize);
        int offset = (pageNumber - 1) * pageSize;
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        queryParams.put("id", dto.getId());
        queryParams.put("sceneId", dto.getSceneId());
        queryParams.put("taskName", dto.getTaskName());
        queryParams.put("dateStart", dto.getCensorStartDate());
        queryParams.put("dateEnd", dto.getCensorEndDate());
        queryParams.put("taskStatus", dto.getTaskStatus());
        count = this.iUsehubTaskMapper.getTaskListCount(queryParams);
        queryParams.put("size", pageSize);
        queryParams.put("offset", offset);
        List<UsehubTaskPo> usehubTaskPoList = this.iUsehubTaskMapper.getAllUsehubTaskInfo(queryParams);
        page.setTotal((long)count);
        page.setRecords(usehubTaskPoList);
        return page;
    }

    public int queryAllCensorTaskCount() {
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        queryParams.put("id", null);
        queryParams.put("sceneId", null);
        queryParams.put("taskName", null);
        queryParams.put("dateStart", null);
        queryParams.put("dateEnd", null);
        queryParams.put("taskStatus", null);
        int count = this.iUsehubTaskMapper.getTaskListCount(queryParams);
        return count;
    }

    public int queryCountBySceneId(Long sceneId) {
        return this.iUsehubTaskMapper.queryCountBySceneId(sceneId);
    }

    public void uploadDocInfo(UsehubTaskDocDto usehubTaskDocDto) {
        block12: {
            String creator;
            LocalDateTime nowTime;
            List<UsehubTaskDocPo> usehubTaskDocPoS;
            List docInfoVos;
            HashMap<String, String> docTypeInfo;
            String batchName;
            String batchNo;
            block11: {
                Long sceneId = usehubTaskDocDto.getSceneId();
                String taskId = usehubTaskDocDto.getTaskId();
                batchNo = usehubTaskDocDto.getBatchNo();
                batchName = usehubTaskDocDto.getBatchName();
                List docTypeVoList = this.sceneDocTypeRelevancyService.getDocTypeObjectList(sceneId.longValue());
                if (docTypeVoList == null || docTypeVoList.isEmpty()) {
                    throw new HussarException("\u672a\u67e5\u8be2\u5230\u5ba1\u67e5\u5e94\u7528\u7ba1\u7406\u4e2d\u5bf9\u5e94\u914d\u7f6e\u7684\u6587\u6863\u7c7b\u578b!");
                }
                docTypeInfo = new HashMap<String, String>();
                for (DocTypeVo docTypeVo : docTypeVoList) {
                    docTypeInfo.put(String.valueOf(docTypeVo.getId()), docTypeVo.getDocTypeName());
                }
                docInfoVos = usehubTaskDocDto.getDocInfoVos();
                usehubTaskDocPoS = this.iUsehubTaskDocMapper.getTaskDocInfo(sceneId, taskId);
                nowTime = LocalDateTime.now();
                creator = String.valueOf(UserUtils.getLoginUserId());
                if (usehubTaskDocPoS != null && !usehubTaskDocPoS.isEmpty()) break block11;
                for (DocInfoVo docInfoVo : docInfoVos) {
                    String fsType = docInfoVo.getFsType();
                    Long id = SnowFlakeUtil.getFlowIdInstance().nextId();
                    UsehubTaskDocPo usehubTaskDocPo = new UsehubTaskDocPo();
                    usehubTaskDocPo.setId(id);
                    usehubTaskDocPo.setSceneId(usehubTaskDocDto.getSceneId());
                    usehubTaskDocPo.setTaskId(usehubTaskDocDto.getTaskId());
                    usehubTaskDocPo.setCreator(creator);
                    usehubTaskDocPo.setCreateTime(nowTime);
                    usehubTaskDocPo.setDocId(docInfoVo.getId());
                    usehubTaskDocPo.setDocName(docInfoVo.getName());
                    usehubTaskDocPo.setBatchNo(batchNo);
                    usehubTaskDocPo.setBatchName(batchName);
                    if (docTypeInfo.containsKey(fsType)) {
                        usehubTaskDocPo.setTemplateId(Long.valueOf(fsType));
                        usehubTaskDocPo.setTemplateName((String)docTypeInfo.get(fsType));
                    }
                    this.iUsehubTaskDocMapper.insert(usehubTaskDocPo);
                }
                break block12;
            }
            HashMap<String, Long> idDocs = new HashMap<String, Long>();
            HashMap<Long, Long> templateMap = new HashMap<Long, Long>();
            for (UsehubTaskDocPo usehubTaskDocPo : usehubTaskDocPoS) {
                Long docId = usehubTaskDocPo.getDocId();
                if (usehubTaskDocPo.getTemplateId() != null && docId == null) {
                    templateMap.put(usehubTaskDocPo.getTemplateId(), usehubTaskDocPo.getId());
                    continue;
                }
                idDocs.put(String.valueOf(docId), usehubTaskDocPo.getId());
            }
            ArrayList deleteTaskDoc = new ArrayList();
            for (DocInfoVo docInfoVo : docInfoVos) {
                String fsType = docInfoVo.getFsType();
                String docId = String.valueOf(docInfoVo.getId());
                if (!idDocs.isEmpty() && idDocs.containsKey(docId)) {
                    if (!docTypeInfo.containsKey(fsType)) continue;
                    this.iUsehubTaskDocMapper.updateTaskDocTypeById((Long)idDocs.get(docId), Long.valueOf(fsType), (String)docTypeInfo.get(fsType), batchNo, batchName);
                    continue;
                }
                Long id = SnowFlakeUtil.getFlowIdInstance().nextId();
                UsehubTaskDocPo usehubTaskDocPo = new UsehubTaskDocPo();
                usehubTaskDocPo.setId(id);
                usehubTaskDocPo.setSceneId(usehubTaskDocDto.getSceneId());
                usehubTaskDocPo.setTaskId(usehubTaskDocDto.getTaskId());
                usehubTaskDocPo.setCreator(creator);
                usehubTaskDocPo.setCreateTime(nowTime);
                usehubTaskDocPo.setDocId(Long.valueOf(docId));
                usehubTaskDocPo.setDocName(docInfoVo.getName());
                usehubTaskDocPo.setBatchNo(batchNo);
                usehubTaskDocPo.setBatchName(batchName);
                if (docTypeInfo.containsKey(fsType)) {
                    usehubTaskDocPo.setTemplateId(Long.valueOf(fsType));
                    usehubTaskDocPo.setTemplateName((String)docTypeInfo.get(fsType));
                    if (!deleteTaskDoc.contains(templateMap.get(Long.valueOf(fsType)))) {
                        deleteTaskDoc.add(templateMap.get(Long.valueOf(fsType)));
                    }
                }
                this.iUsehubTaskDocMapper.insert(usehubTaskDocPo);
            }
            if (deleteTaskDoc.isEmpty()) break block12;
            for (Long id : deleteTaskDoc) {
                this.iUsehubTaskDocMapper.deleteTaskDocById(id);
            }
        }
    }

    public void batchUploadDocInfo(UseHubBatchUploadDocDto useHubBatchUploadDocDto) {
        block12: {
            String creator;
            LocalDateTime nowTime;
            List<UsehubTaskDocPo> usehubTaskDocPoS;
            List docPoList;
            HashMap<String, String> docTypeInfo;
            String taskId;
            Long sceneId;
            block11: {
                sceneId = useHubBatchUploadDocDto.getSceneId();
                taskId = useHubBatchUploadDocDto.getTaskId();
                List docTypeVoList = this.sceneDocTypeRelevancyService.getDocTypeObjectList(sceneId.longValue());
                if (docTypeVoList == null || docTypeVoList.isEmpty()) {
                    throw new HussarException("\u672a\u67e5\u8be2\u5230\u5ba1\u67e5\u5e94\u7528\u7ba1\u7406\u4e2d\u5bf9\u5e94\u914d\u7f6e\u7684\u6587\u6863\u7c7b\u578b!");
                }
                docTypeInfo = new HashMap<String, String>();
                for (DocTypeVo docTypeVo : docTypeVoList) {
                    docTypeInfo.put(String.valueOf(docTypeVo.getId()), docTypeVo.getDocTypeName());
                }
                docPoList = useHubBatchUploadDocDto.getDocPoList();
                usehubTaskDocPoS = this.iUsehubTaskDocMapper.getTaskDocInfo(sceneId, taskId);
                nowTime = LocalDateTime.now();
                creator = String.valueOf(UserUtils.getLoginUserId());
                if (usehubTaskDocPoS != null && !usehubTaskDocPoS.isEmpty()) break block11;
                for (UsehubTaskDocPo usehubTaskDocPo : docPoList) {
                    String fsType = String.valueOf(usehubTaskDocPo.getTemplateId());
                    Long id = SnowFlakeUtil.getFlowIdInstance().nextId();
                    usehubTaskDocPo.setId(id);
                    usehubTaskDocPo.setSceneId(sceneId);
                    usehubTaskDocPo.setTaskId(taskId);
                    usehubTaskDocPo.setCreator(creator);
                    usehubTaskDocPo.setCreateTime(nowTime);
                    if (docTypeInfo.containsKey(fsType)) {
                        usehubTaskDocPo.setTemplateId(Long.valueOf(fsType));
                        usehubTaskDocPo.setTemplateName((String)docTypeInfo.get(fsType));
                    }
                    this.iUsehubTaskDocMapper.insert(usehubTaskDocPo);
                }
                break block12;
            }
            HashMap<String, Long> idDocs = new HashMap<String, Long>();
            HashMap<Long, Long> templateMap = new HashMap<Long, Long>();
            for (UsehubTaskDocPo usehubTaskDocPo : usehubTaskDocPoS) {
                Long docId = usehubTaskDocPo.getDocId();
                if (usehubTaskDocPo.getTemplateId() != null && docId == null) {
                    templateMap.put(usehubTaskDocPo.getTemplateId(), usehubTaskDocPo.getId());
                    continue;
                }
                idDocs.put(String.valueOf(docId), usehubTaskDocPo.getId());
            }
            ArrayList deleteTaskDoc = new ArrayList();
            for (UsehubTaskDocPo usehubTaskDocPo : docPoList) {
                String fsType = String.valueOf(usehubTaskDocPo.getTemplateId());
                String docId = String.valueOf(usehubTaskDocPo.getDocId());
                if (!idDocs.isEmpty() && idDocs.containsKey(docId)) {
                    if (!docTypeInfo.containsKey(fsType)) continue;
                    this.iUsehubTaskDocMapper.updateTaskDocTypeById((Long)idDocs.get(docId), Long.valueOf(fsType), (String)docTypeInfo.get(fsType), usehubTaskDocPo.getBatchNo(), usehubTaskDocPo.getBatchName());
                    continue;
                }
                Long id = SnowFlakeUtil.getFlowIdInstance().nextId();
                usehubTaskDocPo.setId(id);
                usehubTaskDocPo.setSceneId(sceneId);
                usehubTaskDocPo.setTaskId(taskId);
                usehubTaskDocPo.setCreator(creator);
                usehubTaskDocPo.setCreateTime(nowTime);
                if (docTypeInfo.containsKey(fsType)) {
                    usehubTaskDocPo.setTemplateId(Long.valueOf(fsType));
                    usehubTaskDocPo.setTemplateName((String)docTypeInfo.get(fsType));
                    if (!deleteTaskDoc.contains(templateMap.get(Long.valueOf(fsType)))) {
                        deleteTaskDoc.add(templateMap.get(Long.valueOf(fsType)));
                    }
                }
                this.iUsehubTaskDocMapper.insert(usehubTaskDocPo);
            }
            if (deleteTaskDoc.isEmpty()) break block12;
            for (Long id : deleteTaskDoc) {
                this.iUsehubTaskDocMapper.deleteTaskDocById(id);
            }
        }
    }

    public Map<String, Object> getDocTypeList(Long sceneId, List<DocTypeVo> docTypeVoList, String taskId) {
        List docFiles;
        HashMap<String, Object> result = new HashMap<String, Object>();
        LinkedHashMap mateData = new LinkedHashMap();
        ArrayList unMateData = new ArrayList();
        ArrayList<UseHubUploadDocDto> mateDataResult = new ArrayList<UseHubUploadDocDto>();
        HashMap<String, String> batchInfo = new HashMap<String, String>();
        if (docTypeVoList.isEmpty()) {
            result.put("mateData", null);
            result.put("unMateData", null);
            return result;
        }
        LinkedHashMap taskDocPoMap = new LinkedHashMap();
        List<Object> usehubTaskDocPoS = new ArrayList();
        ArrayList<Long> docIdsPlsc = new ArrayList<Long>();
        if (taskId != null && !"".equals(taskId) && (usehubTaskDocPoS = this.iUsehubTaskDocMapper.getTaskDocInfo(sceneId, taskId)) != null && !usehubTaskDocPoS.isEmpty()) {
            for (UsehubTaskDocPo usehubTaskDocPo : usehubTaskDocPoS) {
                List<UsehubTaskDocPo> docPos;
                String batchNo = usehubTaskDocPo.getBatchNo();
                String string = usehubTaskDocPo.getBatchName();
                if (batchNo == null || "".equals(batchNo)) {
                    docIdsPlsc.add(usehubTaskDocPo.getDocId());
                    continue;
                }
                if (taskDocPoMap.containsKey(batchNo)) {
                    docPos = (List)taskDocPoMap.get(batchNo);
                    docPos.add(usehubTaskDocPo);
                    taskDocPoMap.put(batchNo, docPos);
                } else {
                    docPos = new ArrayList();
                    docPos.add(usehubTaskDocPo);
                    taskDocPoMap.put(batchNo, docPos);
                }
                batchInfo.put(batchNo, string);
            }
        }
        if (!docIdsPlsc.isEmpty() && (docFiles = this.docInfoMapper.getDocFiles(docIdsPlsc, 0)) != null && !docFiles.isEmpty()) {
            unMateData.addAll(docFiles);
        }
        String pch = "1";
        ArrayList<UsehubTaskDocDto> arrayList = new ArrayList<UsehubTaskDocDto>();
        for (DocTypeVo docTypeVo : docTypeVoList) {
            Long templateId = docTypeVo.getId();
            if (!taskDocPoMap.isEmpty()) {
                for (Map.Entry m : taskDocPoMap.entrySet()) {
                    List docFiles2;
                    List<UsehubTaskDocDto> usehubTaskDocDtoList;
                    String batchNo = (String)m.getKey();
                    List docPoList = (List)m.getValue();
                    ArrayList<Long> docIds = new ArrayList<Long>();
                    ArrayList<DocInfoVo> docInfoVos = new ArrayList<DocInfoVo>();
                    HashMap<Long, String> docMap = new HashMap<Long, String>();
                    for (UsehubTaskDocPo usehubTaskDocPo : docPoList) {
                        Long docId = usehubTaskDocPo.getDocId();
                        if (docId == null) continue;
                        if (usehubTaskDocPo.getTemplateId() == null) {
                            docIds.add(usehubTaskDocPo.getDocId());
                        }
                        if (!templateId.equals(usehubTaskDocPo.getTemplateId())) continue;
                        docMap.put(usehubTaskDocPo.getDocId(), usehubTaskDocPo.getDocName());
                        DocInfoVo docInfoVo = new DocInfoVo();
                        FileInfoPo fileInfoPo = new FileInfoPo(this.docInfoMapper.getFileInfo(String.valueOf(usehubTaskDocPo.getDocId())));
                        docInfoVo.setId(fileInfoPo.getId());
                        docInfoVo.setName(fileInfoPo.getName());
                        docInfoVo.setFormat(fileInfoPo.getFormat());
                        docInfoVo.setFsType(fileInfoPo.getFsType());
                        docInfoVos.add(docInfoVo);
                    }
                    UsehubTaskDocDto usehubTaskDocDto = new UsehubTaskDocDto();
                    usehubTaskDocDto.setTemplateId(templateId);
                    usehubTaskDocDto.setTemplateName(docTypeVo.getDocTypeName());
                    usehubTaskDocDto.setBatchNo(batchNo);
                    usehubTaskDocDto.setDocMap(docMap);
                    usehubTaskDocDto.setDocInfoVos(docInfoVos);
                    usehubTaskDocDto.setTaskDocNum(docInfoVos.size());
                    usehubTaskDocDto.setEnabled(docTypeVo.getEnabled());
                    if (mateData.containsKey(batchNo)) {
                        usehubTaskDocDtoList = (List)mateData.get(batchNo);
                        usehubTaskDocDtoList.add(usehubTaskDocDto);
                        mateData.put(batchNo, usehubTaskDocDtoList);
                    } else {
                        usehubTaskDocDtoList = new ArrayList();
                        usehubTaskDocDtoList.add(usehubTaskDocDto);
                        mateData.put(batchNo, usehubTaskDocDtoList);
                    }
                    if (docIds.isEmpty() || (docFiles2 = this.docInfoMapper.getDocFiles(docIds, 0)) == null || docFiles2.isEmpty()) continue;
                    unMateData.addAll(docFiles2);
                }
                continue;
            }
            UsehubTaskDocDto usehubTaskDocDto = new UsehubTaskDocDto();
            usehubTaskDocDto.setTemplateId(templateId);
            usehubTaskDocDto.setTemplateName(docTypeVo.getDocTypeName());
            usehubTaskDocDto.setBatchNo(pch);
            usehubTaskDocDto.setTaskDocNum(0);
            usehubTaskDocDto.setEnabled(docTypeVo.getEnabled());
            arrayList.add(usehubTaskDocDto);
        }
        if (!arrayList.isEmpty()) {
            mateData.put(pch, arrayList);
            batchInfo.put(pch, "\u9ed8\u8ba4\u6279\u6b21");
        }
        for (Map.Entry entry : mateData.entrySet()) {
            UseHubUploadDocDto useHubUploadDocDto = new UseHubUploadDocDto();
            useHubUploadDocDto.setId((String)entry.getKey());
            useHubUploadDocDto.setName((String)batchInfo.get(entry.getKey()));
            useHubUploadDocDto.setUsehubTaskDocDtoList((List)entry.getValue());
            mateDataResult.add(useHubUploadDocDto);
        }
        result.put("mateData", mateDataResult);
        result.put("unMateData", unMateData);
        return result;
    }

    public void addOrUpdateBatchInfo(UsehubAddBatchInfoDto usehubAddBatchInfoDto) {
        Long sceneId = usehubAddBatchInfoDto.getSceneId();
        String taskId = usehubAddBatchInfoDto.getTaskId();
        String batchNo = usehubAddBatchInfoDto.getId();
        String batchName = usehubAddBatchInfoDto.getName();
        if (batchNo == null || "".equals(batchNo)) {
            batchNo = String.valueOf(SnowFlakeUtil.getFlowIdInstance().nextId());
            List docTypeVoList = this.sceneDocTypeRelevancyService.getDocTypeObjectList(sceneId.longValue());
            if (docTypeVoList == null || docTypeVoList.isEmpty()) {
                throw new HussarException("\u672a\u67e5\u8be2\u5230\u5ba1\u67e5\u5e94\u7528\u7ba1\u7406\u4e2d\u5bf9\u5e94\u914d\u7f6e\u7684\u6587\u6863\u7c7b\u578b!");
            }
            String creator = String.valueOf(UserUtils.getLoginUserId());
            List<UsehubTaskDocPo> usehubTaskDocPoS = this.iUsehubTaskDocMapper.getTaskDocInfo(sceneId, taskId);
            if (usehubTaskDocPoS == null || usehubTaskDocPoS.isEmpty()) {
                for (DocTypeVo docTypeVo : docTypeVoList) {
                    Long id = SnowFlakeUtil.getFlowIdInstance().nextId();
                    UsehubTaskDocPo usehubTaskDocPo = new UsehubTaskDocPo();
                    usehubTaskDocPo.setId(id);
                    usehubTaskDocPo.setSceneId(sceneId);
                    usehubTaskDocPo.setTaskId(taskId);
                    usehubTaskDocPo.setCreator(creator);
                    usehubTaskDocPo.setCreateTime(LocalDateTime.parse("1029-12-31T00:00:00"));
                    usehubTaskDocPo.setBatchNo("1");
                    usehubTaskDocPo.setBatchName("\u9ed8\u8ba4\u6279\u6b21");
                    usehubTaskDocPo.setTemplateId(docTypeVo.getId());
                    usehubTaskDocPo.setTemplateName(docTypeVo.getDocTypeName());
                    this.iUsehubTaskDocMapper.insert(usehubTaskDocPo);
                }
            }
            LocalDateTime nowTime2 = LocalDateTime.now();
            for (DocTypeVo docTypeVo : docTypeVoList) {
                Long id = SnowFlakeUtil.getFlowIdInstance().nextId();
                UsehubTaskDocPo usehubTaskDocPo = new UsehubTaskDocPo();
                usehubTaskDocPo.setId(id);
                usehubTaskDocPo.setSceneId(sceneId);
                usehubTaskDocPo.setTaskId(taskId);
                usehubTaskDocPo.setCreator(creator);
                usehubTaskDocPo.setCreateTime(nowTime2);
                usehubTaskDocPo.setBatchNo(batchNo);
                usehubTaskDocPo.setBatchName(batchName);
                usehubTaskDocPo.setTemplateId(docTypeVo.getId());
                usehubTaskDocPo.setTemplateName(docTypeVo.getDocTypeName());
                this.iUsehubTaskDocMapper.insert(usehubTaskDocPo);
            }
        } else {
            this.iUsehubTaskDocMapper.updateBatchInfo(taskId, batchNo, batchName);
        }
    }

    public void deleteBatchInfo(String taskId, String batchNo) {
        this.iUsehubTaskDocMapper.deleteBatchInfo(taskId, batchNo);
    }

    public void updateTaskStatus(Long taskId, String taskStatus, String error) {
        UsehubTaskPo usePo = new UsehubTaskPo();
        usePo.setId(taskId);
        usePo.setTaskStatus(taskStatus);
        usePo.setError(error);
        this.iUsehubTaskMapper.updateTaskInfoById(usePo);
    }

    public void deleteUploadDocInfo(String taskId, String docTypeId, String docId) {
        this.iUsehubTaskDocMapper.updateTaskDocTypeInfo(taskId, Long.valueOf(docTypeId), Long.valueOf(docId));
    }

    public boolean ifExitTaskName(String sceneId, String taskName) {
        boolean flag = true;
        List<UsehubTaskPo> usehubTaskPo = this.iUsehubTaskMapper.getInfoByScenceIdAndTaskName(Long.valueOf(sceneId), taskName);
        if (usehubTaskPo != null && !usehubTaskPo.isEmpty()) {
            flag = false;
        }
        return flag;
    }

    public String ifCensorTaskEnd(String taskId) {
        String flag = "0";
        UsehubTaskPo usehubTaskPo = this.iUsehubTaskMapper.getUsehubTaskInfoById(Long.valueOf(taskId));
        if (usehubTaskPo != null) {
            String taskStatus = usehubTaskPo.getTaskStatus();
            if ("\u5ba1\u67e5\u5b8c\u6210".equals(taskStatus)) {
                flag = "1";
            } else if ("\u5ba1\u67e5\u5931\u8d25".equals(taskStatus)) {
                flag = "2";
            }
        }
        return flag;
    }

    public void updateSceneNameInfo(Long sceneId, String sceneName) {
        this.iUsehubTaskMapper.updateSceneNameBySceneId(sceneId, sceneName);
    }

    public void deleteUnmatchedDocInfo(String taskId, String docId) {
        this.iUsehubTaskDocMapper.deleteUnmatchedDocInfo(taskId, Long.valueOf(docId));
    }
}

