/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.usehub.service.impl;

import com.jxdinfo.idp.common.base.dto.FileBytesInfo;
import com.jxdinfo.idp.common.util.SnowFlakeUtil;
import com.jxdinfo.idp.extract.domain.dto.ExtractItemDto;
import com.jxdinfo.idp.extract.domain.po.ExtractRecord;
import com.jxdinfo.idp.extract.interf.IExtractCore;
import com.jxdinfo.idp.scene.api.dto.SceneExtractItemDto;
import com.jxdinfo.idp.usehub.mapper.UsehubTaskExtractResultMapper;
import com.jxdinfo.idp.usehub.util.ResultParseUtil;
import com.jxdinfo.usehub.dto.ExecuteExtractDto;
import com.jxdinfo.usehub.po.UsehubTaskExtractResultPo;
import com.jxdinfo.usehub.service.CensorExecuteExtractService;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CensorExecuteExtractImpl
implements CensorExecuteExtractService {
    private static final Logger log = LoggerFactory.getLogger(CensorExecuteExtractImpl.class);
    @Autowired
    private IExtractCore iIExtractCore;
    @Resource
    private UsehubTaskExtractResultMapper iUsehubTaskExtractResultMapper;

    public ExecuteExtractDto init(ExecuteExtractDto executeExtractDto) {
        return executeExtractDto;
    }

    public void executeExtract(ExecuteExtractDto executeExtractDto) {
        String creator = executeExtractDto.getCreator();
        LocalDateTime nowTime = LocalDateTime.now();
        HashMap docExtractCodeResultMap = new HashMap();
        HashMap<String, Object> docExtractItemResultMap = new HashMap<String, Object>();
        ArrayList<UsehubTaskExtractResultPo> saveResults = new ArrayList<UsehubTaskExtractResultPo>();
        List extractChainItemDtos = executeExtractDto.getExtractChainItemDtos();
        List extractChainNodeDtos = executeExtractDto.getExtractChainNodeDtos();
        Map doExtractMap = executeExtractDto.getDoExtractMap();
        List sceneExtractItemDtoList = executeExtractDto.getSceneExtractItemDtoList();
        ArrayList extractRecordListAll = new ArrayList();
        if (extractChainNodeDtos != null && !extractChainNodeDtos.isEmpty()) {
            extractRecordListAll.addAll(this.iIExtractCore.execute(extractChainItemDtos, extractChainNodeDtos));
        }
        for (Map.Entry map : doExtractMap.entrySet()) {
            FileBytesInfo fileBytesInfo = (FileBytesInfo)map.getKey();
            List itemDtoList = (List)map.getValue();
            extractRecordListAll.addAll(this.iIExtractCore.execute(itemDtoList, fileBytesInfo));
        }
        for (ExtractRecord extractRecord : extractRecordListAll) {
            docExtractItemResultMap.put(String.valueOf(extractRecord.getExtractItemId()), extractRecord.getResultObject());
            UsehubTaskExtractResultPo usehubTaskExtractResultPo = new UsehubTaskExtractResultPo();
            usehubTaskExtractResultPo.setTaskId(executeExtractDto.getTaskId());
            usehubTaskExtractResultPo.setBatchNo(executeExtractDto.getBatchNo());
            usehubTaskExtractResultPo.setDocId(executeExtractDto.getDocId());
            usehubTaskExtractResultPo.setExtractItemId(extractRecord.getExtractItemId());
            usehubTaskExtractResultPo.setCreator(creator);
            usehubTaskExtractResultPo.setCreateTime(nowTime);
            usehubTaskExtractResultPo.setDeleteFlag(Integer.valueOf(0));
            Object result = extractRecord.getResultObject();
            String value = ResultParseUtil.parseExtractValue(result);
            usehubTaskExtractResultPo.setResult(value);
            saveResults.add(usehubTaskExtractResultPo);
        }
        for (SceneExtractItemDto sceneExtractItemDto : sceneExtractItemDtoList) {
            String extractItemId = String.valueOf(sceneExtractItemDto.getExtractItemId());
            if (!docExtractItemResultMap.containsKey(extractItemId)) continue;
            docExtractCodeResultMap.put(sceneExtractItemDto.getCode(), docExtractItemResultMap.get(extractItemId));
        }
        executeExtractDto.setDocExtractItemResultMap(docExtractItemResultMap);
        executeExtractDto.setDocExtractCodeResultMap(docExtractCodeResultMap);
        executeExtractDto.setSaveResults(saveResults);
    }

    public void saveResult(ExecuteExtractDto executeExtractDto) {
        List saveResults = executeExtractDto.getSaveResults();
        ArrayList extractItemIdList = new ArrayList();
        saveResults.forEach(usehubTaskExtractResultPo -> extractItemIdList.add(usehubTaskExtractResultPo.getExtractItemId()));
        List extractItemDtoList = this.iIExtractCore.getExtractItemsByIds(extractItemIdList);
        for (UsehubTaskExtractResultPo usehubTaskExtractResultPo2 : saveResults) {
            Long id = SnowFlakeUtil.getFlowIdInstance().nextId();
            usehubTaskExtractResultPo2.setId(id);
            Long extractItemId = usehubTaskExtractResultPo2.getExtractItemId();
            String extractItemName = "";
            for (ExtractItemDto extractItemDto : extractItemDtoList) {
                if (!extractItemDto.getId().equals(extractItemId)) continue;
                extractItemName = extractItemDto.getName();
                break;
            }
            usehubTaskExtractResultPo2.setExtractItemName(extractItemName);
            this.iUsehubTaskExtractResultMapper.insertInfo(usehubTaskExtractResultPo2);
        }
    }
}

