/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.synchronization.pool;

import com.jxdinfo.idp.synchronization.dto.UsageDataDto;
import com.jxdinfo.idp.synchronization.pool.UsageCountPool;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;

public class DefautUsageCountPool
implements UsageCountPool {
    private Map<String, Map<String, AtomicInteger>> cache;
    private static final int INIT_USAGE_COUNT = 0;
    private Lock lock = new ReentrantLock();

    public void init() {
        this.cache = new HashMap<String, Map<String, AtomicInteger>>();
    }

    public int getUsageCount(UsageDataDto key) {
        this.lock.lock();
        try {
            int n = this.executeFunctionBySourceCode(key, this::getUsageCountById, this::initUsageCount);
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    public int addUsageCount(UsageDataDto key) {
        this.lock.lock();
        try {
            int n = this.executeFunctionBySourceCode(key, this::incrementAndGet, this::initAndIncrementAndGet);
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    public int reduceUsageCount(UsageDataDto key) {
        this.lock.lock();
        try {
            int n = this.executeFunctionBySourceCode(key, this::decrementAndGet, this::initUsageCount);
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    private <R> R executeFunctionBySourceCode(UsageDataDto key, Function<UsageDataDto, R> notNullFunction, Function<UsageDataDto, R> initFunction) {
        if (this.cache.containsKey(key.getSourceCode())) {
            return notNullFunction.apply(key);
        }
        return initFunction.apply(key);
    }

    private <R> R executeFunctionByDataId(UsageDataDto key, Function<UsageDataDto, R> notNullFunction, Function<UsageDataDto, R> initFunction) {
        Map<String, AtomicInteger> map = this.cache.get(key.getSourceCode());
        if (map.containsKey(key.getDataId())) {
            return notNullFunction.apply(key);
        }
        return initFunction.apply(key);
    }

    private int initAndIncrementAndGet(UsageDataDto key) {
        this.initUsageCount(key);
        return this.incrementAndGet(key);
    }

    private int decrementAndGet(UsageDataDto key) {
        return this.executeFunctionByDataId(key, a -> {
            AtomicInteger atomicInteger = this.cache.get(a.getSourceCode()).get(a.getDataId());
            if (atomicInteger.get() > 0) {
                return atomicInteger.decrementAndGet();
            }
            return atomicInteger.get();
        }, b -> {
            this.cache.get(b.getSourceCode()).put(key.getDataId(), new AtomicInteger(0));
            return 0;
        });
    }

    private int incrementAndGet(UsageDataDto key) {
        return this.executeFunctionByDataId(key, a -> this.cache.get(a.getSourceCode()).get(a.getDataId()).incrementAndGet(), b -> {
            AtomicInteger atomicInteger = new AtomicInteger(1);
            this.cache.get(b.getSourceCode()).put(b.getDataId(), atomicInteger);
            return atomicInteger.get();
        });
    }

    private int getUsageCountById(UsageDataDto key) {
        return this.executeFunctionByDataId(key, a -> this.cache.get(a.getSourceCode()).get(a.getDataId()).get(), b -> {
            this.cache.get(b.getSourceCode()).put(b.getDataId(), new AtomicInteger(0));
            return 0;
        });
    }

    private int initUsageCount(UsageDataDto key) {
        ConcurrentHashMap<String, AtomicInteger> map = new ConcurrentHashMap<String, AtomicInteger>();
        map.put(key.getDataId(), new AtomicInteger(0));
        this.cache.put(key.getSourceCode(), map);
        return 0;
    }
}

