/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.style.util;

import com.jxdinfo.idp.style.controller.ConfigDocClassController;
import com.jxdinfo.idp.style.review.word.docx.DocxParser;
import java.util.HashMap;
import java.util.List;
import java.util.Stack;
import java.util.regex.Pattern;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class NumberUtils {
    private static final int[] ARABIC_NUMBERS;
    private static final String[] ROMAN_NUMBERS_LOWER;
    private static final String[] ROMAN_NUMBERS;

    public static int getnum(char a) {
        switch (a) {
            case 'I': {
                return 1;
            }
            case 'V': {
                return 5;
            }
            case 'X': {
                return 10;
            }
            case 'L': {
                return 50;
            }
            case 'C': {
                while (false) {
                }
                return 100;
            }
            case 'D': {
                return 500;
            }
            case 'M': {
                return 1000;
            }
            default: {
                return 0;
            }
        }
    }

    public static boolean isUppercase(String a) {
        return Pattern.compile(DocxParser.long("k3\u001d(mY")).matcher(a).matches();
    }

    public NumberUtils() {
        NumberUtils a;
    }

    public static boolean isUpperNumber(String string) {
        String a;
        return Pattern.compile(DocxParser.long(")\u4e30\u4efe\u4e39\u56a9\u4ea4\u511f\u4e33\u5119\u4e6d\u5333mY")).matcher(a).matches();
    }

    public static boolean isNumeric(List<String> a) {
        int n;
        Pattern pattern = Pattern.compile(DocxParser.long("kB\u001dKmY"));
        for (String string : a) {
            if (pattern.matcher(string).matches()) continue;
            return false;
        }
        int n2 = Integer.parseInt(a.get(0));
        int n3 = n = 1;
        while (n3 < a.size()) {
            if (Integer.parseInt(a.get(n)) != n2 + 1) {
                return false;
            }
            String string = a.get(n);
            n2 = Integer.parseInt(string);
            n3 = ++n;
        }
        return true;
    }

    public static int chineseToArabic(String a2) {
        int n;
        Stack<Integer> stack = new Stack<Integer>();
        String string = ConfigDocClassController.break("\u4e5e\u4ee3\u4e57\u56b4\u4eca\u5102\u4e5d\u5104\u4e03");
        String string2 = DocxParser.long("\u5333\u764e\u5331\u4e37\u4ecd");
        String[] stringArray = a2.split("");
        int n2 = stringArray.length;
        int n3 = n = 0;
        while (n3 < n2) {
            String string3 = stringArray[n];
            int n4 = string.indexOf(string3);
            int n5 = string2.indexOf(string3);
            if (n4 != -1) {
                stack.push(n4 + 1);
            } else if (n5 != -1) {
                n5 = (int)Math.pow(10.0, n5 + 1);
                if (stack.isEmpty()) {
                    stack.push(n5);
                } else {
                    Stack<Integer> stack2 = stack;
                    stack2.push((Integer)stack2.pop() * n5);
                }
            } else {
                return 0;
            }
            n3 = ++n;
        }
        return stack.stream().mapToInt(a -> a).sum();
    }

    public static String convertToRomanLower(int a) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        int n2 = a;
        while (n2 > 0) {
            int n3 = a;
            while (n3 >= ARABIC_NUMBERS[n]) {
                n3 = a - ARABIC_NUMBERS[n];
                stringBuilder.append(ROMAN_NUMBERS_LOWER[n]);
            }
            ++n;
            n2 = a;
        }
        return stringBuilder.toString();
    }

    public static boolean isLowercase(String string) {
        String a;
        return Pattern.compile(ConfigDocClassController.break("4?B$2u")).matcher(a).matches();
    }

    public static int lowerRomanToInt(String a) {
        int n;
        int n2 = 0;
        int n3 = NumberUtils.getnumLower(a.charAt(0));
        int n4 = n = 1;
        while (n4 < a.length()) {
            int n5;
            int n6 = NumberUtils.getnumLower(a.charAt(n));
            if (n3 >= n6) {
                n2 += n3;
                n5 = n6;
            } else {
                n2 -= n3;
                n5 = n6;
            }
            n3 = n5;
            n4 = ++n;
        }
        return n2 += n3;
    }

    public static boolean isRomanUpperNumber(String a) {
        HashMap<Character, Integer> hashMap = new HashMap<Character, Integer>();
        hashMap.put(Character.valueOf('I'), 1);
        hashMap.put(Character.valueOf('V'), 5);
        hashMap.put(Character.valueOf('X'), 10);
        hashMap.put(Character.valueOf('L'), 50);
        hashMap.put(Character.valueOf('C'), 100);
        hashMap.put(Character.valueOf('D'), 500);
        hashMap.put(Character.valueOf('M'), 1000);
        boolean bl = true;
        int n = 0;
        int n2 = n;
        while (n2 < a.length()) {
            bl = n < a.length() - 1 && (Integer)hashMap.get(Character.valueOf(a.charAt(n))) < (Integer)hashMap.get(Character.valueOf(a.charAt(n + 1)));
            n2 = ++n;
        }
        return bl;
    }

    public static int getnumLower(char a) {
        switch (a) {
            case 'i': {
                return 1;
            }
            case 'v': {
                return 5;
            }
            case 'x': {
                return 10;
            }
            case 'l': {
                return 50;
            }
            case 'c': {
                while (false) {
                }
                return 100;
            }
            case 'd': {
                return 500;
            }
            case 'm': {
                return 1000;
            }
            default: {
                return 0;
            }
        }
    }

    static {
        String[] stringArray = new String[13];
        stringArray[0] = DocxParser.long("?");
        stringArray[1] = ConfigDocClassController.break(",\u0013");
        stringArray[2] = DocxParser.long("6");
        stringArray[3] = ConfigDocClassController.break(",\u001a");
        stringArray[4] = DocxParser.long("1");
        stringArray[5] = ConfigDocClassController.break("7\u001d");
        stringArray[6] = DocxParser.long(">");
        stringArray[7] = ConfigDocClassController.break("7\u0012");
        stringArray[8] = DocxParser.long("*");
        stringArray[9] = ConfigDocClassController.break("&\u0006");
        stringArray[10] = DocxParser.long("$");
        stringArray[11] = ConfigDocClassController.break("&\b");
        stringArray[12] = DocxParser.long(";");
        ROMAN_NUMBERS = stringArray;
        String[] stringArray2 = new String[13];
        stringArray2[0] = ConfigDocClassController.break("3");
        stringArray2[1] = DocxParser.long("S\u001f");
        stringArray2[2] = ConfigDocClassController.break(":");
        stringArray2[3] = DocxParser.long("S\u0016");
        stringArray2[4] = ConfigDocClassController.break("=");
        stringArray2[5] = DocxParser.long("H\u0011");
        stringArray2[6] = ConfigDocClassController.break("2");
        stringArray2[7] = DocxParser.long("H\u001e");
        stringArray2[8] = ConfigDocClassController.break("&");
        stringArray2[9] = DocxParser.long("Y\n");
        stringArray2[10] = ConfigDocClassController.break("(");
        stringArray2[11] = DocxParser.long("Y\u0004");
        stringArray2[12] = ConfigDocClassController.break("7");
        ROMAN_NUMBERS_LOWER = stringArray2;
        int[] nArray = new int[13];
        nArray[0] = 1000;
        nArray[1] = 900;
        nArray[2] = 500;
        nArray[3] = 400;
        nArray[4] = 100;
        nArray[5] = 90;
        nArray[6] = 50;
        nArray[7] = 40;
        nArray[8] = 10;
        nArray[9] = 9;
        nArray[10] = 5;
        nArray[11] = 4;
        nArray[12] = 1;
        ARABIC_NUMBERS = nArray;
    }

    public static int upperRomanToInt(String a) {
        int n;
        int n2 = 0;
        int n3 = NumberUtils.getnum(a.charAt(0));
        int n4 = n = 1;
        while (n4 < a.length()) {
            int n5;
            int n6 = NumberUtils.getnum(a.charAt(n));
            if (n3 >= n6) {
                n2 += n3;
                n5 = n6;
            } else {
                n2 -= n3;
                n5 = n6;
            }
            n3 = n5;
            n4 = ++n;
        }
        return n2 += n3;
    }

    public static boolean isRomanLowerNumber(String a) {
        HashMap<Character, Integer> hashMap = new HashMap<Character, Integer>();
        hashMap.put(Character.valueOf('i'), 1);
        hashMap.put(Character.valueOf('v'), 5);
        hashMap.put(Character.valueOf('x'), 10);
        hashMap.put(Character.valueOf('l'), 50);
        hashMap.put(Character.valueOf('c'), 100);
        hashMap.put(Character.valueOf('d'), 500);
        hashMap.put(Character.valueOf('m'), 1000);
        boolean bl = true;
        int n = 0;
        int n2 = n;
        while (n2 < a.length()) {
            bl = n < a.length() - 1 && (Integer)hashMap.get(Character.valueOf(a.charAt(n))) < (Integer)hashMap.get(Character.valueOf(a.charAt(n + 1)));
            n2 = ++n;
        }
        return bl;
    }

    public static String arabicToChinese(int a) {
        int n;
        char[] cArray = new char[10];
        cArray[0] = 38646;
        cArray[1] = 19968;
        cArray[2] = 20108;
        cArray[3] = 19977;
        cArray[4] = 22235;
        cArray[5] = 20116;
        cArray[6] = 20845;
        cArray[7] = 19971;
        cArray[8] = 20843;
        cArray[9] = 20061;
        char[] cArray2 = cArray;
        char[] cArray3 = new char[5];
        cArray3[0] = 20010;
        cArray3[1] = 21313;
        cArray3[2] = 30334;
        cArray3[3] = 21315;
        cArray3[4] = 19975;
        char[] cArray4 = cArray3;
        String string = "";
        String string2 = String.valueOf(a);
        int n2 = string2.length();
        boolean bl = false;
        int n3 = n = 0;
        while (n3 < n2) {
            int n4 = string2.charAt(n) - 48;
            if (n4 != 0 || !bl && n != n2 - 1) {
                string = new StringBuilder().insert(0, string).append(cArray2[n4]).append("").append(cArray4[n2 - 1 - n]).toString();
                bl = false;
            } else {
                bl = true;
            }
            n3 = ++n;
        }
        if ((string = string.replaceAll(ConfigDocClassController.break("\u9699\u0005\u532c\u7620\u532e\u0003"), DocxParser.long("\u9684")).replaceAll(ConfigDocClassController.break("\u96a8D\u4e59"), DocxParser.long("\u4e75")).replaceAll(ConfigDocClassController.break("\u9699u"), DocxParser.long("\u9684")).replaceAll(ConfigDocClassController.break("\u4e74"), "")).startsWith(DocxParser.long("\u4e30\u5333")) && string.length() <= 3) {
            String string3 = string;
            string = string3.substring(1, string3.length());
        }
        if (string.endsWith(ConfigDocClassController.break("\u96a8")) && string.length() > 1) {
            String string4 = string;
            string = string4.substring(0, string4.length() - 1);
        }
        return string;
    }

    public static boolean isNumber(String a) {
        return Pattern.compile(ConfigDocClassController.break("4nBg2u")).matcher(a).matches();
    }

    public static boolean isEnglish(String a) {
        return Pattern.compile(ConfigDocClassController.break("\u0005\u000es\u0015\u001fB\u00042u")).matcher(a).matches();
    }

    public static String convertToRomanUpper(int a) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        int n2 = a;
        while (n2 > 0) {
            int n3 = a;
            while (n3 >= ARABIC_NUMBERS[n]) {
                n3 = a - ARABIC_NUMBERS[n];
                stringBuilder.append(ROMAN_NUMBERS[n]);
            }
            ++n;
            n2 = a;
        }
        return stringBuilder.toString();
    }
}

