/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.style.controller;

import com.jxdinfo.idp.common.response.ApiResponse;
import com.jxdinfo.idp.style.api.service.IConfigDocVersionService;
import com.jxdinfo.idp.style.entity.dto.DocVersionEditDTO;
import com.jxdinfo.idp.style.entity.dto.DocVersionQuery;
import com.jxdinfo.idp.style.entity.vo.DocClassVersionVOPage;
import com.jxdinfo.idp.style.review.word.docx.DocxParser;
import com.jxdinfo.idp.style.review.word.docx.number.NumWrapper;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/config/document/version"})
public class ConfigDocVersionController {
    @Resource
    private IConfigDocVersionService versionService;

    @GetMapping(value={"/todefault"})
    public ApiResponse toDefault(@RequestParam(value="versionId") String versionId) {
        this.versionService.toDefault(versionId);
        return ApiResponse.success();
    }

    @PostMapping(value={"/edit"})
    public ApiResponse editVersionInfo(@RequestBody DocVersionEditDTO dto) {
        this.versionService.editVersionInfo(dto);
        return ApiResponse.success();
    }

    @PostMapping(value={"/uploadTemplate"})
    public ApiResponse<String> uploadTemplate(DocVersionEditDTO dto) {
        try {
            return ApiResponse.data((Object)this.versionService.uploadTemplate(dto));
        }
        catch (Exception a) {
            return ApiResponse.fail((String)new StringBuilder().insert(0, NumWrapper.case("\u4e5b\u4f0f\u6a70\u6750\u5960\u8d0a\uff4b")).append(a.getMessage()).toString());
        }
    }

    @GetMapping(value={"/download"})
    public void download(HttpServletResponse response, @RequestParam(value="fileId") String fileId) {
        this.versionService.download(response, fileId);
    }

    @PostMapping(value={"/deleTemplate"})
    public ApiResponse<Boolean> deleTemplate(@RequestBody DocVersionEditDTO dto) {
        try {
            return ApiResponse.data((Object)this.versionService.deleTemplate(dto));
        }
        catch (Exception a) {
            return ApiResponse.fail((String)new StringBuilder().insert(0, DocxParser.long("\u5252\u9654\u6a53\u674f\u5943\u8d15\uff68")).append(a.getMessage()).toString());
        }
    }

    @PostMapping(value={"/list"})
    public ApiResponse<DocClassVersionVOPage> versionList(@RequestBody DocVersionQuery versionQuery) {
        return ApiResponse.success((Object)this.versionService.versionsList(versionQuery));
    }

    @GetMapping(value={"/batchdel"})
    public ApiResponse batchDel(@RequestParam(value="ids") String ids) {
        this.versionService.batchDel(ids);
        return ApiResponse.success();
    }
}

