/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.style.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.idp.common.entity.dto.DocClassTree;
import com.jxdinfo.idp.common.exception.BusinessException;
import com.jxdinfo.idp.common.response.ApiResponse;
import com.jxdinfo.idp.common.util.SerializeUtils;
import com.jxdinfo.idp.style.api.service.IConfigDocClassService;
import com.jxdinfo.idp.style.api.service.IConfigDocVersionService;
import com.jxdinfo.idp.style.entity.dto.ConfigDocVersionDTO;
import com.jxdinfo.idp.style.entity.dto.DocClassDto;
import com.jxdinfo.idp.style.entity.dto.DocClassQuery;
import com.jxdinfo.idp.style.entity.dto.StyleLibExportDto;
import com.jxdinfo.idp.style.entity.po.ConfigDocClass;
import com.jxdinfo.idp.style.entity.po.ConfigDocVersion;
import com.jxdinfo.idp.style.entity.vo.DocClassVO;
import com.jxdinfo.idp.style.review.correct.util.CorrectNoUtil;
import com.jxdinfo.idp.style.review.word.docx.number.NumWrapper;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/config/document/class"})
public class ConfigDocClassController {
    @Resource
    private IConfigDocVersionService docVersionService;
    @Resource
    private IConfigDocClassService docClassService;

    @PostMapping(value={"/importStyleLib"})
    public ApiResponse<Void> importStyleLib(@RequestPart(value="hussarFile") MultipartFile hussarFile, @RequestParam(value="isUserData") String isUserData) {
        block4: {
            byte[] a = hussarFile.getBytes();
            StyleLibExportDto a2 = (StyleLibExportDto)SerializeUtils.deserialize((byte[])a);
            if (a2 == null) break block4;
            this.docClassService.importStyleLib(a2, isUserData);
        }
        try {
            return ApiResponse.fail((String)CorrectNoUtil.package("\u5bd0\u5115\u591d\u8d55\u0000\u5b8c\u5149\u65f7\u684f\u8993\u67bc\u6500\u6342\u4e4a\u7a56"));
        }
        catch (ClassCastException a) {
            return ApiResponse.fail((int)10001, (String)NumWrapper.true("\u6866\u5f20\u8995\u5236\u5ec2\u5bd3\u5134\u5f2d\u5e69\uff23\u8ba6\u4e25\u4f71\u6818\u5f5e\u89eb\u5248\u5ebc\u76d5\u5bd3\u51ab\u65a8\u4ea7"));
        }
        catch (Exception a) {
            throw new BusinessException(new StringBuilder().insert(0, CorrectNoUtil.package("\u6847\u5f23\u89b4\u5235\u5ee3\u5bd0\u5115\u5f2e\u5e48\u0000\u5b8c\u5149\u65f7\u684f\u8993\u67bc\u5941\u8d09")).append(a.getMessage()).toString());
        }
        return ApiResponse.success((String)NumWrapper.true("\u5bd3\u5134\u623f\u52ce"));
    }

    @PostMapping(value={"/copyDocument"})
    public ApiResponse copyDocument(@RequestBody Map<String, String> classMap) {
        return ApiResponse.success((Object)this.docClassService.copyDocument(classMap));
    }

    @GetMapping(value={"/tree"})
    public ApiResponse<List<DocClassTree>> getTree() {
        return ApiResponse.success((Object)this.docClassService.getTree());
    }

    @PostMapping(value={"/getAllList"})
    public ApiResponse<List<DocClassDto>> getAllList(@RequestBody DocClassQuery query) {
        return ApiResponse.data((Object)this.docClassService.selectAllList(query));
    }

    @PostMapping(value={"/versions"})
    public ApiResponse<List<ConfigDocVersion>> versions(@RequestBody ConfigDocVersionDTO param) {
        return ApiResponse.success((Object)this.docVersionService.getVersions(param));
    }

    @PostMapping(value={"/getList"})
    public ApiResponse<Page<DocClassDto>> getList(@RequestBody DocClassQuery query) {
        return ApiResponse.data((Object)this.docClassService.selectList(query));
    }

    @PostMapping(value={"/exportStyleLib"})
    public void exportStyleLib(@RequestBody List<Long> ids, HttpServletResponse response) {
        this.docClassService.exportStyleLib(ids, response);
    }

    @PostMapping(value={"/pageList"})
    public ApiResponse<Page<DocClassVO>> pageList(@RequestBody DocClassQuery query) {
        return ApiResponse.success((Object)this.docClassService.pageList(query));
    }

    /*
     * WARNING - void declaration
     */
    @GetMapping(value={"/del"})
    public ApiResponse<Void> del(@RequestParam(value="id") String string) {
        void id;
        this.docClassService.docDel((String)id);
        return ApiResponse.success((String)NumWrapper.true("\u520f\u9635\u623f\u52ce"));
    }

    @PostMapping(value={"/getAllTotalTree"})
    public ApiResponse<List<DocClassTree>> getAllTotalTree(@RequestBody ConfigDocClass docClass) {
        return ApiResponse.success((Object)this.docClassService.getAllTotalTree(docClass));
    }

    @PostMapping(value={"/migration"})
    public ApiResponse<Void> migrationDocument(@RequestBody ConfigDocClass docClass) {
        this.docClassService.migrationDocument(docClass);
        return ApiResponse.success();
    }

    @PostMapping(value={"/save"})
    public ApiResponse<ConfigDocVersion> save(@RequestBody ConfigDocClass docClass) {
        return ApiResponse.success((Object)this.docClassService.docSave(docClass));
    }
}

