/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.scene.server.service.impl;

import cn.hutool.core.collection.CollUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.idp.scene.api.po.SceneExtractItemDocTypeRelevancyPo;
import com.jxdinfo.idp.scene.server.mapper.SceneExtractItemDocTypeRelevancyMapper;
import com.jxdinfo.idp.scene.server.service.SceneExtractItemDocTypeRelevancyService;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Service
public class SceneExtractItemDocTypeRelevancyServiceImpl
extends ServiceImpl<SceneExtractItemDocTypeRelevancyMapper, SceneExtractItemDocTypeRelevancyPo>
implements SceneExtractItemDocTypeRelevancyService {
    private static final Logger log = LoggerFactory.getLogger(SceneExtractItemDocTypeRelevancyServiceImpl.class);
    @Autowired
    private SceneExtractItemDocTypeRelevancyMapper sceneExtractItemDocTypeRelevancyMapper;

    @Override
    public List<SceneExtractItemDocTypeRelevancyPo> getBySceneIdAndExtractItemId(long sceneId, long extractItemId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"extract_item_id", (Object)extractItemId);
        queryWrapper.eq((Object)"scene_id", (Object)sceneId);
        return ((SceneExtractItemDocTypeRelevancyMapper)this.baseMapper).selectList((Wrapper)queryWrapper);
    }

    @Override
    public List<SceneExtractItemDocTypeRelevancyPo> getBySceneId(long sceneId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"scene_id", (Object)sceneId);
        queryWrapper.eq((Object)"delete_flag", (Object)0);
        return ((SceneExtractItemDocTypeRelevancyMapper)this.baseMapper).selectList((Wrapper)queryWrapper);
    }

    @Override
    public List<SceneExtractItemDocTypeRelevancyPo> findByDocTypeId(long docTypeId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"doc_type_id", (Object)docTypeId);
        return ((SceneExtractItemDocTypeRelevancyMapper)this.baseMapper).selectList((Wrapper)queryWrapper);
    }

    @Override
    public List<SceneExtractItemDocTypeRelevancyPo> findAllBySceneId(long sceneId) {
        return this.sceneExtractItemDocTypeRelevancyMapper.findAllBySceneId(sceneId);
    }

    @Override
    public List<SceneExtractItemDocTypeRelevancyPo> findAllByCondition(SceneExtractItemDocTypeRelevancyPo sceneExtractItemDocTypeRelevancyPo) {
        return this.sceneExtractItemDocTypeRelevancyMapper.findAllByCondition(sceneExtractItemDocTypeRelevancyPo);
    }

    @Override
    public List<SceneExtractItemDocTypeRelevancyPo> findByExtractItemId(long extractItemId) {
        return this.sceneExtractItemDocTypeRelevancyMapper.findByExtractItemId(extractItemId);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBySceneIdAndExtractItemId(long sceneId, long extractItemId) {
        this.sceneExtractItemDocTypeRelevancyMapper.deleteBySceneIdAndExtractItemId(sceneId, extractItemId);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void delete(long sceneId) {
        this.sceneExtractItemDocTypeRelevancyMapper.deleteBySceneId(sceneId);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void delete(long sceneId, List<Long> templateIdList) {
        if (!ObjectUtils.isEmpty(templateIdList)) {
            this.sceneExtractItemDocTypeRelevancyMapper.deleteBySceneIdAndTemplateId(sceneId, templateIdList);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteByDocTypeId(long docTypeId) {
        this.sceneExtractItemDocTypeRelevancyMapper.deleteByDocTypeId(docTypeId);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void add(SceneExtractItemDocTypeRelevancyPo po) {
        this.sceneExtractItemDocTypeRelevancyMapper.insert(po);
    }

    @Override
    public void deleteById(List<Long> idList) {
        if (!ObjectUtils.isEmpty(idList)) {
            this.sceneExtractItemDocTypeRelevancyMapper.deleteByBusinessId(idList);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteByExtractItemId(long extractItemId) {
        this.sceneExtractItemDocTypeRelevancyMapper.deleteByExtractItemId(extractItemId);
    }

    @Override
    public void saveOrUpdateBatchSence(List<SceneExtractItemDocTypeRelevancyPo> ruleExtractItemDocTypeRelevancyPoList) {
        if (CollUtil.isNotEmpty(ruleExtractItemDocTypeRelevancyPoList)) {
            List<Long> sceneIds = ruleExtractItemDocTypeRelevancyPoList.stream().map(SceneExtractItemDocTypeRelevancyPo::getSceneId).collect(Collectors.toList());
            this.sceneExtractItemDocTypeRelevancyMapper.deleteBySceneIds(sceneIds);
            this.saveBatch(ruleExtractItemDocTypeRelevancyPoList);
            log.debug("\u6210\u529f\u66f4\u65b0\u5ba1\u67e5\u5e94\u7528-\u5ba1\u67e5\u9879-\u63d0\u53d6\u9879-\u6587\u6863\u7c7b\u578b\u6570\u636e{}\u6761", (Object)ruleExtractItemDocTypeRelevancyPoList.size());
        }
    }

    @Override
    public void removeItem(Long ruleItemId) {
        this.sceneExtractItemDocTypeRelevancyMapper.deleteSceneExtractItemDocType(ruleItemId);
    }
}

