/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.scene.server.service.impl;

import cn.hutool.core.collection.CollUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.idp.dm.server.doctypes.service.impl.DocTypeServiceImpl;
import com.jxdinfo.idp.scene.api.dto.SceneDocTypeSaveDto;
import com.jxdinfo.idp.scene.api.po.SceneDocTypeRelevancyPo;
import com.jxdinfo.idp.scene.server.mapper.SceneDocTypeRelevancyMapper;
import com.jxdinfo.idp.scene.server.service.SceneDocTypeRelevancyService;
import com.jxdinfo.idp.vo.DocTypeVo;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Service
public class SceneDocTypeRelevancyServiceImpl
extends ServiceImpl<SceneDocTypeRelevancyMapper, SceneDocTypeRelevancyPo>
implements SceneDocTypeRelevancyService {
    private static final Logger log = LoggerFactory.getLogger(SceneDocTypeRelevancyServiceImpl.class);
    @Autowired
    private DocTypeServiceImpl docTypeService;
    @Autowired
    private SceneDocTypeRelevancyMapper sceneDocTypeRelevancyMapper;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void insertOrUpdate(SceneDocTypeSaveDto sceneDocTypeSaveDto) {
        Long sceneId = sceneDocTypeSaveDto.getSceneId();
        List nodeTypeDtoList = sceneDocTypeSaveDto.getNodeTypeDtoList();
        if (nodeTypeDtoList == null || nodeTypeDtoList.isEmpty()) {
            return;
        }
        List<SceneDocTypeRelevancyPo> sceneDocTypeRelevancyPoList = this.findBySceneId(sceneId);
        List delIds = sceneDocTypeRelevancyPoList.stream().filter(po -> nodeTypeDtoList.stream().noneMatch(nodeTypeDto -> nodeTypeDto.getId().equals(po.getDocTypeId()))).map(SceneDocTypeRelevancyPo::getId).collect(Collectors.toList());
        ArrayList docTypeList = new ArrayList();
        nodeTypeDtoList.forEach(docType -> {
            SceneDocTypeRelevancyPo entity = new SceneDocTypeRelevancyPo();
            entity.setDocTypeId(docType.getId().longValue());
            entity.setSceneId(sceneId.longValue());
            entity.setEnabled(docType.getEnabled());
            entity.setOcrGlobalParam(docType.getOcrGlobalParam());
            docTypeList.add(entity);
        });
        List docTypeInsert = docTypeList.stream().filter(docType -> sceneDocTypeRelevancyPoList.stream().noneMatch(po -> Objects.equals(po.getDocTypeId(), docType.getDocTypeId()))).collect(Collectors.toList());
        List docTypeUpdate = docTypeList.stream().filter(docType -> {
            SceneDocTypeRelevancyPo relevancyPo = sceneDocTypeRelevancyPoList.stream().filter(po -> Objects.equals(po.getDocTypeId(), docType.getDocTypeId())).findFirst().orElse(null);
            if (relevancyPo != null) {
                docType.setId(relevancyPo.getId());
            }
            return relevancyPo != null;
        }).collect(Collectors.toList());
        if (CollUtil.isNotEmpty(delIds)) {
            this.removeByIds(delIds);
        }
        if (CollUtil.isNotEmpty(docTypeInsert)) {
            this.saveBatch(docTypeInsert);
        }
        if (CollUtil.isNotEmpty(docTypeUpdate)) {
            this.updateBatchById(docTypeUpdate);
        }
    }

    @Override
    public List<SceneDocTypeRelevancyPo> findBySceneId(long sceneId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"scene_id", (Object)sceneId);
        return ((SceneDocTypeRelevancyMapper)this.baseMapper).selectList((Wrapper)queryWrapper);
    }

    @Override
    public List<DocTypeVo> findDocTypesBySceneId(long sceneId) {
        return this.sceneDocTypeRelevancyMapper.findDocTypesBySceneId(sceneId);
    }

    @Override
    public List<DocTypeVo> getDocTypeObjectList(long sceneId) {
        List<SceneDocTypeRelevancyPo> sceneDocTypeRelevancyPoList = this.findBySceneId(sceneId);
        ArrayList<DocTypeVo> docTypeVoList = new ArrayList<DocTypeVo>();
        List docTypeVos = this.docTypeService.getDocTypeList();
        block0: for (SceneDocTypeRelevancyPo po : sceneDocTypeRelevancyPoList) {
            for (DocTypeVo docTypeVo : docTypeVos) {
                if (!String.valueOf(po.getDocTypeId()).equals(String.valueOf(docTypeVo.getId()))) continue;
                if (docTypeVoList.contains(docTypeVo)) continue block0;
                docTypeVo.setEnabled(po.getEnabled());
                docTypeVo.setOcrGlobalParam(po.getOcrGlobalParam());
                docTypeVoList.add(docTypeVo);
                continue block0;
            }
        }
        return docTypeVoList;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBySceneIdAndDocTypeId(long sceneId, List<Long> docTypeIdList) {
        if (!ObjectUtils.isEmpty(docTypeIdList)) {
            this.sceneDocTypeRelevancyMapper.deleteBySceneIdAndDocTypeIdList(sceneId, docTypeIdList);
        }
    }

    @Override
    public void delete(long sceneId, List<Long> templateIdList) {
        if (!ObjectUtils.isEmpty(templateIdList)) {
            this.sceneDocTypeRelevancyMapper.delete(sceneId, templateIdList);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteByTemplateId(long sceneId, List<Long> templateIdList) {
        if (!ObjectUtils.isEmpty(templateIdList)) {
            this.sceneDocTypeRelevancyMapper.delete(sceneId, templateIdList);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBySceneId(long sceneId) {
        this.sceneDocTypeRelevancyMapper.deleteBySceneId(sceneId);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteByDocTypeId(long docTypeId) {
        this.sceneDocTypeRelevancyMapper.deleteByDocTypeId(docTypeId);
    }

    @Override
    public List<SceneDocTypeRelevancyPo> findByDocTypeId(long docTypeId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"doc_type_id", (Object)docTypeId);
        return ((SceneDocTypeRelevancyMapper)this.baseMapper).selectList((Wrapper)queryWrapper);
    }

    @Override
    public void saveOrUpdateBatchSence(List<SceneDocTypeRelevancyPo> docTypeList) {
        if (CollUtil.isNotEmpty(docTypeList)) {
            List<Long> sceneIds = docTypeList.stream().map(SceneDocTypeRelevancyPo::getSceneId).collect(Collectors.toList());
            this.sceneDocTypeRelevancyMapper.deleteBySceneIds(sceneIds);
            this.saveBatch(docTypeList);
            log.debug("\u6210\u529f\u66f4\u65b0\u5ba1\u67e5\u5e94\u7528-\u6587\u6863\u7c7b\u578b\u6570\u636e{}\u6761", (Object)docTypeList.size());
        }
    }
}

