/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.scene.server.service.impl;

import cn.hutool.core.collection.CollUtil;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.idp.common.util.SnowFlakeUtil;
import com.jxdinfo.idp.scene.api.po.SceneRuleReviewItemRelevancyPo;
import com.jxdinfo.idp.scene.server.mapper.SceneRuleReviewItemRelevancyMapper;
import com.jxdinfo.idp.scene.server.service.SceneRuleReviewItemRelevancyService;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Service
public class SceneRuleReviewItemRelevancyServiceImpl
extends ServiceImpl<SceneRuleReviewItemRelevancyMapper, SceneRuleReviewItemRelevancyPo>
implements SceneRuleReviewItemRelevancyService {
    private static final Logger log = LoggerFactory.getLogger(SceneRuleReviewItemRelevancyServiceImpl.class);
    @Resource
    private SceneRuleReviewItemRelevancyMapper sceneRuleReviewItemRelevancyMapper;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void add(SceneRuleReviewItemRelevancyPo obj) {
        obj.setId(SnowFlakeUtil.getFlowIdInstance().nextId());
        this.sceneRuleReviewItemRelevancyMapper.insert(obj);
    }

    @Override
    public List<SceneRuleReviewItemRelevancyPo> findAllBySceneId(long sceneId) {
        return this.sceneRuleReviewItemRelevancyMapper.findAllBySceneId(sceneId);
    }

    @Override
    public List<SceneRuleReviewItemRelevancyPo> findAllByRuleLibId(long ruleLibId) {
        return this.sceneRuleReviewItemRelevancyMapper.findAllByRuleLibId(ruleLibId);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void delete(long sceneId) {
        this.sceneRuleReviewItemRelevancyMapper.deleteBySceneId(sceneId);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void delete(long sceneId, List<Long> templateIdList) {
        if (!ObjectUtils.isEmpty(templateIdList)) {
            this.sceneRuleReviewItemRelevancyMapper.deleteBySceneIdAndTemplateId(sceneId, templateIdList);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void delete(long sceneId, long ruleLibId, List<Long> ruleItemIdList) {
        if (!ObjectUtils.isEmpty(ruleItemIdList)) {
            this.sceneRuleReviewItemRelevancyMapper.delete(sceneId, ruleLibId, ruleItemIdList);
        }
    }

    @Override
    public void saveOrUpdateBatchSence(List<SceneRuleReviewItemRelevancyPo> ruleReviewItemList) {
        if (CollUtil.isNotEmpty(ruleReviewItemList)) {
            List<Long> sceneIds = ruleReviewItemList.stream().map(SceneRuleReviewItemRelevancyPo::getSceneId).collect(Collectors.toList());
            this.sceneRuleReviewItemRelevancyMapper.deleteBySceneIds(sceneIds);
            this.saveBatch(ruleReviewItemList);
            log.debug("\u6210\u529f\u66f4\u65b0\u5ba1\u67e5\u5e94\u7528-\u89c4\u5219\u5e93-\u5ba1\u67e5\u9879\u6570\u636e{}\u6761", (Object)ruleReviewItemList.size());
        }
    }

    @Override
    public void removeItem(Long ruleItemId) {
        this.sceneRuleReviewItemRelevancyMapper.deleteSceneRuleReviewItem(ruleItemId);
    }
}

