/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.scene.server.service.impl;

import cn.hutool.core.collection.CollUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.idp.common.base.dto.AuditInfoDto;
import com.jxdinfo.idp.common.base.dto.LogicDeleteAuditInfoDto;
import com.jxdinfo.idp.common.counter.service.ICounterService;
import com.jxdinfo.idp.common.entity.Counter;
import com.jxdinfo.idp.common.entity.dto.DocClassTree;
import com.jxdinfo.idp.common.exception.BusinessException;
import com.jxdinfo.idp.common.service.IStyleModuleReview;
import com.jxdinfo.idp.common.util.SerializeUtils;
import com.jxdinfo.idp.common.util.SnowFlakeUtil;
import com.jxdinfo.idp.common.util.StringUtils;
import com.jxdinfo.idp.common.util.user.UserUtils;
import com.jxdinfo.idp.dm.server.docmgmt.service.impl.DocInfoServiceImpl;
import com.jxdinfo.idp.dto.DocTypeExportDto;
import com.jxdinfo.idp.dto.NodeTypeDto;
import com.jxdinfo.idp.extract.domain.dto.ExtractExportDto;
import com.jxdinfo.idp.extract.domain.po.ExtractItem;
import com.jxdinfo.idp.extract.domain.query.ExtractItemQuery;
import com.jxdinfo.idp.extract.interf.IExtractCore;
import com.jxdinfo.idp.extract.mapper.ExtractItemMapper;
import com.jxdinfo.idp.interf.DocTypeService;
import com.jxdinfo.idp.interf.NodeTypeFoldService;
import com.jxdinfo.idp.interf.NodeTypeRelevancyService;
import com.jxdinfo.idp.po.NodeTypePo;
import com.jxdinfo.idp.rule.api.service.IRuleService;
import com.jxdinfo.idp.rule.api.vo.RuleItemGroupQueryVo;
import com.jxdinfo.idp.rule.api.vo.RuleItemQueryVo;
import com.jxdinfo.idp.rule.api.vo.RuleItemVo;
import com.jxdinfo.idp.rule.api.vo.RuleLibQueryVo;
import com.jxdinfo.idp.rule.api.vo.RuleLibVo;
import com.jxdinfo.idp.rule.server.dto.RuleExportDto;
import com.jxdinfo.idp.scene.api.dto.GroupSceneDto;
import com.jxdinfo.idp.scene.api.dto.QueryRuleLibDto;
import com.jxdinfo.idp.scene.api.dto.SceneConfigResult;
import com.jxdinfo.idp.scene.api.dto.SceneDto;
import com.jxdinfo.idp.scene.api.dto.SceneDtoNew;
import com.jxdinfo.idp.scene.api.dto.SceneRuleLibDto;
import com.jxdinfo.idp.scene.api.po.SceneDocTypeRelevancyPo;
import com.jxdinfo.idp.scene.api.po.SceneExtractItemDocTypeRelevancyPo;
import com.jxdinfo.idp.scene.api.po.SceneGroupPo;
import com.jxdinfo.idp.scene.api.po.ScenePo;
import com.jxdinfo.idp.scene.api.po.SceneRuleExtractRelevancyPo;
import com.jxdinfo.idp.scene.api.po.SceneRuleItemDocTypeRelevancyPo;
import com.jxdinfo.idp.scene.api.po.SceneRuleLibRelevancyPo;
import com.jxdinfo.idp.scene.api.po.SceneRuleReviewItemRelevancyPo;
import com.jxdinfo.idp.scene.api.po.SceneStyleRuleDocTypeRelevancyPo;
import com.jxdinfo.idp.scene.api.query.SceneGroupQuery;
import com.jxdinfo.idp.scene.api.query.SceneQuery;
import com.jxdinfo.idp.scene.api.vo.ScenePageVo;
import com.jxdinfo.idp.scene.dto.ExtractItemObject;
import com.jxdinfo.idp.scene.dto.RuleItemObject;
import com.jxdinfo.idp.scene.server.entity.SceneExportDto;
import com.jxdinfo.idp.scene.server.mapper.SceneDocTypeRelevancyMapper;
import com.jxdinfo.idp.scene.server.mapper.SceneMapper;
import com.jxdinfo.idp.scene.server.mapper.SceneRuleReviewItemRelevancyMapper;
import com.jxdinfo.idp.scene.server.mapper.SceneTemplateRelevancyMapper;
import com.jxdinfo.idp.scene.server.service.SceneDocTypeRelevancyService;
import com.jxdinfo.idp.scene.server.service.SceneExtractItemDocTypeRelevancyService;
import com.jxdinfo.idp.scene.server.service.SceneGroupService;
import com.jxdinfo.idp.scene.server.service.SceneRuleExtractRelevancyService;
import com.jxdinfo.idp.scene.server.service.SceneRuleItemDocTypeRelevancyService;
import com.jxdinfo.idp.scene.server.service.SceneRuleLibRelevancyService;
import com.jxdinfo.idp.scene.server.service.SceneRuleReviewItemRelevancyService;
import com.jxdinfo.idp.scene.server.service.SceneService;
import com.jxdinfo.idp.scene.server.service.SceneStyleRuleDocTypeRelevancyService;
import com.jxdinfo.idp.scene.server.service.SceneTemplateRelevancyService;
import com.jxdinfo.idp.vo.DocTypeVo;
import com.jxdinfo.usehub.service.UseHubTaskService;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Service
public class SceneServiceImpl
extends ServiceImpl<SceneMapper, ScenePo>
implements SceneService {
    private static final Logger log = LoggerFactory.getLogger(SceneServiceImpl.class);
    @Autowired
    private SceneMapper sceneMapper;
    @Autowired
    private IRuleService ruleService;
    @Autowired
    private SceneRuleLibRelevancyService sceneRuleLibRelevancyService;
    @Autowired
    private SceneRuleReviewItemRelevancyService sceneRuleReviewItemRelevancyService;
    @Autowired
    private SceneRuleExtractRelevancyService sceneRuleExtractRelevancyService;
    @Autowired
    private SceneExtractItemDocTypeRelevancyService sceneExtractItemDocTypeRelevancyService;
    @Autowired
    private DocInfoServiceImpl docService;
    @Autowired
    private IExtractCore extractCoreService;
    @Autowired
    private SceneTemplateRelevancyService sceneTemplateRelevancyService;
    @Resource
    private NodeTypeRelevancyService nodeTypeRelevancyService;
    @Autowired
    private SceneDocTypeRelevancyService sceneDocTypeRelevancyService;
    @Autowired
    private SceneRuleItemDocTypeRelevancyService sceneRuleItemDocTypeRelevancyService;
    @Autowired
    private DocTypeService docTypeService;
    @Autowired
    private SceneGroupService sceneGroupService;
    @Autowired
    private SceneDocTypeRelevancyMapper sceneDocTypeRelevancyMapper;
    @Autowired
    private SceneRuleReviewItemRelevancyMapper sceneRuleReviewItemRelevancyMapper;
    @Autowired
    private SceneTemplateRelevancyMapper sceneTemplateRelevancyMapper;
    @Autowired
    private NodeTypeFoldService nodeTypeFoldService;
    @Autowired
    private ICounterService iCounterService;
    @Autowired
    private IRuleService iIRuleService;
    @Resource
    private ExtractItemMapper iExtractItemMapper;
    @Resource
    private UseHubTaskService useHubTaskService;
    @Autowired
    private SceneStyleRuleDocTypeRelevancyService sceneStyleRuleDocTypeRelevancyService;
    @Autowired(required=false)
    private IStyleModuleReview styleModuleReview;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateScene(ScenePo scenePo) {
        scenePo.setCreateTime(LocalDateTime.now());
        this.sceneMapper.update(scenePo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void insert(ScenePo scenePo) {
        scenePo.setDeleteFlag(Integer.valueOf(0));
        this.sceneMapper.insert(scenePo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteById(long sceneId) {
        ScenePo scenePo = (ScenePo)this.sceneMapper.selectById(Long.valueOf(sceneId));
        if (ObjectUtils.isEmpty((Object)scenePo)) {
            return;
        }
        this.sceneExtractItemDocTypeRelevancyService.delete(sceneId);
        this.sceneRuleExtractRelevancyService.delete(sceneId);
        this.sceneRuleReviewItemRelevancyService.delete(sceneId);
        this.sceneRuleLibRelevancyService.delete(sceneId);
        this.sceneRuleItemDocTypeRelevancyService.deleteBySceneId(sceneId);
        this.sceneDocTypeRelevancyService.deleteBySceneId(sceneId);
        if (Objects.equals(scenePo.getType(), 0)) {
            this.sceneTemplateRelevancyService.deleteBySceneId(sceneId);
        }
        this.sceneMapper.deleteById(sceneId);
        this.useHubTaskService.deleteCensorSceneId(Long.valueOf(sceneId));
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"rel_id", (Object)sceneId);
        List result = this.iCounterService.list((Wrapper)wrapper);
        if (result != null && !result.isEmpty()) {
            ArrayList<Long> ids = new ArrayList<Long>();
            for (Counter counter : result) {
                ids.add(counter.getId());
            }
            this.iCounterService.removeByIds(ids);
        }
    }

    @Override
    public ScenePo findById(long sceneId) {
        return (ScenePo)((SceneMapper)this.baseMapper).selectById(Long.valueOf(sceneId));
    }

    @Override
    public Page<SceneRuleLibDto> getSceneList(ScenePageVo pageQueryVo) {
        ArrayList<SceneRuleLibDto> sceneRuleLibDtoList = new ArrayList<SceneRuleLibDto>();
        Page page = new Page((long)pageQueryVo.getCurrent(), (long)pageQueryVo.getSize());
        Page page2 = new Page((long)pageQueryVo.getCurrent(), (long)pageQueryVo.getSize());
        QueryWrapper queryWrapper = new QueryWrapper();
        if (pageQueryVo.getName() != null && !pageQueryVo.getName().isEmpty()) {
            queryWrapper.like((Object)"name", (Object)pageQueryVo.getName());
        }
        page = (Page)this.sceneMapper.selectPage((IPage)page, (Wrapper)queryWrapper);
        List scenePoList = page.getRecords();
        for (ScenePo scenePo : scenePoList) {
            SceneRuleLibDto sceneRuleLibDto = new SceneRuleLibDto();
            sceneRuleLibDto.setSceneId(scenePo.getId());
            sceneRuleLibDto.setSceneName(scenePo.getName());
            sceneRuleLibDto.setCreator(scenePo.getCreator());
            sceneRuleLibDto.setRemark(scenePo.getRemark());
            sceneRuleLibDto.setGroupId(scenePo.getGroupId());
            sceneRuleLibDto.setCreateTime(scenePo.getCreateTime());
            sceneRuleLibDtoList.add(sceneRuleLibDto);
        }
        List scenePoTotalList = this.sceneMapper.selectList((Wrapper)queryWrapper);
        page2.setTotal((long)scenePoTotalList.size());
        page2.setRecords(sceneRuleLibDtoList);
        return page2;
    }

    @Override
    public List<ScenePo> getList(SceneQuery query) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        LocalDateTime startTime = null;
        LocalDateTime endTime = null;
        if (query.getStartCreateTime() != null) {
            startTime = query.getStartCreateTime().atStartOfDay();
        }
        if (query.getEndCreateTime() != null) {
            endTime = query.getEndCreateTime().atTime(LocalTime.MAX);
        }
        wrapper.eq(LogicDeleteAuditInfoDto::getDeleteFlag, (Object)0);
        wrapper.like(StringUtils.isNotEmpty((String)query.getSceneName()), ScenePo::getName, (Object)query.getSceneName());
        wrapper.eq(StringUtils.isNotEmpty((String)query.getCreator()), AuditInfoDto::getCreator, (Object)query.getCreator());
        wrapper.between(startTime != null && endTime != null, AuditInfoDto::getCreateTime, (Object)startTime, (Object)endTime);
        wrapper.orderByDesc(AuditInfoDto::getCreateTime);
        return this.list((Wrapper)wrapper);
    }

    @Override
    public List<GroupSceneDto> getSceneGroupAndList(SceneDto sceneDtoParam) {
        ArrayList<GroupSceneDto> groupSceneDtoList = new ArrayList<GroupSceneDto>();
        List<ScenePo> scenePoList = this.search(sceneDtoParam.getName(), null, null);
        List<SceneGroupPo> sceneGroupPoList = this.sceneGroupService.getSceneGroupList();
        for (ScenePo scenePo : scenePoList) {
            SceneDto sceneDto = new SceneDto(scenePo);
            Optional<SceneGroupPo> sceneGroupPoOptional = sceneGroupPoList.stream().filter(groupPo -> Objects.equals(groupPo.getId(), scenePo.getGroupId())).findFirst();
            if (groupSceneDtoList.stream().noneMatch(dto -> Objects.equals(dto.getGroupId(), scenePo.getGroupId())) && sceneGroupPoOptional.isPresent()) {
                GroupSceneDto groupSceneDto = new GroupSceneDto(scenePo.getGroupId(), sceneGroupPoOptional.get().getName(), sceneGroupPoOptional.get().getDescription(), sceneDto, sceneGroupPoOptional.get().getCreateTime(), sceneGroupPoOptional.get().getCreator());
                groupSceneDtoList.add(groupSceneDto);
                continue;
            }
            groupSceneDtoList.forEach(dto -> {
                if (dto.getGroupId() == scenePo.getGroupId()) {
                    dto.getSceneList().add(sceneDto);
                }
            });
        }
        return groupSceneDtoList;
    }

    @Override
    public SceneDtoNew getSceneDto(Long id) {
        SceneDtoNew dtoNew = new SceneDtoNew();
        ScenePo scenePo = (ScenePo)this.getById(id);
        BeanUtils.copyProperties((Object)scenePo, (Object)dtoNew);
        List<SceneExtractItemDocTypeRelevancyPo> ruleExtractDocTypeList = this.sceneExtractItemDocTypeRelevancyService.getBySceneId(id);
        dtoNew.setRuleExtractDocTypeList(ruleExtractDocTypeList);
        return dtoNew;
    }

    @Override
    public List<GroupSceneDto> getSceneList() {
        List<SceneGroupPo> sceneGroupPoList = this.sceneGroupService.getSceneGroupList();
        ArrayList<GroupSceneDto> groupSceneDtoList = new ArrayList<GroupSceneDto>();
        for (SceneGroupPo sceneGroupPo : sceneGroupPoList) {
            List<ScenePo> scenePoList = this.sceneMapper.getSceneListByGroupId(sceneGroupPo.getId());
            ArrayList<SceneDto> sceneDtos = new ArrayList<SceneDto>();
            for (ScenePo scenePo : scenePoList) {
                SceneDto sceneDto = new SceneDto(scenePo);
                int docTypeCount = this.sceneDocTypeRelevancyMapper.getCountBySceneId(scenePo.getId());
                sceneDto.setDocTypeCount(docTypeCount);
                int ruleItemCount = this.sceneRuleReviewItemRelevancyMapper.getCountBySceneId(scenePo.getId());
                sceneDto.setRuleItemCount(ruleItemCount);
                int templateCount = this.sceneTemplateRelevancyMapper.getCountBySceneId(scenePo.getId());
                sceneDto.setTemplateCount(templateCount);
                sceneDtos.add(sceneDto);
            }
            GroupSceneDto groupSceneDto = new GroupSceneDto(sceneGroupPo, sceneDtos);
            groupSceneDtoList.add(groupSceneDto);
        }
        return groupSceneDtoList;
    }

    @Override
    public SceneDto getScene(long sceneId) {
        ScenePo scenePo = (ScenePo)this.sceneMapper.selectById(Long.valueOf(sceneId));
        SceneDto sceneDto = new SceneDto(scenePo);
        int docTypeCount = this.sceneDocTypeRelevancyMapper.getCountBySceneId(scenePo.getId());
        sceneDto.setDocTypeCount(docTypeCount);
        int ruleItemCount = this.sceneRuleReviewItemRelevancyMapper.getCountBySceneId(scenePo.getId());
        sceneDto.setRuleItemCount(ruleItemCount);
        int templateCount = this.sceneTemplateRelevancyMapper.getCountBySceneId(scenePo.getId());
        sceneDto.setTemplateCount(templateCount);
        return sceneDto;
    }

    @Override
    public List<GroupSceneDto> search2(SceneQuery query) {
        List<ScenePo> scenePoList = this.getList(query);
        ArrayList<GroupSceneDto> groupSceneDtoList = new ArrayList<GroupSceneDto>();
        List<SceneGroupPo> sceneGroupPoList = this.sceneGroupService.getList(new SceneGroupQuery(query.getCreator()));
        HashMap<Long, List> groupSceneMap = new HashMap<Long, List>();
        for (ScenePo scenePo : scenePoList) {
            SceneDto sceneDto = new SceneDto(scenePo);
            int docTypeCount = this.sceneDocTypeRelevancyMapper.getCountBySceneId(scenePo.getId());
            sceneDto.setDocTypeCount(docTypeCount);
            int ruleItemCount = this.sceneRuleReviewItemRelevancyMapper.getCountBySceneId(scenePo.getId());
            sceneDto.setRuleItemCount(ruleItemCount);
            int templateCount = this.sceneTemplateRelevancyMapper.getCountBySceneId(scenePo.getId());
            sceneDto.setTemplateCount(templateCount);
            List sceneDtos = groupSceneMap.computeIfAbsent(sceneDto.getGroupId(), k -> new ArrayList());
            sceneDtos.add(sceneDto);
        }
        for (SceneGroupPo sceneGroupPo : sceneGroupPoList) {
            GroupSceneDto groupSceneDto = new GroupSceneDto(sceneGroupPo, (List)groupSceneMap.get(sceneGroupPo.getId()));
            groupSceneDtoList.add(groupSceneDto);
        }
        return groupSceneDtoList;
    }

    private LocalDateTime getDateTime(String dateString) {
        if (!dateString.isEmpty()) {
            dateString = dateString.replace("-", "");
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMddHHmmss");
            return LocalDateTime.parse(dateString, formatter);
        }
        return null;
    }

    @Override
    @Deprecated
    public List<ScenePo> search(String sceneName, String startCreateTime, String endCreateTime) {
        if (sceneName == null && startCreateTime == null && endCreateTime == null) {
            return null;
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        if (sceneName != null && !sceneName.isEmpty()) {
            queryWrapper.like((Object)"NAME", (Object)sceneName);
        }
        if (startCreateTime != null && !startCreateTime.isEmpty()) {
            queryWrapper.ge((Object)"CREATE_TIME", (Object)this.getDateTime(startCreateTime + "000000"));
        }
        if (endCreateTime != null && !endCreateTime.isEmpty()) {
            queryWrapper.le((Object)"CREATE_TIME", (Object)this.getDateTime(endCreateTime + "235959"));
        }
        queryWrapper.orderByDesc((Object)"CREATE_TIME");
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public Map<String, Object> getDocTypeData(Long sceneId) {
        List<DocTypeVo> docTypeVoList = this.sceneDocTypeRelevancyService.getDocTypeObjectList(sceneId);
        List nodeTypePoList = this.nodeTypeFoldService.findAll();
        ArrayList<NodeTypeDto> chosenDocTypeVoList = new ArrayList<NodeTypeDto>();
        for (DocTypeVo docTypeVo : docTypeVoList) {
            NodeTypeDto nodeTypeDto = new NodeTypeDto(docTypeVo);
            nodeTypeDto.setEnabled(docTypeVo.getEnabled());
            Optional<NodeTypePo> nodeTypePoOptional = nodeTypePoList.stream().filter(nodeTypePo -> Objects.equals(nodeTypePo.getId(), docTypeVo.getPid())).findFirst();
            nodeTypePoOptional.ifPresent(nodeTypePo -> nodeTypeDto.setCatalog(nodeTypePo.getName()));
            nodeTypeDto.setChosen(true);
            nodeTypeDto.setOcrGlobalParam(docTypeVo.getOcrGlobalParam());
            chosenDocTypeVoList.add(nodeTypeDto);
        }
        List nodeTypePoListTree = this.nodeTypeRelevancyService.queryTypeNodeTree(null);
        HashMap<String, Object> nodeTypeDataMap = new HashMap<String, Object>();
        nodeTypeDataMap.put("chosenDocTypeVoList", chosenDocTypeVoList);
        nodeTypeDataMap.put("nodeTypePoListTree", nodeTypePoListTree);
        return nodeTypeDataMap;
    }

    @Override
    public List<RuleLibVo> queryRuleLib(Long sceneId) {
        RuleLibQueryVo queryVo = new RuleLibQueryVo();
        queryVo.setSize(999);
        queryVo.setCurrent(1);
        queryVo.setPid(Long.valueOf(1L));
        queryVo.setChildCount(Integer.valueOf(1));
        queryVo.setQueryFlag(1);
        List ruleLibVoList = this.ruleService.queryRuleLibTree(queryVo);
        SceneRuleLibRelevancyPo po = new SceneRuleLibRelevancyPo();
        po.setSceneId(sceneId.longValue());
        po.setSourceCode("1");
        List<SceneRuleLibRelevancyPo> sceneRuleLibRelevancyPoList = this.sceneRuleLibRelevancyService.findAllByParam(po);
        List chonseRuleLibIdList = sceneRuleLibRelevancyPoList.stream().map(SceneRuleLibRelevancyPo::getRuleLibId).collect(Collectors.toList());
        for (RuleLibVo ruleLibVo : ruleLibVoList) {
            if (ruleLibVo.getChildren() == null) continue;
            ruleLibVo.getChildren().forEach(item -> {
                if (item.getChildren() != null) {
                    item.setChildren(null);
                }
                if (chonseRuleLibIdList.contains(item.getId())) {
                    item.setChosen(true);
                }
            });
        }
        return ruleLibVoList;
    }

    @Override
    public List<DocClassTree> queryStyleRuleLib(Long sceneId) {
        if (this.styleModuleReview != null) {
            List ruleLibVoList = this.styleModuleReview.getAllTotalTree();
            SceneRuleLibRelevancyPo po = new SceneRuleLibRelevancyPo();
            po.setSceneId(sceneId.longValue());
            po.setSourceCode("2");
            List<SceneRuleLibRelevancyPo> sceneRuleLibRelevancyPoList = this.sceneRuleLibRelevancyService.findAllByParam(po);
            List chonseRuleLibIdList = sceneRuleLibRelevancyPoList.stream().map(SceneRuleLibRelevancyPo::getRuleLibId).collect(Collectors.toList());
            for (DocClassTree tree : ruleLibVoList) {
                if (tree.getChildren() == null) continue;
                tree.getChildren().forEach(item -> {
                    if (item.getChildren() != null) {
                        item.setChildren(null);
                    }
                    if (chonseRuleLibIdList.contains(item.getId())) {
                        item.setChosen(true);
                    }
                });
            }
            return ruleLibVoList;
        }
        return new ArrayList<DocClassTree>();
    }

    @Override
    public List<RuleLibVo> queryRuleLibTree(int level) {
        RuleLibQueryVo queryVo = new RuleLibQueryVo();
        queryVo.setSize(999);
        queryVo.setCurrent(1);
        queryVo.setPid(Long.valueOf(1L));
        queryVo.setChildCount(Integer.valueOf(1));
        queryVo.setQueryFlag(1);
        List ruleLibVoList = this.ruleService.queryRuleLibTree(queryVo);
        if (level == 2) {
            for (RuleLibVo ruleLibVo : ruleLibVoList) {
                if (ruleLibVo.getChildren() == null) continue;
                ruleLibVo.getChildren().forEach(item -> {
                    if (item.getChildren() != null) {
                        item.setChildren(null);
                    }
                });
            }
        }
        return ruleLibVoList;
    }

    @Override
    public RuleLibVo getRuleLibVo(long ruleLibId) {
        Optional ruleLibVoOptional;
        RuleLibQueryVo ruleLibQueryVo = new RuleLibQueryVo();
        ruleLibQueryVo.setId(Long.valueOf(ruleLibId));
        Page ruleLibVoPage = this.ruleService.queryRuleLib(ruleLibQueryVo);
        if (!ObjectUtils.isEmpty((Object)ruleLibVoPage.getRecords()) && (ruleLibVoOptional = ruleLibVoPage.getRecords().stream().findFirst()).isPresent()) {
            return (RuleLibVo)ruleLibVoOptional.get();
        }
        return null;
    }

    @Override
    public List<RuleLibVo> getRuleLibItemTree(long sceneId) {
        SceneRuleLibRelevancyPo param = new SceneRuleLibRelevancyPo();
        param.setSceneId(sceneId);
        param.setSourceCode("1");
        List<SceneRuleLibRelevancyPo> sceneRuleLibRelevancyPoList = this.sceneRuleLibRelevancyService.findAllByParam(param);
        ArrayList<RuleLibVo> ruleLibVoListAll = new ArrayList<RuleLibVo>();
        for (SceneRuleLibRelevancyPo po : sceneRuleLibRelevancyPoList) {
            RuleItemGroupQueryVo queryVo = new RuleItemGroupQueryVo();
            queryVo.setRuleLibId(Long.valueOf(po.getRuleLibId()));
            List ruleLibVoList = this.ruleService.queryRuleItemGroup(queryVo);
            if (ruleLibVoList.isEmpty()) continue;
            ruleLibVoListAll.addAll(ruleLibVoList);
        }
        return ruleLibVoListAll;
    }

    @Override
    public List<DocClassTree> queryStyleRuleLibItemTree(long sceneId) {
        SceneRuleLibRelevancyPo param = new SceneRuleLibRelevancyPo();
        param.setSceneId(sceneId);
        param.setSourceCode("2");
        List<SceneRuleLibRelevancyPo> sceneRuleLibRelevancyPoList = this.sceneRuleLibRelevancyService.findAllByParam(param);
        List chonseRuleLibIdList = sceneRuleLibRelevancyPoList.stream().map(SceneRuleLibRelevancyPo::getRuleLibId).collect(Collectors.toList());
        List<Object> ruleLibVoList = new ArrayList<DocClassTree>();
        if (chonseRuleLibIdList != null && chonseRuleLibIdList.size() > 0 && this.styleModuleReview != null) {
            ruleLibVoList = this.styleModuleReview.getTotalTreeByIds(chonseRuleLibIdList);
        }
        return ruleLibVoList;
    }

    @Override
    public List<QueryRuleLibDto> getChosenRuleLib(Long sceneId) {
        List<SceneRuleLibRelevancyPo> sceneRuleLibRelevancyPoList = this.sceneRuleLibRelevancyService.findAllBySceneId(sceneId);
        ArrayList<QueryRuleLibDto> queryRuleLibDtoList = new ArrayList<QueryRuleLibDto>();
        for (SceneRuleLibRelevancyPo po : sceneRuleLibRelevancyPoList) {
            RuleLibVo ruleLibPo = this.getRuleLibVo(po.getRuleLibId());
            if (ruleLibPo == null) continue;
            RuleLibQueryVo queryVoTemp = new RuleLibQueryVo();
            queryVoTemp.setPid(Long.valueOf(po.getRuleLibId()));
            List ruleLibVoList = this.ruleService.queryRuleLibTree(queryVoTemp);
            for (RuleLibVo ruleLibVo : ruleLibVoList) {
                if (queryRuleLibDtoList.stream().anyMatch(dto -> dto.getRuleLibId() == ruleLibPo.getId().longValue())) {
                    for (QueryRuleLibDto queryRuleLibDto : queryRuleLibDtoList) {
                        if (queryRuleLibDto.getRuleLibId() != ruleLibPo.getId().longValue()) continue;
                        queryRuleLibDto.getRuleLibVoList().add(ruleLibVo);
                    }
                    continue;
                }
                QueryRuleLibDto queryRuleLibDto = new QueryRuleLibDto(ruleLibVo);
                queryRuleLibDto.setRuleLibId(ruleLibPo.getId().longValue());
                queryRuleLibDto.setRuleLibName(ruleLibPo.getLibName());
                queryRuleLibDtoList.add(queryRuleLibDto);
            }
        }
        return queryRuleLibDtoList;
    }

    @Override
    public List<RuleItemObject> queryRuleItemList(Long sceneId, Long[] ruleLibIdList) {
        ArrayList<RuleItemObject> ruleItemObjectList = new ArrayList<RuleItemObject>();
        RuleItemQueryVo itemQueryVo = new RuleItemQueryVo();
        itemQueryVo.setSize(999);
        itemQueryVo.setCurrent(1);
        itemQueryVo.setEnabled(Integer.valueOf(1));
        itemQueryVo.setRuleLibIds(ruleLibIdList);
        Page ruleItemVoPage = this.ruleService.queryRuleItem(itemQueryVo);
        List<DocTypeVo> docTypeVoList = this.sceneDocTypeRelevancyService.getDocTypeObjectList(sceneId);
        List<SceneExtractItemDocTypeRelevancyPo> sceneItemDocRels = this.sceneExtractItemDocTypeRelevancyService.getBySceneId(sceneId);
        List<SceneRuleReviewItemRelevancyPo> sceneRuleRels = this.sceneRuleReviewItemRelevancyService.findAllBySceneId(sceneId);
        for (RuleItemVo ruleItemVo : ruleItemVoPage.getRecords()) {
            Map codeMap = this.iIRuleService.queryRuleParam(ruleItemVo.getId());
            List extractItems = new ArrayList();
            ArrayList extractItemCodes = new ArrayList(codeMap.keySet());
            if (!extractItemCodes.isEmpty()) {
                ExtractItemQuery queryVo = new ExtractItemQuery();
                queryVo.setItemCodes(extractItemCodes);
                extractItems = this.iExtractItemMapper.getDtoList(queryVo);
            }
            SceneRuleReviewItemRelevancyPo sceneRuleRel = sceneRuleRels.stream().filter(rel -> Objects.equals(rel.getRuleItemId(), ruleItemVo.getId())).findFirst().orElse(null);
            RuleItemObject ruleItemObject = new RuleItemObject(ruleItemVo);
            if (sceneRuleRel != null) {
                ruleItemObject.setEnabled(Integer.valueOf(sceneRuleRel.getEnabled()));
            }
            ArrayList extractItemList = new ArrayList();
            extractItems.forEach(extractItem -> {
                ExtractItemObject extractItemObject = new ExtractItemObject((ExtractItem)extractItem);
                List rels = sceneItemDocRels.stream().filter(docRel -> Objects.equals(extractItem.getId(), docRel.getExtractItemId())).collect(Collectors.toList());
                extractItemObject.setDocTypeIdList(docTypeVoList.stream().filter(docType -> rels.stream().anyMatch(rel -> Objects.equals(docType.getId(), rel.getDocTypeId()))).map(DocTypeVo::getId).collect(Collectors.toList()));
                extractItemObject.setDocTypeVoList(docTypeVoList);
                extractItemList.add(extractItemObject);
            });
            ruleItemObject.setSceneId(sceneId.longValue());
            ruleItemObject.setExtractItemList(extractItemList);
            ruleItemObjectList.add(ruleItemObject);
        }
        return ruleItemObjectList;
    }

    @Override
    public List<RuleItemObject> queryStyleRuleItemList(Long sceneId, Long[] styleRuleLibIdList) {
        ArrayList<RuleItemObject> ruleItemObjectList;
        block7: {
            List<SceneStyleRuleDocTypeRelevancyPo> sceneStyleRuleDocTypeRelevancyPoList;
            block6: {
                ruleItemObjectList = new ArrayList<RuleItemObject>();
                SceneStyleRuleDocTypeRelevancyPo param = new SceneStyleRuleDocTypeRelevancyPo();
                param.setSceneId(sceneId);
                param.setRuleLibIds(styleRuleLibIdList);
                sceneStyleRuleDocTypeRelevancyPoList = this.sceneStyleRuleDocTypeRelevancyService.findAllByParam(param);
                if (!sceneStyleRuleDocTypeRelevancyPoList.isEmpty()) break block6;
                if (this.styleModuleReview == null) break block7;
                for (Long ruleLibId : styleRuleLibIdList) {
                    Map classInfo = this.styleModuleReview.getStyleConfigDocClassInfo(ruleLibId);
                    if (classInfo == null) continue;
                    RuleItemObject ruleItemObject = new RuleItemObject();
                    ruleItemObject.setSceneId(sceneId.longValue());
                    ruleItemObject.setRuleLibId(ruleLibId.longValue());
                    ruleItemObject.setRuleLibName((String)classInfo.get("documentClassName"));
                    ruleItemObject.setDocTypeIdList(new ArrayList());
                    ruleItemObject.setDocTypeVoList(new ArrayList());
                    ruleItemObject.setSourceCode("2");
                    ruleItemObject.setEnabled(Integer.valueOf(1));
                    ruleItemObjectList.add(ruleItemObject);
                }
                break block7;
            }
            List chonseRuleLibIdList = sceneStyleRuleDocTypeRelevancyPoList.stream().map(SceneStyleRuleDocTypeRelevancyPo::getRuleLibId).collect(Collectors.toList());
            if (this.styleModuleReview != null) {
                for (Long ruleLibId : styleRuleLibIdList) {
                    RuleItemObject ruleItemObject;
                    Map classInfo = this.styleModuleReview.getStyleConfigDocClassInfo(ruleLibId);
                    if (classInfo == null) continue;
                    if (chonseRuleLibIdList.contains(ruleLibId)) {
                        ruleItemObject = new RuleItemObject();
                        ruleItemObject.setSceneId(sceneId.longValue());
                        ruleItemObject.setRuleLibId(ruleLibId.longValue());
                        ruleItemObject.setRuleLibName((String)classInfo.get("documentClassName"));
                        List docTypeIdList = sceneStyleRuleDocTypeRelevancyPoList.stream().filter(po -> po.getRuleLibId().equals(ruleLibId)).map(SceneStyleRuleDocTypeRelevancyPo::getDocTypeId).collect(Collectors.toList());
                        ruleItemObject.setDocTypeIdList(docTypeIdList);
                        ruleItemObject.setDocTypeVoList(new ArrayList());
                        ruleItemObject.setSourceCode("2");
                        List filteredList = sceneStyleRuleDocTypeRelevancyPoList.stream().filter(po -> po.getRuleLibId().equals(ruleLibId)).collect(Collectors.toList());
                        if (filteredList != null && filteredList.size() > 0) {
                            ruleItemObject.setEnabled(((SceneStyleRuleDocTypeRelevancyPo)filteredList.get(0)).getEnabled());
                        } else {
                            ruleItemObject.setEnabled(Integer.valueOf(1));
                        }
                        ruleItemObjectList.add(ruleItemObject);
                        continue;
                    }
                    ruleItemObject = new RuleItemObject();
                    ruleItemObject.setSceneId(sceneId.longValue());
                    ruleItemObject.setRuleLibId(ruleLibId.longValue());
                    ruleItemObject.setRuleLibName((String)classInfo.get("documentClassName"));
                    ruleItemObject.setDocTypeIdList(new ArrayList());
                    ruleItemObject.setDocTypeVoList(new ArrayList());
                    ruleItemObject.setSourceCode("2");
                    ruleItemObject.setEnabled(Integer.valueOf(1));
                    ruleItemObjectList.add(ruleItemObject);
                }
            }
        }
        return ruleItemObjectList;
    }

    private SceneRuleReviewItemRelevancyPo getSceneRuleReviewItemRelevancyPo(RuleItemObject ruleItemObject) {
        SceneRuleReviewItemRelevancyPo sceneRuleReviewItemRelevancyPo = new SceneRuleReviewItemRelevancyPo();
        sceneRuleReviewItemRelevancyPo.setId(SnowFlakeUtil.getFlowIdInstance().nextId());
        sceneRuleReviewItemRelevancyPo.setSceneId(ruleItemObject.getSceneId());
        sceneRuleReviewItemRelevancyPo.setRuleLibId(ruleItemObject.getRuleLibId());
        sceneRuleReviewItemRelevancyPo.setRuleItemId(ruleItemObject.getRuleItemId());
        sceneRuleReviewItemRelevancyPo.setEnabled(ruleItemObject.getEnabled().intValue());
        return sceneRuleReviewItemRelevancyPo;
    }

    private SceneRuleExtractRelevancyPo getSceneRuleExtractRelevancyPo(long sceneId, long extractItemId, long ruleItemId) {
        SceneRuleExtractRelevancyPo sceneRuleExtractRelevancyPo = new SceneRuleExtractRelevancyPo();
        sceneRuleExtractRelevancyPo.setExtractItemId(extractItemId);
        sceneRuleExtractRelevancyPo.setRuleItemId(ruleItemId);
        sceneRuleExtractRelevancyPo.setSceneId(sceneId);
        sceneRuleExtractRelevancyPo.setId(SnowFlakeUtil.getFlowIdInstance().nextId());
        return sceneRuleExtractRelevancyPo;
    }

    private SceneExtractItemDocTypeRelevancyPo getSceneExtractDocRelevancyPo(long sceneId, long ruleItemId, long extractItemId, String extractNodeId, long docTypeId) {
        SceneExtractItemDocTypeRelevancyPo po = new SceneExtractItemDocTypeRelevancyPo();
        po.setId(SnowFlakeUtil.getFlowIdInstance().nextId());
        po.setSceneId(sceneId);
        po.setRuleItemId(ruleItemId);
        po.setExtractItemId(extractItemId);
        po.setDocTypeId(docTypeId);
        if (extractNodeId != null && !"".equals(extractNodeId)) {
            po.setExtractNodeId(extractNodeId);
        }
        return po;
    }

    private SceneRuleItemDocTypeRelevancyPo getSceneRuleItemDocTypeRelevancyPo(long sceneId, long ruleItemId, long docTypeId) {
        SceneRuleItemDocTypeRelevancyPo po2 = new SceneRuleItemDocTypeRelevancyPo();
        po2.setId(SnowFlakeUtil.getFlowIdInstance().nextId());
        po2.setSceneId(sceneId);
        po2.setDocTypeId(docTypeId);
        po2.setRuleItemId(ruleItemId);
        return po2;
    }

    @Override
    public void saveRuleItemList(List<RuleItemObject> ruleItemObjectList) {
        if (ObjectUtils.isEmpty(ruleItemObjectList) || ruleItemObjectList.isEmpty()) {
            return;
        }
        long sceneId1 = ruleItemObjectList.get(0).getSceneId();
        List<SceneRuleExtractRelevancyPo> extractPoExist = this.sceneRuleExtractRelevancyService.findAllBySceneId(sceneId1);
        HashMap<Long, Integer> extractOldMap = new HashMap<Long, Integer>();
        if (extractPoExist != null && !extractPoExist.isEmpty()) {
            for (SceneRuleExtractRelevancyPo sceneRuleExtractRelevancyPo : extractPoExist) {
                long extractId = sceneRuleExtractRelevancyPo.getExtractItemId();
                if (extractOldMap.containsKey(extractId)) {
                    int count = (Integer)extractOldMap.get(extractId);
                    extractOldMap.put(extractId, count + 1);
                    continue;
                }
                extractOldMap.put(extractId, 1);
            }
        }
        this.sceneExtractItemDocTypeRelevancyService.delete(sceneId1);
        this.sceneRuleExtractRelevancyService.delete(sceneId1);
        this.sceneRuleReviewItemRelevancyService.delete(sceneId1);
        this.sceneRuleItemDocTypeRelevancyService.deleteBySceneId(sceneId1);
        this.sceneStyleRuleDocTypeRelevancyService.deleteBySceneId(sceneId1);
        ArrayList<SceneRuleReviewItemRelevancyPo> sceneRuleReviewItemRelevancyPoList = new ArrayList<SceneRuleReviewItemRelevancyPo>();
        ArrayList<SceneRuleExtractRelevancyPo> sceneRuleExtractRelevancyPoList = new ArrayList<SceneRuleExtractRelevancyPo>();
        ArrayList<SceneExtractItemDocTypeRelevancyPo> sceneExtractDocRelevancyPoList = new ArrayList<SceneExtractItemDocTypeRelevancyPo>();
        ArrayList<SceneRuleItemDocTypeRelevancyPo> sceneRuleItemDocTypeRelevancyPoList = new ArrayList<SceneRuleItemDocTypeRelevancyPo>();
        ArrayList<SceneStyleRuleDocTypeRelevancyPo> sceneStyleRuleDocTypeRelevancyPoList = new ArrayList<SceneStyleRuleDocTypeRelevancyPo>();
        for (RuleItemObject ruleItemObject : ruleItemObjectList) {
            long sceneId = ruleItemObject.getSceneId();
            String sourceCode = ruleItemObject.getSourceCode();
            if (StringUtils.isNotEmpty((String)sourceCode) && sourceCode.equals("2")) {
                Iterator iterator = ruleItemObject.getDocTypeIdList().iterator();
                while (iterator.hasNext()) {
                    long docTypeId = (Long)iterator.next();
                    SceneStyleRuleDocTypeRelevancyPo obj = new SceneStyleRuleDocTypeRelevancyPo();
                    obj.setSceneId(Long.valueOf(sceneId));
                    obj.setRuleLibId(Long.valueOf(ruleItemObject.getRuleLibId()));
                    obj.setEnabled(ruleItemObject.getEnabled());
                    obj.setDocTypeId(Long.valueOf(docTypeId));
                    obj.setEnabled(ruleItemObject.getEnabled());
                    obj.setId(Long.valueOf(SnowFlakeUtil.getFlowIdInstance().nextId()));
                    sceneStyleRuleDocTypeRelevancyPoList.add(obj);
                }
                continue;
            }
            long ruleItemId = ruleItemObject.getRuleItemId();
            sceneRuleReviewItemRelevancyPoList.add(this.getSceneRuleReviewItemRelevancyPo(ruleItemObject));
            for (ExtractItemObject item : ruleItemObject.getExtractItemList()) {
                Long extractItemId = item.getId();
                if (extractItemId == null) {
                    ExtractItem extractItem = new ExtractItem();
                    extractItem.setName(item.getName());
                    extractItem.setDescription(item.getDescription());
                    extractItem.setReturnType(item.getReturnType());
                    extractItem.setMethod(Integer.valueOf(item.getMethod()));
                    extractItemId = this.extractCoreService.save(extractItem);
                }
                sceneRuleExtractRelevancyPoList.add(this.getSceneRuleExtractRelevancyPo(sceneId, extractItemId, ruleItemId));
                int type = item.getMethod();
                ArrayList<Long> docTypeIdAllList = new ArrayList<Long>();
                Iterator iterator = item.getDocTypeIdList().iterator();
                while (iterator.hasNext()) {
                    long docTypeId = (Long)iterator.next();
                    sceneExtractDocRelevancyPoList.add(this.getSceneExtractDocRelevancyPo(sceneId, ruleItemId, extractItemId, null, docTypeId));
                    sceneRuleItemDocTypeRelevancyPoList.add(this.getSceneRuleItemDocTypeRelevancyPo(sceneId, ruleItemId, docTypeId));
                    docTypeIdAllList.add(docTypeId);
                }
            }
        }
        this.sceneRuleReviewItemRelevancyService.saveBatch(sceneRuleReviewItemRelevancyPoList);
        this.sceneRuleExtractRelevancyService.saveBatch(sceneRuleExtractRelevancyPoList);
        this.sceneExtractItemDocTypeRelevancyService.saveBatch(sceneExtractDocRelevancyPoList);
        this.sceneRuleItemDocTypeRelevancyService.saveBatch(sceneRuleItemDocTypeRelevancyPoList);
        this.sceneStyleRuleDocTypeRelevancyService.saveBatch(sceneStyleRuleDocTypeRelevancyPoList);
        HashMap<Long, Integer> extractNewMap = new HashMap<Long, Integer>();
        for (SceneRuleExtractRelevancyPo sceneRuleExtractRelevancyPo : sceneRuleExtractRelevancyPoList) {
            long extractId = sceneRuleExtractRelevancyPo.getExtractItemId();
            if (extractNewMap.containsKey(extractId)) {
                int count = (Integer)extractNewMap.get(extractId);
                extractNewMap.put(extractId, count + 1);
                continue;
            }
            extractNewMap.put(extractId, 1);
        }
        HashMap<Long, Integer> hashMap = new HashMap<Long, Integer>();
        HashMap<Long, Integer> extractReduceMap = new HashMap<Long, Integer>();
        for (Map.Entry newMap : extractNewMap.entrySet()) {
            long key = (Long)newMap.getKey();
            int value = (Integer)newMap.getValue();
            if (extractOldMap.containsKey(key)) {
                int result = (Integer)extractOldMap.get(key) - value;
                if (result > 0) {
                    extractReduceMap.put(key, result);
                    continue;
                }
                if (result >= 0) continue;
                hashMap.put(key, -result);
                continue;
            }
            hashMap.put(key, value);
        }
        for (Map.Entry oldMap : extractOldMap.entrySet()) {
            long oldKey = (Long)oldMap.getKey();
            if (extractNewMap.containsKey(oldKey)) continue;
            extractReduceMap.put(oldKey, (Integer)oldMap.getValue());
        }
        if (!hashMap.isEmpty()) {
            for (Map.Entry addMap : hashMap.entrySet()) {
                int loopCount = (Integer)addMap.getValue();
                for (int i = 1; i <= loopCount; ++i) {
                    this.iCounterService.add((Long)addMap.getKey(), Long.valueOf(sceneId1), "1", "1");
                }
            }
        }
        if (!extractReduceMap.isEmpty()) {
            for (Map.Entry reduceMap : extractReduceMap.entrySet()) {
                int loopCount = (Integer)reduceMap.getValue();
                for (int i = 1; i <= loopCount; ++i) {
                    this.iCounterService.subtract((Long)reduceMap.getKey(), Long.valueOf(sceneId1), "1", "1");
                }
            }
        }
    }

    @Override
    public List<SceneConfigResult> getConfigResultList(long sceneId) {
        ArrayList<SceneConfigResult> sceneConfigResultList = new ArrayList<SceneConfigResult>();
        List<SceneRuleLibRelevancyPo> sceneRuleLibRelevancyPoList = this.sceneRuleLibRelevancyService.findAllBySceneId(sceneId);
        List<SceneDocTypeRelevancyPo> sceneDocTypeRelevancyPoList = this.sceneDocTypeRelevancyService.findBySceneId(sceneId);
        List docTypeIdList = sceneDocTypeRelevancyPoList.stream().map(SceneDocTypeRelevancyPo::getDocTypeId).collect(Collectors.toList());
        for (Long docTypeId : docTypeIdList) {
            ArrayList<Long> ruleLibIdList = new ArrayList<Long>();
            ArrayList<RuleLibVo> ruleLibList = new ArrayList<RuleLibVo>();
            for (SceneRuleLibRelevancyPo ruleLibRelevancyPo : sceneRuleLibRelevancyPoList) {
                long ruleLibId = ruleLibRelevancyPo.getRuleLibId();
                RuleLibVo ruleLibVo1 = this.getRuleLibVo(ruleLibId);
                String ruleLibName = ruleLibVo1.getLibName();
                RuleLibQueryVo ruleLibQueryVo = new RuleLibQueryVo();
                ruleLibQueryVo.setPid(Long.valueOf(ruleLibId));
                ruleLibQueryVo.setQueryFlag(1);
                Page ruleLibVoPage = this.ruleService.queryRuleLib(ruleLibQueryVo);
                for (RuleLibVo ruleLibVo : ruleLibVoPage.getRecords()) {
                    List<SceneRuleReviewItemRelevancyPo> sceneRuleReviewItemRelevancyPoList = this.sceneRuleReviewItemRelevancyService.findAllByRuleLibId(ruleLibVo.getId());
                    for (SceneRuleReviewItemRelevancyPo po : sceneRuleReviewItemRelevancyPoList) {
                        List<SceneRuleItemDocTypeRelevancyPo> ruleItemDocTypeRelevancyPoList = this.sceneRuleItemDocTypeRelevancyService.getByRuleItemId(sceneId, po.getRuleItemId());
                        if (!ruleItemDocTypeRelevancyPoList.stream().anyMatch(item -> item.getDocTypeId() == docTypeId.longValue()) || ruleLibIdList.contains(ruleLibId)) continue;
                        ruleLibIdList.add(ruleLibId);
                        RuleLibVo ruleLibVo2 = new RuleLibVo();
                        ruleLibVo2.setId(Long.valueOf(ruleLibId));
                        ruleLibVo2.setLibName(ruleLibName);
                        ruleLibList.add(ruleLibVo2);
                    }
                }
            }
            DocTypeVo docTypeVo = this.docTypeService.queryDocTypeById(docTypeId);
            SceneConfigResult sceneConfigResult = new SceneConfigResult(docTypeVo, ruleLibIdList, ruleLibList);
            sceneConfigResultList.add(sceneConfigResult);
        }
        return sceneConfigResultList;
    }

    @Override
    public List<ScenePo> findByGroupId(long groupId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"group_id", (Object)groupId);
        return this.sceneMapper.selectList((Wrapper)queryWrapper);
    }

    @Override
    public int getSceneCount() {
        return this.sceneMapper.getSceneCount();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteByExtractItemId(long extractItemId) {
        if (ObjectUtils.isEmpty((Object)extractItemId)) {
            return;
        }
        this.sceneRuleExtractRelevancyService.deleteByExtractItemId(extractItemId);
        this.sceneExtractItemDocTypeRelevancyService.deleteByExtractItemId(extractItemId);
    }

    @Override
    public void exportScene(List<Long> ids, HttpServletResponse response) {
        byte[] bytes;
        SceneExportDto exportDto = this.getSceneDataByItemIds(ids);
        try {
            bytes = SerializeUtils.serialize((Serializable)exportDto);
        }
        catch (IOException e) {
            log.error("\u5e8f\u5217\u5316\u6570\u636e\u5f02\u5e38\uff1a", (Throwable)e);
            throw new BusinessException("\u5e8f\u5217\u5316\u6570\u636e\u5f02\u5e38\uff0c\u5bfc\u51fa\u5931\u8d25");
        }
        try {
            String fileName = URLEncoder.encode("\u5ba1\u67e5\u5e94\u7528_" + LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd_Hmmss")) + ".hussar", "UTF-8");
            response.addHeader("Content-Disposition", "attachment;filename=" + fileName);
            response.setContentType("multipart/form-data");
            try (ServletOutputStream outputStream = response.getOutputStream();){
                outputStream.write(bytes);
                outputStream.flush();
            }
        }
        catch (UnsupportedEncodingException e) {
            log.error("\u4e0d\u652f\u6301\u7684\u7f16\u7801\u5f02\u5e38\uff1a", (Throwable)e);
            throw new RuntimeException("\u4e0b\u8f7d\u51fa\u9519,\u4e0d\u652f\u6301\u7684\u7f16\u7801\u5f02\u5e38");
        }
        catch (IOException e) {
            log.error("IO\u5f02\u5e38\uff1a", (Throwable)e);
            throw new RuntimeException("\u4e0b\u8f7d\u51fa\u9519\uff0cIO\u5f02\u5e38");
        }
    }

    @Override
    public SceneExportDto getSceneDataByItemIds(List<Long> sceneIds) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.in(ScenePo::getId, sceneIds);
        List sceneList = this.list((Wrapper)queryWrapper);
        if (sceneList.isEmpty()) {
            throw new BusinessException("\u672a\u627e\u5230\u6307\u5b9a\u7684\u5ba1\u67e5\u5e94\u7528");
        }
        LambdaQueryWrapper groupQuery = new LambdaQueryWrapper();
        groupQuery.in(SceneGroupPo::getId, (Collection)sceneList.stream().map(ScenePo::getGroupId).distinct().collect(Collectors.toList()));
        List groupList = this.sceneGroupService.list((Wrapper)groupQuery);
        LambdaQueryWrapper docTypeQuery = new LambdaQueryWrapper();
        docTypeQuery.in(SceneDocTypeRelevancyPo::getSceneId, sceneIds);
        List docTypeList = this.sceneDocTypeRelevancyService.list((Wrapper)docTypeQuery);
        LambdaQueryWrapper ruleLibQuery = new LambdaQueryWrapper();
        ruleLibQuery.in(SceneRuleLibRelevancyPo::getSceneId, sceneIds);
        List ruleLibList = this.sceneRuleLibRelevancyService.list((Wrapper)ruleLibQuery);
        LambdaQueryWrapper ruleReviewItemQuery = new LambdaQueryWrapper();
        ruleReviewItemQuery.in(SceneRuleReviewItemRelevancyPo::getSceneId, sceneIds);
        List ruleReviewItemList = this.sceneRuleReviewItemRelevancyService.list((Wrapper)ruleReviewItemQuery);
        LambdaQueryWrapper ruleItemDocTypeQuery = new LambdaQueryWrapper();
        ruleItemDocTypeQuery.in(SceneRuleItemDocTypeRelevancyPo::getSceneId, sceneIds);
        List ruleItemDocTypeRelevancyPoList = this.sceneRuleItemDocTypeRelevancyService.list((Wrapper)ruleItemDocTypeQuery);
        LambdaQueryWrapper ruleExtractQuery = new LambdaQueryWrapper();
        ruleExtractQuery.in(SceneRuleExtractRelevancyPo::getSceneId, sceneIds);
        List ruleExtractRelevancyPoList = this.sceneRuleExtractRelevancyService.list((Wrapper)ruleExtractQuery);
        LambdaQueryWrapper ruleExtractItemDocTypeQuery = new LambdaQueryWrapper();
        ruleExtractItemDocTypeQuery.in(SceneExtractItemDocTypeRelevancyPo::getSceneId, sceneIds);
        List ruleExtractItemDocTypeRelevancyPoList = this.sceneExtractItemDocTypeRelevancyService.list((Wrapper)ruleExtractItemDocTypeQuery);
        List extractItemIds = ruleExtractRelevancyPoList.stream().map(SceneRuleExtractRelevancyPo::getExtractItemId).distinct().collect(Collectors.toList());
        ExtractExportDto extractData = this.extractCoreService.getExportDataByItemIds(extractItemIds);
        List ruleLibIds = ruleLibList.stream().map(SceneRuleLibRelevancyPo::getRuleLibId).distinct().collect(Collectors.toList());
        RuleExportDto ruleData = (RuleExportDto)this.ruleService.getExportDataByLibIds(ruleLibIds);
        List docTypeIds = docTypeList.stream().map(SceneDocTypeRelevancyPo::getDocTypeId).distinct().collect(Collectors.toList());
        DocTypeExportDto docTypeData = this.docTypeService.getDocTypeDataByItemIds(docTypeIds);
        LambdaQueryWrapper sceneStyleQuery = new LambdaQueryWrapper();
        sceneStyleQuery.in(SceneStyleRuleDocTypeRelevancyPo::getSceneId, sceneIds);
        List sceneStyleList = this.sceneStyleRuleDocTypeRelevancyService.list((Wrapper)sceneStyleQuery);
        List styleLibIds = sceneStyleList.stream().map(SceneStyleRuleDocTypeRelevancyPo::getRuleLibId).distinct().collect(Collectors.toList());
        HashMap<String, Object> styleLibExportDto = new HashMap();
        if (!ObjectUtils.isEmpty(styleLibIds) && this.styleModuleReview != null) {
            styleLibExportDto = this.styleModuleReview.getExportStyleLibData(styleLibIds);
        }
        SceneExportDto exportDto = new SceneExportDto();
        exportDto.setSceneList(sceneList);
        exportDto.setSceneGroupList(groupList);
        exportDto.setSceneDocTypeRelevancyList(docTypeList);
        exportDto.setSceneRuleLibRelevancyList(ruleLibList);
        exportDto.setSceneRuleReviewItemRelevancyList(ruleReviewItemList);
        exportDto.setSceneRuleExtractRelevancyList(ruleExtractRelevancyPoList);
        exportDto.setSceneExtractItemDocTypeRelevancyList(ruleExtractItemDocTypeRelevancyPoList);
        exportDto.setSceneRuleItemDocTypeRelevancyList(ruleItemDocTypeRelevancyPoList);
        exportDto.setExtractExportData(extractData);
        exportDto.setRuleExportData(ruleData);
        exportDto.setDocTypeExportData(docTypeData);
        exportDto.setSceneStyleList(sceneStyleList);
        exportDto.setStyleLibExportDto(styleLibExportDto);
        return exportDto;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void improtScene(SceneExportDto exportDto, String isUserData) {
        List<ScenePo> sceneList = exportDto.getSceneList();
        List<SceneGroupPo> groupList = exportDto.getSceneGroupList();
        List<SceneDocTypeRelevancyPo> docTypeList = exportDto.getSceneDocTypeRelevancyList();
        List<SceneRuleLibRelevancyPo> ruleLibList = exportDto.getSceneRuleLibRelevancyList();
        List<SceneRuleReviewItemRelevancyPo> ruleReviewItemList = exportDto.getSceneRuleReviewItemRelevancyList();
        List<SceneRuleItemDocTypeRelevancyPo> ruleItemDocTypeRelevancyPoList = exportDto.getSceneRuleItemDocTypeRelevancyList();
        List<SceneRuleExtractRelevancyPo> ruleExtractRelevancyPoList = exportDto.getSceneRuleExtractRelevancyList();
        List<SceneExtractItemDocTypeRelevancyPo> ruleExtractItemDocTypeRelevancyPoList = exportDto.getSceneExtractItemDocTypeRelevancyList();
        ExtractExportDto extractExportDto = exportDto.getExtractExportData();
        RuleExportDto ruleExportData = exportDto.getRuleExportData();
        DocTypeExportDto docTypeData = exportDto.getDocTypeExportData();
        List<SceneStyleRuleDocTypeRelevancyPo> sceneStyleList = exportDto.getSceneStyleList();
        Map<String, Object> styleLibExportDto = exportDto.getStyleLibExportDto();
        if (StringUtils.isNotEmpty((String)isUserData) && "true".equals(isUserData)) {
            if (groupList != null && !groupList.isEmpty()) {
                groupList.forEach(lib -> {
                    if (lib.getId() > 0L) {
                        lib.setCreator(String.valueOf(UserUtils.getLoginUserId()));
                    }
                });
            }
            if (sceneList != null && !sceneList.isEmpty()) {
                sceneList.forEach(lib -> lib.setCreator(String.valueOf(UserUtils.getLoginUserId())));
            }
            if (docTypeList != null && !docTypeList.isEmpty()) {
                docTypeList.forEach(lib -> lib.setCreator(String.valueOf(UserUtils.getLoginUserId())));
            }
            if (ruleLibList != null && !ruleLibList.isEmpty()) {
                ruleLibList.forEach(lib -> lib.setCreator(String.valueOf(UserUtils.getLoginUserId())));
            }
            if (ruleReviewItemList != null && !ruleReviewItemList.isEmpty()) {
                ruleReviewItemList.forEach(lib -> lib.setCreator(String.valueOf(UserUtils.getLoginUserId())));
            }
            if (ruleItemDocTypeRelevancyPoList != null && !ruleItemDocTypeRelevancyPoList.isEmpty()) {
                ruleItemDocTypeRelevancyPoList.forEach(lib -> lib.setCreator(String.valueOf(UserUtils.getLoginUserId())));
            }
            if (ruleExtractRelevancyPoList != null && !ruleExtractRelevancyPoList.isEmpty()) {
                ruleExtractRelevancyPoList.forEach(lib -> lib.setCreator(String.valueOf(UserUtils.getLoginUserId())));
            }
            if (ruleExtractItemDocTypeRelevancyPoList != null && !ruleExtractItemDocTypeRelevancyPoList.isEmpty()) {
                ruleExtractItemDocTypeRelevancyPoList.forEach(lib -> lib.setCreator(String.valueOf(UserUtils.getLoginUserId())));
            }
            if (sceneStyleList != null && !sceneStyleList.isEmpty()) {
                sceneStyleList.forEach(lib -> lib.setCreator(String.valueOf(UserUtils.getLoginUserId())));
            }
        }
        this.saveOrUpdateBatchSence(sceneList);
        this.sceneGroupService.saveOrUpdateBatchSence(groupList);
        this.sceneDocTypeRelevancyService.saveOrUpdateBatchSence(docTypeList);
        this.sceneRuleLibRelevancyService.saveOrUpdateBatchSence(ruleLibList);
        this.sceneRuleReviewItemRelevancyService.saveOrUpdateBatchSence(ruleReviewItemList);
        this.sceneRuleItemDocTypeRelevancyService.saveOrUpdateBatchSence(ruleItemDocTypeRelevancyPoList);
        this.sceneRuleExtractRelevancyService.saveOrUpdateBatchSence(ruleExtractRelevancyPoList);
        this.sceneExtractItemDocTypeRelevancyService.saveOrUpdateBatchSence(ruleExtractItemDocTypeRelevancyPoList);
        this.extractCoreService.importExtract(extractExportDto, isUserData);
        this.ruleService.importExtract((Object)ruleExportData, isUserData);
        this.docTypeService.improtDocType(docTypeData, isUserData);
        this.sceneStyleRuleDocTypeRelevancyService.saveOrUpdateBatchSence(sceneStyleList);
        if (this.styleModuleReview != null && styleLibExportDto != null) {
            this.styleModuleReview.importStyleLib(styleLibExportDto, isUserData);
        }
    }

    @Override
    public void saveOrUpdateBatchSence(List<ScenePo> sceneList) {
        if (CollUtil.isNotEmpty(sceneList)) {
            this.sceneMapper.deleteByIds(sceneList.stream().map(ScenePo::getId).collect(Collectors.toList()));
            this.saveBatch(sceneList);
            log.debug("\u6210\u529f\u66f4\u65b0\u573a\u666f\u6570\u636e{}\u6761", (Object)sceneList.size());
        }
    }
}

