/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.scene.server.service.impl;

import cn.hutool.core.collection.CollUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.idp.scene.api.po.SceneRuleItemDocTypeRelevancyPo;
import com.jxdinfo.idp.scene.server.mapper.SceneRuleItemDocTypeRelevancyMapper;
import com.jxdinfo.idp.scene.server.service.SceneRuleItemDocTypeRelevancyService;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Service
public class SceneRuleItemDocTypeRelevancyServiceImpl
extends ServiceImpl<SceneRuleItemDocTypeRelevancyMapper, SceneRuleItemDocTypeRelevancyPo>
implements SceneRuleItemDocTypeRelevancyService {
    private static final Logger log = LoggerFactory.getLogger(SceneRuleItemDocTypeRelevancyServiceImpl.class);
    @Autowired
    private SceneRuleItemDocTypeRelevancyMapper sceneRuleItemDocTypeRelevancyMapper;

    @Override
    public List<SceneRuleItemDocTypeRelevancyPo> getByRuleItemId(long sceneId, long ruleItemId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"scene_id", (Object)sceneId);
        queryWrapper.eq((Object)"rule_item_id", (Object)ruleItemId);
        return ((SceneRuleItemDocTypeRelevancyMapper)this.baseMapper).selectList((Wrapper)queryWrapper);
    }

    @Override
    public List<SceneRuleItemDocTypeRelevancyPo> getBySceneId(long sceneId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"scene_id", (Object)sceneId);
        queryWrapper.eq((Object)"delete_flag", (Object)0);
        return ((SceneRuleItemDocTypeRelevancyMapper)this.baseMapper).selectList((Wrapper)queryWrapper);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void delete(long sceneId, long ruleItemId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"scene_id", (Object)sceneId);
        queryWrapper.eq((Object)"rule_item_id", (Object)ruleItemId);
        ((SceneRuleItemDocTypeRelevancyMapper)this.baseMapper).delete((Wrapper)queryWrapper);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void delete(long sceneId, List<Long> templateIdList) {
        if (!ObjectUtils.isEmpty(templateIdList)) {
            this.sceneRuleItemDocTypeRelevancyMapper.deleteBySceneIdAndTemplateId(sceneId, templateIdList);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void delete(long sceneId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"scene_id", (Object)sceneId);
        ((SceneRuleItemDocTypeRelevancyMapper)this.baseMapper).delete((Wrapper)queryWrapper);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBySceneId(long sceneId) {
        this.sceneRuleItemDocTypeRelevancyMapper.deleteBySceneId(sceneId);
    }

    @Override
    public List<SceneRuleItemDocTypeRelevancyPo> findByDocTypeId(long docTypeId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"doc_type_id", (Object)docTypeId);
        return ((SceneRuleItemDocTypeRelevancyMapper)this.baseMapper).selectList((Wrapper)queryWrapper);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteByDocTypeId(long docTypeId) {
        this.sceneRuleItemDocTypeRelevancyMapper.deleteByDocTypeId(docTypeId);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void delete(long sceneId, long ruleItemId, long docTypeId) {
        this.sceneRuleItemDocTypeRelevancyMapper.delete(sceneId, ruleItemId, docTypeId);
    }

    @Override
    public void saveOrUpdateBatchSence(List<SceneRuleItemDocTypeRelevancyPo> ruleItemDocTypeRelevancyPoList) {
        if (CollUtil.isNotEmpty(ruleItemDocTypeRelevancyPoList)) {
            List<Long> sceneIds = ruleItemDocTypeRelevancyPoList.stream().map(SceneRuleItemDocTypeRelevancyPo::getSceneId).collect(Collectors.toList());
            this.sceneRuleItemDocTypeRelevancyMapper.deleteBySceneIds(sceneIds);
            this.saveBatch(ruleItemDocTypeRelevancyPoList);
            log.debug("\u6210\u529f\u66f4\u65b0\u5ba1\u67e5\u5e94\u7528-\u5ba1\u67e5\u9879-\u6587\u6863\u7c7b\u578b\u6570\u636e{}\u6761", (Object)ruleItemDocTypeRelevancyPoList.size());
        }
    }

    @Override
    public void removeItem(Long ruleItemId) {
        this.sceneRuleItemDocTypeRelevancyMapper.deleteSceneRuleItemDocType(ruleItemId);
    }
}

