/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.scene.server.service.impl;

import cn.hutool.core.collection.CollUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.idp.common.base.dto.AuditInfoDto;
import com.jxdinfo.idp.common.base.dto.LogicDeleteAuditInfoDto;
import com.jxdinfo.idp.common.util.StringUtils;
import com.jxdinfo.idp.scene.api.po.SceneGroupPo;
import com.jxdinfo.idp.scene.api.query.SceneGroupQuery;
import com.jxdinfo.idp.scene.server.mapper.SceneGroupMapper;
import com.jxdinfo.idp.scene.server.service.SceneGroupService;
import java.time.LocalDateTime;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class SceneGroupServiceImpl
extends ServiceImpl<SceneGroupMapper, SceneGroupPo>
implements SceneGroupService {
    private static final Logger log = LoggerFactory.getLogger(SceneGroupServiceImpl.class);
    @Resource
    private SceneGroupMapper sceneGroupMapper;

    @Override
    public List<SceneGroupPo> getSceneGroupList() {
        return this.getList(new SceneGroupQuery());
    }

    @Override
    public List<SceneGroupPo> getList(SceneGroupQuery query) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        if (StringUtils.isNotEmpty((String)query.getCreator())) {
            wrapper.eq(AuditInfoDto::getCreator, (Object)query.getCreator());
            ((LambdaQueryWrapper)wrapper.or()).eq(SceneGroupPo::getId, (Object)0);
        }
        wrapper.orderByDesc(AuditInfoDto::getCreateTime);
        wrapper.eq(LogicDeleteAuditInfoDto::getDeleteFlag, (Object)0);
        return this.list((Wrapper)wrapper);
    }

    @Override
    public SceneGroupPo getById(long id) {
        return (SceneGroupPo)((SceneGroupMapper)this.baseMapper).selectById(Long.valueOf(id));
    }

    @Override
    public void saveOrUpdateBatchSence(List<SceneGroupPo> groupList) {
        if (CollUtil.isNotEmpty(groupList)) {
            List<Long> ids = groupList.stream().map(SceneGroupPo::getId).collect(Collectors.toList());
            this.sceneGroupMapper.deleteByIds(ids);
            this.saveBatch(groupList);
            log.debug("\u4fee\u6539\u573a\u666f\u6570\u636e{}\u6761", (Object)groupList.size());
            if (ids.contains(0L)) {
                LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
                wrapper.eq(SceneGroupPo::getId, (Object)0);
                wrapper.set(AuditInfoDto::getCreator, null);
                wrapper.set(AuditInfoDto::getCreateTime, (Object)LocalDateTime.parse("2099-12-31T00:00:00"));
                this.update((Wrapper)wrapper);
            }
        }
    }

    public SceneGroupMapper getSceneGroupMapper() {
        return this.sceneGroupMapper;
    }

    public void setSceneGroupMapper(SceneGroupMapper sceneGroupMapper) {
        this.sceneGroupMapper = sceneGroupMapper;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SceneGroupServiceImpl)) {
            return false;
        }
        SceneGroupServiceImpl other = (SceneGroupServiceImpl)o;
        if (!other.canEqual(this)) {
            return false;
        }
        SceneGroupMapper this$sceneGroupMapper = this.getSceneGroupMapper();
        SceneGroupMapper other$sceneGroupMapper = other.getSceneGroupMapper();
        return !(this$sceneGroupMapper == null ? other$sceneGroupMapper != null : !this$sceneGroupMapper.equals(other$sceneGroupMapper));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SceneGroupServiceImpl;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        SceneGroupMapper $sceneGroupMapper = this.getSceneGroupMapper();
        result = result * 59 + ($sceneGroupMapper == null ? 43 : $sceneGroupMapper.hashCode());
        return result;
    }

    public String toString() {
        return "SceneGroupServiceImpl(sceneGroupMapper=" + this.getSceneGroupMapper() + ")";
    }
}

