/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.scene.server.controller;

import com.jxdinfo.idp.common.response.ApiResponse;
import com.jxdinfo.idp.scene.api.dto.SceneRuleLibRelevancyDto;
import com.jxdinfo.idp.scene.api.po.SceneRuleLibRelevancyPo;
import com.jxdinfo.idp.scene.server.service.SceneRuleLibRelevancyService;
import com.jxdinfo.idp.scene.server.service.impl.SceneRuleItemDocTypeRelevancyServiceImpl;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/scene/ruleLib"})
public class SceneRuleLibRelevancyController {
    private static final Logger log = LoggerFactory.getLogger(SceneRuleLibRelevancyController.class);
    @Resource
    private SceneRuleLibRelevancyService sceneRuleLibRelevancyService;
    @Autowired
    private SceneRuleItemDocTypeRelevancyServiceImpl sceneRuleItemDocTypeRelevancyService;

    @PostMapping(value={"/add"})
    public ApiResponse<Void> add(@RequestParam Long sceneId, @RequestParam List<Long> ruleLibIdList) {
        this.sceneRuleLibRelevancyService.insert(sceneId, ruleLibIdList);
        return ApiResponse.success();
    }

    @PostMapping(value={"/addOrUpdate"})
    public ApiResponse<Void> addOrUpdate(@RequestParam Long sceneId, @RequestParam List<Long> ruleLibIdList) {
        this.sceneRuleLibRelevancyService.addOrUpdate(sceneId, ruleLibIdList);
        return ApiResponse.success();
    }

    @PostMapping(value={"/addOrUpdateNew"})
    public ApiResponse<Void> addOrUpdateNew(@RequestBody SceneRuleLibRelevancyDto dto) {
        this.sceneRuleLibRelevancyService.addOrUpdateNew(dto);
        return ApiResponse.success();
    }

    @GetMapping(value={"/findAllBySceneId"})
    public ApiResponse<List<SceneRuleLibRelevancyPo>> findAllBySceneId(@RequestParam Long sceneId) {
        return ApiResponse.success(this.sceneRuleLibRelevancyService.findAllBySceneId(sceneId));
    }
}

