/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.scene.server.service.impl;

import cn.hutool.core.collection.CollUtil;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.idp.rule.server.service.RemoveSceneRuleExtractService;
import com.jxdinfo.idp.scene.api.po.SceneRuleExtractRelevancyPo;
import com.jxdinfo.idp.scene.server.mapper.SceneRuleExtractRelevancyMapper;
import com.jxdinfo.idp.scene.server.service.SceneRuleExtractRelevancyService;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Service
public class SceneRuleExtractRelevancyServiceImpl
extends ServiceImpl<SceneRuleExtractRelevancyMapper, SceneRuleExtractRelevancyPo>
implements SceneRuleExtractRelevancyService,
RemoveSceneRuleExtractService {
    private static final Logger log = LoggerFactory.getLogger(SceneRuleExtractRelevancyServiceImpl.class);
    @Resource
    private SceneRuleExtractRelevancyMapper sceneRuleExtractRelevancyMapper;

    @Override
    public List<SceneRuleExtractRelevancyPo> findAllBySceneId(long sceneId) {
        return this.sceneRuleExtractRelevancyMapper.findAllBySceneId(sceneId);
    }

    @Override
    public List<SceneRuleExtractRelevancyPo> findBySceneIdAndRuleItemId(long sceneId, long ruleItemId) {
        return this.sceneRuleExtractRelevancyMapper.findBySceneIdAndRuleItemId(sceneId, ruleItemId);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void delete(long sceneId) {
        this.sceneRuleExtractRelevancyMapper.deleteBySceneId(sceneId);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void delete(long sceneId, long ruleItemId, List<Long> extractIdList) {
        if (!ObjectUtils.isEmpty(extractIdList)) {
            this.sceneRuleExtractRelevancyMapper.delete(sceneId, ruleItemId, extractIdList);
        }
    }

    @Override
    public void delete(long sceneId, List<Long> templateIdList) {
        if (!ObjectUtils.isEmpty(templateIdList)) {
            this.sceneRuleExtractRelevancyMapper.deleteBySceneIdAndTemplateId(sceneId, templateIdList);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteByExtractItemId(long extractItemId) {
        if (!ObjectUtils.isEmpty((Object)extractItemId)) {
            this.sceneRuleExtractRelevancyMapper.deleteByExtractItemId(extractItemId);
        }
    }

    @Override
    public void saveOrUpdateBatchSence(List<SceneRuleExtractRelevancyPo> ruleExtractRelevancyPoList) {
        if (CollUtil.isNotEmpty(ruleExtractRelevancyPoList)) {
            List<Long> sceneIds = ruleExtractRelevancyPoList.stream().map(SceneRuleExtractRelevancyPo::getSceneId).collect(Collectors.toList());
            this.sceneRuleExtractRelevancyMapper.deleteBySceneIds(sceneIds);
            this.saveBatch(ruleExtractRelevancyPoList);
            log.debug("\u6210\u529f\u66f4\u65b0\u5ba1\u67e5\u5e94\u7528-\u5ba1\u67e5\u9879-\u63d0\u53d6\u9879\u6570\u636e{}\u6761", (Object)ruleExtractRelevancyPoList.size());
        }
    }

    public void removeItem(Long ruleItemId) {
        this.sceneRuleExtractRelevancyMapper.deleteSceneRuleExtract(ruleItemId);
    }
}

