/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.scene.server.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.idp.common.counter.service.ICounterService;
import com.jxdinfo.idp.common.entity.Counter;
import com.jxdinfo.idp.common.util.SnowFlakeUtil;
import com.jxdinfo.idp.dm.server.service.impl.DocServiceImpl;
import com.jxdinfo.idp.dto.NodeTypeDto;
import com.jxdinfo.idp.extract.chain.dto.ExtractNode;
import com.jxdinfo.idp.extract.chain.service.IExtractChainService;
import com.jxdinfo.idp.extract.domain.dto.ExtractItemDto;
import com.jxdinfo.idp.extract.domain.po.ExtractItem;
import com.jxdinfo.idp.extract.domain.query.ExtractItemQuery;
import com.jxdinfo.idp.extract.interf.IExtractCore;
import com.jxdinfo.idp.extract.mapper.ExtractItemMapper;
import com.jxdinfo.idp.interf.DocTypeService;
import com.jxdinfo.idp.interf.NodeTypeFoldService;
import com.jxdinfo.idp.interf.NodeTypeRelevancyService;
import com.jxdinfo.idp.po.NodeTypePo;
import com.jxdinfo.idp.rule.api.service.IRuleService;
import com.jxdinfo.idp.rule.api.vo.RuleItemGroupQueryVo;
import com.jxdinfo.idp.rule.api.vo.RuleItemQueryVo;
import com.jxdinfo.idp.rule.api.vo.RuleItemVo;
import com.jxdinfo.idp.rule.api.vo.RuleLibQueryVo;
import com.jxdinfo.idp.rule.api.vo.RuleLibVo;
import com.jxdinfo.idp.scene.api.dto.GroupSceneDto;
import com.jxdinfo.idp.scene.api.dto.QueryRuleLibDto;
import com.jxdinfo.idp.scene.api.dto.SceneConfigResult;
import com.jxdinfo.idp.scene.api.dto.SceneDto;
import com.jxdinfo.idp.scene.api.dto.SceneRuleLibDto;
import com.jxdinfo.idp.scene.api.po.SceneDocTypeRelevancyPo;
import com.jxdinfo.idp.scene.api.po.SceneExtractItemDocTypeRelevancyPo;
import com.jxdinfo.idp.scene.api.po.SceneGroupPo;
import com.jxdinfo.idp.scene.api.po.ScenePo;
import com.jxdinfo.idp.scene.api.po.SceneRuleExtractRelevancyPo;
import com.jxdinfo.idp.scene.api.po.SceneRuleItemDocTypeRelevancyPo;
import com.jxdinfo.idp.scene.api.po.SceneRuleLibRelevancyPo;
import com.jxdinfo.idp.scene.api.po.SceneRuleReviewItemRelevancyPo;
import com.jxdinfo.idp.scene.api.vo.ScenePageVo;
import com.jxdinfo.idp.scene.dto.ExtractItemObject;
import com.jxdinfo.idp.scene.dto.RuleItemObject;
import com.jxdinfo.idp.scene.server.mapper.SceneDocTypeRelevancyMapper;
import com.jxdinfo.idp.scene.server.mapper.SceneMapper;
import com.jxdinfo.idp.scene.server.mapper.SceneRuleReviewItemRelevancyMapper;
import com.jxdinfo.idp.scene.server.mapper.SceneTemplateRelevancyMapper;
import com.jxdinfo.idp.scene.server.service.SceneDocTypeRelevancyService;
import com.jxdinfo.idp.scene.server.service.SceneExtractItemDocTypeRelevancyService;
import com.jxdinfo.idp.scene.server.service.SceneGroupService;
import com.jxdinfo.idp.scene.server.service.SceneRuleExtractRelevancyService;
import com.jxdinfo.idp.scene.server.service.SceneRuleItemDocTypeRelevancyService;
import com.jxdinfo.idp.scene.server.service.SceneRuleLibRelevancyService;
import com.jxdinfo.idp.scene.server.service.SceneRuleReviewItemRelevancyService;
import com.jxdinfo.idp.scene.server.service.SceneService;
import com.jxdinfo.idp.scene.server.service.SceneTemplateRelevancyService;
import com.jxdinfo.idp.vo.DocTypeVo;
import com.jxdinfo.usehub.service.UseHubTaskService;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Service
public class SceneServiceImpl
extends ServiceImpl<SceneMapper, ScenePo>
implements SceneService {
    private static final Logger log = LoggerFactory.getLogger(SceneServiceImpl.class);
    @Autowired
    private SceneMapper sceneMapper;
    @Autowired
    private IRuleService ruleService;
    @Autowired
    private SceneRuleLibRelevancyService sceneRuleLibRelevancyService;
    @Autowired
    private SceneRuleReviewItemRelevancyService sceneRuleReviewItemRelevancyService;
    @Autowired
    private SceneRuleExtractRelevancyService sceneRuleExtractRelevancyService;
    @Autowired
    private SceneExtractItemDocTypeRelevancyService sceneExtractItemDocTypeRelevancyService;
    @Autowired
    private DocServiceImpl docService;
    @Autowired
    private IExtractCore extractCoreService;
    @Autowired
    private SceneTemplateRelevancyService sceneTemplateRelevancyService;
    @Resource
    private NodeTypeRelevancyService nodeTypeRelevancyService;
    @Autowired
    private SceneDocTypeRelevancyService sceneDocTypeRelevancyService;
    @Autowired
    private SceneRuleItemDocTypeRelevancyService sceneRuleItemDocTypeRelevancyService;
    @Autowired
    private DocTypeService docTypeService;
    @Autowired
    private SceneGroupService sceneGroupService;
    @Autowired
    private SceneDocTypeRelevancyMapper sceneDocTypeRelevancyMapper;
    @Autowired
    private SceneRuleReviewItemRelevancyMapper sceneRuleReviewItemRelevancyMapper;
    @Autowired
    private SceneTemplateRelevancyMapper sceneTemplateRelevancyMapper;
    @Autowired
    private NodeTypeFoldService nodeTypeFoldService;
    @Autowired
    private ICounterService iCounterService;
    @Autowired
    private IExtractChainService iExtractChainService;
    @Autowired
    private IRuleService iIRuleService;
    @Resource
    private ExtractItemMapper iExtractItemMapper;
    @Resource
    private UseHubTaskService useHubTaskService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateScene(ScenePo scenePo) {
        scenePo.setCreateTime(LocalDateTime.now());
        this.sceneMapper.update(scenePo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void insert(ScenePo scenePo) {
        scenePo.setDeleteFlag(Integer.valueOf(0));
        this.sceneMapper.insert(scenePo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteById(long sceneId) {
        ScenePo scenePo = (ScenePo)this.sceneMapper.selectById(Long.valueOf(sceneId));
        if (ObjectUtils.isEmpty((Object)scenePo)) {
            return;
        }
        this.sceneExtractItemDocTypeRelevancyService.delete(sceneId);
        this.sceneRuleExtractRelevancyService.delete(sceneId);
        this.sceneRuleReviewItemRelevancyService.delete(sceneId);
        this.sceneRuleLibRelevancyService.delete(sceneId);
        this.sceneRuleItemDocTypeRelevancyService.deleteBySceneId(sceneId);
        this.sceneDocTypeRelevancyService.deleteBySceneId(sceneId);
        if (Objects.equals(scenePo.getType(), 0)) {
            this.sceneTemplateRelevancyService.deleteBySceneId(sceneId);
        }
        this.sceneMapper.deleteById(sceneId);
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"rel_id", (Object)sceneId);
        List result = this.iCounterService.list((Wrapper)wrapper);
        if (result != null && !result.isEmpty()) {
            ArrayList<Long> ids = new ArrayList<Long>();
            for (Counter counter : result) {
                ids.add(counter.getId());
            }
            this.iCounterService.removeByIds(ids);
        }
    }

    @Override
    public ScenePo findById(long sceneId) {
        return (ScenePo)((SceneMapper)this.baseMapper).selectById(Long.valueOf(sceneId));
    }

    @Override
    public Page<SceneRuleLibDto> getSceneList(ScenePageVo pageQueryVo) {
        ArrayList<SceneRuleLibDto> sceneRuleLibDtoList = new ArrayList<SceneRuleLibDto>();
        Page page = new Page((long)pageQueryVo.getCurrent(), (long)pageQueryVo.getSize());
        Page page2 = new Page((long)pageQueryVo.getCurrent(), (long)pageQueryVo.getSize());
        QueryWrapper queryWrapper = new QueryWrapper();
        if (pageQueryVo.getName() != null && !pageQueryVo.getName().isEmpty()) {
            queryWrapper.like((Object)"name", (Object)pageQueryVo.getName());
        }
        page = (Page)this.sceneMapper.selectPage((IPage)page, (Wrapper)queryWrapper);
        List scenePoList = page.getRecords();
        for (ScenePo scenePo : scenePoList) {
            SceneRuleLibDto sceneRuleLibDto = new SceneRuleLibDto();
            sceneRuleLibDto.setSceneId(scenePo.getId());
            sceneRuleLibDto.setSceneName(scenePo.getName());
            sceneRuleLibDto.setCreator(scenePo.getCreator());
            sceneRuleLibDto.setRemark(scenePo.getRemark());
            sceneRuleLibDto.setGroupId(scenePo.getGroupId());
            sceneRuleLibDto.setCreateTime(scenePo.getCreateTime());
            sceneRuleLibDtoList.add(sceneRuleLibDto);
        }
        List scenePoTotalList = this.sceneMapper.selectList((Wrapper)queryWrapper);
        page2.setTotal((long)scenePoTotalList.size());
        page2.setRecords(sceneRuleLibDtoList);
        return page2;
    }

    @Override
    public List<GroupSceneDto> getSceneGroupAndList(SceneDto sceneDtoParam) {
        ArrayList<GroupSceneDto> groupSceneDtoList = new ArrayList<GroupSceneDto>();
        List<ScenePo> scenePoList = this.search(sceneDtoParam.getName(), null, null);
        List<SceneGroupPo> sceneGroupPoList = this.sceneGroupService.getSceneGroupList();
        for (ScenePo scenePo : scenePoList) {
            SceneDto sceneDto = new SceneDto(scenePo);
            Optional<SceneGroupPo> sceneGroupPoOptional = sceneGroupPoList.stream().filter(groupPo -> Objects.equals(groupPo.getId(), scenePo.getGroupId())).findFirst();
            if (groupSceneDtoList.stream().noneMatch(dto -> Objects.equals(dto.getGroupId(), scenePo.getGroupId())) && sceneGroupPoOptional.isPresent()) {
                GroupSceneDto groupSceneDto = new GroupSceneDto(scenePo.getGroupId(), sceneGroupPoOptional.get().getName(), sceneGroupPoOptional.get().getDescription(), sceneDto, sceneGroupPoOptional.get().getCreateTime());
                groupSceneDtoList.add(groupSceneDto);
                continue;
            }
            groupSceneDtoList.forEach(dto -> {
                if (dto.getGroupId() == scenePo.getGroupId()) {
                    dto.getSceneList().add(sceneDto);
                }
            });
        }
        return groupSceneDtoList;
    }

    @Override
    public List<GroupSceneDto> getSceneList() {
        List<SceneGroupPo> sceneGroupPoList = this.sceneGroupService.getSceneGroupList();
        ArrayList<GroupSceneDto> groupSceneDtoList = new ArrayList<GroupSceneDto>();
        for (SceneGroupPo sceneGroupPo : sceneGroupPoList) {
            List<ScenePo> scenePoList = this.sceneMapper.getSceneListByGroupId(sceneGroupPo.getId());
            ArrayList<SceneDto> sceneDtos = new ArrayList<SceneDto>();
            for (ScenePo scenePo : scenePoList) {
                SceneDto sceneDto = new SceneDto(scenePo);
                int docTypeCount = this.sceneDocTypeRelevancyMapper.getCountBySceneId(scenePo.getId());
                sceneDto.setDocTypeCount(docTypeCount);
                int ruleItemCount = this.sceneRuleReviewItemRelevancyMapper.getCountBySceneId(scenePo.getId());
                sceneDto.setRuleItemCount(ruleItemCount);
                int templateCount = this.sceneTemplateRelevancyMapper.getCountBySceneId(scenePo.getId());
                sceneDto.setTemplateCount(templateCount);
                sceneDtos.add(sceneDto);
            }
            GroupSceneDto groupSceneDto = new GroupSceneDto(sceneGroupPo, sceneDtos);
            groupSceneDtoList.add(groupSceneDto);
        }
        return groupSceneDtoList;
    }

    @Override
    public SceneDto getScene(long sceneId) {
        ScenePo scenePo = (ScenePo)this.sceneMapper.selectById(Long.valueOf(sceneId));
        SceneDto sceneDto = new SceneDto(scenePo);
        int docTypeCount = this.sceneDocTypeRelevancyMapper.getCountBySceneId(scenePo.getId());
        sceneDto.setDocTypeCount(docTypeCount);
        int ruleItemCount = this.sceneRuleReviewItemRelevancyMapper.getCountBySceneId(scenePo.getId());
        sceneDto.setRuleItemCount(ruleItemCount);
        int templateCount = this.sceneTemplateRelevancyMapper.getCountBySceneId(scenePo.getId());
        sceneDto.setTemplateCount(templateCount);
        return sceneDto;
    }

    @Override
    public List<GroupSceneDto> search2(String sceneName, String startCreateTime, String endCreateTime) {
        if (sceneName == null && startCreateTime == null && endCreateTime == null) {
            return null;
        }
        List<ScenePo> scenePoList = this.search(sceneName, startCreateTime, endCreateTime);
        ArrayList<GroupSceneDto> groupSceneDtoList = new ArrayList<GroupSceneDto>();
        List<SceneGroupPo> sceneGroupPoList = this.sceneGroupService.getSceneGroupList();
        for (ScenePo scenePo : scenePoList) {
            SceneDto sceneDto = new SceneDto(scenePo);
            Optional<SceneGroupPo> sceneGroupPoOptional = sceneGroupPoList.stream().filter(groupPo -> Objects.equals(groupPo.getId(), scenePo.getGroupId())).findFirst();
            int docTypeCount = this.sceneDocTypeRelevancyMapper.getCountBySceneId(scenePo.getId());
            sceneDto.setDocTypeCount(docTypeCount);
            int ruleItemCount = this.sceneRuleReviewItemRelevancyMapper.getCountBySceneId(scenePo.getId());
            sceneDto.setRuleItemCount(ruleItemCount);
            int templateCount = this.sceneTemplateRelevancyMapper.getCountBySceneId(scenePo.getId());
            sceneDto.setTemplateCount(templateCount);
            if (groupSceneDtoList.stream().noneMatch(dto -> Objects.equals(dto.getGroupId(), scenePo.getGroupId())) && sceneGroupPoOptional.isPresent()) {
                GroupSceneDto groupSceneDto = new GroupSceneDto(scenePo.getGroupId(), sceneGroupPoOptional.get().getName(), sceneGroupPoOptional.get().getDescription(), sceneDto, sceneGroupPoOptional.get().getCreateTime());
                groupSceneDtoList.add(groupSceneDto);
                continue;
            }
            groupSceneDtoList.forEach(dto -> {
                if (dto.getGroupId() == scenePo.getGroupId()) {
                    dto.getSceneList().add(sceneDto);
                }
            });
        }
        return groupSceneDtoList;
    }

    private LocalDateTime getDateTime(String dateString) {
        if (!dateString.isEmpty()) {
            dateString = dateString.replace("-", "");
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMddHHmmss");
            return LocalDateTime.parse(dateString, formatter);
        }
        return null;
    }

    @Override
    public List<ScenePo> search(String sceneName, String startCreateTime, String endCreateTime) {
        if (sceneName == null && startCreateTime == null && endCreateTime == null) {
            return null;
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        if (sceneName != null && !sceneName.isEmpty()) {
            queryWrapper.like((Object)"name", (Object)sceneName);
        }
        if (startCreateTime != null && !startCreateTime.isEmpty()) {
            queryWrapper.ge((Object)"create_time", (Object)this.getDateTime(startCreateTime + "000000"));
        }
        if (endCreateTime != null && !endCreateTime.isEmpty()) {
            queryWrapper.le((Object)"create_time", (Object)this.getDateTime(endCreateTime + "235959"));
        }
        return this.sceneMapper.selectList((Wrapper)queryWrapper);
    }

    @Override
    public Map<String, Object> getDocTypeData(Long sceneId) {
        List<DocTypeVo> docTypeVoList = this.sceneDocTypeRelevancyService.getDocTypeObjectList(sceneId);
        List nodeTypePoList = this.nodeTypeFoldService.findAll();
        ArrayList<NodeTypeDto> chosenDocTypeVoList = new ArrayList<NodeTypeDto>();
        for (DocTypeVo docTypeVo : docTypeVoList) {
            NodeTypeDto nodeTypeDto = new NodeTypeDto(docTypeVo);
            nodeTypeDto.setEnabled(docTypeVo.getEnabled());
            Optional<NodeTypePo> nodeTypePoOptional = nodeTypePoList.stream().filter(nodeTypePo -> Objects.equals(nodeTypePo.getId(), docTypeVo.getPid())).findFirst();
            nodeTypePoOptional.ifPresent(nodeTypePo -> nodeTypeDto.setCatalog(nodeTypePo.getName()));
            nodeTypeDto.setChosen(true);
            chosenDocTypeVoList.add(nodeTypeDto);
        }
        List nodeTypePoListTree = this.nodeTypeRelevancyService.queryTypeNodeTree(null);
        HashMap<String, Object> nodeTypeDataMap = new HashMap<String, Object>();
        nodeTypeDataMap.put("chosenDocTypeVoList", chosenDocTypeVoList);
        nodeTypeDataMap.put("nodeTypePoListTree", nodeTypePoListTree);
        return nodeTypeDataMap;
    }

    @Override
    public List<RuleLibVo> queryRuleLib(Long sceneId) {
        RuleLibQueryVo queryVo = new RuleLibQueryVo();
        queryVo.setSize(999);
        queryVo.setCurrent(1);
        queryVo.setPid(Long.valueOf(1L));
        queryVo.setChildCount(Integer.valueOf(1));
        queryVo.setQueryFlag(1);
        List ruleLibVoList = this.ruleService.queryRuleLibTree(queryVo);
        List<SceneRuleLibRelevancyPo> sceneRuleLibRelevancyPoList = this.sceneRuleLibRelevancyService.findAllBySceneId(sceneId);
        List chonseRuleLibIdList = sceneRuleLibRelevancyPoList.stream().map(SceneRuleLibRelevancyPo::getRuleLibId).collect(Collectors.toList());
        for (RuleLibVo ruleLibVo : ruleLibVoList) {
            if (ruleLibVo.getChildren() == null) continue;
            ruleLibVo.getChildren().forEach(item -> {
                if (item.getChildren() != null) {
                    item.setChildren(null);
                }
                if (chonseRuleLibIdList.contains(item.getId())) {
                    item.setChosen(true);
                }
            });
        }
        return ruleLibVoList;
    }

    @Override
    public List<RuleLibVo> queryRuleLibTree(int level) {
        RuleLibQueryVo queryVo = new RuleLibQueryVo();
        queryVo.setSize(999);
        queryVo.setCurrent(1);
        queryVo.setPid(Long.valueOf(1L));
        queryVo.setChildCount(Integer.valueOf(1));
        queryVo.setQueryFlag(1);
        List ruleLibVoList = this.ruleService.queryRuleLibTree(queryVo);
        if (level == 2) {
            for (RuleLibVo ruleLibVo : ruleLibVoList) {
                if (ruleLibVo.getChildren() == null) continue;
                ruleLibVo.getChildren().forEach(item -> {
                    if (item.getChildren() != null) {
                        item.setChildren(null);
                    }
                });
            }
        }
        return ruleLibVoList;
    }

    @Override
    public RuleLibVo getRuleLibVo(long ruleLibId) {
        Optional ruleLibVoOptional;
        RuleLibQueryVo ruleLibQueryVo = new RuleLibQueryVo();
        ruleLibQueryVo.setId(Long.valueOf(ruleLibId));
        Page ruleLibVoPage = this.ruleService.queryRuleLib(ruleLibQueryVo);
        if (!ObjectUtils.isEmpty((Object)ruleLibVoPage.getRecords()) && (ruleLibVoOptional = ruleLibVoPage.getRecords().stream().findFirst()).isPresent()) {
            return (RuleLibVo)ruleLibVoOptional.get();
        }
        return null;
    }

    @Override
    public List<RuleLibVo> getRuleLibItemTree(long sceneId) {
        List<SceneRuleLibRelevancyPo> sceneRuleLibRelevancyPoList = this.sceneRuleLibRelevancyService.findAllBySceneId(sceneId);
        ArrayList<RuleLibVo> ruleLibVoListAll = new ArrayList<RuleLibVo>();
        for (SceneRuleLibRelevancyPo po : sceneRuleLibRelevancyPoList) {
            RuleItemGroupQueryVo queryVo = new RuleItemGroupQueryVo();
            queryVo.setRuleLibId(Long.valueOf(po.getRuleLibId()));
            List ruleLibVoList = this.ruleService.queryRuleItemGroup(queryVo);
            if (ruleLibVoList.isEmpty()) continue;
            ruleLibVoListAll.addAll(ruleLibVoList);
        }
        return ruleLibVoListAll;
    }

    @Override
    public List<QueryRuleLibDto> getChosenRuleLib(Long sceneId) {
        List<SceneRuleLibRelevancyPo> sceneRuleLibRelevancyPoList = this.sceneRuleLibRelevancyService.findAllBySceneId(sceneId);
        ArrayList<QueryRuleLibDto> queryRuleLibDtoList = new ArrayList<QueryRuleLibDto>();
        for (SceneRuleLibRelevancyPo po : sceneRuleLibRelevancyPoList) {
            RuleLibVo ruleLibPo = this.getRuleLibVo(po.getRuleLibId());
            if (ruleLibPo == null) continue;
            RuleLibQueryVo queryVoTemp = new RuleLibQueryVo();
            queryVoTemp.setPid(Long.valueOf(po.getRuleLibId()));
            List ruleLibVoList = this.ruleService.queryRuleLibTree(queryVoTemp);
            for (RuleLibVo ruleLibVo : ruleLibVoList) {
                if (queryRuleLibDtoList.stream().anyMatch(dto -> dto.getRuleLibId() == ruleLibPo.getId().longValue())) {
                    for (QueryRuleLibDto queryRuleLibDto : queryRuleLibDtoList) {
                        if (queryRuleLibDto.getRuleLibId() != ruleLibPo.getId().longValue()) continue;
                        queryRuleLibDto.getRuleLibVoList().add(ruleLibVo);
                    }
                    continue;
                }
                QueryRuleLibDto queryRuleLibDto = new QueryRuleLibDto(ruleLibVo);
                queryRuleLibDto.setRuleLibId(ruleLibPo.getId().longValue());
                queryRuleLibDto.setRuleLibName(ruleLibPo.getLibName());
                queryRuleLibDtoList.add(queryRuleLibDto);
            }
        }
        return queryRuleLibDtoList;
    }

    @Override
    public List<RuleItemObject> queryRuleItemList(Long sceneId, Long[] ruleIdList) {
        ArrayList<RuleItemObject> ruleItemObjectList = new ArrayList<RuleItemObject>();
        RuleItemQueryVo itemQueryVo = new RuleItemQueryVo();
        itemQueryVo.setSize(999);
        itemQueryVo.setCurrent(1);
        itemQueryVo.setEnabled(Integer.valueOf(1));
        itemQueryVo.setRuleLibIds(ruleIdList);
        Page ruleItemVoPage = this.ruleService.queryRuleItem(itemQueryVo);
        List<DocTypeVo> docTypeVoList = this.sceneDocTypeRelevancyService.getDocTypeObjectList(sceneId);
        List<SceneRuleExtractRelevancyPo> sceneRuleExtractRelevancyPoAll = this.sceneRuleExtractRelevancyService.findAllBySceneId(sceneId);
        List<SceneRuleReviewItemRelevancyPo> sceneRuleReviewItemRelevancyPoList = this.sceneRuleReviewItemRelevancyService.findAllBySceneId(sceneId);
        List<SceneExtractItemDocTypeRelevancyPo> sceneExtractItemDocTypeRelevancyPoAll = this.sceneExtractItemDocTypeRelevancyService.getBySceneId(sceneId);
        List extractDocRelevancyPos = sceneExtractItemDocTypeRelevancyPoAll.stream().filter(item -> item.getExtractNodeId() == null).collect(Collectors.toList());
        List extractDocRelevancyNodePos = sceneExtractItemDocTypeRelevancyPoAll.stream().filter(item -> item.getExtractNodeId() != null).collect(Collectors.toList());
        HashMap nodeDocTypeMap = new HashMap();
        for (SceneExtractItemDocTypeRelevancyPo nodeDocTypePos : extractDocRelevancyNodePos) {
            List<Long> docTypeIdList;
            if (nodeDocTypeMap.containsKey(nodeDocTypePos.getExtractNodeId())) {
                docTypeIdList = (List)nodeDocTypeMap.get(nodeDocTypePos.getExtractNodeId());
                docTypeIdList.add(nodeDocTypePos.getDocTypeId());
                nodeDocTypeMap.put(nodeDocTypePos.getExtractNodeId(), docTypeIdList);
                continue;
            }
            docTypeIdList = new ArrayList<Long>();
            docTypeIdList.add(nodeDocTypePos.getDocTypeId());
            nodeDocTypeMap.put(nodeDocTypePos.getExtractNodeId(), docTypeIdList);
        }
        ExtractItemQuery queryVo = new ExtractItemQuery();
        List extractItems = this.iExtractItemMapper.getDtoList(queryVo);
        HashMap<String, Long> extractCodeRelationMap = new HashMap<String, Long>();
        for (ExtractItemDto extractItemDto : extractItems) {
            extractCodeRelationMap.put(extractItemDto.getCode(), extractItemDto.getId());
        }
        for (RuleItemVo ruleItemVo : ruleItemVoPage.getRecords()) {
            ArrayList<Long> needExtractItemId = new ArrayList<Long>();
            ArrayList<Long> matchExtractItemId = new ArrayList<Long>();
            Map codeMap = this.iIRuleService.queryRuleParam(ruleItemVo.getId());
            for (Map.Entry map : codeMap.entrySet()) {
                if (map.getKey() == null || "".equals(map.getKey())) continue;
                long tqId = (Long)extractCodeRelationMap.get(map.getKey());
                needExtractItemId.add(tqId);
            }
            RuleItemObject ruleItemObject = new RuleItemObject(ruleItemVo);
            ruleItemObject.setSceneId(sceneId.longValue());
            Optional<SceneRuleReviewItemRelevancyPo> sceneRuleReviewItemRelevancyPoOptional = sceneRuleReviewItemRelevancyPoList.stream().filter(po -> po.getRuleLibId() == ruleItemVo.getRuleLibId().longValue() && po.getRuleItemId() == ruleItemVo.getId().longValue()).findFirst();
            sceneRuleReviewItemRelevancyPoOptional.ifPresent(sceneRuleReviewItemRelevancyPo -> ruleItemObject.setEnabled(Integer.valueOf(sceneRuleReviewItemRelevancyPo.getEnabled())));
            ArrayList<ExtractItemObject> extractItemList = new ArrayList<ExtractItemObject>();
            List sceneRuleExtractRelevancyPoList = sceneRuleExtractRelevancyPoAll.parallelStream().filter(po -> po.getSceneId() == sceneId.longValue() && po.getRuleItemId() == ruleItemVo.getId().longValue()).collect(Collectors.toList());
            for (SceneRuleExtractRelevancyPo po2 : sceneRuleExtractRelevancyPoList) {
                List sceneExtractItemDocTypeRelevancyPoList = extractDocRelevancyPos.parallelStream().filter(relevancyPo -> relevancyPo.getSceneId() == sceneId.longValue() && relevancyPo.getExtractItemId() == po2.getExtractItemId() && relevancyPo.getRuleItemId() == po2.getRuleItemId()).collect(Collectors.toList());
                ArrayList chosenDocTypeIdList2ExtractItem = new ArrayList();
                for (SceneExtractItemDocTypeRelevancyPo po22 : sceneExtractItemDocTypeRelevancyPoList) {
                    if (!chosenDocTypeIdList2ExtractItem.stream().noneMatch(obj -> obj.longValue() == po22.getDocTypeId())) continue;
                    Optional<DocTypeVo> docTypeVoOptional = docTypeVoList.stream().filter(docTypeVo -> docTypeVo.getId().longValue() == po22.getDocTypeId()).findFirst();
                    docTypeVoOptional.ifPresent(docTypeVo -> chosenDocTypeIdList2ExtractItem.add(docTypeVo.getId()));
                }
                ExtractItem extractItem = this.extractCoreService.findById(po2.getExtractItemId());
                int type = extractItem.getMethod();
                ExtractItemObject extractItemObject = new ExtractItemObject(extractItem);
                extractItemObject.setDocTypeIdList(chosenDocTypeIdList2ExtractItem);
                extractItemObject.setDocTypeVoList(docTypeVoList);
                if (type == 1) {
                    extractItemObject.setMethod(1);
                    List extractNodeList = this.iExtractChainService.getInputNode(extractItem.getId());
                    for (ExtractNode extractNode : extractNodeList) {
                        List typeIdList = (List)nodeDocTypeMap.get(extractNode.getId());
                        extractNode.setDocTypeIdList(typeIdList);
                    }
                    extractItemObject.setExtractNodeList(extractNodeList);
                }
                matchExtractItemId.add(extractItem.getId());
                extractItemList.add(extractItemObject);
            }
            if (!needExtractItemId.isEmpty()) {
                for (Long id : needExtractItemId) {
                    if (matchExtractItemId.contains(id)) continue;
                    ExtractItem extractItem = this.extractCoreService.findById(id.longValue());
                    int type = extractItem.getMethod();
                    ExtractItemObject extractItemObject = new ExtractItemObject(extractItem);
                    if (type == 1) {
                        extractItemObject.setMethod(1);
                        List extractNodeList = this.iExtractChainService.getInputNode(extractItem.getId());
                        for (ExtractNode extractNode : extractNodeList) {
                            List typeIdList = (List)nodeDocTypeMap.get(extractNode.getId());
                            extractNode.setDocTypeIdList(typeIdList);
                        }
                        extractItemObject.setExtractNodeList(extractNodeList);
                    }
                    extractItemList.add(extractItemObject);
                }
            }
            ruleItemObject.setExtractItemList(extractItemList);
            ruleItemObjectList.add(ruleItemObject);
        }
        return ruleItemObjectList;
    }

    private SceneRuleReviewItemRelevancyPo getSceneRuleReviewItemRelevancyPo(RuleItemObject ruleItemObject) {
        SceneRuleReviewItemRelevancyPo sceneRuleReviewItemRelevancyPo = new SceneRuleReviewItemRelevancyPo();
        sceneRuleReviewItemRelevancyPo.setId(SnowFlakeUtil.getFlowIdInstance().nextId());
        sceneRuleReviewItemRelevancyPo.setSceneId(ruleItemObject.getSceneId());
        sceneRuleReviewItemRelevancyPo.setRuleLibId(ruleItemObject.getRuleLibId());
        sceneRuleReviewItemRelevancyPo.setRuleItemId(ruleItemObject.getRuleItemId());
        sceneRuleReviewItemRelevancyPo.setEnabled(ruleItemObject.getEnabled().intValue());
        return sceneRuleReviewItemRelevancyPo;
    }

    private SceneRuleExtractRelevancyPo getSceneRuleExtractRelevancyPo(long sceneId, long extractItemId, long ruleItemId) {
        SceneRuleExtractRelevancyPo sceneRuleExtractRelevancyPo = new SceneRuleExtractRelevancyPo();
        sceneRuleExtractRelevancyPo.setExtractItemId(extractItemId);
        sceneRuleExtractRelevancyPo.setRuleItemId(ruleItemId);
        sceneRuleExtractRelevancyPo.setSceneId(sceneId);
        sceneRuleExtractRelevancyPo.setId(SnowFlakeUtil.getFlowIdInstance().nextId());
        return sceneRuleExtractRelevancyPo;
    }

    private SceneExtractItemDocTypeRelevancyPo getSceneExtractDocRelevancyPo(long sceneId, long ruleItemId, long extractItemId, String extractNodeId, long docTypeId) {
        SceneExtractItemDocTypeRelevancyPo po = new SceneExtractItemDocTypeRelevancyPo();
        po.setId(SnowFlakeUtil.getFlowIdInstance().nextId());
        po.setSceneId(sceneId);
        po.setRuleItemId(ruleItemId);
        po.setExtractItemId(extractItemId);
        po.setDocTypeId(docTypeId);
        if (extractNodeId != null && !"".equals(extractNodeId)) {
            po.setExtractNodeId(extractNodeId);
        }
        return po;
    }

    private SceneRuleItemDocTypeRelevancyPo getSceneRuleItemDocTypeRelevancyPo(long sceneId, long ruleItemId, long docTypeId) {
        SceneRuleItemDocTypeRelevancyPo po2 = new SceneRuleItemDocTypeRelevancyPo();
        po2.setId(SnowFlakeUtil.getFlowIdInstance().nextId());
        po2.setSceneId(sceneId);
        po2.setDocTypeId(docTypeId);
        po2.setRuleItemId(ruleItemId);
        return po2;
    }

    @Override
    public void saveRuleItemList(List<RuleItemObject> ruleItemObjectList) {
        if (ObjectUtils.isEmpty(ruleItemObjectList) || ruleItemObjectList.isEmpty()) {
            return;
        }
        long sceneId1 = ruleItemObjectList.get(0).getSceneId();
        List<SceneRuleExtractRelevancyPo> extractPoExist = this.sceneRuleExtractRelevancyService.findAllBySceneId(sceneId1);
        HashMap<Long, Integer> extractOldMap = new HashMap<Long, Integer>();
        if (extractPoExist != null && !extractPoExist.isEmpty()) {
            for (SceneRuleExtractRelevancyPo sceneRuleExtractRelevancyPo : extractPoExist) {
                long extractId = sceneRuleExtractRelevancyPo.getExtractItemId();
                if (extractOldMap.containsKey(extractId)) {
                    int count = (Integer)extractOldMap.get(extractId);
                    extractOldMap.put(extractId, count + 1);
                    continue;
                }
                extractOldMap.put(extractId, 1);
            }
        }
        this.sceneExtractItemDocTypeRelevancyService.delete(sceneId1);
        this.sceneRuleExtractRelevancyService.delete(sceneId1);
        this.sceneRuleReviewItemRelevancyService.delete(sceneId1);
        this.sceneRuleItemDocTypeRelevancyService.deleteBySceneId(sceneId1);
        ArrayList<SceneRuleReviewItemRelevancyPo> sceneRuleReviewItemRelevancyPoList = new ArrayList<SceneRuleReviewItemRelevancyPo>();
        ArrayList<SceneRuleExtractRelevancyPo> sceneRuleExtractRelevancyPoList = new ArrayList<SceneRuleExtractRelevancyPo>();
        ArrayList<SceneExtractItemDocTypeRelevancyPo> sceneExtractDocRelevancyPoList = new ArrayList<SceneExtractItemDocTypeRelevancyPo>();
        ArrayList<SceneRuleItemDocTypeRelevancyPo> sceneRuleItemDocTypeRelevancyPoList = new ArrayList<SceneRuleItemDocTypeRelevancyPo>();
        for (RuleItemObject ruleItemObject : ruleItemObjectList) {
            long sceneId = ruleItemObject.getSceneId();
            long ruleItemId = ruleItemObject.getRuleItemId();
            sceneRuleReviewItemRelevancyPoList.add(this.getSceneRuleReviewItemRelevancyPo(ruleItemObject));
            for (ExtractItemObject item : ruleItemObject.getExtractItemList()) {
                Long extractItemId = item.getId();
                if (extractItemId == null) {
                    ExtractItem extractItem = new ExtractItem();
                    extractItem.setName(item.getName());
                    extractItem.setDescription(item.getDescription());
                    extractItem.setReturnType(item.getReturnType());
                    extractItem.setMethod(Integer.valueOf(item.getMethod()));
                    extractItemId = this.extractCoreService.save(extractItem);
                }
                sceneRuleExtractRelevancyPoList.add(this.getSceneRuleExtractRelevancyPo(sceneId, extractItemId, ruleItemId));
                int type = item.getMethod();
                ArrayList<Long> docTypeIdAllList = new ArrayList<Long>();
                if (type == 1) {
                    List extractNodeList = item.getExtractNodeList();
                    for (ExtractNode extractNode : extractNodeList) {
                        Iterator iterator = extractNode.getDocTypeIdList().iterator();
                        while (iterator.hasNext()) {
                            long docTypeId = (Long)iterator.next();
                            sceneExtractDocRelevancyPoList.add(this.getSceneExtractDocRelevancyPo(sceneId, ruleItemId, extractItemId, extractNode.getId(), docTypeId));
                            if (docTypeIdAllList.contains(docTypeId)) continue;
                            sceneRuleItemDocTypeRelevancyPoList.add(this.getSceneRuleItemDocTypeRelevancyPo(sceneId, ruleItemId, docTypeId));
                            docTypeIdAllList.add(docTypeId);
                        }
                    }
                    continue;
                }
                Iterator iterator = item.getDocTypeIdList().iterator();
                while (iterator.hasNext()) {
                    long docTypeId = (Long)iterator.next();
                    sceneExtractDocRelevancyPoList.add(this.getSceneExtractDocRelevancyPo(sceneId, ruleItemId, extractItemId, null, docTypeId));
                    sceneRuleItemDocTypeRelevancyPoList.add(this.getSceneRuleItemDocTypeRelevancyPo(sceneId, ruleItemId, docTypeId));
                    docTypeIdAllList.add(docTypeId);
                }
            }
        }
        this.sceneRuleReviewItemRelevancyService.saveBatch(sceneRuleReviewItemRelevancyPoList);
        this.sceneRuleExtractRelevancyService.saveBatch(sceneRuleExtractRelevancyPoList);
        this.sceneExtractItemDocTypeRelevancyService.saveBatch(sceneExtractDocRelevancyPoList);
        this.sceneRuleItemDocTypeRelevancyService.saveBatch(sceneRuleItemDocTypeRelevancyPoList);
        HashMap<Long, Integer> extractNewMap = new HashMap<Long, Integer>();
        for (SceneRuleExtractRelevancyPo sceneRuleExtractRelevancyPo : sceneRuleExtractRelevancyPoList) {
            long extractId = sceneRuleExtractRelevancyPo.getExtractItemId();
            if (extractNewMap.containsKey(extractId)) {
                int count = (Integer)extractNewMap.get(extractId);
                extractNewMap.put(extractId, count + 1);
                continue;
            }
            extractNewMap.put(extractId, 1);
        }
        HashMap<Long, Integer> hashMap = new HashMap<Long, Integer>();
        HashMap<Long, Integer> extractReduceMap = new HashMap<Long, Integer>();
        for (Map.Entry newMap : extractNewMap.entrySet()) {
            long key = (Long)newMap.getKey();
            int value = (Integer)newMap.getValue();
            if (extractOldMap.containsKey(key)) {
                int result = (Integer)extractOldMap.get(key) - value;
                if (result > 0) {
                    extractReduceMap.put(key, result);
                    continue;
                }
                if (result >= 0) continue;
                hashMap.put(key, -result);
                continue;
            }
            hashMap.put(key, value);
        }
        for (Map.Entry oldMap : extractOldMap.entrySet()) {
            long oldKey = (Long)oldMap.getKey();
            if (extractNewMap.containsKey(oldKey)) continue;
            extractReduceMap.put(oldKey, (Integer)oldMap.getValue());
        }
        if (!hashMap.isEmpty()) {
            for (Map.Entry addMap : hashMap.entrySet()) {
                int loopCount = (Integer)addMap.getValue();
                for (int i = 1; i <= loopCount; ++i) {
                    this.iCounterService.add((Long)addMap.getKey(), Long.valueOf(sceneId1), "1", "1");
                }
            }
        }
        if (!extractReduceMap.isEmpty()) {
            for (Map.Entry reduceMap : extractReduceMap.entrySet()) {
                int loopCount = (Integer)reduceMap.getValue();
                for (int i = 1; i <= loopCount; ++i) {
                    this.iCounterService.subtract((Long)reduceMap.getKey(), Long.valueOf(sceneId1), "1", "1");
                }
            }
        }
    }

    @Override
    public List<SceneConfigResult> getConfigResultList(long sceneId) {
        ArrayList<SceneConfigResult> sceneConfigResultList = new ArrayList<SceneConfigResult>();
        List<SceneRuleLibRelevancyPo> sceneRuleLibRelevancyPoList = this.sceneRuleLibRelevancyService.findAllBySceneId(sceneId);
        List<SceneDocTypeRelevancyPo> sceneDocTypeRelevancyPoList = this.sceneDocTypeRelevancyService.findBySceneId(sceneId);
        List docTypeIdList = sceneDocTypeRelevancyPoList.stream().map(SceneDocTypeRelevancyPo::getDocTypeId).collect(Collectors.toList());
        for (Long docTypeId : docTypeIdList) {
            ArrayList<Long> ruleLibIdList = new ArrayList<Long>();
            ArrayList<RuleLibVo> ruleLibList = new ArrayList<RuleLibVo>();
            for (SceneRuleLibRelevancyPo ruleLibRelevancyPo : sceneRuleLibRelevancyPoList) {
                long ruleLibId = ruleLibRelevancyPo.getRuleLibId();
                RuleLibVo ruleLibVo1 = this.getRuleLibVo(ruleLibId);
                String ruleLibName = ruleLibVo1.getLibName();
                RuleLibQueryVo ruleLibQueryVo = new RuleLibQueryVo();
                ruleLibQueryVo.setPid(Long.valueOf(ruleLibId));
                ruleLibQueryVo.setQueryFlag(1);
                Page ruleLibVoPage = this.ruleService.queryRuleLib(ruleLibQueryVo);
                for (RuleLibVo ruleLibVo : ruleLibVoPage.getRecords()) {
                    List<SceneRuleReviewItemRelevancyPo> sceneRuleReviewItemRelevancyPoList = this.sceneRuleReviewItemRelevancyService.findAllByRuleLibId(ruleLibVo.getId());
                    for (SceneRuleReviewItemRelevancyPo po : sceneRuleReviewItemRelevancyPoList) {
                        List<SceneRuleItemDocTypeRelevancyPo> ruleItemDocTypeRelevancyPoList = this.sceneRuleItemDocTypeRelevancyService.getByRuleItemId(sceneId, po.getRuleItemId());
                        if (!ruleItemDocTypeRelevancyPoList.stream().anyMatch(item -> item.getDocTypeId() == docTypeId.longValue()) || ruleLibIdList.contains(ruleLibId)) continue;
                        ruleLibIdList.add(ruleLibId);
                        RuleLibVo ruleLibVo2 = new RuleLibVo();
                        ruleLibVo2.setId(Long.valueOf(ruleLibId));
                        ruleLibVo2.setLibName(ruleLibName);
                        ruleLibList.add(ruleLibVo2);
                    }
                }
            }
            DocTypeVo docTypeVo = this.docTypeService.queryDocTypeById(docTypeId);
            SceneConfigResult sceneConfigResult = new SceneConfigResult(docTypeVo, ruleLibIdList, ruleLibList);
            sceneConfigResultList.add(sceneConfigResult);
        }
        return sceneConfigResultList;
    }

    @Override
    public List<ScenePo> findByGroupId(long groupId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"group_id", (Object)groupId);
        return this.sceneMapper.selectList((Wrapper)queryWrapper);
    }

    @Override
    public int getSceneCount() {
        return this.sceneMapper.getSceneCount();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteByExtractItemId(long extractItemId) {
        if (ObjectUtils.isEmpty((Object)extractItemId)) {
            return;
        }
        this.sceneRuleExtractRelevancyService.deleteByExtractItemId(extractItemId);
        this.sceneExtractItemDocTypeRelevancyService.deleteByExtractItemId(extractItemId);
    }
}

