/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.scene.server.controller;

import com.jxdinfo.idp.common.response.ApiResponse;
import com.jxdinfo.idp.scene.api.po.SceneRuleExtractRelevancyPo;
import com.jxdinfo.idp.scene.api.po.SceneRuleReviewItemRelevancyPo;
import com.jxdinfo.idp.scene.server.service.SceneRuleExtractRelevancyService;
import com.jxdinfo.idp.scene.server.service.impl.SceneRuleReviewItemRelevancyServiceImpl;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/scene/ruleReview"})
public class SceneRuleReviewItemRelevancyController {
    private static final Logger log = LoggerFactory.getLogger(SceneRuleReviewItemRelevancyController.class);
    @Resource
    private SceneRuleReviewItemRelevancyServiceImpl sceneRuleReviewItemRelevancyService;
    @Autowired
    private SceneRuleExtractRelevancyService sceneRuleExtractRelevancyService;

    @PostMapping(value={"/add"})
    public ApiResponse<Void> add(@RequestParam List<SceneRuleReviewItemRelevancyPo> objects) {
        objects.forEach(obj -> this.sceneRuleReviewItemRelevancyService.add((SceneRuleReviewItemRelevancyPo)obj));
        return ApiResponse.success();
    }

    @PostMapping(value={"/update"})
    public ApiResponse<Void> update(@RequestParam List<SceneRuleReviewItemRelevancyPo> objects) {
        objects.forEach(obj -> this.sceneRuleReviewItemRelevancyService.updateById(obj));
        return ApiResponse.success();
    }

    @GetMapping(value={"/getBySceneId"})
    public ApiResponse<List<SceneRuleReviewItemRelevancyPo>> getBySceneId(@RequestParam long sceneId) {
        return ApiResponse.success(this.sceneRuleReviewItemRelevancyService.findAllBySceneId(sceneId));
    }

    @GetMapping(value={"/getExtractItems"})
    public ApiResponse<List<Long>> getExtractItems(@RequestParam long sceneId, @RequestParam long ruleItemId) {
        List<SceneRuleExtractRelevancyPo> sceneRuleExtractRelevancyPoList = this.sceneRuleExtractRelevancyService.findBySceneIdAndRuleItemId(sceneId, ruleItemId);
        List extractItemIdList = sceneRuleExtractRelevancyPoList.stream().map(SceneRuleExtractRelevancyPo::getExtractItemId).collect(Collectors.toList());
        return ApiResponse.success(extractItemIdList);
    }
}

