/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.scene.server.controller;

import com.jxdinfo.idp.common.response.ApiResponse;
import com.jxdinfo.idp.scene.api.dto.SceneDocTypeSaveDto;
import com.jxdinfo.idp.scene.server.service.impl.SceneDocTypeRelevancyServiceImpl;
import com.jxdinfo.idp.vo.DocTypeVo;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/scene/docType"})
public class SceneDocTypeController {
    @Autowired
    private SceneDocTypeRelevancyServiceImpl sceneDocTypeRelevancyService;

    @PostMapping(value={"/insertOrUpdate"})
    public ApiResponse<Void> insertOrUpdate(@RequestBody SceneDocTypeSaveDto sceneDocTypeSaveDto) {
        this.sceneDocTypeRelevancyService.insertOrUpdate(sceneDocTypeSaveDto);
        return ApiResponse.success();
    }

    @GetMapping(value={"/getDocTypeList"})
    public ApiResponse<List<DocTypeVo>> getDocTypeList(@RequestParam long sceneId) {
        List<DocTypeVo> docTypeVoList = this.sceneDocTypeRelevancyService.getDocTypeObjectList(sceneId);
        return ApiResponse.success(docTypeVoList);
    }

    @GetMapping(value={"/delete"})
    public ApiResponse<Void> delete(@RequestParam long docTypeId) {
        this.sceneDocTypeRelevancyService.deleteByDocTypeId(docTypeId);
        return ApiResponse.success();
    }
}

