/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.scene.server.extend;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.idp.common.base.dto.ImplCodeDto;
import com.jxdinfo.idp.dm.server.service.impl.DocServiceImpl;
import com.jxdinfo.idp.dm.server.service.impl.FileSystemServiceImpl;
import com.jxdinfo.idp.extract.domain.po.ExtractItem;
import com.jxdinfo.idp.extract.interf.impl.ExtractCoreImpl;
import com.jxdinfo.idp.extract.service.IExtractItemService;
import com.jxdinfo.idp.interf.DocTypeService;
import com.jxdinfo.idp.rule.api.service.IRuleService;
import com.jxdinfo.idp.rule.api.vo.RuleLibQueryVo;
import com.jxdinfo.idp.rule.api.vo.RuleLibVo;
import com.jxdinfo.idp.scene.api.dto.SceneConfigDto;
import com.jxdinfo.idp.scene.api.dto.SceneDocInfoDto;
import com.jxdinfo.idp.scene.api.dto.SceneExtractItemDto;
import com.jxdinfo.idp.scene.api.dto.SceneRuleLibDto;
import com.jxdinfo.idp.scene.api.extend.SceneConfigExpandBuild;
import com.jxdinfo.idp.scene.api.po.SceneExtractItemDocTypeRelevancyPo;
import com.jxdinfo.idp.scene.api.po.ScenePo;
import com.jxdinfo.idp.scene.api.po.SceneRuleLibRelevancyPo;
import com.jxdinfo.idp.scene.container.ConfigBuildMap;
import com.jxdinfo.idp.scene.server.service.SceneExtractItemDocTypeRelevancyService;
import com.jxdinfo.idp.scene.server.service.impl.SceneRuleExtractRelevancyServiceImpl;
import com.jxdinfo.idp.scene.server.service.impl.SceneRuleLibRelevancyServiceImpl;
import com.jxdinfo.idp.scene.server.service.impl.SceneRuleReviewItemRelevancyServiceImpl;
import com.jxdinfo.idp.scene.server.service.impl.SceneServiceImpl;
import com.jxdinfo.idp.vo.DocTypeVo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class SceneConfigExpandBuildImpl
implements SceneConfigExpandBuild {
    private static final Logger log = LoggerFactory.getLogger(SceneConfigExpandBuildImpl.class);
    @Autowired
    private DocServiceImpl docService;
    @Autowired
    private FileSystemServiceImpl fileSystemService;
    @Autowired
    private SceneServiceImpl sceneService;
    @Autowired
    private SceneRuleLibRelevancyServiceImpl sceneRuleLibRelevancyService;
    @Autowired
    private ExtractCoreImpl extractCoreService;
    @Autowired
    private SceneRuleReviewItemRelevancyServiceImpl sceneRuleReviewItemRelevancyService;
    @Autowired
    private SceneRuleExtractRelevancyServiceImpl sceneRuleExtractRelevancyService;
    @Autowired
    private SceneExtractItemDocTypeRelevancyService sceneExtractDocRelevancyService;
    @Autowired
    private IExtractItemService extractItemService;
    @Autowired
    private DocTypeService docTypeService;
    @Autowired
    private IRuleService ruleService;

    public ImplCodeDto getImplCode() {
        return new ImplCodeDto("SceneConfigExpandBuildImpl", "\u573a\u666f\u914d\u7f6e\u6267\u884c\u6269\u5c55\u63a5\u53e3\u5b9e\u73b0");
    }

    public void initMap() {
        ConfigBuildMap.put((String)this.getImplCode().getImplCode(), (SceneConfigExpandBuild)this);
    }

    public SceneConfigDto build(SceneConfigDto sceneConfigDto) {
        this.initBasicInfo(sceneConfigDto);
        this.initRelation(sceneConfigDto);
        return sceneConfigDto;
    }

    public void initBasicInfo(SceneConfigDto sceneConfigDto) {
        ScenePo scenePo = (ScenePo)this.sceneService.getById(sceneConfigDto.getSceneId());
        sceneConfigDto.setSceneName(scenePo.getName());
        sceneConfigDto.setRemark(scenePo.getRemark());
        sceneConfigDto.setSceneType(sceneConfigDto.getSceneType());
    }

    public void initTemplateList(SceneConfigDto sceneConfigDto) {
    }

    public void initExtractItemList(SceneConfigDto sceneConfigDto) {
        super.initExtractItemList(sceneConfigDto);
    }

    private RuleLibVo getRuleLibVo(long ruleLibId) {
        Optional ruleLibVoOptional;
        RuleLibQueryVo ruleLibQueryVo = new RuleLibQueryVo();
        ruleLibQueryVo.setId(Long.valueOf(ruleLibId));
        Page ruleLibVoPage = this.ruleService.queryRuleLib(ruleLibQueryVo);
        if (!ObjectUtils.isEmpty((Object)ruleLibVoPage.getRecords()) && (ruleLibVoOptional = ruleLibVoPage.getRecords().stream().findFirst()).isPresent()) {
            return (RuleLibVo)ruleLibVoOptional.get();
        }
        return null;
    }

    public void initRuleLibList(SceneConfigDto sceneConfigDto) {
        super.initRuleLibList(sceneConfigDto);
        List<SceneRuleLibRelevancyPo> sceneRuleLibRelevancyPoList = this.sceneRuleLibRelevancyService.findAllBySceneId(sceneConfigDto.getSceneId());
        if (ObjectUtils.isEmpty(sceneRuleLibRelevancyPoList)) {
            return;
        }
        List ruleLibList = sceneRuleLibRelevancyPoList.stream().map(SceneRuleLibRelevancyPo::getRuleLibId).collect(Collectors.toList());
        ArrayList<SceneRuleLibDto> sceneRuleLibDtoList = new ArrayList<SceneRuleLibDto>();
        for (Long ruleLibId : ruleLibList) {
            RuleLibVo ruleLibPo = this.getRuleLibVo(ruleLibId);
            if (ruleLibPo == null) continue;
            SceneRuleLibDto sceneRuleLibDto = new SceneRuleLibDto(ruleLibPo);
            sceneRuleLibDtoList.add(sceneRuleLibDto);
        }
        sceneConfigDto.setRuleLibList(sceneRuleLibDtoList);
    }

    public void initReviewDocList(SceneConfigDto sceneConfigDto) {
        super.initReviewDocList(sceneConfigDto);
    }

    public void initRelation(SceneConfigDto sceneConfigDto) {
        HashMap<SceneDocInfoDto, List<SceneExtractItemDto>> docTypeAndExtractItemsMap = new HashMap<SceneDocInfoDto, List<SceneExtractItemDto>>();
        HashMap<String, String> extractInfoMap = new HashMap<String, String>();
        List<SceneExtractItemDocTypeRelevancyPo> sceneExtractDocRelevancyPoList = this.sceneExtractDocRelevancyService.findAllBySceneId(sceneConfigDto.getSceneId());
        HashMap<Long, List<String>> extractItemNodeMap = new HashMap<Long, List<String>>();
        if (sceneExtractDocRelevancyPoList != null && !sceneExtractDocRelevancyPoList.isEmpty()) {
            List extractDocRelevancyNodePos = sceneExtractDocRelevancyPoList.stream().filter(item -> item.getExtractNodeId() != null).collect(Collectors.toList());
            for (SceneExtractItemDocTypeRelevancyPo pos : extractDocRelevancyNodePos) {
                List<String> ids;
                long extractId = pos.getExtractItemId();
                if (extractItemNodeMap.containsKey(extractId)) {
                    ids = (List)extractItemNodeMap.get(extractId);
                    if (ids.contains(pos.getExtractNodeId())) continue;
                    ids.add(pos.getExtractNodeId());
                    extractItemNodeMap.put(extractId, ids);
                    continue;
                }
                ids = new ArrayList<String>();
                ids.add(pos.getExtractNodeId());
                extractItemNodeMap.put(extractId, ids);
            }
        }
        List docTypeVoList = this.docTypeService.getDocTypeList();
        for (SceneExtractItemDocTypeRelevancyPo extractDocRelevancyPo : sceneExtractDocRelevancyPoList) {
            List<SceneExtractItemDto> extractItemDtoList;
            Optional<DocTypeVo> docTypeVoOptional1 = docTypeVoList.stream().filter(doc -> doc.getId().longValue() == extractDocRelevancyPo.getDocTypeId()).findFirst();
            ExtractItem extractItem = this.extractItemService.findById(extractDocRelevancyPo.getExtractItemId());
            if (!docTypeVoOptional1.isPresent()) {
                return;
            }
            SceneDocInfoDto docInfoDto = new SceneDocInfoDto(docTypeVoOptional1.get());
            ArrayList docInfoList = new ArrayList();
            List<SceneExtractItemDocTypeRelevancyPo> sceneExtractDocRelevancyPos = sceneExtractDocRelevancyPoList.stream().filter(item -> item.getExtractItemId() == extractItem.getId().longValue()).collect(Collectors.toList());
            sceneExtractDocRelevancyPos.forEach(item -> {
                SceneDocInfoDto docInfoDto1;
                Optional<DocTypeVo> docTypeVoOptional = docTypeVoList.stream().filter(doc -> doc.getId().longValue() == item.getDocTypeId()).findFirst();
                if (docTypeVoOptional.isPresent() && !docInfoList.contains(docInfoDto1 = new SceneDocInfoDto(docTypeVoOptional.get()))) {
                    docInfoList.add(docInfoDto1);
                }
            });
            SceneExtractItemDto extractItemDto = new SceneExtractItemDto(extractItem, docInfoList);
            if (extractItemNodeMap.containsKey(extractDocRelevancyPo.getExtractItemId())) {
                extractItemDto.setMethod(Integer.valueOf(1));
                extractItemDto.setExtractNodeIdList((List)extractItemNodeMap.get(extractDocRelevancyPo.getExtractItemId()));
            } else {
                extractItemDto.setMethod(Integer.valueOf(0));
            }
            if (docTypeAndExtractItemsMap.get(docInfoDto) == null) {
                extractItemDtoList = new ArrayList<SceneExtractItemDto>();
                extractItemDtoList.add(extractItemDto);
                docTypeAndExtractItemsMap.put(docInfoDto, extractItemDtoList);
            } else {
                extractItemDtoList = (List)docTypeAndExtractItemsMap.get(docInfoDto);
                if (!extractItemDtoList.contains(extractItemDto)) {
                    extractItemDtoList.add(extractItemDto);
                    docTypeAndExtractItemsMap.put(docInfoDto, extractItemDtoList);
                }
            }
            if (extractInfoMap.containsKey(extractItemDto.getCode())) continue;
            extractInfoMap.put(extractItemDto.getCode(), String.valueOf(extractItemDto.getExtractItemId()));
        }
        sceneConfigDto.setDocTypeAndExtractItemsMap(docTypeAndExtractItemsMap);
        sceneConfigDto.setExtractInfoMap(extractInfoMap);
    }
}

