/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.scene.server.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.idp.rule.server.service.RemoveSceneExtractItemDocTypeService;
import com.jxdinfo.idp.scene.api.po.SceneExtractItemDocTypeRelevancyPo;
import com.jxdinfo.idp.scene.server.mapper.SceneExtractItemDocTypeRelevancyMapper;
import com.jxdinfo.idp.scene.server.service.SceneExtractItemDocTypeRelevancyService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Service
public class SceneExtractItemDocTypeRelevancyServiceImpl
extends ServiceImpl<SceneExtractItemDocTypeRelevancyMapper, SceneExtractItemDocTypeRelevancyPo>
implements SceneExtractItemDocTypeRelevancyService,
RemoveSceneExtractItemDocTypeService {
    @Autowired
    private SceneExtractItemDocTypeRelevancyMapper sceneExtractItemDocTypeRelevancyMapper;

    @Override
    public List<SceneExtractItemDocTypeRelevancyPo> getBySceneIdAndExtractItemId(long sceneId, long extractItemId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"extract_item_id", (Object)extractItemId);
        queryWrapper.eq((Object)"scene_id", (Object)sceneId);
        return ((SceneExtractItemDocTypeRelevancyMapper)this.baseMapper).selectList((Wrapper)queryWrapper);
    }

    @Override
    public List<SceneExtractItemDocTypeRelevancyPo> getBySceneId(long sceneId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"scene_id", (Object)sceneId);
        queryWrapper.eq((Object)"delete_flag", (Object)0);
        return ((SceneExtractItemDocTypeRelevancyMapper)this.baseMapper).selectList((Wrapper)queryWrapper);
    }

    @Override
    public List<SceneExtractItemDocTypeRelevancyPo> findByDocTypeId(long docTypeId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"doc_type_id", (Object)docTypeId);
        return ((SceneExtractItemDocTypeRelevancyMapper)this.baseMapper).selectList((Wrapper)queryWrapper);
    }

    @Override
    public List<SceneExtractItemDocTypeRelevancyPo> findAllBySceneId(long sceneId) {
        return this.sceneExtractItemDocTypeRelevancyMapper.findAllBySceneId(sceneId);
    }

    @Override
    public List<SceneExtractItemDocTypeRelevancyPo> findByExtractItemId(long extractItemId) {
        return this.sceneExtractItemDocTypeRelevancyMapper.findByExtractItemId(extractItemId);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBySceneIdAndExtractItemId(long sceneId, long extractItemId) {
        this.sceneExtractItemDocTypeRelevancyMapper.deleteBySceneIdAndExtractItemId(sceneId, extractItemId);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void delete(long sceneId) {
        this.sceneExtractItemDocTypeRelevancyMapper.deleteBySceneId(sceneId);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void delete(long sceneId, List<Long> templateIdList) {
        if (!ObjectUtils.isEmpty(templateIdList)) {
            this.sceneExtractItemDocTypeRelevancyMapper.deleteBySceneIdAndTemplateId(sceneId, templateIdList);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteByDocTypeId(long docTypeId) {
        this.sceneExtractItemDocTypeRelevancyMapper.deleteByDocTypeId(docTypeId);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void add(SceneExtractItemDocTypeRelevancyPo po) {
        this.sceneExtractItemDocTypeRelevancyMapper.insert(po);
    }

    @Override
    public void deleteById(List<Long> idList) {
        if (!ObjectUtils.isEmpty(idList)) {
            this.sceneExtractItemDocTypeRelevancyMapper.deleteByBusinessId(idList);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteByExtractItemId(long extractItemId) {
        this.sceneExtractItemDocTypeRelevancyMapper.deleteByExtractItemId(extractItemId);
    }

    public void removeItem(Long ruleItemId) {
        this.sceneExtractItemDocTypeRelevancyMapper.deleteSceneExtractItemDocType(ruleItemId);
    }
}

