/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.scene.server.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.idp.common.util.SnowFlakeUtil;
import com.jxdinfo.idp.dm.server.service.impl.DocTypeServiceImpl;
import com.jxdinfo.idp.scene.api.dto.SceneDocTypeSaveDto;
import com.jxdinfo.idp.scene.api.po.SceneDocTypeRelevancyPo;
import com.jxdinfo.idp.scene.server.mapper.SceneDocTypeRelevancyMapper;
import com.jxdinfo.idp.scene.server.service.SceneDocTypeRelevancyService;
import com.jxdinfo.idp.vo.DocTypeVo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Service
public class SceneDocTypeRelevancyServiceImpl
extends ServiceImpl<SceneDocTypeRelevancyMapper, SceneDocTypeRelevancyPo>
implements SceneDocTypeRelevancyService {
    @Autowired
    private DocTypeServiceImpl docTypeService;
    @Autowired
    private SceneDocTypeRelevancyMapper sceneDocTypeRelevancyMapper;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void insertOrUpdate(SceneDocTypeSaveDto sceneDocTypeSaveDto) {
        Long sceneId = sceneDocTypeSaveDto.getSceneId();
        List nodeTypeDtoList = sceneDocTypeSaveDto.getNodeTypeDtoList();
        if (nodeTypeDtoList == null || nodeTypeDtoList.isEmpty()) {
            return;
        }
        HashMap<Long, Integer> docTypeIdMap = new HashMap<Long, Integer>();
        for (Object nodeTypeDto : nodeTypeDtoList) {
            docTypeIdMap.put(nodeTypeDto.getId(), nodeTypeDto.getEnabled());
        }
        List<SceneDocTypeRelevancyPo> sceneDocTypeRelevancyPoList = this.findBySceneId(sceneId);
        for (SceneDocTypeRelevancyPo po : sceneDocTypeRelevancyPoList) {
            if (docTypeIdMap.containsKey(po.getDocTypeId())) continue;
            ((SceneDocTypeRelevancyMapper)this.baseMapper).deleteById(Long.valueOf(po.getId()));
        }
        List docTypeIds = sceneDocTypeRelevancyPoList.stream().map(SceneDocTypeRelevancyPo::getDocTypeId).collect(Collectors.toList());
        for (Map.Entry m : docTypeIdMap.entrySet()) {
            if (!docTypeIds.contains(m.getKey())) {
                SceneDocTypeRelevancyPo entity = new SceneDocTypeRelevancyPo();
                entity.setId(SnowFlakeUtil.getFlowIdInstance().nextId());
                entity.setDocTypeId(((Long)m.getKey()).longValue());
                entity.setEnabled((Integer)m.getValue());
                entity.setSceneId(sceneId.longValue());
                this.save(entity);
                continue;
            }
            this.sceneDocTypeRelevancyMapper.updateEnabledBySceneIdAndDocTypeId(sceneId, (Long)m.getKey(), (Integer)m.getValue());
        }
    }

    @Override
    public List<SceneDocTypeRelevancyPo> findBySceneId(long sceneId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"scene_id", (Object)sceneId);
        return ((SceneDocTypeRelevancyMapper)this.baseMapper).selectList((Wrapper)queryWrapper);
    }

    @Override
    public List<DocTypeVo> getDocTypeObjectList(long sceneId) {
        List<SceneDocTypeRelevancyPo> sceneDocTypeRelevancyPoList = this.findBySceneId(sceneId);
        ArrayList<DocTypeVo> docTypeVoList = new ArrayList<DocTypeVo>();
        List docTypeVos = this.docTypeService.getDocTypeList();
        block0: for (SceneDocTypeRelevancyPo po : sceneDocTypeRelevancyPoList) {
            for (DocTypeVo docTypeVo : docTypeVos) {
                if (!String.valueOf(po.getDocTypeId()).equals(String.valueOf(docTypeVo.getId()))) continue;
                if (docTypeVoList.contains(docTypeVo)) continue block0;
                docTypeVo.setEnabled(po.getEnabled());
                docTypeVoList.add(docTypeVo);
                continue block0;
            }
        }
        return docTypeVoList;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBySceneIdAndDocTypeId(long sceneId, List<Long> docTypeIdList) {
        if (!ObjectUtils.isEmpty(docTypeIdList)) {
            this.sceneDocTypeRelevancyMapper.deleteBySceneIdAndDocTypeIdList(sceneId, docTypeIdList);
        }
    }

    @Override
    public void delete(long sceneId, List<Long> templateIdList) {
        if (!ObjectUtils.isEmpty(templateIdList)) {
            this.sceneDocTypeRelevancyMapper.delete(sceneId, templateIdList);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteByTemplateId(long sceneId, List<Long> templateIdList) {
        if (!ObjectUtils.isEmpty(templateIdList)) {
            this.sceneDocTypeRelevancyMapper.delete(sceneId, templateIdList);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBySceneId(long sceneId) {
        this.sceneDocTypeRelevancyMapper.deleteBySceneId(sceneId);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteByDocTypeId(long docTypeId) {
        this.sceneDocTypeRelevancyMapper.deleteByDocTypeId(docTypeId);
    }

    @Override
    public List<SceneDocTypeRelevancyPo> findByDocTypeId(long docTypeId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"doc_type_id", (Object)docTypeId);
        return ((SceneDocTypeRelevancyMapper)this.baseMapper).selectList((Wrapper)queryWrapper);
    }
}

