/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.rule.server.controller;

import com.jxdinfo.idp.common.response.ApiResponse;
import com.jxdinfo.idp.common.response.ResultCode;
import com.jxdinfo.idp.rule.api.vo.RuleGroupVo;
import com.jxdinfo.idp.rule.api.vo.RuleImportVo;
import com.jxdinfo.idp.rule.api.vo.RuleItemVo;
import com.jxdinfo.idp.rule.server.service.IRuleItemService;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/rule/item"})
public class RuleItemController {
    @Resource
    private IRuleItemService ruleItemService;

    @PostMapping(value={"AiImport"})
    public ApiResponse<Void> aiImport(@RequestPart(value="file") MultipartFile file, @RequestPart(value="ruleImportVo") RuleImportVo ruleImportVo) {
        return ApiResponse.status((boolean)this.ruleItemService.aiImport(file, ruleImportVo));
    }

    @PostMapping(value={"/queryRule"})
    public ApiResponse<RuleGroupVo> queryRule(@RequestBody RuleGroupVo ruleGroupVo) {
        return ApiResponse.success((Object)this.ruleItemService.queryRule(ruleGroupVo));
    }

    @PostMapping(value={"AiGenerate"})
    public ApiResponse<Void> aiGenerate(@RequestBody RuleItemVo ruleItemVo) {
        return ApiResponse.status((boolean)this.ruleItemService.aiGenerate(ruleItemVo));
    }

    @PostMapping(value={"/save"})
    public ApiResponse<RuleItemVo> save(@RequestBody RuleItemVo ruleItemVo) {
        return ApiResponse.success((Object)this.ruleItemService.save(ruleItemVo));
    }

    @PostMapping(value={"/saveRule"})
    public ApiResponse<Void> saveRule(@RequestBody RuleGroupVo ruleGroupVo) {
        return ApiResponse.status((boolean)this.ruleItemService.saveRule(ruleGroupVo));
    }

    @GetMapping(value={"/del"})
    public ApiResponse<Void> del(@RequestParam Long ruleItemId) {
        return ApiResponse.status((boolean)this.ruleItemService.del(ruleItemId));
    }

    @PostMapping(value={"/saveReviewLogic"})
    public ApiResponse<Void> saveReviewLogic(@RequestBody RuleItemVo ruleItemVo) {
        return ApiResponse.status((boolean)this.ruleItemService.saveReviewLogic(ruleItemVo));
    }

    @PostMapping(value={"/queryReviewLogic"})
    public ApiResponse<String> queryReviewLogic(@RequestBody RuleItemVo ruleItemVo) {
        return ApiResponse.success((Object)this.ruleItemService.queryReviewLogic(ruleItemVo), (String)ResultCode.SUCCESS.getMessage());
    }

    @GetMapping(value={"/queryCount"})
    public ApiResponse<Long> queryRuleItemCount() {
        return ApiResponse.success((Object)this.ruleItemService.count());
    }
}

