/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.rule.server.internal.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.idp.common.base.dto.LogicDeleteAuditInfoDto;
import com.jxdinfo.idp.common.exception.BusinessException;
import com.jxdinfo.idp.common.util.SnowFlakeUtil;
import com.jxdinfo.idp.rule.api.vo.RuleGroupVo;
import com.jxdinfo.idp.rule.api.vo.RuleInfoVo;
import com.jxdinfo.idp.rule.server.internal.service.IRuleGroupService;
import com.jxdinfo.idp.rule.server.internal.service.IRuleInfoService;
import com.jxdinfo.idp.rule.server.mapper.RuleGroupMapper;
import com.jxdinfo.idp.rule.server.po.RuleGroupPo;
import com.jxdinfo.idp.rule.server.po.RuleInfoPo;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class RuleGroupService
extends ServiceImpl<RuleGroupMapper, RuleGroupPo>
implements IRuleGroupService {
    @Resource
    private RuleGroupMapper ruleGroupMapper;
    @Resource
    private IRuleInfoService ruleInfoService;

    @Override
    public void removeAllRule(Long ruleItemId, Long nodeId) {
        if (nodeId == null && ruleItemId == null) {
            throw new BusinessException("\u5220\u9664\u5ba1\u67e5\u89c4\u5219\u65f6\u9700\u6307\u5b9a\u903b\u8f91\u8282\u70b9\u6216\u5ba1\u67e5\u9879");
        }
        LambdaUpdateWrapper groupQuery = new LambdaUpdateWrapper();
        groupQuery.eq(nodeId != null, RuleGroupPo::getNodeId, (Object)nodeId);
        groupQuery.eq(ruleItemId != null, RuleGroupPo::getRuleItemId, (Object)ruleItemId);
        groupQuery.set(LogicDeleteAuditInfoDto::getDeleteTime, (Object)LocalDateTime.now());
        groupQuery.set(LogicDeleteAuditInfoDto::getDeleteFlag, (Object)1);
        this.update((Wrapper)groupQuery);
        LambdaUpdateWrapper infoQuery = new LambdaUpdateWrapper();
        infoQuery.eq(nodeId != null, RuleInfoPo::getNodeId, (Object)nodeId);
        infoQuery.eq(ruleItemId != null, RuleInfoPo::getRuleItemId, (Object)ruleItemId);
        infoQuery.set(LogicDeleteAuditInfoDto::getDeleteTime, (Object)LocalDateTime.now());
        infoQuery.set(LogicDeleteAuditInfoDto::getDeleteFlag, (Object)1);
        this.ruleInfoService.update((Wrapper)infoQuery);
    }

    @Override
    public void deleteAllRule(Long ruleItemId, Long nodeId) {
        this.ruleGroupMapper.deleteRuleGroup(ruleItemId, nodeId);
        this.ruleInfoService.deleteRuleInfo(ruleItemId, nodeId);
    }

    @Override
    public void saveGroupInfo(RuleGroupVo ruleGroupVo) {
        ArrayList<RuleGroupPo> ruleGroupPos = new ArrayList<RuleGroupPo>();
        RuleGroupPo groupPo = this.getNewRuleGroupPo(ruleGroupVo, ruleGroupVo.getRuleItemId(), ruleGroupVo.getNodeId(), null);
        ruleGroupPos.add(groupPo);
        List subGroupVos = ruleGroupVo.getRuleGroupList();
        ArrayList<RuleInfoPo> ruleInfoPos = new ArrayList<RuleInfoPo>(this.copyProperties(ruleGroupVo.getRuleInfoList(), groupPo));
        if (CollectionUtils.isNotEmpty((Collection)subGroupVos)) {
            this.getTableList(subGroupVos, ruleGroupPos, ruleInfoPos, groupPo);
        }
        this.saveBatch(ruleGroupPos);
        if (CollectionUtils.isNotEmpty(ruleInfoPos)) {
            this.ruleInfoService.saveBatch(ruleInfoPos);
        }
    }

    private void getTableList(List<RuleGroupVo> ruleGroupVos, List<RuleGroupPo> ruleGroupPos, List<RuleInfoPo> ruleInfoPos, RuleGroupPo pNode) {
        ruleGroupVos.forEach(groupVo -> {
            RuleGroupPo po = this.getNewRuleGroupPo((RuleGroupVo)groupVo, pNode.getRuleItemId(), pNode.getNodeId(), pNode.getId());
            ruleGroupPos.add(po);
            ruleInfoPos.addAll(this.copyProperties(groupVo.getRuleInfoList(), po));
            List subGroupVos = groupVo.getRuleGroupList();
            if (CollectionUtils.isNotEmpty((Collection)subGroupVos)) {
                this.getTableList(subGroupVos, ruleGroupPos, ruleInfoPos, po);
            }
        });
    }

    private RuleGroupPo getNewRuleGroupPo(RuleGroupVo ruleGroupVo, Long ruleItemId, Long nodeId, Long pid) {
        RuleGroupPo groupPo = new RuleGroupPo();
        BeanUtils.copyProperties((Object)ruleGroupVo, (Object)groupPo);
        groupPo.setId(SnowFlakeUtil.getFlowIdInstance().nextId());
        if (ObjectUtils.isNotEmpty((Object)ruleItemId)) {
            groupPo.setRuleItemId(ruleItemId);
        }
        if (ObjectUtils.isNotEmpty((Object)nodeId)) {
            groupPo.setNodeId(nodeId);
        }
        if (ObjectUtils.isNotEmpty((Object)pid)) {
            groupPo.setPid(pid);
        }
        return groupPo;
    }

    @Override
    public RuleGroupVo queryGroupInfo(Long nodeId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(RuleGroupPo::getNodeId, (Object)nodeId);
        queryWrapper.orderByDesc(RuleGroupPo::getPid);
        queryWrapper.orderByAsc(RuleGroupPo::getIndexNum);
        List ruleGroupPos = this.ruleGroupMapper.selectList((Wrapper)queryWrapper);
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.eq(RuleInfoPo::getNodeId, (Object)nodeId);
        query.orderByDesc(RuleInfoPo::getGroupId);
        query.orderByAsc(RuleInfoPo::getIndexNum);
        List ruleInfoPos = this.ruleInfoService.list((Wrapper)query);
        return this.buildTree(ruleGroupPos, ruleInfoPos);
    }

    @Override
    public void saveGroupInfoBatch(List<RuleGroupVo> ruleGroupVoList) {
        ArrayList ruleGroupPoList = new ArrayList();
        ArrayList ruleInfoPoList = new ArrayList();
        if (CollectionUtils.isNotEmpty(ruleGroupVoList)) {
            ruleGroupVoList.forEach(ruleGroupVo -> {
                ArrayList<RuleGroupPo> ruleGroupPos = new ArrayList<RuleGroupPo>();
                RuleGroupPo groupPo = this.getNewRuleGroupPo((RuleGroupVo)ruleGroupVo, ruleGroupVo.getRuleItemId(), ruleGroupVo.getNodeId(), null);
                ruleGroupPos.add(groupPo);
                List subGroupVos = ruleGroupVo.getRuleGroupList();
                ArrayList<RuleInfoPo> ruleInfoPos = new ArrayList<RuleInfoPo>(this.copyProperties(ruleGroupVo.getRuleInfoList(), groupPo));
                if (CollectionUtils.isNotEmpty((Collection)subGroupVos)) {
                    this.getTableList(subGroupVos, ruleGroupPos, ruleInfoPos, groupPo);
                }
                ruleGroupPoList.addAll(ruleGroupPos);
                ruleInfoPoList.addAll(ruleInfoPos);
            });
        }
        this.saveBatch(ruleGroupPoList);
        if (CollectionUtils.isNotEmpty(ruleInfoPoList)) {
            this.ruleInfoService.saveBatch(ruleInfoPoList);
        }
    }

    @Override
    public void deleteByRel(Long ruleItemId, List<Long> nodeIds) {
        this.ruleGroupMapper.deleteByRel(ruleItemId, nodeIds);
        this.ruleInfoService.deleteByRel(ruleItemId, nodeIds);
    }

    private RuleGroupVo buildTree(List<RuleGroupPo> groups, List<RuleInfoPo> ruleInfos) {
        RuleGroupVo tree = new RuleGroupVo();
        RuleGroupPo root = groups.stream().filter(t -> t.getPid() == null).findFirst().orElse(null);
        if (root != null) {
            BeanUtils.copyProperties((Object)root, (Object)tree);
            groups.remove(root);
            List<RuleInfoPo> ruleInfoPos = ruleInfos.stream().filter(rule -> Objects.equals(rule.getGroupId(), root.getId())).collect(Collectors.toList());
            ruleInfos.removeIf(t -> Objects.equals(t.getGroupId(), root.getId()));
            tree.setRuleInfoList(this.copyProperties(ruleInfoPos));
            tree.setRuleGroupList(this.buildSubTree(groups, ruleInfos, tree.getId()));
        }
        return tree;
    }

    private List<RuleGroupVo> buildSubTree(List<RuleGroupPo> groups, List<RuleInfoPo> ruleInfos, Long pid) {
        ArrayList<RuleGroupVo> trees = new ArrayList<RuleGroupVo>();
        List<RuleGroupPo> subGroups = groups.stream().filter(t -> Objects.equals(t.getPid(), pid)).collect(Collectors.toList());
        groups.removeIf(t -> Objects.equals(t.getPid(), pid));
        if (CollectionUtils.isNotEmpty(subGroups)) {
            subGroups.forEach(group -> {
                RuleGroupVo tree = new RuleGroupVo();
                BeanUtils.copyProperties((Object)group, (Object)tree);
                List<RuleInfoPo> ruleInfoPos = ruleInfos.stream().filter(rule -> Objects.equals(rule.getGroupId(), group.getId())).collect(Collectors.toList());
                ruleInfos.removeIf(t -> Objects.equals(t.getGroupId(), t.getId()));
                tree.setRuleInfoList(this.copyProperties(ruleInfoPos));
                tree.setRuleGroupList(this.buildSubTree(groups, ruleInfos, tree.getId()));
                trees.add(tree);
            });
        }
        return trees;
    }

    private List<RuleInfoVo> copyProperties(List<RuleInfoPo> ruleInfoPos) {
        ArrayList<RuleInfoVo> ruleInfoVos = new ArrayList<RuleInfoVo>();
        if (CollectionUtils.isNotEmpty(ruleInfoPos)) {
            ruleInfoPos.forEach(po -> {
                RuleInfoVo vo = new RuleInfoVo();
                BeanUtils.copyProperties((Object)po, (Object)vo);
                ruleInfoVos.add(vo);
            });
        }
        return ruleInfoVos;
    }

    private List<RuleInfoPo> copyProperties(List<RuleInfoVo> ruleInfoVos, RuleGroupPo pNode) {
        ArrayList<RuleInfoPo> ruleInfoPos = new ArrayList<RuleInfoPo>();
        if (CollectionUtils.isNotEmpty(ruleInfoVos)) {
            ruleInfoVos.forEach(ruleInfoVo -> {
                RuleInfoPo ruleInfoPo = new RuleInfoPo();
                BeanUtils.copyProperties((Object)ruleInfoVo, (Object)ruleInfoPo);
                if (pNode != null) {
                    ruleInfoPo.setRuleItemId(pNode.getRuleItemId());
                    ruleInfoPo.setNodeId(pNode.getNodeId());
                    ruleInfoPo.setGroupId(pNode.getId());
                }
                ruleInfoPos.add(ruleInfoPo);
            });
        }
        return ruleInfoPos;
    }
}

