/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.rule.server.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.idp.rule.api.dto.FormulaParamDto;
import com.jxdinfo.idp.rule.api.service.IRuleService;
import com.jxdinfo.idp.rule.api.vo.RuleExecuteItemVo;
import com.jxdinfo.idp.rule.api.vo.RuleExecuteLibVo;
import com.jxdinfo.idp.rule.api.vo.RuleItemGroupQueryVo;
import com.jxdinfo.idp.rule.api.vo.RuleItemQueryVo;
import com.jxdinfo.idp.rule.api.vo.RuleItemRecordVo;
import com.jxdinfo.idp.rule.api.vo.RuleItemVo;
import com.jxdinfo.idp.rule.api.vo.RuleLibQueryVo;
import com.jxdinfo.idp.rule.api.vo.RuleLibVo;
import com.jxdinfo.idp.rule.server.dto.RuleItemGroupQueryDto;
import com.jxdinfo.idp.rule.server.dto.RuleItemQueryDto;
import com.jxdinfo.idp.rule.server.dto.RuleItemRecordDto;
import com.jxdinfo.idp.rule.server.dto.RuleLibQueryDto;
import com.jxdinfo.idp.rule.server.internal.execute.IRuleItemExecuteService;
import com.jxdinfo.idp.rule.server.internal.service.IRuleInfoRecordService;
import com.jxdinfo.idp.rule.server.internal.service.IRuleInfoService;
import com.jxdinfo.idp.rule.server.internal.service.IRuleItemRecordService;
import com.jxdinfo.idp.rule.server.mapper.RuleItemMapper;
import com.jxdinfo.idp.rule.server.mapper.RuleItemRecordMapper;
import com.jxdinfo.idp.rule.server.mapper.RuleLibMapper;
import com.jxdinfo.idp.rule.server.po.RuleInfoPo;
import com.jxdinfo.idp.rule.server.po.RuleInfoRecordPo;
import com.jxdinfo.idp.rule.server.po.RuleItemPo;
import com.jxdinfo.idp.rule.server.po.RuleItemRecordPo;
import com.jxdinfo.idp.rule.server.po.RuleLibPo;
import com.jxdinfo.idp.tag.api.dto.tageasy.TagEasyQueryVo;
import com.jxdinfo.idp.tag.api.interf.TagEasyController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RuleServiceImpl
implements IRuleService {
    @Resource
    private RuleLibMapper ruleLibMapper;
    @Resource
    private RuleItemMapper ruleItemMapper;
    @Resource
    private RuleItemRecordMapper ruleItemRecordMapper;
    @Resource
    private IRuleItemExecuteService ruleItemExecuteService;
    @Resource
    private IRuleItemRecordService ruleItemRecordService;
    @Resource
    private IRuleInfoRecordService ruleInfoRecordService;
    @Resource
    private IRuleInfoService ruleInfoService;
    @Autowired(required=false)
    private TagEasyController tagEasyController;

    public Page<RuleLibVo> queryRuleLib(RuleLibQueryVo ruleLibQueryVo) {
        RuleLibQueryDto queryDto = new RuleLibQueryDto();
        BeanUtils.copyProperties((Object)ruleLibQueryVo, (Object)((Object)queryDto));
        if (ruleLibQueryVo.getTag() != null && this.tagEasyController != null) {
            Map dtoMap = this.tagEasyController.queryTagMapByTag((TagEasyQueryVo)ruleLibQueryVo.copyTagProperties(TagEasyQueryVo.class, Integer.valueOf(3)));
            queryDto.setIdList(new ArrayList<Long>(dtoMap.keySet()));
            if (CollectionUtils.isEmpty(queryDto.getIdList())) {
                return queryDto.getPage(RuleLibVo.class);
            }
        }
        Page page = queryDto.getPage(RuleLibPo.class);
        return this.ruleLibMapper.queryRuleLib((Page<RuleLibPo>)page, queryDto);
    }

    public List<RuleLibVo> queryRuleLibTree(RuleLibQueryVo ruleLibQueryVo) {
        RuleLibQueryDto queryDto = new RuleLibQueryDto();
        BeanUtils.copyProperties((Object)ruleLibQueryVo, (Object)((Object)queryDto));
        List<RuleLibVo> libs = this.ruleLibMapper.queryRuleLib(queryDto);
        List<RuleLibVo> level1 = libs.stream().filter(t -> Objects.equals(t.getPid(), queryDto.getPid())).collect(Collectors.toList());
        libs.removeAll(level1);
        return this.buildTree(level1, libs);
    }

    public List<RuleLibVo> queryRuleItemGroup(RuleItemGroupQueryVo queryVo) {
        RuleItemGroupQueryDto queryDto = new RuleItemGroupQueryDto();
        BeanUtils.copyProperties((Object)queryVo, (Object)queryDto);
        List<RuleLibVo> treeNodes = this.ruleLibMapper.queryItemGroup(queryDto);
        List<RuleLibVo> level1 = treeNodes.stream().filter(t -> Objects.equals(t.getId(), queryDto.getRuleLibId()) || t.getPid() == 1L).collect(Collectors.toList());
        treeNodes.removeAll(level1);
        return this.buildTree(level1, treeNodes);
    }

    private List<RuleLibVo> buildTree(List<RuleLibVo> treeNodes, List<RuleLibVo> treeData) {
        if (CollectionUtils.isEmpty(treeData)) {
            return treeNodes;
        }
        treeNodes.forEach(node -> {
            node.setChildren(treeData.stream().filter(t -> Objects.equals(t.getPid(), node.getId())).collect(Collectors.toList()));
            treeData.removeAll(node.getChildren());
            this.buildTree(node.getChildren(), treeData);
        });
        return treeNodes;
    }

    public Page<RuleItemVo> queryRuleItem(RuleItemQueryVo ruleItemQueryVo) {
        RuleItemQueryDto queryDto = new RuleItemQueryDto();
        BeanUtils.copyProperties((Object)ruleItemQueryVo, (Object)((Object)queryDto));
        if (ruleItemQueryVo.getTag() != null && this.tagEasyController != null) {
            Map dtoMap = this.tagEasyController.queryTagMapByTag((TagEasyQueryVo)ruleItemQueryVo.copyTagProperties(TagEasyQueryVo.class, Integer.valueOf(3)));
            queryDto.setIdList(new ArrayList<Long>(dtoMap.keySet()));
            if (CollectionUtils.isEmpty(queryDto.getIdList())) {
                return queryDto.getPage(RuleItemVo.class);
            }
        }
        Page page = queryDto.getPage(RuleItemPo.class);
        return this.ruleItemMapper.queryPage((Page<RuleItemPo>)page, queryDto);
    }

    public List<RuleItemRecordVo> executeRuleLib(RuleExecuteLibVo ruleExecuteLibVo) {
        ArrayList<RuleItemRecordDto> recordDtos = new ArrayList<RuleItemRecordDto>();
        RuleItemQueryDto queryDto = new RuleItemQueryDto();
        queryDto.setEnabled(1);
        queryDto.setRuleLibIds(new Long[]{ruleExecuteLibVo.getRuleLibId()});
        List<RuleItemVo> ruleItems = this.ruleItemMapper.queryPage(queryDto);
        ruleItems.forEach(ruleItemVo -> recordDtos.add(this.ruleItemExecuteService.execute((RuleItemVo)ruleItemVo, ruleExecuteLibVo.getExtractedData(), ruleExecuteLibVo.getBatchNo())));
        return this.saveRuleResult(recordDtos);
    }

    public List<RuleItemRecordVo> executeRuleItems(RuleExecuteItemVo ruleExecuteItemVos) {
        ArrayList<RuleItemRecordDto> recordDtos = new ArrayList<RuleItemRecordDto>();
        RuleItemQueryDto queryDto = new RuleItemQueryDto();
        queryDto.setEnabled(1);
        queryDto.setIdList(Arrays.asList(ruleExecuteItemVos.getRuleItemId()));
        List<RuleItemVo> ruleItems = this.ruleItemMapper.queryPage(queryDto);
        ruleItems.forEach(ruleItem -> recordDtos.add(this.ruleItemExecuteService.execute((RuleItemVo)ruleItem, ruleExecuteItemVos.getExtractedData(), ruleExecuteItemVos.getBatchNo())));
        return this.saveRuleResult(recordDtos);
    }

    public List<RuleItemRecordVo> queryRuleItemRecord(RuleItemRecordVo ruleItemRecordVo) {
        return this.ruleItemRecordMapper.queryRuleItemRecord(ruleItemRecordVo);
    }

    public Map<String, String> queryRuleParam(Long ruleItemId) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.eq(RuleInfoPo::getRuleItemId, (Object)ruleItemId);
        List ruleInfoPos = this.ruleInfoService.list((Wrapper)query);
        ruleInfoPos.forEach(rule -> {
            if (StringUtils.isNotBlank((CharSequence)rule.getFormulaParams())) {
                List paramList = JSON.parseArray((String)rule.getFormulaParams(), FormulaParamDto.class);
                paramList.forEach(param -> paramMap.put(param.getExtractItemKey(), param.getExtractItemName()));
            }
        });
        return paramMap;
    }

    private List<RuleItemRecordVo> saveRuleResult(List<RuleItemRecordDto> recordDtos) {
        ArrayList itemRecordPos = new ArrayList();
        ArrayList ruleInfoRecordPos = new ArrayList();
        ArrayList<RuleItemRecordVo> recordVos = new ArrayList<RuleItemRecordVo>();
        if (CollectionUtils.isNotEmpty(recordDtos)) {
            recordDtos.forEach(r -> {
                RuleItemRecordPo itemRecordPo = new RuleItemRecordPo();
                BeanUtils.copyProperties((Object)r, (Object)itemRecordPo);
                itemRecordPos.add(itemRecordPo);
                if (CollectionUtils.isNotEmpty(r.getRuleInfoList())) {
                    r.getRuleInfoList().forEach(ruleInfo -> {
                        RuleInfoRecordPo po = new RuleInfoRecordPo();
                        BeanUtils.copyProperties((Object)ruleInfo, (Object)po);
                        ruleInfoRecordPos.add(po);
                    });
                }
            });
            this.ruleItemRecordService.saveBatch(itemRecordPos);
            this.ruleInfoRecordService.saveBatch(ruleInfoRecordPos);
            itemRecordPos.forEach(po -> {
                RuleItemRecordVo vo = new RuleItemRecordVo();
                BeanUtils.copyProperties((Object)po, (Object)vo);
                recordVos.add(vo);
            });
        }
        return recordVos;
    }
}

