/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.rule.server.internal.service.impl;

import com.jxdinfo.idp.common.base.dto.ImplCodeDto;
import com.jxdinfo.idp.common.base.vo.TagQueryVo;
import com.jxdinfo.idp.common.exception.BusinessException;
import com.jxdinfo.idp.rule.api.dto.ExtractItemQueryDto;
import com.jxdinfo.idp.rule.api.service.IExtractItemQueryService;
import com.jxdinfo.idp.rule.api.vo.ExtractItemQueryVo;
import com.jxdinfo.idp.rule.api.vo.ExtractItemVo;
import com.jxdinfo.idp.rule.server.internal.service.IExtractItemService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

@Service
public class ExtractItemService
implements IExtractItemService {
    private final Map<String, IExtractItemQueryService> extractItemApiMap = new HashMap<String, IExtractItemQueryService>();
    @Resource
    ApplicationContext applicationContext;

    @PostConstruct
    public void getBeans() {
        Map beanMap = this.applicationContext.getBeansOfType(IExtractItemQueryService.class);
        for (Map.Entry bean : beanMap.entrySet()) {
            this.extractItemApiMap.put(((IExtractItemQueryService)bean.getValue()).getImplCode().getImplCode(), (IExtractItemQueryService)bean.getValue());
        }
    }

    @Override
    public List<ExtractItemVo> getExtractItem(ExtractItemQueryVo queryVo) {
        if (StringUtils.isBlank((CharSequence)queryVo.getApiType())) {
            throw new BusinessException("apiType\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (this.extractItemApiMap.containsKey(queryVo.getApiType())) {
            ExtractItemQueryDto queryDto = new ExtractItemQueryDto();
            queryDto.setTag(new TagQueryVo());
            queryDto.getTag().setTagList(queryVo.getTagList());
            return this.extractItemApiMap.get(queryVo.getApiType()).getExtractItem(queryDto);
        }
        return new ArrayList<ExtractItemVo>();
    }

    @Override
    public List<ImplCodeDto> getExtractItemApi() {
        ArrayList<ImplCodeDto> list = new ArrayList<ImplCodeDto>();
        for (Map.Entry<String, IExtractItemQueryService> bean : this.extractItemApiMap.entrySet()) {
            list.add(bean.getValue().getImplCode());
        }
        return list;
    }
}

