/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.rule.server.util;

import com.jxdinfo.idp.rule.server.po.RuleNodePo;
import com.jxdinfo.idp.rule.server.util.RuleNode;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.ObjectUtils;

public class RuleBinaryTree {
    private RuleNode root;
    private RuleNode current;
    private RuleBinaryTree currentSubTree;
    List<RuleNode> hasSubTreeNodes = new ArrayList<RuleNode>();

    public RuleBinaryTree(List<RuleNodePo> ruleNodePos) {
        this.buildTree(ruleNodePos);
        if (!ruleNodePos.isEmpty() && !this.hasSubTreeNodes.isEmpty()) {
            this.hasSubTreeNodes.forEach(ruleNode -> ruleNode.setSubTree(new RuleBinaryTree(ruleNodePos, ruleNode.getKey())));
        }
    }

    public RuleBinaryTree(List<RuleNodePo> ruleNodePos, Long pid) {
        this.buildTree(ruleNodePos, pid);
        if (!ruleNodePos.isEmpty() && !this.hasSubTreeNodes.isEmpty()) {
            this.hasSubTreeNodes.forEach(ruleNode -> ruleNode.setSubTree(new RuleBinaryTree(ruleNodePos, ruleNode.getKey())));
        }
    }

    public boolean insert(RuleNodePo node) {
        RuleNode treeNode = new RuleNode(node.getId(), node);
        if (this.root == null) {
            this.root = treeNode;
        } else if (node.getNodeType() != 1) {
            RuleNode pNode = this.levelFind(node.getPid());
            if (pNode == null) {
                return false;
            }
            if (node.getNodeType() == 6) {
                this.hasSubTreeNodes.add(treeNode);
            }
            if (ObjectUtils.isEmpty((Object)node.getPnodeResult()) || Objects.equals(1, node.getPnodeResult())) {
                pNode.setLeftNode(treeNode);
            } else {
                pNode.setRightNode(treeNode);
            }
        } else {
            return false;
        }
        return true;
    }

    public RuleNode levelFind(Long key) {
        if (this.root == null) {
            return null;
        }
        LinkedList<RuleNode> queue = new LinkedList<RuleNode>();
        queue.add(this.root);
        while (!queue.isEmpty()) {
            for (int i = 0; i < queue.size(); ++i) {
                RuleNode node = (RuleNode)queue.poll();
                if (Objects.equals(key, node.getKey())) {
                    return node;
                }
                if (node.getLeftNode() != null) {
                    queue.offer(node.getLeftNode());
                }
                if (node.getRightNode() == null) continue;
                queue.offer(node.getRightNode());
            }
        }
        return null;
    }

    public void buildTree(List<RuleNodePo> nodes, Long pid) {
        RuleNodePo rootNode = nodes.stream().filter(obj -> obj.getPid().equals(pid)).findFirst().orElse(null);
        if (rootNode != null) {
            this.setRoot(new RuleNode(rootNode.getId(), rootNode));
            nodes.remove(rootNode);
            int nums = 0;
            while (!nodes.isEmpty()) {
                if (this.insert(nodes.get(nums))) {
                    nodes.remove(nums);
                    nums = 0;
                } else {
                    ++nums;
                }
                if (nums < nodes.size()) continue;
                break;
            }
        }
    }

    public void buildTree(List<RuleNodePo> nodes) {
        RuleNodePo rootNode = nodes.stream().filter(obj -> ObjectUtils.isEmpty((Object)obj.getPid())).findFirst().orElse(null);
        if (rootNode != null) {
            this.setRoot(new RuleNode(rootNode.getId(), rootNode));
            nodes.remove(rootNode);
            int nums = 0;
            while (!nodes.isEmpty()) {
                if (this.insert(nodes.get(nums))) {
                    nodes.remove(nums);
                    nums = 0;
                } else {
                    ++nums;
                }
                if (nums < nodes.size()) continue;
                break;
            }
        }
    }

    public void start() {
        this.current = this.root;
    }

    public RuleNode next(int pNodeResult) {
        this.current = pNodeResult == 1 ? this.current.getLeftNode() : this.current.getRightNode();
        return this.current;
    }

    public boolean hasNext() {
        return !(this.current == null || this.current.getValue().getNodeType() != 1 && this.current.getValue().getNodeType() != 2 && this.current.getValue().getNodeType() != 6 || this.current.getRightNode() == null && this.current.getLeftNode() == null);
    }

    public List<RuleNodePo> level() {
        if (this.root == null) {
            return new ArrayList<RuleNodePo>();
        }
        ArrayList<RuleNodePo> nodes = new ArrayList<RuleNodePo>();
        LinkedList<RuleNode> queue = new LinkedList<RuleNode>();
        queue.add(this.root);
        while (!queue.isEmpty()) {
            for (int i = 0; i < queue.size(); ++i) {
                RuleNode node = (RuleNode)queue.poll();
                nodes.add(node.getValue());
                if (node.getLeftNode() != null) {
                    queue.offer(node.getLeftNode());
                }
                if (node.getRightNode() == null) continue;
                queue.offer(node.getRightNode());
            }
        }
        return nodes;
    }

    public RuleNode getRoot() {
        return this.root;
    }

    public RuleNode getCurrent() {
        return this.current;
    }

    public RuleBinaryTree getCurrentSubTree() {
        return this.currentSubTree;
    }

    public List<RuleNode> getHasSubTreeNodes() {
        return this.hasSubTreeNodes;
    }

    public void setRoot(RuleNode root) {
        this.root = root;
    }

    public void setCurrent(RuleNode current) {
        this.current = current;
    }

    public void setCurrentSubTree(RuleBinaryTree currentSubTree) {
        this.currentSubTree = currentSubTree;
    }

    public void setHasSubTreeNodes(List<RuleNode> hasSubTreeNodes) {
        this.hasSubTreeNodes = hasSubTreeNodes;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RuleBinaryTree)) {
            return false;
        }
        RuleBinaryTree other = (RuleBinaryTree)o;
        if (!other.canEqual(this)) {
            return false;
        }
        RuleNode this$root = this.getRoot();
        RuleNode other$root = other.getRoot();
        if (this$root == null ? other$root != null : !((Object)this$root).equals(other$root)) {
            return false;
        }
        RuleNode this$current = this.getCurrent();
        RuleNode other$current = other.getCurrent();
        if (this$current == null ? other$current != null : !((Object)this$current).equals(other$current)) {
            return false;
        }
        RuleBinaryTree this$currentSubTree = this.getCurrentSubTree();
        RuleBinaryTree other$currentSubTree = other.getCurrentSubTree();
        if (this$currentSubTree == null ? other$currentSubTree != null : !((Object)this$currentSubTree).equals(other$currentSubTree)) {
            return false;
        }
        List<RuleNode> this$hasSubTreeNodes = this.getHasSubTreeNodes();
        List<RuleNode> other$hasSubTreeNodes = other.getHasSubTreeNodes();
        return !(this$hasSubTreeNodes == null ? other$hasSubTreeNodes != null : !((Object)this$hasSubTreeNodes).equals(other$hasSubTreeNodes));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RuleBinaryTree;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RuleNode $root = this.getRoot();
        result = result * 59 + ($root == null ? 43 : ((Object)$root).hashCode());
        RuleNode $current = this.getCurrent();
        result = result * 59 + ($current == null ? 43 : ((Object)$current).hashCode());
        RuleBinaryTree $currentSubTree = this.getCurrentSubTree();
        result = result * 59 + ($currentSubTree == null ? 43 : ((Object)$currentSubTree).hashCode());
        List<RuleNode> $hasSubTreeNodes = this.getHasSubTreeNodes();
        result = result * 59 + ($hasSubTreeNodes == null ? 43 : ((Object)$hasSubTreeNodes).hashCode());
        return result;
    }

    public String toString() {
        return "RuleBinaryTree(root=" + this.getRoot() + ", current=" + this.getCurrent() + ", currentSubTree=" + this.getCurrentSubTree() + ", hasSubTreeNodes=" + this.getHasSubTreeNodes() + ")";
    }
}

