/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.rule.server.internal.ai;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.jxdinfo.idp.common.exception.BusinessException;
import com.jxdinfo.idp.common.util.uuid.IdUtils;
import com.jxdinfo.idp.rule.api.dto.FormulaParamDto;
import com.jxdinfo.idp.rule.api.vo.RuleGroupVo;
import com.jxdinfo.idp.rule.api.vo.RuleNodeVo;
import com.jxdinfo.idp.rule.formula.entity.RuleFormula;
import com.jxdinfo.idp.rule.formula.service.IRuleFormula;
import com.jxdinfo.idp.rule.server.dto.AIGenerateRuleResultDto;
import com.jxdinfo.idp.rule.server.dto.AIRequestParamDto;
import com.jxdinfo.idp.rule.server.dto.RuleInfoDto;
import com.jxdinfo.idp.rule.server.po.RuleNodePo;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class AIGenerateRuleService {
    private static final Logger log = LoggerFactory.getLogger(AIGenerateRuleService.class);
    @Value(value="${rmi.ruleGenerate.url}")
    private String url;
    @Value(value="${rmi.ruleGenerate.api.generate}")
    private String generate;
    @Resource
    private RestTemplate restTemplate;
    @Resource
    private IRuleFormula ruleFormulaService;

    public List<AIGenerateRuleResultDto> aiGenerateRule(AIRequestParamDto paramDto) {
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_PROBLEM_JSON);
            HttpEntity entity = new HttpEntity((Object)paramDto, (MultiValueMap)headers);
            ResponseEntity result = this.restTemplate.exchange(this.url + this.generate, HttpMethod.POST, entity, String.class, new Object[0]);
            return JSON.parseArray((String)((String)result.getBody()), AIGenerateRuleResultDto.class);
        }
        catch (Exception e) {
            log.error("AI\u667a\u80fd\u751f\u6210\u89c4\u5219\u63a5\u53e3\u5f02\u5e38", (Throwable)e);
            return new ArrayList<AIGenerateRuleResultDto>();
        }
    }

    public String getCanvasStr(Long canvasId, List<RuleInfoDto> ruleList) {
        String jsonStr = "{\"cells\":[{\"position\":{\"x\":439,\"y\":60},\"size\":{\"width\":96,\"height\":48},\"view\":\"vue-shape-view\",\"shape\":\"custom-vue-node-start\",\"id\":\"[canvasId]00\",\"data\":{\"data\":{\"isConfig\":true,\"name\":\"\u5f00\u59cb\",\"opinion\":\"\",\"rule\":[],\"showPoint\":\"0\",\"text\":\"\"},\"pointName\":\"1\"},\"label\":\"\u5f00\u59cb\",\"zIndex\":1,\"ports\":{\"groups\":{\"bottom\":{\"attrs\":{\"circle\":{\"fill\":\"#fff\",\"magnet\":true,\"r\":4,\"stroke\":\"#5F95FF\",\"strokeWidth\":1,\"style\":{\"visibility\":\"hidden\"}}},\"position\":\"bottom\"},\"left\":{\"attrs\":{\"circle\":{\"fill\":\"#fff\",\"magnet\":true,\"r\":4,\"stroke\":\"#5F95FF\",\"strokeWidth\":1,\"style\":{\"visibility\":\"hidden\"}}},\"position\":\"left\"},\"right\":{\"attrs\":{\"circle\":{\"fill\":\"#fff\",\"magnet\":true,\"r\":4,\"stroke\":\"#5F95FF\",\"strokeWidth\":1,\"style\":{\"visibility\":\"hidden\"}}},\"position\":\"right\"},\"top\":{\"attrs\":{\"circle\":{\"fill\":\"#fff\",\"magnet\":true,\"r\":4,\"stroke\":\"#5F95FF\",\"strokeWidth\":1,\"style\":{\"visibility\":\"hidden\"}}},\"position\":\"top\"}},\"items\":[{\"group\":\"right\",\"id\":\"[uuid]01\"},{\"group\":\"left\",\"id\":\"[uuid]02\"},{\"group\":\"top\",\"id\":\"[uuid]03\"},{\"group\":\"bottom\",\"id\":\"[uuid]04\"}]}},{\"position\":{\"x\":262,\"y\":170},\"size\":{\"width\":450,\"height\":153},\"view\":\"vue-shape-view\",\"shape\":\"custom-vue-node-judge1\",\"id\":\"[canvasId]01\",\"data\":{\"data\":{\"isConfig\":false,\"name\":\"\u6761\u4ef6\u7ec4\u4ef6\",\"opinion\":\"\",\"rule\":[{\"logicOpt\":\"\",\"param1\":\"\u7535\u4ef7\",\"judge\":\"\u7b49\u4e8e\",\"param2\":\"\u8865\u507f\u7535\u4ef7\",\"margin\":1,\"bracket\":\"\"}],\"showPoint\":\"1\",\"text\":\"\"},\"pointName\":\"2\"},\"label\":\"\u6761\u4ef6\u7ec4\u4ef6\",\"zIndex\":2,\"ports\":{\"groups\":{\"bottom\":{\"attrs\":{\"circle\":{\"fill\":\"#fff\",\"magnet\":true,\"r\":4,\"stroke\":\"#5F95FF\",\"strokeWidth\":1,\"style\":{\"visibility\":\"hidden\"}}},\"position\":\"bottom\"},\"left\":{\"attrs\":{\"circle\":{\"fill\":\"#fff\",\"magnet\":true,\"r\":4,\"stroke\":\"#5F95FF\",\"strokeWidth\":1,\"style\":{\"visibility\":\"hidden\"}}},\"position\":\"left\"},\"right\":{\"attrs\":{\"circle\":{\"fill\":\"#fff\",\"magnet\":true,\"r\":4,\"stroke\":\"#5F95FF\",\"strokeWidth\":1,\"style\":{\"visibility\":\"hidden\"}}},\"position\":\"right\"},\"top\":{\"attrs\":{\"circle\":{\"fill\":\"#fff\",\"magnet\":true,\"r\":4,\"stroke\":\"#5F95FF\",\"strokeWidth\":1,\"style\":{\"visibility\":\"hidden\"}}},\"position\":\"top\"}},\"items\":[{\"group\":\"right\",\"id\":\"[uuid]05\"},{\"group\":\"left\",\"id\":\"[uuid]06\"},{\"group\":\"top\",\"id\":\"[uuid]07\"},{\"group\":\"bottom\",\"id\":\"[uuid]08\"}]},\"tools\":{\"items\":[],\"name\":null}},{\"shape\":\"edge\",\"attrs\":{\"line\":{\"stroke\":\"#A2B1C3\",\"targetMarker\":{\"height\":8,\"name\":\"block\",\"width\":12}}},\"id\":\"[uuid]09\",\"data\":{\"data\":{},\"edgeAttribute\":\"\",\"edgeName\":\"edge\"},\"labels\":[],\"zIndex\":3,\"source\":{\"cell\":\"[canvasId]00\",\"port\":\"[uuid]04\"},\"target\":{\"cell\":\"[canvasId]01\",\"port\":\"[uuid]07\"}},{\"position\":{\"x\":425,\"y\":410},\"size\":{\"width\":124,\"height\":48},\"view\":\"vue-shape-view\",\"shape\":\"custom-vue-node-pass\",\"id\":\"[canvasId]02\",\"data\":{\"data\":{\"isConfig\":true,\"name\":\"\u5ba1\u67e5\u901a\u8fc7\",\"opinion\":\"\",\"rule\":[],\"showPoint\":\"2\",\"text\":\"\"},\"pointName\":\"3\"},\"label\":\"\u5ba1\u67e5\u901a\u8fc7\",\"zIndex\":4,\"ports\":{\"groups\":{\"bottom\":{\"attrs\":{\"circle\":{\"fill\":\"#fff\",\"magnet\":true,\"r\":4,\"stroke\":\"#5F95FF\",\"strokeWidth\":1,\"style\":{\"visibility\":\"hidden\"}}},\"position\":\"bottom\"},\"left\":{\"attrs\":{\"circle\":{\"fill\":\"#fff\",\"magnet\":true,\"r\":4,\"stroke\":\"#5F95FF\",\"strokeWidth\":1,\"style\":{\"visibility\":\"hidden\"}}},\"position\":\"left\"},\"right\":{\"attrs\":{\"circle\":{\"fill\":\"#fff\",\"magnet\":true,\"r\":4,\"stroke\":\"#5F95FF\",\"strokeWidth\":1,\"style\":{\"visibility\":\"hidden\"}}},\"position\":\"right\"},\"top\":{\"attrs\":{\"circle\":{\"fill\":\"#fff\",\"magnet\":true,\"r\":4,\"stroke\":\"#5F95FF\",\"strokeWidth\":1,\"style\":{\"visibility\":\"hidden\"}}},\"position\":\"top\"}},\"items\":[{\"group\":\"right\",\"id\":\"[uuid]09\"},{\"group\":\"left\",\"id\":\"[uuid]10\"},{\"group\":\"top\",\"id\":\"[uuid]11\"},{\"group\":\"bottom\",\"id\":\"[uuid]12\"}]},\"tools\":{\"items\":[],\"name\":null}},{\"shape\":\"edge\",\"attrs\":{\"line\":{\"stroke\":\"#A2B1C3\",\"targetMarker\":{\"height\":8,\"name\":\"block\",\"width\":12}}},\"id\":\"[uuid]13\",\"data\":{\"data\":{},\"edgeAttribute\":\"true\",\"edgeName\":\"edge\"},\"labels\":[\"\u6ee1\u8db3\"],\"zIndex\":5,\"source\":{\"cell\":\"[canvasId]01\",\"port\":\"[uuid]08\"},\"target\":{\"cell\":\"[canvasId]02\",\"port\":\"[uuid]11\"}},{\"position\":{\"x\":810,\"y\":222.5},\"size\":{\"width\":138,\"height\":48},\"view\":\"vue-shape-view\",\"shape\":\"custom-vue-node-unpass\",\"id\":\"[canvasId]03\",\"data\":{\"data\":{\"isConfig\":true,\"name\":\"\u5ba1\u67e5\u4e0d\u901a\u8fc7\",\"opinion\":\"\",\"rule\":[],\"showPoint\":\"3\",\"text\":\"\"},\"pointName\":\"4\"},\"label\":\"\u5ba1\u67e5\u4e0d\u901a\u8fc7\",\"zIndex\":6,\"ports\":{\"groups\":{\"bottom\":{\"attrs\":{\"circle\":{\"fill\":\"#fff\",\"magnet\":true,\"r\":4,\"stroke\":\"#5F95FF\",\"strokeWidth\":1,\"style\":{\"visibility\":\"hidden\"}}},\"position\":\"bottom\"},\"left\":{\"attrs\":{\"circle\":{\"fill\":\"#fff\",\"magnet\":true,\"r\":4,\"stroke\":\"#5F95FF\",\"strokeWidth\":1,\"style\":{\"visibility\":\"hidden\"}}},\"position\":\"left\"},\"right\":{\"attrs\":{\"circle\":{\"fill\":\"#fff\",\"magnet\":true,\"r\":4,\"stroke\":\"#5F95FF\",\"strokeWidth\":1,\"style\":{\"visibility\":\"hidden\"}}},\"position\":\"right\"},\"top\":{\"attrs\":{\"circle\":{\"fill\":\"#fff\",\"magnet\":true,\"r\":4,\"stroke\":\"#5F95FF\",\"strokeWidth\":1,\"style\":{\"visibility\":\"hidden\"}}},\"position\":\"top\"}},\"items\":[{\"group\":\"right\",\"id\":\"[uuid]14\"},{\"group\":\"left\",\"id\":\"[uuid]15\"},{\"group\":\"top\",\"id\":\"[uuid]16\"},{\"group\":\"bottom\",\"id\":\"[uuid]17\"}]},\"tools\":{\"items\":[],\"name\":null}},{\"shape\":\"edge\",\"attrs\":{\"line\":{\"stroke\":\"#A2B1C3\",\"targetMarker\":{\"height\":8,\"name\":\"block\",\"width\":12}}},\"id\":\"[uuid]18\",\"data\":{\"data\":{},\"edgeAttribute\":\"false\",\"edgeName\":\"edge\"},\"labels\":[\"\u4e0d\u6ee1\u8db3\"],\"zIndex\":7,\"source\":{\"cell\":\"[canvasId]01\",\"port\":\"[uuid]05\"},\"target\":{\"cell\":\"[canvasId]03\",\"port\":\"[uuid]15\"}}]}";
        jsonStr = jsonStr.replace("[canvasId]", String.valueOf(canvasId));
        String cellId = IdUtils.fastSimpleUUID();
        jsonStr = jsonStr.replace("[uuid]", cellId);
        StringBuilder rule = new StringBuilder();
        for (int i = 0; i < ruleList.size(); ++i) {
            RuleInfoDto ruleInfo = ruleList.get(i);
            ruleInfo.setIndexNum(i + 1);
            RuleFormula ruleFormula = this.ruleFormulaService.getFormula(ruleInfo.getFormulaCode());
            if (CollectionUtils.isEmpty(ruleInfo.getFormulaParams())) {
                throw new BusinessException("\u81ea\u52a8\u751f\u6210\u89c4\u5219\u5f02\u5e38\uff0c\u89c4\u5219\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ruleFormula == null) {
                throw new BusinessException("\u81ea\u52a8\u751f\u6210\u89c4\u5219\u5f02\u5e38\uff0c\u89c4\u5219\u4f7f\u7528\u7684\u51fd\u6570\u4e0d\u5b58\u5728");
            }
            String logicOperator = ruleInfo.getLogicOperator() == null ? "" : (ruleInfo.getLogicOperator() == 1 ? "\u4e14" : "\u6216");
            String paramName = this.getParamValue(ruleInfo.getFormulaParams(), ruleInfo.getFormulaType());
            if (i > 0) {
                rule.append(",");
            }
            rule.append("{\"logicOpt\": \"").append(logicOperator).append("\"");
            rule.append(",\"param1\": \"").append(ruleInfo.getFormulaParams().get(0).getExtractItemName()).append("\"");
            rule.append(",\"judge\": \"").append(ruleFormula.getAlisa()).append("\"");
            rule.append(",\"param2\": \"").append(paramName).append("\"");
            rule.append(",\"margin\": 1,\"bracket\": \"\"}");
        }
        return jsonStr.replace("[ruleInfo]", rule.toString());
    }

    private String getParamValue(List<FormulaParamDto> formulaParams, Integer formulaType) {
        String paramName = "";
        if (formulaParams.size() == 2) {
            paramName = StringUtils.isNotBlank((CharSequence)formulaParams.get(1).getParamValue()) ? formulaParams.get(1).getParamValue() : formulaParams.get(1).getExtractItemName();
        } else if (formulaParams.size() == 3 && formulaType == 1) {
            paramName = formulaParams.get(1).getParamValue() + '~' + formulaParams.get(2).getParamValue();
        }
        return paramName;
    }

    public List<RuleNodeVo> getCanvasNode(Long ruleItemId, Long canvasId) {
        ArrayList<RuleNodeVo> nodeList = new ArrayList<RuleNodeVo>();
        long nodeId = canvasId * 100L;
        nodeList.add(new RuleNodeVo(Long.valueOf(nodeId), ruleItemId, null, Integer.valueOf(1), null, null, null, null));
        nodeList.add(new RuleNodeVo(Long.valueOf(nodeId + 1L), ruleItemId, Long.valueOf(nodeId), Integer.valueOf(2), null, null, null, null));
        nodeList.add(new RuleNodeVo(Long.valueOf(nodeId + 2L), ruleItemId, Long.valueOf(nodeId + 1L), Integer.valueOf(3), Integer.valueOf(1), null, null, null));
        nodeList.add(new RuleNodeVo(Long.valueOf(nodeId + 3L), ruleItemId, Long.valueOf(nodeId + 1L), Integer.valueOf(4), Integer.valueOf(2), null, null, null));
        return nodeList;
    }

    public RuleGroupVo getRuleGroup(Long ruleItemId, Long nodeId, List<RuleInfoDto> ruleInfoList) {
        RuleGroupVo ruleGroup = new RuleGroupVo(ruleItemId, nodeId, 1);
        if (CollectionUtils.isNotEmpty(ruleInfoList)) {
            List ruleInfoVoList = ruleInfoList.stream().map(RuleInfoDto::convertVo).collect(Collectors.toList());
            ruleGroup.setRuleInfoList(ruleInfoVoList);
        }
        return ruleGroup;
    }

    public List<RuleNodePo> getCanvasNodePo(Long ruleItemId, long canvasId) {
        ArrayList<RuleNodePo> nodeList = new ArrayList<RuleNodePo>();
        long nodeId = canvasId * 100L;
        nodeList.add(new RuleNodePo(nodeId, ruleItemId, null, null, 1, null, null));
        nodeList.add(new RuleNodePo(nodeId + 1L, ruleItemId, nodeId, null, 2, null, null));
        nodeList.add(new RuleNodePo(nodeId + 2L, ruleItemId, nodeId + 1L, 1, 3, null, null));
        nodeList.add(new RuleNodePo(nodeId + 3L, ruleItemId, nodeId + 1L, 2, 4, null, null));
        return nodeList;
    }
}

