/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.rule.server.internal.execute;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.jxdinfo.idp.common.util.uuid.IdUtils;
import com.jxdinfo.idp.rule.api.dto.FormulaParamDto;
import com.jxdinfo.idp.rule.api.vo.FormulaExecuteVo;
import com.jxdinfo.idp.rule.api.vo.RuleGroupVo;
import com.jxdinfo.idp.rule.api.vo.RuleInfoVo;
import com.jxdinfo.idp.rule.api.vo.RuleItemVo;
import com.jxdinfo.idp.rule.api.vo.RuleVo;
import com.jxdinfo.idp.rule.formula.exception.RuleExecuteExption;
import com.jxdinfo.idp.rule.formula.exception.RuleExecuteParamException;
import com.jxdinfo.idp.rule.formula.service.IRuleFormula;
import com.jxdinfo.idp.rule.server.dto.RuleInfoRecordDto;
import com.jxdinfo.idp.rule.server.dto.RuleItemRecordDto;
import com.jxdinfo.idp.rule.server.internal.execute.IRuleItemExecuteService;
import com.jxdinfo.idp.rule.server.internal.service.IRuleGroupService;
import com.jxdinfo.idp.rule.server.mapper.RuleNodeMapper;
import com.jxdinfo.idp.rule.server.po.RuleNodePo;
import com.jxdinfo.idp.rule.server.util.RuleBinaryTree;
import com.jxdinfo.idp.rule.server.util.RuleNode;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class RuleItemExecuteService
implements IRuleItemExecuteService {
    private static final Logger log = LoggerFactory.getLogger(RuleItemExecuteService.class);
    @Resource
    private RuleNodeMapper ruleNodeMapper;
    @Resource
    private IRuleGroupService ruleGroupService;
    @Resource
    private IRuleFormula ruleFormula;
    private static ThreadLocal<StringBuilder> resultInfoThreadLocal = new ThreadLocal();

    @Override
    public RuleItemRecordDto execute(RuleItemVo ruleItemVo, Map<String, Object> extractedData, Long batchNo) {
        RuleItemRecordDto itemRecord = new RuleItemRecordDto(ruleItemVo);
        itemRecord.setBatchNo(batchNo);
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.eq(RuleNodePo::getRuleItemId, (Object)ruleItemVo.getId());
        List ruleNodePos = this.ruleNodeMapper.selectList((Wrapper)query);
        RuleBinaryTree tree = new RuleBinaryTree(ruleNodePos);
        try {
            int result = this.executeRuleBinaryTree(itemRecord, tree, extractedData);
            itemRecord.setResult(result);
        }
        catch (RuleExecuteExption e) {
            log.error("\u3010{}\u3011\u5ba1\u67e5\u5f02\u5e38\uff0c{}", (Object)ruleItemVo.getRuleItemName(), (Object)e.getMessage());
            itemRecord.setResult(3);
        }
        catch (Exception e) {
            log.error("\u3010{}\u3011\u5ba1\u67e5\u8fc7\u7a0b\u5f02\u5e38\uff0c{}", (Object)ruleItemVo.getRuleItemName(), (Object)e.getMessage());
            itemRecord.setResult(3);
        }
        itemRecord.setResultReason(resultInfoThreadLocal.get().toString());
        resultInfoThreadLocal.remove();
        return itemRecord;
    }

    private StringBuilder recordResultInfo(StringBuilder resultInfo, int result, RuleNode current) {
        switch (result) {
            case 1: {
                resultInfo.append("\u2014\u2014\u3010").append(current.getValue().getNodeName()).append("\u3011\u5ba1\u67e5\u901a\u8fc7");
                break;
            }
            case 2: {
                resultInfo.append("\u2014\u2014\u3010").append(current.getValue().getNodeName()).append("\u3011\u5ba1\u67e5\u4e0d\u901a\u8fc7");
                break;
            }
            case 3: {
                resultInfo.append("\u2014\u2014\u3010").append(current.getValue().getNodeName()).append("\u3011\u65e0\u6cd5\u9884\u5ba1");
                break;
            }
        }
        return resultInfo;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int executeRuleBinaryTree(RuleItemRecordDto itemRecord, RuleBinaryTree tree, Map<String, Object> extractedData) {
        int result;
        if (tree.getRoot() == null) {
            throw new RuleExecuteExption("\u672a\u914d\u7f6e\u5ba1\u67e5\u903b\u8f91\uff0c\u65e0\u6cd5\u9884\u5ba1");
        }
        StringBuilder resultInfo = new StringBuilder();
        tree.start();
        ArrayList<Long> nodePaths = new ArrayList<Long>();
        while (tree.hasNext()) {
            nodePaths.add(tree.getCurrent().getKey());
            result = 1;
            if (tree.getCurrent().getValue().getNodeType() == 2) {
                itemRecord.setEndNodeId(tree.getCurrent().getKey());
                result = this.executeNodeRule(itemRecord, extractedData);
                tree.next(result);
            } else if (tree.getCurrent().getValue().getNodeType() == 6) {
                itemRecord.setEndNodeId(tree.getCurrent().getKey());
                if (tree.getCurrent().getSubTree() == null) throw new RuleExecuteExption("\u5faa\u73af\u8282\u70b9\u672a\u914d\u7f6e\u5ba1\u67e5\u903b\u8f91\uff0c\u65e0\u6cd5\u9884\u5ba1");
                result = this.executeLoopNode(itemRecord, tree.getCurrent(), extractedData);
                tree.next(result);
            } else {
                tree.next(1);
            }
            this.recordResultInfo(resultInfo, result, tree.getCurrent());
        }
        nodePaths.add(tree.getCurrent().getKey());
        if (ObjectUtils.isNotEmpty((Object)resultInfo) && resultInfo.length() > 2) {
            resultInfo = new StringBuilder(resultInfo.substring(2));
            resultInfoThreadLocal.set(resultInfo);
        }
        result = 3;
        if (tree.getCurrent().getValue().getNodeType() == 3) {
            result = 1;
        } else if (tree.getCurrent().getValue().getNodeType() == 4) {
            result = 2;
            itemRecord.setRectifyComments(tree.getCurrent().getValue().getRectifyComments());
        }
        itemRecord.setEndNodeId(tree.getCurrent().getKey());
        String nodePath = itemRecord.getNodePath() == null ? "" : itemRecord.getNodePath() + ",";
        itemRecord.setNodePath(nodePath + StringUtils.join(nodePaths, (String)","));
        return result;
    }

    private int executeLoopNode(RuleItemRecordDto itemRecord, RuleNode loopNode, Map<String, Object> extractedData) {
        String op;
        FormulaParamDto loopParam;
        RuleInfoVo ruleInfoVo;
        StringBuilder stringBuilder = new StringBuilder();
        HashMap<String, Object> paramData = new HashMap<String, Object>(extractedData);
        try {
            RuleGroupVo ruleGroupVo = this.ruleGroupService.queryGroupInfo(itemRecord.getEndNodeId());
            ruleInfoVo = (RuleInfoVo)ruleGroupVo.getRuleInfoList().get(0);
            List paramList = JSON.parseArray((String)ruleInfoVo.getFormulaParams(), FormulaParamDto.class);
            loopParam = (FormulaParamDto)paramList.get(0);
        }
        catch (Exception e) {
            throw new RuleExecuteExption("\u5faa\u73af\u7ec4\u4ef6\u8282\u70b9\u914d\u7f6e\u5f02\u5e38\uff0c\u65e0\u6cd5\u9884\u5ba1");
        }
        String valPath = loopParam.getExtractItemKey();
        Object loopValue = this.getValueByPath(extractedData, valPath);
        String string = op = ruleInfoVo.getLogicOperator() == 1 ? "&&" : "||";
        if (!(loopValue instanceof ArrayList)) {
            throw new RuleExecuteExption("\u5faa\u73af\u7ec4\u4ef6\u8282\u70b9\u89c4\u5219\u6267\u884c\u5f02\u5e38\uff0c\u4ec5\u652f\u6301List\u7c7b\u578b\u5165\u53c2");
        }
        ArrayList arr = (ArrayList)loopValue;
        arr.forEach(t -> {
            boolean res;
            paramData.put(valPath, t);
            int result = this.executeRuleBinaryTree(itemRecord, loopNode.getSubTree(), paramData);
            if (result == 3) {
                throw new RuleExecuteExption(loopParam.getExtractItemName() + "\u5ba1\u67e5\u5f02\u5e38\uff0c\u65e0\u6cd5\u83b7\u5f97\u5ba1\u67e5\u7ed3\u679c");
            }
            boolean bl = res = result == 1;
            if (StringUtils.isEmpty((CharSequence)stringBuilder)) {
                stringBuilder.append(res);
            } else {
                stringBuilder.append(op).append(res);
            }
        });
        boolean res = (Boolean)this.ruleFormula.execute(stringBuilder.toString());
        return res ? 1 : 2;
    }

    private Integer executeNodeRule(RuleItemRecordDto itemRecord, Map<String, Object> extractedData) {
        RuleGroupVo ruleGroupVo = this.ruleGroupService.queryGroupInfo(itemRecord.getEndNodeId());
        if (ObjectUtils.isEmpty((Object)ruleGroupVo.getId()) || CollectionUtils.isEmpty((Collection)ruleGroupVo.getRuleInfoList()) && CollectionUtils.isEmpty((Collection)ruleGroupVo.getRuleGroupList())) {
            throw new RuleExecuteExption("\u6761\u4ef6\u7ec4\u4ef6\u8282\u70b9\u672a\u914d\u7f6e\u5ba1\u67e5\u89c4\u5219\uff0c\u65e0\u6cd5\u9884\u5ba1");
        }
        boolean result = this.executeRuleGroup(itemRecord, ruleGroupVo, extractedData);
        return result ? 1 : 2;
    }

    private boolean executeRuleGroup(RuleItemRecordDto itemRecord, RuleGroupVo ruleGroupVo, Map<String, Object> extractedData) {
        Queue<RuleVo> ruleQueue = this.sortRules(ruleGroupVo);
        if (ruleQueue.isEmpty()) {
            throw new RuleExecuteExption("\u6761\u4ef6\u7ec4\u4ef6\u8282\u70b9\u89c4\u5219\u4e0d\u6b63\u786e\uff0c\u5206\u7ec4\u4e0b\u672a\u914d\u7f6e\u5177\u4f53\u89c4\u5219\uff0c\u65e0\u6cd5\u9884\u5ba1");
        }
        StringBuilder stringBuilder = new StringBuilder();
        while (!ruleQueue.isEmpty()) {
            RuleVo rule = ruleQueue.poll();
            if (ObjectUtils.isNotEmpty((Object)rule.getLogicOperator())) {
                stringBuilder.append(rule.getLogicOperator() == 1 ? "&&" : "||");
            }
            boolean result = rule instanceof RuleGroupVo ? this.executeRuleGroup(itemRecord, (RuleGroupVo)rule, extractedData) : this.executeRuleInfo(itemRecord, (RuleInfoVo)rule, extractedData);
            stringBuilder.append(result);
        }
        return (Boolean)this.ruleFormula.execute(stringBuilder.toString());
    }

    private boolean executeRuleInfo(RuleItemRecordDto itemRecord, RuleInfoVo rule, Map<String, Object> extractedData) {
        boolean result;
        RuleInfoRecordDto ruleResult = new RuleInfoRecordDto(itemRecord);
        ruleResult.setRuleInfoId(rule.getId());
        try {
            result = this.executeRule(rule, extractedData);
            ruleResult.setResult(result ? 1 : 2);
            itemRecord.getRuleInfoList().add(ruleResult);
        }
        catch (RuleExecuteExption e) {
            ruleResult.setResult(3);
            itemRecord.getRuleInfoList().add(ruleResult);
            throw new RuleExecuteExption(rule.getFormulaCode() + "\u89c4\u5219\u5ba1\u67e5\u5f02\u5e38\uff1b" + e.getMessage());
        }
        return result;
    }

    private boolean executeRule(RuleInfoVo rule, Map<String, Object> extractedData) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        String expression = Objects.equals(1, rule.getFormulaType()) ? this.handleParamAndExpress(paramMap, rule, extractedData) : this.handleCustomizeParamAndExpress(paramMap, rule, extractedData);
        FormulaExecuteVo executeVo = new FormulaExecuteVo();
        executeVo.setExpression(this.handleDot(expression));
        executeVo.setExtractedData(paramMap);
        return (Boolean)this.ruleFormula.executeFormula(executeVo);
    }

    private String handleParamAndExpress(Map<String, Object> paramMap, RuleInfoVo rule, Map<String, Object> extractedData) {
        StringBuilder expression = new StringBuilder();
        List paramList = JSON.parseArray((String)rule.getFormulaParams(), FormulaParamDto.class);
        paramList.sort(Comparator.comparingInt(FormulaParamDto::getIndexNum));
        expression.append(rule.getFormulaCode()).append("(");
        paramList.forEach(t -> {
            if (StringUtils.isBlank((CharSequence)t.getExtractItemKey()) && StringUtils.isNotBlank((CharSequence)t.getParamValue())) {
                if (t.getIndexNum() > 1) {
                    expression.append(",");
                }
                String uuid = "zdy" + IdUtils.fastSimpleUUID();
                expression.append(uuid);
                paramMap.put(uuid, this.getRealValue((FormulaParamDto)t, t.getParamValue()));
            } else if (StringUtils.isNotBlank((CharSequence)t.getExtractItemKey())) {
                if (t.getIndexNum() > 1) {
                    expression.append(",");
                }
                expression.append("e").append(this.handleDot(t.getExtractItemKey()));
                paramMap.put("e" + this.handleDot(t.getExtractItemKey()), this.getRealValue((FormulaParamDto)t, this.getValueByPath(extractedData, t.getExtractItemKey())));
            }
        });
        expression.append(")");
        return expression.toString();
    }

    private String handleCustomizeParamAndExpress(Map<String, Object> paramMap, RuleInfoVo rule, Map<String, Object> extractedData) {
        List paramList = JSON.parseArray((String)rule.getFormulaParams(), FormulaParamDto.class);
        paramList.sort(Comparator.comparingInt(t -> {
            if (StringUtils.isNotBlank((CharSequence)t.getExtractItemName())) {
                return -t.getExtractItemName().length();
            }
            return 0;
        }));
        String[] expressionCode = new String[]{rule.getFormulaCode()};
        paramList.forEach(t -> {
            if (StringUtils.isBlank((CharSequence)t.getExtractItemKey()) && StringUtils.isNotBlank((CharSequence)t.getParamValue())) {
                String uuid = "zdy" + IdUtils.fastSimpleUUID();
                if (StringUtils.isNotBlank((CharSequence)t.getExtractItemName())) {
                    expressionCode[0] = this.transformExpress(expressionCode[0], t.getExtractItemName(), uuid);
                }
                paramMap.put(uuid, this.getRealValue((FormulaParamDto)t, t.getParamValue()));
            } else if (StringUtils.isNotBlank((CharSequence)t.getExtractItemKey())) {
                expressionCode[0] = this.transformExpress(expressionCode[0], t.getExtractItemName(), t.getExtractItemKey());
                paramMap.put("e" + this.handleDot(t.getExtractItemKey()), this.getRealValue((FormulaParamDto)t, this.getValueByPath(extractedData, t.getExtractItemKey())));
            }
        });
        return expressionCode[0];
    }

    private String transformExpress(String original, String extractName, String extractKey) {
        return original.replaceAll("\\(" + extractName + ",", "(e" + this.handleDot(extractKey) + ",").replaceAll("," + extractName + ",", ",e" + this.handleDot(extractKey) + ",").replaceAll("," + extractName + "\\)", ",e" + this.handleDot(extractKey) + ")").replaceAll(extractName, "e" + this.handleDot(extractKey));
    }

    private Queue<RuleVo> sortRules(RuleGroupVo tree) {
        ArrayList<RuleVo> rules = new ArrayList<RuleVo>();
        if (CollectionUtils.isNotEmpty((Collection)tree.getRuleGroupList())) {
            rules.addAll(tree.getRuleGroupList());
        }
        if (CollectionUtils.isNotEmpty((Collection)tree.getRuleInfoList())) {
            rules.addAll(tree.getRuleInfoList());
        }
        rules.sort(Comparator.comparingInt(RuleVo::getIndexNum));
        return new LinkedList<RuleVo>(rules);
    }

    private String handleDot(String str) {
        return str.replace("\u00b7", ".");
    }

    private Object getValueByPath(Map<String, Object> param, String path) {
        String[] paths = path.split("\u00b7");
        Map<String, Object> p = param;
        for (String s : paths) {
            if (!(p instanceof HashMap)) break;
            HashMap map = (HashMap)p;
            p = map.get(s);
        }
        return p;
    }

    private Object getRealValue(FormulaParamDto param, Object p) {
        if (p == null || StringUtils.isEmpty((CharSequence)String.valueOf(p))) {
            return null;
        }
        if ("date".equals(param.getExtractItemDatatype())) {
            return this.getLocalDateValue(p);
        }
        if ("number".equals(param.getExtractItemDatatype())) {
            return this.getNumberValue(p);
        }
        if ("text".equals(param.getExtractItemDatatype())) {
            return String.valueOf(p);
        }
        return p;
    }

    private Number getNumberValue(Object p) {
        try {
            if (p instanceof Number) {
                return (Number)p;
            }
            if (p instanceof String) {
                return NumberUtils.createNumber((String)String.valueOf(p));
            }
        }
        catch (Exception e) {
            throw new RuleExecuteParamException("\u89c4\u5219\u8ba1\u7b97\u53c2\u6570\u503c\u5f02\u5e38\uff0c\u9700\u8981\u7684\u662f\u6570\u5b57\u683c\u5f0f\u6570\u636e\uff0c\u4f20\u5165\u7684\u662f\u975e\u6570\u5b57\u683c\u5f0f\u6570\u636e");
        }
        throw new RuleExecuteParamException("\u89c4\u5219\u8ba1\u7b97\u53c2\u6570\u503c\u5f02\u5e38\uff0c\u9700\u8981\u7684\u662f\u6570\u5b57\u683c\u5f0f\u6570\u636e\uff0c\u4f20\u5165\u7684\u662f\u975e\u6570\u5b57\u683c\u5f0f\u6570\u636e");
    }

    private LocalDateTime getLocalDateValue(Object p) {
        if (p instanceof LocalDate) {
            return LocalDateTime.of((LocalDate)p, LocalDateTime.now().toLocalTime());
        }
        if (p instanceof LocalDateTime) {
            return (LocalDateTime)p;
        }
        if (p instanceof Date) {
            Instant instant = ((Date)p).toInstant();
            ZoneId zoneId = ZoneId.systemDefault();
            return LocalDateTime.ofInstant(instant, zoneId);
        }
        if (p instanceof String) {
            if (StringUtils.isEmpty((CharSequence)String.valueOf(p))) {
                throw new RuleExecuteParamException("\u89c4\u5219\u8ba1\u7b97\u53c2\u6570\u503c\u5f02\u5e38\uff0c\u9700\u8981\u7684\u662f\u65e5\u671f\u683c\u5f0f\u6570\u636e\uff0c\u4f20\u5165\u7684\u662f\u7a7a\u5b57\u7b26\u4e32");
            }
            String dateStr = this.getDateStr(p);
            try {
                DateTime t = DateUtil.parse((String)dateStr);
                Instant instant = t.toInstant();
                ZoneId zoneId = ZoneId.systemDefault();
                return LocalDateTime.ofInstant(instant, zoneId);
            }
            catch (Exception e) {
                throw new RuleExecuteParamException("\u89c4\u5219\u8ba1\u7b97\u53c2\u6570\u503c\u5f02\u5e38\uff0c\u9700\u8981\u7684\u662f\u65e5\u671f\u683c\u5f0f\u6570\u636e\uff0c\u4f20\u5165\u53c2\u6570\u3010" + p + "\u3011\u4e0d\u80fd\u8f6c\u6362\u4e3a\u65e5\u671f\u683c\u5f0f");
            }
        }
        return null;
    }

    private String getDateStr(Object p) {
        String dateStr = String.valueOf(p).replace(" ", "");
        if (dateStr.contains("\u65f6") && dateStr.contains("\u65e5")) {
            dateStr = dateStr.replace("\u65e5", "\u65e5 ");
        }
        return dateStr;
    }
}

