/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.rule.server.controller;

import com.jxdinfo.idp.common.base.dto.ImplCodeDto;
import com.jxdinfo.idp.common.response.ApiResponse;
import com.jxdinfo.idp.rule.api.vo.ExtractItemQueryVo;
import com.jxdinfo.idp.rule.api.vo.ExtractItemVo;
import com.jxdinfo.idp.rule.api.vo.RuleLibVo;
import com.jxdinfo.idp.rule.server.internal.service.IExtractItemService;
import com.jxdinfo.idp.rule.server.service.IRuleLibService;
import java.util.Collections;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rule/lib"})
public class RuleLibController {
    @Resource
    private IRuleLibService ruleLibService;
    @Resource
    private IExtractItemService extractItemService;

    @PostMapping(value={"/save"})
    public ApiResponse<RuleLibVo> save(@RequestBody RuleLibVo ruleLib) {
        return ApiResponse.success((Object)this.ruleLibService.save(ruleLib));
    }

    @GetMapping(value={"/del"})
    public ApiResponse<Void> del(@RequestParam Long ruleLibId) {
        return ApiResponse.status((boolean)this.ruleLibService.batchDel(Collections.singletonList(ruleLibId)));
    }

    @PostMapping(value={"/batchDel"})
    public ApiResponse<Void> batchDel(@RequestBody List<Long> ruleLibIds) {
        return ApiResponse.status((boolean)this.ruleLibService.batchDel(ruleLibIds));
    }

    @GetMapping(value={"/forcedDel"})
    public ApiResponse<Void> forcedDel(@RequestParam List<Long> ruleLibId) {
        return ApiResponse.status((boolean)this.ruleLibService.forcedDel(ruleLibId));
    }

    @PostMapping(value={"relateExtractItem"})
    public ApiResponse<Void> relateExtractItem(@RequestBody RuleLibVo ruleLib) {
        return ApiResponse.status((boolean)this.ruleLibService.relateExtractItem(ruleLib));
    }

    @PostMapping(value={"/delRelatedExtractItem"})
    public ApiResponse<Void> delRelatedExtractItem(@RequestBody Long[] relatedExtractItemIds) {
        return ApiResponse.status((boolean)this.ruleLibService.delRelatedExtractItem(relatedExtractItemIds));
    }

    @PostMapping(value={"/addRelatedExtractItem"})
    public ApiResponse<Void> addRelatedExtractItem(@RequestBody List<ExtractItemVo> extractItemList) {
        return ApiResponse.status((boolean)this.ruleLibService.addrelatedExtractItem(extractItemList));
    }

    @PostMapping(value={"/getRelatedExtractItem"})
    public ApiResponse<List<ExtractItemVo>> getRuleItemExtractItem(@RequestBody RuleLibVo ruleLib) {
        return ApiResponse.success(this.ruleLibService.getLibRelatedExtractItem(ruleLib));
    }

    @PostMapping(value={"getExtractItem"})
    public ApiResponse<List<ExtractItemVo>> getExtractItem(@RequestBody ExtractItemQueryVo queryVo) {
        return ApiResponse.success(this.extractItemService.getExtractItem(queryVo));
    }

    @GetMapping(value={"/getExtractItemApi"})
    public ApiResponse<List<ImplCodeDto>> getExtractItemApi() {
        return ApiResponse.success(this.extractItemService.getExtractItemApi());
    }
}

