/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.rule.server.service.impl;

import cn.afterturn.easypoi.excel.ExcelImportUtil;
import cn.afterturn.easypoi.excel.entity.ImportParams;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.idp.common.base.dto.LogicDeleteAuditInfoDto;
import com.jxdinfo.idp.common.exception.BusinessException;
import com.jxdinfo.idp.rule.api.vo.ExtractItemVo;
import com.jxdinfo.idp.rule.api.vo.RuleGroupVo;
import com.jxdinfo.idp.rule.api.vo.RuleImportVo;
import com.jxdinfo.idp.rule.api.vo.RuleItemVo;
import com.jxdinfo.idp.rule.api.vo.RuleLibVo;
import com.jxdinfo.idp.rule.server.dto.AIGenerateRuleResultDto;
import com.jxdinfo.idp.rule.server.dto.AIRequestParamDto;
import com.jxdinfo.idp.rule.server.dto.RuleItemExcelDto;
import com.jxdinfo.idp.rule.server.dto.RuleLibDto;
import com.jxdinfo.idp.rule.server.internal.ai.AIGenerateRuleService;
import com.jxdinfo.idp.rule.server.internal.service.IRuleGroupService;
import com.jxdinfo.idp.rule.server.internal.service.IRuleNodeService;
import com.jxdinfo.idp.rule.server.mapper.RuleItemMapper;
import com.jxdinfo.idp.rule.server.mapper.RuleLibMapper;
import com.jxdinfo.idp.rule.server.po.RuleItemPo;
import com.jxdinfo.idp.rule.server.po.RuleNodePo;
import com.jxdinfo.idp.rule.server.service.IRuleItemService;
import com.jxdinfo.idp.rule.server.service.RemoveSceneExtractItemDocTypeService;
import com.jxdinfo.idp.rule.server.service.RemoveSceneRuleExtractService;
import com.jxdinfo.idp.rule.server.service.RemoveSceneRuleItemDocTypeService;
import com.jxdinfo.idp.rule.server.service.RemoveSceneRuleReviewItemService;
import java.io.InputStream;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;
import org.springframework.web.multipart.MultipartFile;

@Service
public class RuleItemServiceImpl
extends ServiceImpl<RuleItemMapper, RuleItemPo>
implements IRuleItemService {
    private static final Logger log = LoggerFactory.getLogger(RuleItemServiceImpl.class);
    @Resource
    private RuleLibMapper ruleLibMapper;
    @Resource
    private RuleItemMapper ruleItemMapper;
    @Resource
    private IRuleNodeService ruleNodeService;
    @Resource
    private IRuleGroupService ruleGroupService;
    @Resource
    private AIGenerateRuleService aiGenerateRuleService;
    @Resource
    private RemoveSceneExtractItemDocTypeService removeSceneExtractItemDocTypeService;
    @Resource
    private RemoveSceneRuleItemDocTypeService removeSceneRuleItemDocTypeService;
    @Resource
    private RemoveSceneRuleExtractService removeSceneRuleExtractService;
    @Resource
    private RemoveSceneRuleReviewItemService removeSceneRuleReviewItemService;
    private final Random random = new Random();

    @Override
    @Transactional
    public RuleItemVo save(RuleItemVo ruleItemVo) {
        RuleItemPo ruleItemPo = new RuleItemPo();
        BeanUtils.copyProperties((Object)ruleItemVo, (Object)ruleItemPo);
        try {
            if (Objects.isNull(ruleItemPo.getId()) || ruleItemPo.getId() == 0L) {
                this.ruleItemMapper.insert(ruleItemPo);
                ruleItemVo.setId(ruleItemPo.getId());
            } else {
                this.ruleItemMapper.updateById(ruleItemPo);
            }
        }
        catch (Exception e) {
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            log.error("\u5ba1\u67e5\u9879\u4fdd\u5b58\u5f02\u5e38\uff1a{}", (Object)e.getMessage(), (Object)e);
            throw new BusinessException("\u64cd\u4f5c\u5931\u8d25\uff0c\u8bf7\u67e5\u770b\u540e\u53f0\u65e5\u5fd7");
        }
        return ruleItemVo;
    }

    @Override
    @Transactional
    public boolean del(Long ruleItemId) {
        this.delRuleItem(ruleItemId);
        this.removeSceneExtractItemDocTypeService.removeItem(ruleItemId);
        this.removeSceneRuleExtractService.removeItem(ruleItemId);
        this.removeSceneRuleItemDocTypeService.removeItem(ruleItemId);
        this.removeSceneRuleReviewItemService.removeItem(ruleItemId);
        return true;
    }

    private boolean delRuleItem(Long ruleItemId) {
        try {
            RuleItemPo po = new RuleItemPo();
            po.setId(ruleItemId);
            this.ruleItemMapper.deleteById(po);
            LambdaUpdateWrapper nodeQuery = new LambdaUpdateWrapper();
            nodeQuery.eq(ruleItemId != null, RuleNodePo::getRuleItemId, (Object)ruleItemId);
            nodeQuery.set(LogicDeleteAuditInfoDto::getDeleteTime, (Object)LocalDateTime.now());
            nodeQuery.set(LogicDeleteAuditInfoDto::getDeleteFlag, (Object)1);
            this.ruleNodeService.update((Wrapper)nodeQuery);
            this.ruleGroupService.removeAllRule(ruleItemId, null);
        }
        catch (Exception e) {
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            log.error("\u5ba1\u67e5\u9879\u5220\u9664\u5f02\u5e38\uff1a{}", (Object)e.getMessage(), (Object)e);
            return false;
        }
        return true;
    }

    @Override
    @Transactional
    public boolean aiImport(MultipartFile file, RuleImportVo ruleImportVo) {
        try {
            ImportParams params = new ImportParams();
            params.setTitleRows(0);
            params.setHeadRows(1);
            List ruleItemExcelDtos = ExcelImportUtil.importExcel((InputStream)file.getInputStream(), RuleItemExcelDto.class, (ImportParams)params);
            if (CollectionUtils.isEmpty((Collection)ruleItemExcelDtos)) {
                log.info("\u5ba1\u67e5\u9879\u5bfc\u5165\u6570\u636e\u4e3a\u7a7a");
                return false;
            }
            ArrayList<RuleItemPo> ruleItemPos = new ArrayList<RuleItemPo>();
            for (RuleItemExcelDto ruleItemExcelDto : ruleItemExcelDtos) {
                RuleItemPo po = ruleItemExcelDto.convertToPo();
                po.setRuleLibId(ruleImportVo.getRuleLibId());
                ruleItemPos.add(po);
            }
            this.saveBatch(ruleItemPos);
            if (ruleImportVo.getIsAiGenerate() == 1) {
                this.aiGenerateBatch(ruleItemPos, ruleImportVo);
            }
        }
        catch (BusinessException e) {
            throw e;
        }
        catch (Exception e) {
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            log.error("\u5ba1\u67e5\u9879\u5bfc\u5165\u5f02\u5e38\uff1a{}", (Object)e.getMessage(), (Object)e);
            return false;
        }
        return true;
    }

    private void aiGenerateBatch(List<RuleItemPo> ruleItemPos, RuleImportVo ruleImportVo) {
        RuleLibDto libDto;
        List<ExtractItemVo> vo = this.ruleLibMapper.queryLibRelatedExtractItem(new RuleLibVo(ruleImportVo.getRuleLibId()));
        if (CollectionUtils.isEmpty(vo)) {
            throw new BusinessException("\u672a\u67e5\u8be2\u5230\u89c4\u5219\u5e93\u5173\u8054\u7684\u63d0\u53d6\u9879\uff0c\u8bf7\u5148\u5173\u8054\u63d0\u53d6\u9879");
        }
        String[] ruleItemNames = (String[])ruleItemPos.stream().map(RuleItemPo::getRuleItemName).toArray(String[]::new);
        AIRequestParamDto requestParamDto = new AIRequestParamDto(ruleItemNames, libDto = new RuleLibDto(vo));
        List<AIGenerateRuleResultDto> resultDtoList = this.aiGenerateRuleService.aiGenerateRule(requestParamDto);
        if (CollectionUtils.isEmpty(resultDtoList)) {
            throw new BusinessException("AI\u63a5\u53e3\u672a\u80fd\u751f\u6210\u89c4\u5219\uff0c\u8bf7\u68c0\u67e5\u4e0a\u4f20\u6587\u6863\u6570\u636e");
        }
        long canvasId = System.currentTimeMillis() * 1000L + (long)this.random.nextInt(1000);
        ArrayList nodePoList = new ArrayList();
        ArrayList<RuleGroupVo> ruleGroupVoList = new ArrayList<RuleGroupVo>();
        AtomicInteger index = new AtomicInteger();
        ruleItemPos.forEach(rulePo -> resultDtoList.forEach(resultDto -> {
            if (Objects.equals(resultDto.getQuestion(), rulePo.getRuleItemName())) {
                rulePo.setReviewLogic(this.aiGenerateRuleService.getCanvasStr(canvasId + (long)index.get(), resultDto.getRule()));
                nodePoList.addAll(this.aiGenerateRuleService.getCanvasNodePo(rulePo.getId(), canvasId + (long)index.get()));
                ruleGroupVoList.add(this.aiGenerateRuleService.getRuleGroup(rulePo.getId(), (canvasId + (long)index.get()) * 100L + 1L, resultDto.getRule()));
                index.getAndIncrement();
            }
        }));
        this.updateBatchById(ruleItemPos);
        this.ruleNodeService.saveBatch(nodePoList);
        this.ruleGroupService.saveGroupInfoBatch(ruleGroupVoList);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean aiGenerate(RuleItemVo ruleItemVo) {
        List<ExtractItemVo> vo = this.ruleLibMapper.queryLibRelatedExtractItem(new RuleLibVo(ruleItemVo.getRuleLibId()));
        if (CollectionUtils.isEmpty(vo)) {
            throw new BusinessException("\u672a\u67e5\u8be2\u5230\u89c4\u5219\u5e93\u5173\u8054\u7684\u63d0\u53d6\u9879\uff0c\u8bf7\u5148\u5173\u8054\u63d0\u53d6\u9879");
        }
        RuleLibDto libDto = new RuleLibDto(vo);
        AIRequestParamDto requestParamDto = new AIRequestParamDto(new String[]{ruleItemVo.getRuleItemName()}, libDto);
        List<AIGenerateRuleResultDto> resultDto = this.aiGenerateRuleService.aiGenerateRule(requestParamDto);
        if (CollectionUtils.isEmpty(resultDto)) {
            throw new BusinessException("AI\u63a5\u53e3\u672a\u80fd\u751f\u6210\u89c4\u5219\uff0c\u8bf7\u66f4\u6362\u5ba1\u67e5\u540d\u79f0\u540e\u91cd\u8bd5");
        }
        long canvasId = System.currentTimeMillis() * 1000L + (long)this.random.nextInt(1000);
        ruleItemVo.setReviewLogic(this.aiGenerateRuleService.getCanvasStr(canvasId, resultDto.get(0).getRule()));
        ruleItemVo.setNodeList(this.aiGenerateRuleService.getCanvasNode(ruleItemVo.getId(), canvasId));
        this.saveReviewLogic(ruleItemVo);
        this.ruleGroupService.saveGroupInfo(this.aiGenerateRuleService.getRuleGroup(ruleItemVo.getId(), canvasId * 100L + 1L, resultDto.get(0).getRule()));
        return true;
    }

    @Override
    @Transactional
    public boolean saveReviewLogic(RuleItemVo ruleItemVo) {
        RuleItemPo ruleItemPo = new RuleItemPo();
        ruleItemPo.setId(ruleItemVo.getId());
        ruleItemPo.setReviewLogic(ruleItemVo.getReviewLogic());
        List nodeList = ruleItemVo.getNodeList();
        ArrayList nodePos = new ArrayList();
        ArrayList<Long> nodeIds = new ArrayList<Long>();
        ArrayList<RuleGroupVo> ruleGroupVoList = new ArrayList<RuleGroupVo>();
        if (CollectionUtils.isNotEmpty((Collection)nodeList)) {
            nodeList.forEach(t -> {
                RuleNodePo ruleNodePo = new RuleNodePo();
                BeanUtils.copyProperties((Object)t, (Object)ruleNodePo);
                ruleNodePo.setRuleItemId(ruleItemPo.getId());
                nodePos.add(ruleNodePo);
                nodeIds.add(t.getId());
                if (t.getRules() != null) {
                    ruleGroupVoList.add(t.getRules());
                }
            });
        }
        try {
            this.ruleItemMapper.updateById(ruleItemPo);
            if (!nodePos.isEmpty() && StringUtils.isNotBlank((CharSequence)ruleItemVo.getReviewLogic())) {
                this.ruleNodeService.removeByRuleItemId(ruleItemPo.getId());
                this.ruleGroupService.deleteByRel(ruleItemPo.getId(), nodeIds);
                this.ruleNodeService.saveBatch(nodePos);
                if (!ruleGroupVoList.isEmpty()) {
                    this.ruleGroupService.saveGroupInfoBatch(ruleGroupVoList);
                }
            }
        }
        catch (Exception e) {
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            log.error("\u5ba1\u67e5\u9879\u5ba1\u67e5\u903b\u8f91\u56fe\u4fdd\u5b58\u5f02\u5e38\uff1a{}", (Object)e.getMessage(), (Object)e);
            return false;
        }
        return true;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean saveRule(RuleGroupVo ruleGroupVo) {
        this.ruleGroupService.deleteAllRule(ruleGroupVo.getRuleItemId(), ruleGroupVo.getNodeId());
        this.ruleGroupService.saveGroupInfo(ruleGroupVo);
        return true;
    }

    @Override
    public String queryReviewLogic(RuleItemVo ruleItemVo) {
        try {
            RuleItemPo ruleItemPo = (RuleItemPo)this.ruleItemMapper.selectById(ruleItemVo.getId());
            if (ruleItemPo != null) {
                return ruleItemPo.getReviewLogic();
            }
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u5ba1\u67e5\u9879\u5ba1\u67e5\u903b\u8f91\u56fe\u5f02\u5e38\uff1a{}", (Object)e.getMessage(), (Object)e);
        }
        return "";
    }

    @Override
    public RuleGroupVo queryRule(RuleGroupVo ruleGroupVo) {
        if (ObjectUtils.isEmpty((Object)ruleGroupVo.getNodeId())) {
            throw new BusinessException("\u5ba1\u67e5\u903b\u8f91\u8282\u70b9id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.ruleGroupService.queryGroupInfo(ruleGroupVo.getNodeId());
    }
}

