/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.rule.server.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.jxdinfo.idp.common.base.dto.LogicDeleteAuditInfoDto;
import com.jxdinfo.idp.common.exception.BusinessException;
import com.jxdinfo.idp.rule.api.vo.ExtractItemVo;
import com.jxdinfo.idp.rule.api.vo.RuleItemVo;
import com.jxdinfo.idp.rule.api.vo.RuleLibVo;
import com.jxdinfo.idp.rule.server.dto.RuleItemQueryDto;
import com.jxdinfo.idp.rule.server.internal.service.IRuleLibReleExtractItemService;
import com.jxdinfo.idp.rule.server.internal.service.IRuleLibRelevancyService;
import com.jxdinfo.idp.rule.server.mapper.RuleItemMapper;
import com.jxdinfo.idp.rule.server.mapper.RuleLibMapper;
import com.jxdinfo.idp.rule.server.po.RuleItemPo;
import com.jxdinfo.idp.rule.server.po.RuleLibPo;
import com.jxdinfo.idp.rule.server.po.RuleLibReleExtractItemPo;
import com.jxdinfo.idp.rule.server.po.RuleLibRelevancyPo;
import com.jxdinfo.idp.rule.server.service.IRuleItemService;
import com.jxdinfo.idp.rule.server.service.IRuleLibService;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;

@Service
public class RuleLibServiceImpl
implements IRuleLibService {
    private static final Logger log = LoggerFactory.getLogger(RuleLibServiceImpl.class);
    @Resource
    private RuleLibMapper ruleLibMapper;
    @Resource
    private IRuleLibReleExtractItemService ruleLibReleExtractItemService;
    @Resource
    private IRuleLibRelevancyService ruleLibRelevancyService;
    @Resource
    private IRuleItemService ruleItemService;
    @Resource
    private RuleItemMapper ruleItemMapper;

    @PostConstruct
    private void initDefaultGroup() {
        try {
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(RuleLibPo::getId, (Object)RuleLibPo.defaultGroup().getId());
            if (this.ruleLibMapper.selectCount((Wrapper)queryWrapper) < 1L) {
                log.info("\u89c4\u5219\u5e93\u521d\u59cb\u5316\u9ed8\u8ba4\u5206\u7ec4");
                this.ruleLibMapper.insert(RuleLibPo.defaultGroup());
                this.ruleLibRelevancyService.saveOrUpdate(RuleLibRelevancyPo.defaultGroupRel());
            }
        }
        catch (Exception e) {
            log.error("\u89c4\u5219\u5e93\u521d\u59cb\u5316\u9ed8\u8ba4\u5206\u7ec4\u5f02\u5e38\uff1a{}", (Object)e.getMessage(), (Object)e);
        }
    }

    @Override
    @Transactional
    public RuleLibVo save(RuleLibVo ruleLib) {
        RuleLibPo ruleLibPo = new RuleLibPo();
        BeanUtils.copyProperties((Object)ruleLib, (Object)ruleLibPo);
        if (Objects.equals(RuleLibPo.defaultGroup().getId(), ruleLib.getId())) {
            throw new BusinessException("\u9ed8\u8ba4\u5206\u7ec4\u4e0d\u5141\u8bb8\u4fee\u6539");
        }
        try {
            if (Objects.isNull(ruleLibPo.getId()) || ruleLibPo.getId() == 0L) {
                this.ruleLibMapper.insert(ruleLibPo);
                ruleLib.setId(ruleLibPo.getId());
                LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
                queryWrapper.eq(RuleLibRelevancyPo::getCid, (Object)ruleLib.getPid());
                List libRelevancyPos = this.ruleLibRelevancyService.list((Wrapper)queryWrapper);
                if (CollectionUtils.isNotEmpty((Collection)libRelevancyPos)) {
                    libRelevancyPos.forEach(t -> {
                        t.setId(null);
                        t.setCid(ruleLibPo.getId());
                        t.setDistance(t.getDistance() + 1);
                    });
                }
                libRelevancyPos.add(new RuleLibRelevancyPo(ruleLib));
                this.ruleLibRelevancyService.saveBatch(libRelevancyPos);
            } else {
                this.ruleLibMapper.updateById(ruleLibPo);
                this.keepRelevance(ruleLib);
            }
        }
        catch (Exception e) {
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            log.error("\u89c4\u5219\u5e93\u4fdd\u5b58\u5f02\u5e38\uff1a{}", (Object)e.getMessage(), (Object)e);
            throw new BusinessException("\u64cd\u4f5c\u5931\u8d25\uff0c\u8bf7\u67e5\u770b\u540e\u53f0\u65e5\u5fd7");
        }
        return ruleLib;
    }

    private void keepRelevance(RuleLibVo ruleLib) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(RuleLibRelevancyPo::getCid, (Object)ruleLib.getId());
        queryWrapper.eq(RuleLibRelevancyPo::getDistance, (Object)1);
        List libRelevancyPos = this.ruleLibRelevancyService.list((Wrapper)queryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)libRelevancyPos) && !Objects.equals(ruleLib.getPid(), ((RuleLibRelevancyPo)libRelevancyPos.get(0)).getPid())) {
            queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(RuleLibRelevancyPo::getCid, (Object)ruleLib.getPid());
            List newLibRelevancyPos = this.ruleLibRelevancyService.list((Wrapper)queryWrapper);
            if (CollectionUtils.isEmpty((Collection)newLibRelevancyPos)) {
                throw new BusinessException("\u89c4\u5219\u5e93\u5c42\u7ea7\u53d8\u66f4\u5931\u8d25\uff0c\u7236\u8282\u70b9\u4e0d\u5b58\u5728");
            }
            newLibRelevancyPos.forEach(t -> {
                t.setId(null);
                t.setCid(ruleLib.getId());
                t.setDistance(t.getDistance() + 1);
            });
            newLibRelevancyPos.add(new RuleLibRelevancyPo(ruleLib));
            queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(RuleLibRelevancyPo::getPid, (Object)ruleLib.getId());
            List subNodes = this.ruleLibRelevancyService.list((Wrapper)queryWrapper);
            List<Long> relIds = subNodes.stream().map(RuleLibRelevancyPo::getCid).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty((Collection)subNodes)) {
                ArrayList newSubNodes = new ArrayList();
                queryWrapper = new LambdaQueryWrapper();
                queryWrapper.in(RuleLibRelevancyPo::getCid, relIds);
                List allSubNodesRel = this.ruleLibRelevancyService.list((Wrapper)queryWrapper);
                subNodes.forEach(node -> {
                    List nodeRel = allSubNodesRel.stream().filter(t -> Objects.equals(t.getCid(), node.getCid()) && t.getDistance() <= node.getDistance()).collect(Collectors.toList());
                    newLibRelevancyPos.forEach(t -> {
                        RuleLibRelevancyPo newRel = new RuleLibRelevancyPo();
                        newRel.setPid(t.getPid());
                        newRel.setCid(node.getCid());
                        newRel.setDistance(t.getDistance() + node.getDistance());
                        nodeRel.add(newRel);
                    });
                    newSubNodes.addAll(nodeRel);
                });
                newLibRelevancyPos.addAll(newSubNodes);
            }
            relIds.add(ruleLib.getId());
            this.ruleLibRelevancyService.deleteAllRel(relIds);
            this.ruleLibRelevancyService.saveBatch(newLibRelevancyPos);
        }
    }

    @Override
    @Transactional
    @Deprecated
    public boolean relateExtractItem(RuleLibVo ruleLib) {
        StringBuilder stringBuilder = new StringBuilder(",");
        ArrayList ruleLibReleExtractItemPos = new ArrayList();
        List extractItemVos = ruleLib.getExtractItemList();
        if (CollectionUtils.isNotEmpty((Collection)extractItemVos)) {
            extractItemVos.forEach(t -> {
                if (stringBuilder.toString().contains("," + t.getExtractItemName() + ",")) {
                    throw new BusinessException("\u540c\u4e00\u4e2a\u89c4\u5219\u5e93\u4e0b\u5173\u8054\u7684\u63d0\u53d6\u9879\u540d\u79f0\u4e0d\u80fd\u91cd\u590d");
                }
                stringBuilder.append(t.getExtractItemName()).append(",");
                RuleLibReleExtractItemPo extractItemPo = new RuleLibReleExtractItemPo();
                BeanUtils.copyProperties((Object)t, (Object)extractItemPo);
                extractItemPo.setRuleLibId(ruleLib.getId());
                ruleLibReleExtractItemPos.add(extractItemPo);
            });
        }
        try {
            this.ruleLibReleExtractItemService.deleteByRuleLibId(ruleLib.getId());
            if (!ruleLibReleExtractItemPos.isEmpty()) {
                this.ruleLibReleExtractItemService.saveBatch(ruleLibReleExtractItemPos);
            }
        }
        catch (Exception e) {
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            log.error("\u89c4\u5219\u5e93\u5173\u8054\u63d0\u53d6\u9879\u5f02\u5e38\uff1a{}", (Object)e.getMessage(), (Object)e);
            return false;
        }
        return true;
    }

    @Override
    public boolean delRelatedExtractItem(Long[] relatedExtractItemIds) {
        List<ExtractItemVo> extractItemVos = this.ruleLibMapper.queryLibRelatedExtractItemById(relatedExtractItemIds);
        if (CollectionUtils.isNotEmpty(extractItemVos)) {
            RuleItemQueryDto queryDto = new RuleItemQueryDto();
            queryDto.setRuleLibIds(new Long[]{extractItemVos.get(0).getRuleLibId()});
            queryDto.setExtractItemKeys((String[])extractItemVos.stream().map(ExtractItemVo::getExtractItemKey).toArray(String[]::new));
            List<RuleItemVo> ruleItems = this.ruleItemMapper.queryPage(queryDto);
            if (CollectionUtils.isNotEmpty(ruleItems)) {
                throw new BusinessException("\u63d0\u53d6\u9879\u5df2\u88ab\u89c4\u5219\u5f15\u7528\uff0c\u4e0d\u5141\u8bb8\u5220\u9664");
            }
            try {
                this.ruleLibReleExtractItemService.removeByIds(Arrays.asList(relatedExtractItemIds));
            }
            catch (Exception e) {
                log.error("\u5220\u9664\u89c4\u5219\u5e93\u5173\u8054\u63d0\u53d6\u9879\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean addrelatedExtractItem(List<ExtractItemVo> extractItemList) {
        if (CollectionUtils.isNotEmpty(extractItemList)) {
            RuleLibVo ruleLibVo = new RuleLibVo();
            ruleLibVo.setId(extractItemList.get(0).getRuleLibId());
            List<ExtractItemVo> related = this.ruleLibMapper.queryLibRelatedExtractItem(ruleLibVo);
            StringBuilder stringBuilder = new StringBuilder(",");
            related.forEach(t -> stringBuilder.append(t.getExtractItemName()).append(","));
            ArrayList ruleLibReleExtractItemPos = new ArrayList();
            extractItemList.forEach(t -> {
                if (stringBuilder.toString().contains("," + t.getExtractItemName() + ",")) {
                    throw new BusinessException("\u540c\u4e00\u4e2a\u89c4\u5219\u5e93\u4e0b\u5173\u8054\u7684\u63d0\u53d6\u9879\u540d\u79f0\u4e0d\u80fd\u91cd\u590d");
                }
                stringBuilder.append(t.getExtractItemName()).append(",");
                RuleLibReleExtractItemPo extractItemPo = new RuleLibReleExtractItemPo();
                BeanUtils.copyProperties((Object)t, (Object)extractItemPo);
                ruleLibReleExtractItemPos.add(extractItemPo);
            });
            try {
                if (!ruleLibReleExtractItemPos.isEmpty()) {
                    this.ruleLibReleExtractItemService.saveBatch(ruleLibReleExtractItemPos);
                }
            }
            catch (Exception e) {
                log.error("\u89c4\u5219\u5e93\u5173\u8054\u63d0\u53d6\u9879\u5f02\u5e38\uff1a{}", (Object)e.getMessage(), (Object)e);
                return false;
            }
        }
        return true;
    }

    @Override
    public List<ExtractItemVo> getLibRelatedExtractItem(RuleLibVo ruleLib) {
        try {
            return this.ruleLibMapper.queryLibRelatedExtractItem(ruleLib);
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u89c4\u5219\u5e93\u5df2\u5173\u8054\u7684\u63d0\u53d6\u9879\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            return new ArrayList<ExtractItemVo>();
        }
    }

    @Override
    @Transactional
    public boolean batchDel(List<Long> ruleLibIds) {
        if (CollectionUtils.isEmpty(ruleLibIds)) {
            throw new BusinessException("\u89c4\u5219\u5e93id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (ruleLibIds.contains(RuleLibPo.defaultGroup().getId())) {
            throw new BusinessException("\u9ed8\u8ba4\u5206\u7ec4\u4e0d\u5141\u8bb8\u5220\u9664");
        }
        try {
            long nextLevelLibCount = this.ruleLibMapper.queryNextLevelLibCount(ruleLibIds);
            if (nextLevelLibCount > 0L) {
                LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
                queryWrapper.eq(RuleLibRelevancyPo::getCid, (Object)ruleLibIds.get(0));
                long currentLevel = this.ruleLibRelevancyService.count((Wrapper)queryWrapper);
                if (currentLevel == 1L) {
                    throw new BusinessException("\u5220\u9664\u5931\u8d25\uff0c\u5b58\u5728\u4e0b\u7ea7\u89c4\u5219\u5e93");
                }
                throw new BusinessException("\u5220\u9664\u5931\u8d25\uff0c\u5b58\u5728\u4e0b\u7ea7\u5ba1\u67e5\u9879\u5206\u7ec4");
            }
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.in(RuleItemPo::getRuleLibId, ruleLibIds);
            long ruleItemCount = this.ruleItemService.count((Wrapper)queryWrapper);
            if (ruleItemCount > 0L) {
                throw new BusinessException("\u5220\u9664\u5931\u8d25\uff0c\u5b58\u5728\u4e0b\u7ea7\u5ba1\u67e5\u9879");
            }
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.set(LogicDeleteAuditInfoDto::getDeleteFlag, (Object)1);
            updateWrapper.set(LogicDeleteAuditInfoDto::getDeleteTime, (Object)LocalDateTime.now());
            updateWrapper.in(RuleLibPo::getId, ruleLibIds);
            this.ruleLibMapper.update(null, (Wrapper)updateWrapper);
            LambdaUpdateWrapper updateWrapper1 = new LambdaUpdateWrapper();
            updateWrapper1.set(LogicDeleteAuditInfoDto::getDeleteTime, (Object)LocalDateTime.now());
            updateWrapper1.set(LogicDeleteAuditInfoDto::getDeleteFlag, (Object)1);
            updateWrapper1.in(RuleLibRelevancyPo::getCid, ruleLibIds);
            this.ruleLibRelevancyService.update((Wrapper)updateWrapper1);
        }
        catch (BusinessException be) {
            throw be;
        }
        catch (Exception e) {
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            log.error("\u89c4\u5219\u5e93\u5220\u9664\u5f02\u5e38\uff1a{}", (Object)e.getMessage(), (Object)e);
            return false;
        }
        return true;
    }

    @Override
    @Transactional
    public boolean forcedDel(List<Long> ruleLibIds) {
        if (CollectionUtils.isEmpty(ruleLibIds)) {
            throw new BusinessException("\u89c4\u5219\u5e93id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (ruleLibIds.contains(RuleLibPo.defaultGroup().getId())) {
            throw new BusinessException("\u9ed8\u8ba4\u5206\u7ec4\u4e0d\u5141\u8bb8\u5220\u9664");
        }
        try {
            LambdaQueryWrapper relQuery = new LambdaQueryWrapper();
            relQuery.in(RuleLibRelevancyPo::getPid, ruleLibIds);
            List toDel = this.ruleLibRelevancyService.list((Wrapper)relQuery);
            List toDelLibIds = toDel.stream().map(RuleLibRelevancyPo::getCid).collect(Collectors.toList());
            toDelLibIds.addAll(ruleLibIds);
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.set(LogicDeleteAuditInfoDto::getDeleteFlag, (Object)1);
            updateWrapper.set(LogicDeleteAuditInfoDto::getDeleteTime, (Object)LocalDateTime.now());
            updateWrapper.in(RuleLibPo::getId, toDelLibIds);
            this.ruleLibMapper.update(null, (Wrapper)updateWrapper);
            LambdaUpdateWrapper updateWrapper1 = new LambdaUpdateWrapper();
            updateWrapper1.set(LogicDeleteAuditInfoDto::getDeleteTime, (Object)LocalDateTime.now());
            updateWrapper1.set(LogicDeleteAuditInfoDto::getDeleteFlag, (Object)1);
            updateWrapper1.in(RuleLibRelevancyPo::getCid, toDelLibIds);
            this.ruleLibRelevancyService.update((Wrapper)updateWrapper1);
        }
        catch (Exception e) {
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            log.error("\u89c4\u5219\u5e93\u5220\u9664\u5f02\u5e38", (Throwable)e);
            return false;
        }
        return true;
    }
}

